/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.impl;

import com.google.common.util.concurrent.Striped;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.assetmanager.api.Snapshot;
import org.opencastproject.assetmanager.api.query.RichAResult;
import org.opencastproject.assetmanager.util.WorkflowPropertiesUtil;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.api.SearchResult;
import org.opencastproject.elasticsearch.api.SearchResultItem;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.event.Event;
import org.opencastproject.elasticsearch.index.objects.event.EventSearchQuery;
import org.opencastproject.elasticsearch.index.rebuild.AbstractIndexProducer;
import org.opencastproject.elasticsearch.index.rebuild.IndexProducer;
import org.opencastproject.elasticsearch.index.rebuild.IndexRebuildException;
import org.opencastproject.elasticsearch.index.rebuild.IndexRebuildService;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobProducer;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.mediapackage.MediaPackageSupport;
import org.opencastproject.mediapackage.Publication;
import org.opencastproject.metadata.api.MediaPackageMetadata;
import org.opencastproject.metadata.api.MediaPackageMetadataService;
import org.opencastproject.metadata.api.MetadataService;
import org.opencastproject.metadata.api.util.MediaPackageMetadataSupport;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AccessControlUtil;
import org.opencastproject.security.api.AclScope;
import org.opencastproject.security.api.AuthorizationService;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.Permissions;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.series.api.SeriesException;
import org.opencastproject.series.api.SeriesService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.serviceregistry.api.UndispatchableJobException;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.ReadinessIndicator;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.workflow.api.ResumableWorkflowOperationHandler;
import org.opencastproject.workflow.api.RetryStrategy;
import org.opencastproject.workflow.api.WorkflowDatabaseException;
import org.opencastproject.workflow.api.WorkflowDefinition;
import org.opencastproject.workflow.api.WorkflowException;
import org.opencastproject.workflow.api.WorkflowIdentifier;
import org.opencastproject.workflow.api.WorkflowIndexData;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowListener;
import org.opencastproject.workflow.api.WorkflowOperationDefinition;
import org.opencastproject.workflow.api.WorkflowOperationDefinitionImpl;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workflow.api.WorkflowOperationResultImpl;
import org.opencastproject.workflow.api.WorkflowParsingException;
import org.opencastproject.workflow.api.WorkflowService;
import org.opencastproject.workflow.api.WorkflowServiceDatabase;
import org.opencastproject.workflow.api.WorkflowStateException;
import org.opencastproject.workflow.api.WorkflowStateMapping;
import org.opencastproject.workflow.api.WorkflowUtil;
import org.opencastproject.workflow.api.XmlWorkflowParser;
import org.opencastproject.workflow.impl.WorkflowDefinitionScanner;
import org.opencastproject.workflow.impl.WorkflowOperationWorker;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Workflow Service", "service.pid=org.opencastproject.workflow.impl.WorkflowServiceImpl"}, immediate=true, service={WorkflowService.class, WorkflowServiceImpl.class, IndexProducer.class})
public class WorkflowServiceImpl
extends AbstractIndexProducer
implements WorkflowService,
JobProducer {
    private static final String RETRY_STRATEGY = "retryStrategy";
    private static final Logger logger = LoggerFactory.getLogger(WorkflowServiceImpl.class);
    private static final String NULL_PARENT_ID = "-";
    private static final float WORKFLOW_JOB_LOAD = 0.0f;
    public static final String ERROR_RESOLUTION_HANDLER_ID = "error-resolution";
    protected ComponentContext componentContext = null;
    private SortedSet<MediaPackageMetadataService> metadataServices;
    protected WorkflowServiceDatabase persistence;
    private final List<WorkflowListener> listeners = new CopyOnWriteArrayList<WorkflowListener>();
    protected ThreadPoolExecutor executorService;
    protected Workspace workspace = null;
    protected ServiceRegistry serviceRegistry = null;
    protected SecurityService securityService = null;
    protected AuthorizationService authorizationService = null;
    protected UserDirectoryService userDirectoryService = null;
    protected OrganizationDirectoryService organizationDirectoryService = null;
    protected SeriesService seriesService;
    protected AssetManager assetManager = null;
    private WorkflowDefinitionScanner workflowDefinitionScanner;
    private final List<Long> delayedWorkflows = new ArrayList<Long>();
    private final Striped<Lock> lock = Striped.lazyWeakLock((int)1024);
    private final Striped<Lock> updateLock = Striped.lazyWeakLock((int)1024);
    private final Striped<Lock> mediaPackageLocks = Striped.lazyWeakLock((int)1024);
    private ElasticsearchIndex index;

    public WorkflowServiceImpl() {
        this.metadataServices = new TreeSet<MediaPackageMetadataService>(Comparator.comparingInt(MetadataService::getPriority));
    }

    @Activate
    public void activate(ComponentContext componentContext) {
        this.componentContext = componentContext;
        this.executorService = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        logger.info("Activate Workflow service");
    }

    public void addWorkflowListener(WorkflowListener listener) {
        this.listeners.add(listener);
    }

    public void removeWorkflowListener(WorkflowListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireListeners(WorkflowInstance oldWorkflowInstance, WorkflowInstance newWorkflowInstance) {
        User currentUser = this.securityService.getUser();
        Organization currentOrganization = this.securityService.getOrganization();
        for (WorkflowListener listener : this.listeners) {
            Runnable runnable;
            if (oldWorkflowInstance == null || !oldWorkflowInstance.getState().equals((Object)newWorkflowInstance.getState())) {
                runnable = () -> {
                    try {
                        this.securityService.setUser(currentUser);
                        this.securityService.setOrganization(currentOrganization);
                        listener.stateChanged(newWorkflowInstance);
                    }
                    finally {
                        this.securityService.setUser(null);
                        this.securityService.setOrganization(null);
                    }
                };
                this.executorService.execute(runnable);
            } else {
                logger.debug("Not notifying {} because the workflow state has not changed", (Object)listener);
            }
            if (newWorkflowInstance.getCurrentOperation() != null) {
                if (oldWorkflowInstance != null && oldWorkflowInstance.getCurrentOperation() != null && oldWorkflowInstance.getCurrentOperation().equals((Object)newWorkflowInstance.getCurrentOperation())) continue;
                runnable = () -> {
                    try {
                        this.securityService.setUser(currentUser);
                        this.securityService.setOrganization(currentOrganization);
                        listener.operationChanged(newWorkflowInstance);
                    }
                    finally {
                        this.securityService.setUser(null);
                        this.securityService.setOrganization(null);
                    }
                };
                this.executorService.execute(runnable);
                continue;
            }
            logger.debug("Not notifying {} because the workflow operation has not changed", (Object)listener);
        }
    }

    public List<WorkflowDefinition> listAvailableWorkflowDefinitions() {
        return this.workflowDefinitionScanner.getAvailableWorkflowDefinitions(this.securityService.getOrganization(), this.securityService.getUser()).sorted().collect(Collectors.toList());
    }

    public boolean isRunnable(WorkflowDefinition workflowDefinition) {
        List<String> availableOperations = this.listAvailableOperationNames();
        ArrayList<WorkflowDefinition> checkedWorkflows = new ArrayList<WorkflowDefinition>();
        boolean runnable = this.isRunnable(workflowDefinition, availableOperations, checkedWorkflows);
        int wfCount = checkedWorkflows.size() - 1;
        if (runnable) {
            logger.info("Workflow {}, containing {} derived workflows, is runnable", (Object)workflowDefinition, (Object)wfCount);
        } else {
            logger.warn("Workflow {}, containing {} derived workflows, is not runnable", (Object)workflowDefinition, (Object)wfCount);
        }
        return runnable;
    }

    private boolean isRunnable(WorkflowDefinition workflowDefinition, List<String> availableOperations, List<WorkflowDefinition> checkedWorkflows) {
        if (checkedWorkflows.contains(workflowDefinition)) {
            return true;
        }
        for (WorkflowOperationDefinition op : workflowDefinition.getOperations()) {
            WorkflowDefinition catchWorkflowDefinition;
            if (!availableOperations.contains(op.getId())) {
                logger.info("{} is not runnable due to missing operation {}", (Object)workflowDefinition, (Object)op);
                return false;
            }
            String catchWorkflow = op.getExceptionHandlingWorkflow();
            if (catchWorkflow == null) continue;
            try {
                catchWorkflowDefinition = this.getWorkflowDefinitionById(catchWorkflow);
            }
            catch (NotFoundException e) {
                logger.info("{} is not runnable due to missing catch workflow {} on operation {}", new Object[]{workflowDefinition, catchWorkflow, op});
                return false;
            }
            if (this.isRunnable(catchWorkflowDefinition, availableOperations, checkedWorkflows)) continue;
            return false;
        }
        if (!checkedWorkflows.contains(workflowDefinition)) {
            checkedWorkflows.add(workflowDefinition);
        }
        return true;
    }

    public Set<HandlerRegistration> getRegisteredHandlers() {
        ServiceReference[] refs;
        HashSet<HandlerRegistration> set = new HashSet<HandlerRegistration>();
        try {
            refs = this.componentContext.getBundleContext().getServiceReferences(WorkflowOperationHandler.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException(e);
        }
        if (refs != null) {
            for (ServiceReference ref : refs) {
                WorkflowOperationHandler handler = (WorkflowOperationHandler)this.componentContext.getBundleContext().getService(ref);
                set.add(new HandlerRegistration((String)ref.getProperty("workflow.operation"), handler));
            }
        } else {
            logger.warn("No registered workflow operation handlers found");
        }
        return set;
    }

    protected WorkflowOperationHandler getWorkflowOperationHandler(String operationId) {
        for (HandlerRegistration reg : this.getRegisteredHandlers()) {
            if (!reg.operationName.equals(operationId)) continue;
            return reg.handler;
        }
        return null;
    }

    protected List<String> listAvailableOperationNames() {
        return this.getRegisteredHandlers().parallelStream().map(op -> op.operationName).collect(Collectors.toList());
    }

    public WorkflowInstance getWorkflowById(long id) throws NotFoundException, UnauthorizedException {
        try {
            WorkflowInstance workflow = this.persistence.getWorkflow(id);
            this.assertPermission(workflow, Permissions.Action.READ.toString(), workflow.getOrganizationId());
            return workflow;
        }
        catch (WorkflowDatabaseException e) {
            throw new IllegalStateException("Got not get workflow from database with id ");
        }
    }

    public WorkflowInstance start(WorkflowDefinition workflowDefinition, MediaPackage mediaPackage) throws WorkflowDatabaseException, UnauthorizedException, WorkflowParsingException {
        return this.start(workflowDefinition, mediaPackage, new HashMap<String, String>());
    }

    public WorkflowInstance start(WorkflowDefinition workflowDefinition, MediaPackage mediaPackage, Map<String, String> properties) throws WorkflowDatabaseException, UnauthorizedException, WorkflowParsingException {
        try {
            return this.start(workflowDefinition, mediaPackage, null, properties);
        }
        catch (NotFoundException e) {
            throw new IllegalStateException("a null workflow ID caused a NotFoundException.  This is a programming error.");
        }
    }

    public WorkflowInstance start(WorkflowDefinition workflowDefinition, MediaPackage sourceMediaPackage, Long parentWorkflowId, Map<String, String> originalProperties) throws WorkflowDatabaseException, NotFoundException, UnauthorizedException, WorkflowParsingException, IllegalStateException {
        String mediaPackageId = sourceMediaPackage.getIdentifier().toString();
        Map properties = null;
        this.populateMediaPackageMetadata(sourceMediaPackage);
        if (originalProperties != null) {
            WorkflowPropertiesUtil.storeProperties((AssetManager)this.assetManager, (MediaPackage)sourceMediaPackage, originalProperties);
            properties = WorkflowPropertiesUtil.getLatestWorkflowProperties((AssetManager)this.assetManager, (String)mediaPackageId);
        }
        Lock lock = (Lock)this.mediaPackageLocks.get((Object)mediaPackageId);
        lock.lock();
        try {
            if (workflowDefinition == null) {
                throw new IllegalArgumentException("workflow definition must not be null");
            }
            Iterator iterator = MediaPackageSupport.sanityCheck((MediaPackage)sourceMediaPackage).iterator();
            if (iterator.hasNext()) {
                List errors = (List)iterator.next();
                throw new IllegalArgumentException("Insane media package cannot be processed: " + String.join((CharSequence)"; ", errors));
            }
            if (parentWorkflowId != null) {
                try {
                    this.getWorkflowById(parentWorkflowId);
                }
                catch (UnauthorizedException e) {
                    throw new IllegalArgumentException("Parent workflow " + parentWorkflowId + " not visible to this user");
                }
            } else if (this.persistence.mediaPackageHasActiveWorkflows(mediaPackageId)) {
                throw new IllegalStateException(String.format("Can't start workflow '%s' for media package '%s' because another workflow is currently active.", workflowDefinition.getTitle(), sourceMediaPackage.getIdentifier().toString()));
            }
            User currentUser = this.securityService.getUser();
            this.validUserOrThrow(currentUser);
            Organization organization = this.securityService.getOrganization();
            if (organization == null) {
                throw new SecurityException("Current organization is unknown");
            }
            WorkflowInstance workflowInstance = new WorkflowInstance(workflowDefinition, sourceMediaPackage, currentUser, organization, properties);
            workflowInstance = this.updateConfiguration(workflowInstance, properties);
            try {
                String workflowDefinitionXml = XmlWorkflowParser.toXml((WorkflowDefinition)workflowDefinition);
                String mediaPackageXml = MediaPackageParser.getAsXml((MediaPackage)sourceMediaPackage);
                ArrayList<String> arguments = new ArrayList<String>();
                arguments.add(workflowDefinitionXml);
                arguments.add(mediaPackageXml);
                if (parentWorkflowId != null || properties != null) {
                    String parentWorkflowIdString = parentWorkflowId != null ? parentWorkflowId.toString() : NULL_PARENT_ID;
                    arguments.add(parentWorkflowIdString);
                }
                if (properties != null) {
                    arguments.add(this.mapToString(properties));
                }
                Job job = this.serviceRegistry.createJob("org.opencastproject.workflow", Operation.START_WORKFLOW.toString(), arguments, null, false, null, Float.valueOf(0.0f));
                workflowInstance.setId(job.getId());
                this.update(workflowInstance);
                WorkflowInstance workflowInstance2 = workflowInstance;
                return workflowInstance2;
            }
            catch (Throwable t) {
                try {
                    workflowInstance.setState(WorkflowInstance.WorkflowState.FAILED);
                    this.update(workflowInstance);
                }
                catch (Exception failureToFail) {
                    logger.warn("Unable to update workflow to failed state", (Throwable)failureToFail);
                }
                try {
                    throw t;
                }
                catch (ServiceRegistryException e) {
                    throw new WorkflowDatabaseException((Throwable)e);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    protected WorkflowInstance updateConfiguration(WorkflowInstance instance, Map<String, String> properties) {
        if (properties != null) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                instance.setConfiguration(entry.getKey(), entry.getValue());
            }
        }
        return instance;
    }

    protected WorkflowOperationHandler selectOperationHandler(WorkflowOperationInstance operation) {
        ArrayList<WorkflowOperationHandler> handlerList = new ArrayList<WorkflowOperationHandler>();
        for (HandlerRegistration handlerReg : this.getRegisteredHandlers()) {
            if (handlerReg.operationName == null || !handlerReg.operationName.equals(operation.getTemplate())) continue;
            handlerList.add(handlerReg.handler);
        }
        if (handlerList.size() > 1) {
            throw new IllegalStateException("Multiple operation handlers found for operation '" + operation.getTemplate() + "'");
        }
        if (handlerList.size() == 1) {
            return (WorkflowOperationHandler)handlerList.get(0);
        }
        logger.warn("No workflow operation handlers found for operation '{}'", (Object)operation.getTemplate());
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Job runWorkflow(WorkflowInstance workflow) throws WorkflowException, UnauthorizedException {
        if (WorkflowInstance.WorkflowState.INSTANTIATED != workflow.getState()) {
            if (WorkflowInstance.WorkflowState.RUNNING != workflow.getState()) throw new IllegalStateException("Cannot start a workflow in state '" + String.valueOf(workflow.getState()) + "'");
            WorkflowOperationInstance currentOperation = workflow.getCurrentOperation();
            if (currentOperation == null) throw new IllegalStateException("Cannot start a workflow '" + String.valueOf(workflow) + "' with no current operation");
            if (currentOperation.getId() != null) {
                try {
                    Job operationJob = this.serviceRegistry.getJob(currentOperation.getId().longValue());
                    if (Job.Status.RUNNING.equals((Object)operationJob.getStatus())) {
                        logger.debug("Not starting workflow {}, it is already in running state", (Object)workflow);
                        return null;
                    }
                    logger.info("Scheduling next operation of workflow {}", (Object)workflow);
                    operationJob.setStatus(Job.Status.QUEUED);
                    operationJob.setDispatchable(true);
                    return this.serviceRegistry.updateJob(operationJob);
                }
                catch (Exception e) {
                    logger.warn("Error determining status of current workflow operation in {}", (Object)workflow, (Object)e);
                    return null;
                }
            }
        }
        workflow.setState(WorkflowInstance.WorkflowState.RUNNING);
        this.update(workflow);
        WorkflowOperationInstance operation = workflow.getCurrentOperation();
        if (operation == null) {
            throw new IllegalStateException("Cannot start a workflow without a current operation");
        }
        if (!operation.equals(workflow.getOperations().get(0))) {
            throw new IllegalStateException("Current operation expected to be first");
        }
        try {
            logger.info("Scheduling workflow {} for execution", (Object)workflow.getId());
            Job job = this.serviceRegistry.createJob("org.opencastproject.workflow", Operation.START_OPERATION.toString(), Collections.singletonList(Long.toString(workflow.getId())), null, false, null, Float.valueOf(0.0f));
            operation.setId(Long.valueOf(job.getId()));
            this.update(workflow);
            job.setStatus(Job.Status.QUEUED);
            job.setDispatchable(true);
            return this.serviceRegistry.updateJob(job);
        }
        catch (ServiceRegistryException e) {
            throw new WorkflowDatabaseException((Throwable)e);
        }
        catch (NotFoundException e) {
            throw new IllegalStateException("Unable to find a job that was just created");
        }
    }

    protected WorkflowOperationInstance runWorkflowOperation(WorkflowInstance workflow, Map<String, String> properties) throws WorkflowException, UnauthorizedException {
        WorkflowOperationInstance processingOperation = workflow.getCurrentOperation();
        if (processingOperation == null) {
            throw new IllegalStateException("Workflow '" + String.valueOf(workflow) + "' has no operation to run");
        }
        WorkflowInstance.WorkflowState initialState = workflow.getState();
        WorkflowOperationHandler operationHandler = this.selectOperationHandler(processingOperation);
        WorkflowOperationWorker worker = new WorkflowOperationWorker(operationHandler, workflow, properties, this);
        workflow = worker.execute();
        Long currentOperationJobId = processingOperation.getId();
        try {
            this.updateOperationJob(currentOperationJobId, processingOperation.getState());
        }
        catch (NotFoundException e) {
            throw new IllegalStateException("Unable to find a job that has already been running");
        }
        catch (ServiceRegistryException e) {
            throw new WorkflowDatabaseException((Throwable)e);
        }
        WorkflowOperationInstance currentOperation = workflow.getCurrentOperation();
        if (currentOperation == null) {
            if (WorkflowInstance.WorkflowState.FAILING.equals((Object)workflow.getState())) {
                workflow.setState(WorkflowInstance.WorkflowState.FAILED);
            } else if (!WorkflowInstance.WorkflowState.FAILED.equals((Object)workflow.getState())) {
                workflow.setState(WorkflowInstance.WorkflowState.SUCCEEDED);
                for (WorkflowOperationInstance op : workflow.getOperations()) {
                    if (!op.getState().equals((Object)WorkflowOperationInstance.OperationState.FAILED) || !op.isFailOnError()) continue;
                    workflow.setState(WorkflowInstance.WorkflowState.FAILED);
                    break;
                }
            }
            logger.debug("{} has {}", (Object)workflow, (Object)workflow.getState());
            this.update(workflow);
        } else {
            WorkflowInstance.WorkflowState dbWorkflowState;
            try {
                dbWorkflowState = this.getWorkflowById(workflow.getId()).getState();
            }
            catch (NotFoundException e) {
                throw new IllegalStateException("The workflow with ID " + workflow.getId() + " can not be found in the database", e);
            }
            catch (UnauthorizedException e) {
                throw new IllegalStateException("The workflow with ID " + workflow.getId() + " can not be read", e);
            }
            if (!dbWorkflowState.equals((Object)initialState)) {
                logger.info("Workflow state for {} was changed to '{}' from the outside", (Object)workflow, (Object)dbWorkflowState);
                workflow.setState(dbWorkflowState);
            }
            switch (workflow.getState()) {
                case FAILED: {
                    this.update(workflow);
                    break;
                }
                case FAILING: 
                case RUNNING: {
                    try {
                        Job job = this.serviceRegistry.createJob("org.opencastproject.workflow", Operation.START_OPERATION.toString(), Collections.singletonList(Long.toString(workflow.getId())), null, false, null, Float.valueOf(0.0f));
                        currentOperation.setId(Long.valueOf(job.getId()));
                        this.update(workflow);
                        job.setStatus(Job.Status.QUEUED);
                        job.setDispatchable(true);
                        this.serviceRegistry.updateJob(job);
                        break;
                    }
                    catch (ServiceRegistryException e) {
                        throw new WorkflowDatabaseException((Throwable)e);
                    }
                    catch (NotFoundException e) {
                        throw new IllegalStateException("Unable to find a job that was just created");
                    }
                }
                case PAUSED: 
                case STOPPED: 
                case SUCCEEDED: {
                    this.update(workflow);
                    break;
                }
                case INSTANTIATED: {
                    this.update(workflow);
                    throw new IllegalStateException("Impossible workflow state found during processing");
                }
                default: {
                    throw new IllegalStateException("Unknown workflow state found during processing");
                }
            }
        }
        return processingOperation;
    }

    public WorkflowDefinition getWorkflowDefinitionById(String id) throws NotFoundException {
        WorkflowIdentifier workflowIdentifier = new WorkflowIdentifier(id, this.securityService.getOrganization().getId());
        WorkflowDefinition def = this.workflowDefinitionScanner.getWorkflowDefinition(this.securityService.getUser(), workflowIdentifier);
        if (def == null) {
            throw new NotFoundException("Workflow definition '" + String.valueOf(workflowIdentifier) + "' not found or inaccessible");
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkflowInstance stop(long workflowInstanceId) throws WorkflowException, NotFoundException, UnauthorizedException {
        Lock lock = (Lock)this.lock.get((Object)workflowInstanceId);
        lock.lock();
        try {
            WorkflowInstance instance = this.getWorkflowById(workflowInstanceId);
            if (instance.getState() != WorkflowInstance.WorkflowState.STOPPED) {
                instance.setState(WorkflowInstance.WorkflowState.STOPPED);
                this.update(instance);
            }
            try {
                this.removeTempFiles(instance);
            }
            catch (Exception e) {
                logger.warn("Cannot remove temp files for workflow instance {}", (Object)workflowInstanceId, (Object)e);
            }
            WorkflowInstance workflowInstance = instance;
            return workflowInstance;
        }
        finally {
            lock.unlock();
        }
    }

    private void validUserOrThrow(User user) {
        if (user == null) {
            throw new SecurityException("Current user is unknown");
        }
        if (this.userDirectoryService.loadUser(user.getUsername()) == null) {
            throw new SecurityException(String.format("Current user '%s' can not be loaded", user.getUsername()));
        }
    }

    private void removeTempFiles(WorkflowInstance workflowInstance) {
        logger.info("Removing temporary files for workflow {}", (Object)workflowInstance.getId());
        MediaPackage mp = workflowInstance.getMediaPackage();
        if (null == mp) {
            logger.warn("Workflow instance {} does not have an media package set", (Object)workflowInstance.getId());
            return;
        }
        for (MediaPackageElement elem : mp.getElements()) {
            if (elem instanceof Publication) continue;
            if (null == elem.getURI()) {
                logger.warn("Media package element {} from the media package {} does not have an URI set", (Object)elem.getIdentifier(), (Object)mp.getIdentifier());
                continue;
            }
            try {
                logger.debug("Removing temporary file {} for workflow {}", (Object)elem.getURI(), (Object)workflowInstance);
                this.workspace.delete(elem.getURI());
            }
            catch (IOException e) {
                logger.warn("Unable to delete mediapackage element", (Throwable)e);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
    }

    public void remove(long workflowInstanceId) throws WorkflowDatabaseException, NotFoundException, UnauthorizedException, WorkflowParsingException, WorkflowStateException {
        this.remove(workflowInstanceId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(long workflowInstanceId, boolean force) throws WorkflowDatabaseException, NotFoundException, UnauthorizedException, WorkflowStateException {
        Lock lock = (Lock)this.lock.get((Object)workflowInstanceId);
        lock.lock();
        try {
            WorkflowInstance instance = this.getWorkflowById(workflowInstanceId);
            WorkflowInstance.WorkflowState state = instance.getState();
            if (!state.isTerminated() && !force) {
                throw new WorkflowStateException("Workflow instance with state '" + String.valueOf(state) + "' cannot be removed since it is not yet terminated.");
            }
            this.assertPermission(instance, Permissions.Action.WRITE.toString(), instance.getOrganizationId());
            this.removeTempFiles(instance);
            List operations = instance.getOperations();
            ArrayList<Long> jobsToDelete = new ArrayList<Long>();
            for (WorkflowOperationInstance op : operations) {
                long workflowOpId;
                if (op.getId() == null || (workflowOpId = op.getId().longValue()) == workflowInstanceId) continue;
                jobsToDelete.add(workflowOpId);
            }
            try {
                this.serviceRegistry.removeJobs(jobsToDelete);
            }
            catch (ServiceRegistryException e) {
                logger.warn("Problems while removing jobs related to workflow operations '{}'", jobsToDelete, (Object)e);
            }
            catch (NotFoundException e) {
                logger.debug("No jobs related to one of the workflow operation '{}' found in service registry", jobsToDelete);
            }
            try {
                this.serviceRegistry.removeJobs(Collections.singletonList(workflowInstanceId));
                this.removeWorkflowInstanceFromIndex(instance.getId());
            }
            catch (ServiceRegistryException e) {
                logger.warn("Problems while removing workflow instance job '{}'", (Object)workflowInstanceId, (Object)e);
            }
            catch (NotFoundException e) {
                logger.info("No workflow instance job '{}' found in the service registry", (Object)workflowInstanceId);
            }
            this.persistence.removeFromDatabase(instance);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkflowInstance suspend(long workflowInstanceId) throws WorkflowException, NotFoundException, UnauthorizedException {
        Lock lock = (Lock)this.lock.get((Object)workflowInstanceId);
        lock.lock();
        try {
            WorkflowInstance instance = this.getWorkflowById(workflowInstanceId);
            instance.setState(WorkflowInstance.WorkflowState.PAUSED);
            this.update(instance);
            WorkflowInstance workflowInstance = instance;
            return workflowInstance;
        }
        finally {
            lock.unlock();
        }
    }

    public WorkflowInstance resume(long id) throws WorkflowException, NotFoundException, IllegalStateException, UnauthorizedException {
        return this.resume(id, null);
    }

    public WorkflowInstance resume(long workflowInstanceId, Map<String, String> properties) throws WorkflowException, NotFoundException, IllegalStateException, UnauthorizedException {
        WorkflowInstance workflowInstance = this.getWorkflowById(workflowInstanceId);
        if (!WorkflowInstance.WorkflowState.PAUSED.equals((Object)workflowInstance.getState())) {
            throw new IllegalStateException("Can not resume a workflow where the current state is not in paused");
        }
        workflowInstance = this.updateConfiguration(workflowInstance, properties);
        this.update(workflowInstance);
        WorkflowOperationInstance currentOperation = workflowInstance.getCurrentOperation();
        if (currentOperation == null) {
            workflowInstance.setState(WorkflowInstance.WorkflowState.SUCCEEDED);
            for (WorkflowOperationInstance op : workflowInstance.getOperations()) {
                if (!op.getState().equals((Object)WorkflowOperationInstance.OperationState.FAILED) || !op.isFailOnError()) continue;
                workflowInstance.setState(WorkflowInstance.WorkflowState.FAILED);
                break;
            }
            logger.debug("{} has {}", (Object)workflowInstance, (Object)workflowInstance.getState());
            this.update(workflowInstance);
            return workflowInstance;
        }
        if (WorkflowOperationInstance.OperationState.INSTANTIATED.equals((Object)currentOperation.getState())) {
            try {
                Job operationJob = this.serviceRegistry.createJob("org.opencastproject.workflow", Operation.START_OPERATION.toString(), Collections.singletonList(Long.toString(workflowInstanceId)), null, false, null, Float.valueOf(0.0f));
                workflowInstance.setState(WorkflowInstance.WorkflowState.RUNNING);
                currentOperation.setId(Long.valueOf(operationJob.getId()));
                this.update(workflowInstance);
                operationJob.setStatus(Job.Status.QUEUED);
                operationJob.setDispatchable(true);
                this.serviceRegistry.updateJob(operationJob);
                return workflowInstance;
            }
            catch (ServiceRegistryException e) {
                throw new WorkflowDatabaseException((Throwable)e);
            }
        }
        Long operationJobId = workflowInstance.getCurrentOperation().getId();
        if (operationJobId == null) {
            throw new IllegalStateException("Can not resume a workflow where the current operation has no associated id");
        }
        try {
            Job workflowJob = this.serviceRegistry.getJob(workflowInstanceId);
            workflowJob.setStatus(Job.Status.RUNNING);
            this.persistence.updateInDatabase(workflowInstance);
            this.serviceRegistry.updateJob(workflowJob);
            Job operationJob = this.serviceRegistry.getJob(operationJobId.longValue());
            operationJob.setStatus(Job.Status.QUEUED);
            operationJob.setDispatchable(true);
            if (properties != null) {
                Properties props = new Properties();
                props.putAll(properties);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                props.store(out, null);
                ArrayList<String> newArguments = new ArrayList<String>(operationJob.getArguments());
                newArguments.add(new String(out.toByteArray(), StandardCharsets.UTF_8));
                operationJob.setArguments(newArguments);
            }
            this.serviceRegistry.updateJob(operationJob);
        }
        catch (ServiceRegistryException e) {
            throw new WorkflowDatabaseException((Throwable)e);
        }
        catch (IOException e) {
            throw new WorkflowParsingException("Unable to parse workflow and/or workflow properties");
        }
        return workflowInstance;
    }

    protected void assertPermission(WorkflowInstance workflow, String action, String workflowOrgId) throws UnauthorizedException {
        boolean authorized;
        String creatorName;
        Optional assetMediapackage;
        User currentUser = this.securityService.getUser();
        Organization currentOrg = this.securityService.getOrganization();
        String currentOrgAdminRole = currentOrg.getAdminRole();
        String currentOrgId = currentOrg.getId();
        MediaPackage mediapackage = workflow.getMediaPackage();
        WorkflowInstance.WorkflowState state = workflow.getState();
        if (state != WorkflowInstance.WorkflowState.INSTANTIATED && state != WorkflowInstance.WorkflowState.RUNNING && workflow.getState() != WorkflowInstance.WorkflowState.FAILING && (assetMediapackage = this.assetManager.getMediaPackage(mediapackage.getIdentifier().toString())).isPresent()) {
            mediapackage = (MediaPackage)assetMediapackage.get();
        }
        User workflowCreator = (creatorName = workflow.getCreatorName()) == null ? null : this.userDirectoryService.loadUser(creatorName);
        boolean bl = authorized = currentUser.hasRole("ROLE_ADMIN") || currentUser.hasRole(currentOrgAdminRole) && currentOrgId.equals(workflowOrgId) || currentUser.equals((Object)workflowCreator) || this.authorizationService.hasPermission(mediapackage, action) && currentOrgId.equals(workflowOrgId);
        if (!authorized) {
            throw new UnauthorizedException(currentUser, action);
        }
    }

    protected boolean assertMediaPackagePermission(String mediaPackageId, String action) {
        User currentUser = this.securityService.getUser();
        Optional mp = this.assetManager.getMediaPackage(mediaPackageId);
        return currentUser.hasRole("ROLE_ADMIN") || mp.isPresent() && currentUser.hasRole(this.securityService.getOrganization().getAdminRole()) || mp.isPresent() && this.authorizationService.hasPermission((MediaPackage)mp.get(), action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(WorkflowInstance workflowInstance) throws WorkflowDatabaseException, UnauthorizedException {
        Lock lock = (Lock)this.updateLock.get((Object)workflowInstance.getId());
        lock.lock();
        try {
            Job job;
            WorkflowInstance originalWorkflowInstance = null;
            try {
                originalWorkflowInstance = this.getWorkflowById(workflowInstance.getId());
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            MediaPackage updatedMediaPackage = null;
            try {
                updatedMediaPackage = workflowInstance.getMediaPackage();
                this.populateMediaPackageMetadata(updatedMediaPackage);
                String seriesId = updatedMediaPackage.getSeries();
                if (seriesId != null && workflowInstance.getCurrentOperation() != null) {
                    try {
                        AccessControlList acl = this.seriesService.getSeriesAccessControl(seriesId);
                        Tuple activeAcl = this.authorizationService.getAcl(updatedMediaPackage, AclScope.Series);
                        if (!AclScope.Series.equals(activeAcl.getB()) || !AccessControlUtil.equals((AccessControlList)((AccessControlList)activeAcl.getA()), (AccessControlList)acl)) {
                            this.authorizationService.setAcl(updatedMediaPackage, AclScope.Series, acl);
                        }
                    }
                    catch (NotFoundException e) {
                        logger.debug("Not updating series ACL on event {} since series {} has no ACL set", new Object[]{updatedMediaPackage, seriesId, e});
                    }
                }
                workflowInstance.setMediaPackage(updatedMediaPackage);
            }
            catch (SeriesException e) {
                throw new WorkflowDatabaseException((Throwable)e);
            }
            catch (Exception e) {
                logger.error("Metadata for media package {} could not be updated", (Object)updatedMediaPackage, (Object)e);
            }
            WorkflowInstance.WorkflowState workflowState = workflowInstance.getState();
            try {
                job = this.serviceRegistry.getJob(workflowInstance.getId());
                job.setPayload(Long.toString(workflowInstance.getId()));
                switch (workflowState) {
                    case FAILED: {
                        job.setStatus(Job.Status.FAILED);
                        break;
                    }
                    case FAILING: {
                        break;
                    }
                    case INSTANTIATED: {
                        job.setDispatchable(true);
                        job.setStatus(Job.Status.QUEUED);
                        break;
                    }
                    case PAUSED: {
                        job.setStatus(Job.Status.PAUSED);
                        break;
                    }
                    case RUNNING: {
                        job.setStatus(Job.Status.RUNNING);
                        break;
                    }
                    case STOPPED: {
                        job.setStatus(Job.Status.CANCELLED);
                        break;
                    }
                    case SUCCEEDED: {
                        job.setStatus(Job.Status.FINISHED);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Found a workflow state that is not handled");
                    }
                }
            }
            catch (ServiceRegistryException e) {
                throw new WorkflowDatabaseException("Unable to read workflow job " + workflowInstance.getId() + " from service registry", (Throwable)e);
            }
            catch (NotFoundException e) {
                throw new WorkflowDatabaseException("Job for workflow " + workflowInstance.getId() + " not found in service registry", (Throwable)e);
            }
            try {
                this.persistence.updateInDatabase(workflowInstance);
                job = this.serviceRegistry.updateJob(job);
                WorkflowOperationInstance op = workflowInstance.getCurrentOperation();
                if (op == null || op.getState() != WorkflowOperationInstance.OperationState.RUNNING) {
                    long id = workflowInstance.getId();
                    int state = workflowInstance.getState().ordinal();
                    String template = workflowInstance.getTemplate();
                    String mpId = workflowInstance.getMediaPackage().getIdentifier().toString();
                    String orgId = workflowInstance.getOrganizationId();
                    this.updateWorkflowInstanceInIndex(id, state, template, mpId, orgId);
                }
            }
            catch (ServiceRegistryException e) {
                throw new WorkflowDatabaseException("Update of workflow job " + workflowInstance.getId() + " in the service registry failed, service registry and workflow table may be out of sync", (Throwable)e);
            }
            catch (NotFoundException e) {
                throw new WorkflowDatabaseException("Job for workflow " + workflowInstance.getId() + " not found in service registry", (Throwable)e);
            }
            catch (Exception e) {
                throw new WorkflowDatabaseException("Update of workflow job " + job.getId() + " in the service registry failed, service registry and workflow table may be out of sync", (Throwable)e);
            }
            try {
                this.fireListeners(originalWorkflowInstance, workflowInstance);
            }
            catch (Exception e) {
                throw new IllegalStateException("In-memory workflow instance could not be serialized", e);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public long countWorkflowInstances() throws WorkflowDatabaseException {
        return this.countWorkflowInstances(null);
    }

    public long countWorkflowInstances(WorkflowInstance.WorkflowState state) throws WorkflowDatabaseException {
        return this.persistence.countWorkflows(state);
    }

    public List<WorkflowInstance> getWorkflowInstancesByMediaPackage(String mediaPackageId) throws WorkflowDatabaseException, UnauthorizedException {
        if (!this.assertMediaPackagePermission(mediaPackageId, Permissions.Action.READ.toString())) {
            throw new UnauthorizedException("Not allowed to access event");
        }
        return this.persistence.getWorkflowInstancesByMediaPackage(mediaPackageId);
    }

    public Optional<WorkflowInstance> getRunningWorkflowInstanceByMediaPackage(String mediaPackageId, String action) throws WorkflowException, UnauthorizedException, WorkflowDatabaseException {
        List workflowInstances = this.persistence.getRunningWorkflowInstancesByMediaPackage(mediaPackageId);
        if (workflowInstances.size() > 1) {
            throw new WorkflowException("Multiple workflows are active on mediapackage " + mediaPackageId);
        }
        Optional<WorkflowInstance> optWorkflowInstance = Optional.empty();
        if (workflowInstances.size() == 1) {
            WorkflowInstance wfInstance = (WorkflowInstance)workflowInstances.get(0);
            optWorkflowInstance = Optional.of(wfInstance);
            this.assertPermission(wfInstance, action, wfInstance.getOrganizationId());
        }
        return optWorkflowInstance;
    }

    public boolean mediaPackageHasActiveWorkflows(String mediaPackageId) throws WorkflowDatabaseException {
        return this.persistence.mediaPackageHasActiveWorkflows(mediaPackageId);
    }

    public boolean userHasActiveWorkflows(String userId) throws WorkflowDatabaseException {
        return this.persistence.userHasActiveWorkflows(userId);
    }

    protected WorkflowInstance handleOperationException(WorkflowInstance workflow, WorkflowOperationInstance currentOperation) {
        int failedAttempt = currentOperation.getFailedAttempts() + 1;
        currentOperation.setFailedAttempts(failedAttempt);
        if (ERROR_RESOLUTION_HANDLER_ID.equals(currentOperation.getTemplate()) && WorkflowOperationInstance.OperationState.FAILED.equals((Object)currentOperation.getState())) {
            int position = workflow.getOperations().indexOf(currentOperation);
            if (workflow.getOperations().size() > position + 1) {
                currentOperation = (WorkflowOperationInstance)workflow.getOperations().get(position + 1);
                currentOperation.setState(WorkflowOperationInstance.OperationState.FAILED);
            }
            this.handleFailedOperation(workflow, currentOperation);
        } else if (currentOperation.getMaxAttempts() != -1 && failedAttempt == currentOperation.getMaxAttempts()) {
            this.handleFailedOperation(workflow, currentOperation);
        } else {
            switch (currentOperation.getRetryStrategy()) {
                case NONE: {
                    this.handleFailedOperation(workflow, currentOperation);
                    break;
                }
                case RETRY: {
                    currentOperation.setState(WorkflowOperationInstance.OperationState.RETRY);
                    break;
                }
                case HOLD: {
                    currentOperation.setState(WorkflowOperationInstance.OperationState.RETRY);
                    List operations = workflow.getOperations();
                    WorkflowOperationDefinitionImpl errorResolutionDefinition = new WorkflowOperationDefinitionImpl(ERROR_RESOLUTION_HANDLER_ID, "Error Resolution Operation", "error", false);
                    WorkflowOperationInstance errorResolutionInstance = new WorkflowOperationInstance((WorkflowOperationDefinition)errorResolutionDefinition);
                    errorResolutionInstance.setExceptionHandlingWorkflow(currentOperation.getExceptionHandlingWorkflow());
                    int index = workflow.getOperations().indexOf(currentOperation);
                    operations.add(index, errorResolutionInstance);
                    workflow.setOperations(operations);
                    break;
                }
            }
        }
        return workflow;
    }

    private void handleFailedOperation(WorkflowInstance workflow, WorkflowOperationInstance currentOperation) {
        String errorDefId = currentOperation.getExceptionHandlingWorkflow();
        if (currentOperation.isFailOnError()) {
            if (StringUtils.isBlank((CharSequence)errorDefId)) {
                workflow.setState(WorkflowInstance.WorkflowState.FAILED);
            } else {
                workflow.setState(WorkflowInstance.WorkflowState.FAILING);
                int currentOperationPosition = workflow.getOperations().indexOf(currentOperation);
                ArrayList operations = new ArrayList(workflow.getOperations().subList(0, currentOperationPosition + 1));
                workflow.setOperations(operations);
                HashMap<String, String> configuration = new HashMap<String, String>();
                for (String configKey : workflow.getConfigurationKeys()) {
                    configuration.put(configKey, workflow.getConfiguration(configKey));
                }
                WorkflowDefinition errorDef = null;
                try {
                    errorDef = this.getWorkflowDefinitionById(errorDefId);
                    workflow.extend(errorDef);
                    workflow.setOperations(this.updateConfiguration(workflow, configuration).getOperations());
                }
                catch (NotFoundException notFoundException) {
                    throw new IllegalStateException("Unable to find the error workflow definition '" + errorDefId + "'");
                }
            }
        }
        currentOperation.setState(WorkflowOperationInstance.OperationState.FAILED);
    }

    protected WorkflowInstance handleOperationResult(WorkflowInstance workflow, WorkflowOperationResult result) throws WorkflowDatabaseException {
        WorkflowOperationInstance currentOperation = workflow.getCurrentOperation();
        WorkflowOperationHandler handler = this.getWorkflowOperationHandler(currentOperation.getTemplate());
        if (result == null) {
            logger.warn("Handling a null operation result for workflow {} in operation {}", (Object)workflow.getId(), (Object)currentOperation.getTemplate());
            result = new WorkflowOperationResultImpl(workflow.getMediaPackage(), null, WorkflowOperationResult.Action.CONTINUE, 0L);
        } else {
            MediaPackage mp = result.getMediaPackage();
            if (mp != null) {
                workflow.setMediaPackage(mp);
            }
        }
        WorkflowOperationResult.Action action = result.getAction();
        workflow = this.updateConfiguration(workflow, result.getProperties());
        currentOperation.setTimeInQueue(result.getTimeInQueue());
        switch (action) {
            case CONTINUE: {
                currentOperation.setState(WorkflowOperationInstance.OperationState.SUCCEEDED);
                break;
            }
            case PAUSE: {
                if (!(handler instanceof ResumableWorkflowOperationHandler)) {
                    throw new IllegalStateException("Operation " + currentOperation.getTemplate() + " is not resumable");
                }
                currentOperation.setContinuable(Boolean.valueOf(result.allowsContinue()));
                currentOperation.setAbortable(Boolean.valueOf(result.allowsAbort()));
                workflow.setState(WorkflowInstance.WorkflowState.PAUSED);
                currentOperation.setState(WorkflowOperationInstance.OperationState.PAUSED);
                break;
            }
            case SKIP: {
                currentOperation.setState(WorkflowOperationInstance.OperationState.SKIPPED);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown action '" + String.valueOf(action) + "' returned");
            }
        }
        if (ERROR_RESOLUTION_HANDLER_ID.equals(currentOperation.getTemplate()) && result.getAction() == WorkflowOperationResult.Action.CONTINUE) {
            Map resultProperties = result.getProperties();
            if (resultProperties == null || StringUtils.isBlank((CharSequence)((CharSequence)resultProperties.get(RETRY_STRATEGY)))) {
                throw new WorkflowDatabaseException("Retry strategy not present in properties!");
            }
            RetryStrategy retryStrategy = RetryStrategy.valueOf((String)((String)resultProperties.get(RETRY_STRATEGY)));
            switch (retryStrategy) {
                case NONE: {
                    this.handleFailedOperation(workflow, workflow.getCurrentOperation());
                    break;
                }
                case RETRY: {
                    break;
                }
                default: {
                    throw new WorkflowDatabaseException("Retry strategy not implemented yet!");
                }
            }
        }
        return workflow;
    }

    protected void populateMediaPackageMetadata(MediaPackage mp) {
        if (this.metadataServices.isEmpty()) {
            logger.warn("No metadata services are registered, so no media package metadata can be extracted from catalogs");
            return;
        }
        for (MediaPackageMetadataService metadataService : this.metadataServices) {
            MediaPackageMetadata metadata = (MediaPackageMetadata)metadataService.getMetadata(mp);
            MediaPackageMetadataSupport.populateMediaPackageMetadata((MediaPackage)mp, (MediaPackageMetadata)metadata);
        }
    }

    public boolean isReadyToAcceptJobs(String operation) {
        return true;
    }

    public boolean isReadyToAccept(Job job) throws UndispatchableJobException {
        Optional<WorkflowInstance> workflowInstance;
        String mediaPackageId;
        WorkflowInstance workflow;
        String operation = job.getOperation();
        if (!Operation.START_WORKFLOW.toString().equals(operation)) {
            return true;
        }
        if (job.getArguments().size() > 1 && job.getArguments().get(0) != null) {
            try {
                String firstOperationId;
                WorkflowOperationHandler handler;
                WorkflowDefinition workflowDef = XmlWorkflowParser.parseWorkflowDefinition((String)((String)job.getArguments().get(0)));
                if (workflowDef.getOperations().size() > 0 && (handler = this.getWorkflowOperationHandler(firstOperationId = ((WorkflowOperationDefinition)workflowDef.getOperations().get(0)).getId())) instanceof ResumableWorkflowOperationHandler && ((ResumableWorkflowOperationHandler)handler).isAlwaysPause()) {
                    return true;
                }
            }
            catch (WorkflowParsingException e) {
                throw new UndispatchableJobException(String.valueOf(job) + " is not a proper job to start a workflow", (Throwable)e);
            }
        }
        try {
            workflow = this.getWorkflowById(job.getId());
            mediaPackageId = workflow.getMediaPackage().getIdentifier().toString();
        }
        catch (NotFoundException e) {
            throw new UndispatchableJobException("Trying to start workflow with job id " + job.getId() + " but no corresponding instance is available from the workflow service", (Throwable)e);
        }
        catch (UnauthorizedException e) {
            throw new UndispatchableJobException("Authorization denied while requesting to loading workflow instance. Job: " + job.getId(), (Throwable)e);
        }
        try {
            workflowInstance = this.getRunningWorkflowInstanceByMediaPackage(workflow.getMediaPackage().getIdentifier().toString(), Permissions.Action.READ.toString());
        }
        catch (UnauthorizedException e) {
            throw new UndispatchableJobException("Authorization denied while requesting to loading workflow instance " + workflow.getId(), (Throwable)e);
        }
        catch (WorkflowDatabaseException e) {
            throw new UndispatchableJobException("An database error occurred while checking if a workflow is already active (job: " + job.getId() + ")", (Throwable)e);
        }
        catch (WorkflowException e) {
            this.delayWorkflow(workflow, mediaPackageId);
            return false;
        }
        if (workflowInstance.isPresent() && workflow.getId() != workflowInstance.get().getId()) {
            this.delayWorkflow(workflow, mediaPackageId);
            return false;
        }
        return true;
    }

    private void delayWorkflow(WorkflowInstance workflow, String mediaPackageId) {
        if (!this.delayedWorkflows.contains(workflow.getId())) {
            logger.info("Delaying start of workflow {}, another workflow on media package {} is still running", (Object)workflow.getId(), (Object)mediaPackageId);
            this.delayedWorkflows.add(workflow.getId());
        }
    }

    public synchronized void acceptJob(Job job) throws ServiceRegistryException {
        User originalUser = this.securityService.getUser();
        Organization originalOrg = this.securityService.getOrganization();
        try {
            Organization organization = this.organizationDirectoryService.getOrganization(job.getOrganization());
            this.securityService.setOrganization(organization);
            User user = this.userDirectoryService.loadUser(job.getCreator());
            this.securityService.setUser(user);
            job.setStatus(Job.Status.RUNNING);
            job = this.serviceRegistry.updateJob(job);
            if (this.delayedWorkflows.contains(job.getId())) {
                this.delayedWorkflows.remove(job.getId());
                logger.info("Starting initially delayed workflow {}, {} more waiting", (Object)job.getId(), (Object)this.delayedWorkflows.size());
            }
            this.executorService.submit(new JobRunner(job, this.serviceRegistry.getCurrentJob()));
        }
        catch (Exception e) {
            if (e instanceof ServiceRegistryException) {
                throw (ServiceRegistryException)((Object)e);
            }
            throw new ServiceRegistryException((Throwable)e);
        }
        finally {
            this.securityService.setUser(originalUser);
            this.securityService.setOrganization(originalOrg);
        }
    }

    protected String process(Job job) throws Exception {
        List arguments = job.getArguments();
        Operation op = null;
        WorkflowInstance workflowInstance = null;
        String operation = job.getOperation();
        try {
            try {
                op = Operation.valueOf(operation);
                switch (op.ordinal()) {
                    case 0: {
                        workflowInstance = this.persistence.getWorkflow(Long.parseLong(job.getPayload()));
                        logger.debug("Starting new workflow {}", (Object)workflowInstance);
                        this.runWorkflow(workflowInstance);
                        break;
                    }
                    case 1: {
                        workflowInstance = this.getWorkflowById(Long.parseLong((String)arguments.get(0)));
                        HashMap<String, String> properties = null;
                        if (arguments.size() > 1) {
                            Properties props = new Properties();
                            props.load(IOUtils.toInputStream((String)((String)arguments.get(arguments.size() - 1)), (Charset)StandardCharsets.UTF_8));
                            properties = new HashMap<String, String>();
                            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                                properties.put(entry.getKey().toString(), entry.getValue().toString());
                            }
                        }
                        logger.debug("Resuming {} at {}", (Object)workflowInstance, (Object)workflowInstance.getCurrentOperation());
                        workflowInstance.setState(WorkflowInstance.WorkflowState.RUNNING);
                        this.update(workflowInstance);
                        this.runWorkflowOperation(workflowInstance, properties);
                        break;
                    }
                    case 2: {
                        workflowInstance = this.getWorkflowById(Long.parseLong((String)arguments.get(0)));
                        WorkflowOperationInstance wfo = workflowInstance.getCurrentOperation();
                        if (WorkflowOperationInstance.OperationState.RUNNING.equals((Object)wfo.getState()) || WorkflowOperationInstance.OperationState.PAUSED.equals((Object)wfo.getState())) {
                            logger.info("Reset operation state {} {} to INSTANTIATED due to job restart", (Object)workflowInstance, (Object)wfo);
                            wfo.setState(WorkflowOperationInstance.OperationState.INSTANTIATED);
                        }
                        wfo.setExecutionHost(job.getProcessingHost());
                        logger.debug("Running {} {}", (Object)workflowInstance, (Object)wfo);
                        wfo = this.runWorkflowOperation(workflowInstance, null);
                        this.updateOperationJob(job.getId(), wfo.getState());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Don't know how to handle operation '" + operation + "'");
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw new ServiceRegistryException("This service can't handle operations of type '" + String.valueOf((Object)op) + "'", (Throwable)e);
            }
            catch (IndexOutOfBoundsException e) {
                throw new ServiceRegistryException("The argument list for operation '" + String.valueOf((Object)op) + "' (job: " + job.getId() + ") does not meet expectations", (Throwable)e);
            }
            catch (NotFoundException e) {
                logger.warn("Not found processing job {}", (Object)job, (Object)e);
                this.updateOperationJob(job.getId(), WorkflowOperationInstance.OperationState.FAILED);
            }
            return null;
        }
        catch (Exception e) {
            logger.warn("Exception while accepting job {}", (Object)job, (Object)e);
            try {
                if (workflowInstance != null) {
                    logger.warn("Marking job {} and workflow instance {} as failed", (Object)job, (Object)workflowInstance);
                    this.updateOperationJob(job.getId(), WorkflowOperationInstance.OperationState.FAILED);
                    workflowInstance.setState(WorkflowInstance.WorkflowState.FAILED);
                    this.update(workflowInstance);
                } else {
                    logger.warn("Unable to parse workflow instance", (Throwable)e);
                }
            }
            catch (WorkflowDatabaseException e1) {
                throw new ServiceRegistryException((Throwable)e1);
            }
            if (e instanceof ServiceRegistryException) {
                throw e;
            }
            throw new ServiceRegistryException("Error handling operation '" + String.valueOf((Object)op) + "'", (Throwable)e);
        }
    }

    private Job updateOperationJob(Long jobId, WorkflowOperationInstance.OperationState state) throws NotFoundException, ServiceRegistryException {
        if (jobId == null) {
            return null;
        }
        Job job = this.serviceRegistry.getJob(jobId.longValue());
        switch (state) {
            case FAILED: 
            case RETRY: {
                job.setStatus(Job.Status.FAILED);
                break;
            }
            case PAUSED: {
                job.setStatus(Job.Status.PAUSED);
                job.setOperation(Operation.RESUME.toString());
                break;
            }
            case SKIPPED: 
            case SUCCEEDED: {
                job.setStatus(Job.Status.FINISHED);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected state '" + String.valueOf(state) + "' found");
            }
        }
        return this.serviceRegistry.updateJob(job);
    }

    public long countJobs(Job.Status status) throws ServiceRegistryException {
        return this.serviceRegistry.count("org.opencastproject.workflow", status);
    }

    private String mapToString(Map<String, String> props) {
        if (props == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(entry.getValue());
            sb.append("\n");
        }
        return sb.toString();
    }

    @Reference(target="(artifact=workflowdefinition)")
    protected void setProfilesReadyIndicator(ReadinessIndicator unused) {
    }

    @Reference
    protected void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    protected void setServiceRegistry(ServiceRegistry registry) {
        this.serviceRegistry = registry;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectory) {
        this.organizationDirectoryService = organizationDirectory;
    }

    @Reference
    public void setSeriesService(SeriesService seriesService) {
        this.seriesService = seriesService;
    }

    @Reference
    public void setAssetManager(AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="removeMetadataService")
    protected void addMetadataService(MediaPackageMetadataService service) {
        this.metadataServices.add(service);
    }

    protected void removeMetadataService(MediaPackageMetadataService service) {
        this.metadataServices.remove(service);
    }

    @Reference
    protected void addWorkflowDefinitionScanner(WorkflowDefinitionScanner scanner) {
        this.workflowDefinitionScanner = scanner;
    }

    @Reference
    public void setIndex(ElasticsearchIndex index) {
        this.index = index;
    }

    @Reference(name="workflow-persistence")
    public void setPersistence(WorkflowServiceDatabase persistence) {
        this.persistence = persistence;
    }

    public String getJobType() {
        return "org.opencastproject.workflow";
    }

    public synchronized void cleanupWorkflowInstances(int buffer, WorkflowInstance.WorkflowState state) throws UnauthorizedException, WorkflowDatabaseException {
        logger.info("Start cleaning up workflow instances older than {} days with status '{}'", (Object)buffer, (Object)state);
        int instancesCleaned = 0;
        int cleaningFailed = 0;
        Date priorTo = DateUtils.addDays((Date)new Date(), (int)(-buffer));
        try {
            for (WorkflowInstance workflowInstance : this.persistence.getWorkflowInstancesForCleanup(state, priorTo)) {
                try {
                    logger.debug("Deleting workflow instance {}", (Object)workflowInstance.getId());
                    this.remove(workflowInstance.getId());
                    ++instancesCleaned;
                }
                catch (UnauthorizedException | WorkflowDatabaseException e) {
                    throw e;
                }
                catch (NotFoundException e) {
                    logger.debug("Workflow instance '{}' could not be removed", (Object)workflowInstance.getId(), (Object)e);
                }
                catch (WorkflowParsingException | WorkflowStateException e) {
                    logger.warn("Workflow instance '{}' could not be removed", (Object)workflowInstance.getId(), (Object)e);
                    ++cleaningFailed;
                }
            }
        }
        catch (WorkflowDatabaseException e) {
            throw new WorkflowDatabaseException((Throwable)e);
        }
        if (instancesCleaned == 0 && cleaningFailed == 0) {
            logger.info("No workflow instances found to clean up");
            return;
        }
        if (instancesCleaned > 0) {
            logger.info("Cleaned up '{}' workflow instances", (Object)instancesCleaned);
        }
        if (cleaningFailed > 0) {
            logger.warn("Cleaning failed for '{}' workflow instances", (Object)cleaningFailed);
            throw new WorkflowDatabaseException("Unable to clean all workflow instances, see logs!");
        }
    }

    public Map<String, Map<String, String>> getWorkflowStateMappings() {
        return this.workflowDefinitionScanner.workflowStateMappings.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Set)e.getValue()).stream().collect(Collectors.toMap(m -> m.getState().name(), WorkflowStateMapping::getValue))));
    }

    public void repopulate(IndexRebuildService.DataType type) throws IndexRebuildException {
        block15: {
            try {
                List workflowIndexData;
                int total;
                try {
                    total = this.persistence.countMediaPackages();
                }
                catch (WorkflowDatabaseException e) {
                    this.logIndexRebuildError(logger, e);
                    throw new IndexRebuildException(this.getService(), (Throwable)e);
                }
                if (total <= 0) break block15;
                this.logIndexRebuildBegin(logger, total, "workflows");
                int current = 0;
                int n = 20;
                int limit = 1000;
                int offset = 0;
                String lastMediapackageId = "";
                ArrayList<Event> updatedWorkflowRange = new ArrayList<Event>();
                do {
                    try {
                        workflowIndexData = this.persistence.getWorkflowIndexData(limit, offset);
                    }
                    catch (WorkflowDatabaseException e) {
                        this.logIndexRebuildError(logger, e);
                        throw new IndexRebuildException(this.getService(), (Throwable)e);
                    }
                    if (workflowIndexData.isEmpty()) continue;
                    offset += limit;
                    logger.debug("Got {} workflows for re-indexing", (Object)workflowIndexData.size());
                    for (WorkflowIndexData indexData : workflowIndexData) {
                        String currentMediapackageId = indexData.getMediaPackageId();
                        if (currentMediapackageId.equals(lastMediapackageId)) continue;
                        ++current;
                        if (!WorkflowUtil.isActive((String)WorkflowInstance.WorkflowState.values()[indexData.getState()].toString()) || WorkflowInstance.WorkflowState.PAUSED == WorkflowInstance.WorkflowState.values()[indexData.getState()]) {
                            String orgid = indexData.getOrganizationId();
                            if (null == orgid) {
                                String mpId = indexData.getMediaPackageId();
                                RichAResult results = this.assetManager.getSnapshotsById(mpId);
                                if (results.getSize() == 0L) {
                                    logger.debug("Dropping {} from the index since it is missing from the database", (Object)mpId);
                                    continue;
                                }
                                orgid = ((Snapshot)results.getSnapshots().stream().findFirst().get()).getOrganizationId();
                                try {
                                    WorkflowInstance instance = this.persistence.getWorkflow(indexData.getId().longValue(), null);
                                    instance.setOrganizationId(orgid);
                                    this.persistence.updateInDatabase(instance);
                                }
                                catch (NotFoundException notFoundException) {
                                    // empty catch block
                                }
                            }
                            Optional<Event> updatedWorkflowData = this.index.getEvent(indexData.getMediaPackageId(), orgid, this.securityService.getUser());
                            updatedWorkflowData = this.getStateUpdateFunction(indexData.getId(), indexData.getState(), indexData.getMediaPackageId(), indexData.getTemplate(), indexData.getOrganizationId()).apply(updatedWorkflowData);
                            updatedWorkflowRange.add(updatedWorkflowData.get());
                            if (updatedWorkflowRange.size() >= n || current >= total) {
                                this.index.bulkEventUpdate(updatedWorkflowRange);
                                this.logIndexRebuildProgress(logger, total, current, n);
                                updatedWorkflowRange.clear();
                            }
                        } else {
                            logger.info("Skipping. Workflow {} is currently active.", (Object)indexData.getId());
                        }
                        lastMediapackageId = currentMediapackageId;
                    }
                } while (!workflowIndexData.isEmpty());
            }
            catch (Exception e) {
                this.logIndexRebuildError(logger, e);
                throw new IndexRebuildException(this.getService(), (Throwable)e);
            }
        }
    }

    public IndexRebuildService.Service getService() {
        return IndexRebuildService.Service.Workflow;
    }

    private void removeWorkflowInstanceFromIndex(long workflowInstanceId) {
        SearchResult results;
        String orgId = this.securityService.getOrganization().getId();
        User user = this.securityService.getUser();
        try {
            results = this.index.getByQuery(new EventSearchQuery(orgId, user).withWorkflowId(workflowInstanceId));
        }
        catch (SearchIndexException e) {
            logger.error("Error retrieving the events for workflow instance {} from the {} index.", new Object[]{workflowInstanceId, this.index.getIndexName(), e});
            return;
        }
        if (results.getItems().length == 0) {
            logger.warn("No events for workflow instance {} found in the {} index.", (Object)workflowInstanceId, (Object)this.index.getIndexName());
            return;
        }
        for (SearchResultItem item : results.getItems()) {
            String eventId = ((Event)item.getSource()).getIdentifier();
            logger.debug("Removing workflow instance {} of event {} from the {} index.", new Object[]{workflowInstanceId, eventId, this.index.getIndexName()});
            Function<Optional, Optional> updateFunction = eventOpt -> {
                if (!eventOpt.isPresent()) {
                    logger.warn("Event {} of workflow instance {} not found in the {} index.", new Object[]{workflowInstanceId, eventId, this.index.getIndexName()});
                    return Optional.empty();
                }
                Event event = (Event)eventOpt.get();
                if (event.getWorkflowId() != null && event.getWorkflowId().equals(workflowInstanceId)) {
                    logger.debug("Workflow {} is the current workflow of event {}. Removing it from event.", (Object)eventId, (Object)workflowInstanceId);
                    event.setWorkflowId(null);
                    event.setWorkflowDefinitionId(null);
                    event.setWorkflowState(null);
                    return Optional.of(event);
                }
                return Optional.empty();
            };
            try {
                this.index.addOrUpdateEvent(eventId, updateFunction, orgId, user);
                logger.debug("Workflow instance {} of event {} removed from the {} index.", new Object[]{workflowInstanceId, eventId, this.index.getIndexName()});
            }
            catch (SearchIndexException e) {
                logger.error("Error removing the workflow instance {} of event {} from the {} index.", new Object[]{workflowInstanceId, eventId, this.index.getIndexName(), e});
            }
        }
    }

    private void updateWorkflowInstanceInIndex(long id, int state, String wfDefId, String mpId, String orgId) {
        User user = this.securityService.getUser();
        logger.debug("Updating workflow instance {} of event {} in the {} index.", new Object[]{id, mpId, this.index.getIndexName()});
        Function<Optional<Event>, Optional<Event>> updateFunction = this.getStateUpdateFunction(id, state, wfDefId, mpId, orgId);
        try {
            this.index.addOrUpdateEvent(mpId, updateFunction, orgId, user);
            logger.debug("Workflow instance {} of event {} updated in the {} index.", new Object[]{id, mpId, this.index.getIndexName()});
        }
        catch (SearchIndexException e) {
            logger.error("Error updating the workflow instance {} of event {} in the {} index.", new Object[]{id, mpId, this.index.getIndexName(), e});
        }
    }

    private Function<Optional<Event>, Optional<Event>> getStateUpdateFunction(long workflowId, int workflowState, String workflowDefinitionId, String mediaPackageId, String orgId) {
        return eventOpt -> {
            Event event = eventOpt.orElse(new Event(mediaPackageId, orgId));
            event.setWorkflowId(Long.valueOf(workflowId));
            event.setWorkflowState(WorkflowInstance.WorkflowState.values()[workflowState]);
            event.setWorkflowDefinitionId(workflowDefinitionId);
            return Optional.of(event);
        };
    }

    public static class HandlerRegistration {
        protected WorkflowOperationHandler handler;
        protected String operationName;

        public HandlerRegistration(String operationName, WorkflowOperationHandler handler) {
            if (operationName == null) {
                throw new IllegalArgumentException("Operation name cannot be null");
            }
            if (handler == null) {
                throw new IllegalArgumentException("Handler cannot be null");
            }
            this.operationName = operationName;
            this.handler = handler;
        }

        public WorkflowOperationHandler getHandler() {
            return this.handler;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.handler.hashCode();
            result = 31 * result + this.operationName.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HandlerRegistration other = (HandlerRegistration)obj;
            if (!this.handler.equals((Object)other.handler)) {
                return false;
            }
            return this.operationName.equals(other.operationName);
        }
    }

    static enum Operation {
        START_WORKFLOW,
        RESUME,
        START_OPERATION;

    }

    class JobRunner
    implements Callable<Void> {
        private Job job = null;
        private final Job currentJob;

        JobRunner(Job job, Job currentJob) {
            this.job = job;
            this.currentJob = currentJob;
        }

        @Override
        public Void call() throws Exception {
            Organization jobOrganization = WorkflowServiceImpl.this.organizationDirectoryService.getOrganization(this.job.getOrganization());
            try {
                WorkflowServiceImpl.this.serviceRegistry.setCurrentJob(this.currentJob);
                WorkflowServiceImpl.this.securityService.setOrganization(jobOrganization);
                User jobUser = WorkflowServiceImpl.this.userDirectoryService.loadUser(this.job.getCreator());
                WorkflowServiceImpl.this.securityService.setUser(jobUser);
                WorkflowServiceImpl.this.process(this.job);
            }
            finally {
                WorkflowServiceImpl.this.serviceRegistry.setCurrentJob(null);
                WorkflowServiceImpl.this.securityService.setUser(null);
                WorkflowServiceImpl.this.securityService.setOrganization(null);
            }
            return null;
        }
    }
}

