/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.api;

import java.io.Closeable;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.IOUtils;
import org.opencastproject.util.IoSupport;
import org.opencastproject.util.XmlSafeParser;
import org.opencastproject.workflow.api.JaxbWorkflowInstance;
import org.opencastproject.workflow.api.WorkflowDefinition;
import org.opencastproject.workflow.api.WorkflowDefinitionImpl;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowParsingException;
import org.opencastproject.workflow.api.WorkflowSet;
import org.opencastproject.workflow.api.WorkflowSetImpl;
import org.w3c.dom.Node;

public final class XmlWorkflowParser {
    private static final JAXBContext jaxbContext;

    private XmlWorkflowParser() {
    }

    public static List<WorkflowDefinition> parseWorkflowDefinitions(InputStream in) throws WorkflowParsingException {
        try {
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            WorkflowDefinitionImpl[] impls = (WorkflowDefinitionImpl[])unmarshaller.unmarshal((Node)XmlSafeParser.parse((InputStream)in), WorkflowDefinitionImpl[].class).getValue();
            ArrayList<WorkflowDefinition> list = new ArrayList<WorkflowDefinition>();
            for (WorkflowDefinitionImpl impl : impls) {
                list.add(impl);
            }
            ArrayList<WorkflowDefinition> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            throw new WorkflowParsingException(e);
        }
        finally {
            IoSupport.closeQuietly((Closeable)in);
        }
    }

    public static WorkflowDefinition parseWorkflowDefinition(InputStream in) throws WorkflowParsingException {
        try {
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            WorkflowDefinition workflowDefinition = (WorkflowDefinition)unmarshaller.unmarshal((Node)XmlSafeParser.parse((InputStream)in), WorkflowDefinitionImpl.class).getValue();
            return workflowDefinition;
        }
        catch (Exception e) {
            throw new WorkflowParsingException(e);
        }
        finally {
            IoSupport.closeQuietly((Closeable)in);
        }
    }

    public static WorkflowDefinition parseWorkflowDefinition(String in) throws WorkflowParsingException {
        return XmlWorkflowParser.parseWorkflowDefinition(IOUtils.toInputStream((String)in, (String)"UTF8"));
    }

    public static WorkflowInstance parseWorkflowInstance(InputStream in) throws WorkflowParsingException {
        try {
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            WorkflowInstance workflowInstance = ((JaxbWorkflowInstance)unmarshaller.unmarshal((Node)XmlSafeParser.parse((InputStream)in), JaxbWorkflowInstance.class).getValue()).toWorkflowInstance();
            return workflowInstance;
        }
        catch (Exception e) {
            throw new WorkflowParsingException(e);
        }
        finally {
            IoSupport.closeQuietly((Closeable)in);
        }
    }

    public static WorkflowInstance parseWorkflowInstance(String in) throws WorkflowParsingException {
        return XmlWorkflowParser.parseWorkflowInstance(IOUtils.toInputStream((String)in, (String)"UTF8"));
    }

    public static WorkflowSet parseWorkflowSet(InputStream in) throws WorkflowParsingException {
        try {
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            WorkflowSet workflowSet = (WorkflowSet)unmarshaller.unmarshal((Node)XmlSafeParser.parse((InputStream)in), WorkflowSetImpl.class).getValue();
            return workflowSet;
        }
        catch (Exception e) {
            throw new WorkflowParsingException(e);
        }
        finally {
            IoSupport.closeQuietly((Closeable)in);
        }
    }

    public static String toXml(WorkflowInstance workflowInstance) throws WorkflowParsingException {
        return XmlWorkflowParser.toXml(new JaxbWorkflowInstance(workflowInstance));
    }

    public static String toXml(JaxbWorkflowInstance workflowInstance) throws WorkflowParsingException {
        try {
            Marshaller marshaller = jaxbContext.createMarshaller();
            StringWriter writer = new StringWriter();
            marshaller.marshal((Object)workflowInstance, (Writer)writer);
            return ((Object)writer).toString();
        }
        catch (Exception e) {
            throw new WorkflowParsingException(e);
        }
    }

    public static String toXml(WorkflowDefinition workflowDefinition) throws WorkflowParsingException {
        try {
            Marshaller marshaller = jaxbContext.createMarshaller();
            StringWriter writer = new StringWriter();
            marshaller.marshal((Object)workflowDefinition, (Writer)writer);
            return ((Object)writer).toString();
        }
        catch (Exception e) {
            throw new WorkflowParsingException(e);
        }
    }

    static {
        StringBuilder sb = new StringBuilder();
        sb.append("org.opencastproject.mediapackage");
        sb.append(":org.opencastproject.workflow.api");
        try {
            jaxbContext = JAXBContext.newInstance((String)sb.toString(), (ClassLoader)XmlWorkflowParser.class.getClassLoader());
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }
}

