/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.api;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.workflow.api.JaxbWorkflowConfiguration;
import org.opencastproject.workflow.api.JaxbWorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowInstance;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="workflow", namespace="http://workflow.opencastproject.org")
@XmlRootElement(name="workflow", namespace="http://workflow.opencastproject.org")
public class JaxbWorkflowInstance {
    @XmlAttribute
    private long id;
    @XmlAttribute
    private WorkflowInstance.WorkflowState state;
    @XmlElement(name="template")
    private String template;
    @XmlElement(name="title")
    private String title;
    @XmlElement(name="description")
    private String description;
    @XmlElement(name="creator-id", namespace="http://org.opencastproject.security")
    private String creatorName;
    @XmlElement(name="organization-id", namespace="http://org.opencastproject.security")
    private String organizationId;
    @XmlElement
    private Date dateCreated = null;
    @XmlElement
    private Date dateCompleted = null;
    @XmlElement(name="mediapackage", namespace="http://mediapackage.opencastproject.org")
    private MediaPackage mediaPackage;
    @XmlElement(name="operation")
    @XmlElementWrapper(name="operations")
    protected List<JaxbWorkflowOperationInstance> operations;
    @XmlElement(name="configuration")
    @XmlElementWrapper(name="configurations")
    protected Set<JaxbWorkflowConfiguration> configurations;
    @XmlElement
    protected String mediaPackageId;
    @XmlElement
    protected String seriesId;

    public JaxbWorkflowInstance() {
    }

    public JaxbWorkflowInstance(WorkflowInstance workflow) {
        this();
        this.id = workflow.getId();
        this.state = workflow.getState();
        this.template = workflow.getTemplate();
        this.title = workflow.getTitle();
        this.description = workflow.getDescription();
        this.creatorName = workflow.getCreatorName();
        this.organizationId = workflow.getOrganizationId();
        this.dateCreated = workflow.getDateCreated();
        this.dateCompleted = workflow.getDateCompleted();
        this.mediaPackage = workflow.getMediaPackage();
        this.operations = workflow.getOperations().stream().map(JaxbWorkflowOperationInstance::new).collect(Collectors.toList());
        this.configurations = workflow.getConfigurations().entrySet().stream().map(config -> new JaxbWorkflowConfiguration((String)config.getKey(), (String)config.getValue())).collect(Collectors.toSet());
        this.mediaPackageId = this.mediaPackage == null ? null : this.mediaPackage.getIdentifier().toString();
        this.seriesId = this.mediaPackage == null ? null : this.mediaPackage.getSeries();
    }

    public WorkflowInstance toWorkflowInstance() {
        WorkflowInstance wf = new WorkflowInstance(this.id, this.state, this.template, this.title, this.description, this.creatorName, this.organizationId, this.dateCreated, this.dateCompleted, this.mediaPackage, Optional.ofNullable(this.operations).orElseGet(Collections::emptyList).stream().map(JaxbWorkflowOperationInstance::toWorkflowOperationInstance).collect(Collectors.toList()), Optional.ofNullable(this.configurations).orElseGet(Collections::emptySet).stream().collect(Collectors.toMap(JaxbWorkflowConfiguration::getKey, JaxbWorkflowConfiguration::getValue)), this.mediaPackageId, this.seriesId);
        wf.getOperations().stream().forEach(wo -> wo.setWorkflowInstance(wf));
        return wf;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JaxbWorkflowInstance jaxbWorkflow = (JaxbWorkflowInstance)o;
        return new EqualsBuilder().append(this.id, jaxbWorkflow.id).append((Object)this.state, (Object)jaxbWorkflow.state).append((Object)this.template, (Object)jaxbWorkflow.template).append((Object)this.title, (Object)jaxbWorkflow.title).append((Object)this.description, (Object)jaxbWorkflow.description).append((Object)this.creatorName, (Object)jaxbWorkflow.creatorName).append((Object)this.organizationId, (Object)jaxbWorkflow.organizationId).append((Object)this.dateCreated, (Object)jaxbWorkflow.dateCreated).append((Object)this.dateCompleted, (Object)jaxbWorkflow.dateCompleted).append((Object)this.mediaPackage, (Object)jaxbWorkflow.mediaPackage).append(this.operations, jaxbWorkflow.operations).append(this.configurations, jaxbWorkflow.configurations).append((Object)this.mediaPackageId, (Object)jaxbWorkflow.mediaPackageId).append((Object)this.seriesId, (Object)jaxbWorkflow.seriesId).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.id).append((Object)this.state).append((Object)this.template).append((Object)this.title).append((Object)this.description).append((Object)this.creatorName).append((Object)this.organizationId).append((Object)this.dateCreated).append((Object)this.dateCompleted).append((Object)this.mediaPackage).append(this.operations).append(this.configurations).append((Object)this.mediaPackageId).append((Object)this.seriesId).toHashCode();
    }
}

