/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.api;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.opencastproject.workflow.api.Configurable;
import org.opencastproject.workflow.api.RetryStrategy;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationDefinition;

@Entity(name="WorkflowOperationInstance")
@Access(value=AccessType.FIELD)
@Table(name="oc_workflow_operation", indexes={@Index(name="IX_oc_workflow_operation_workflow_id", columnList="workflow_id")})
public class WorkflowOperationInstance
implements Configurable {
    @Id
    @GeneratedValue
    @Column(name="id")
    private Long id;
    @Column(name="template")
    protected String template;
    @Column(name="job")
    protected Long jobId;
    @Column(name="state")
    protected OperationState state;
    @Column(name="description")
    @Lob
    protected String description;
    @ElementCollection
    @CollectionTable(name="oc_workflow_operation_configuration", joinColumns={@JoinColumn(name="workflow_operation_id")}, indexes={@Index(name="IX_oc_workflow_operation_configuration_workflow_operation_id", columnList="workflow_operation_id")})
    @MapKeyColumn(name="configuration_key", nullable=false)
    @Lob
    @Column(name="configuration_value")
    protected Map<String, String> configurations;
    @Column(name="fail_on_error")
    protected boolean failOnError;
    @Column(name="if_condition")
    @Lob
    protected String executeCondition;
    @Column(name="exception_handler_workflow")
    protected String exceptionHandlingWorkflow;
    @Column(name="abortable")
    protected Boolean abortable;
    @Column(name="continuable")
    protected Boolean continuable;
    @Column(name="started")
    @Temporal(value=TemporalType.TIMESTAMP)
    protected Date dateStarted;
    @Column(name="completed")
    @Temporal(value=TemporalType.TIMESTAMP)
    protected Date dateCompleted;
    @Column(name="time_in_queue")
    protected Long timeInQueue;
    @Column(name="max_attempts")
    protected int maxAttempts;
    @Column(name="failed_attempts")
    protected int failedAttempts;
    @Column(name="execution_host")
    protected String executionHost;
    @Column(name="retry_strategy", length=128)
    protected RetryStrategy retryStrategy;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="workflow_id", nullable=false)
    private WorkflowInstance instance;

    public WorkflowOperationInstance() {
        this.maxAttempts = 1;
        this.retryStrategy = RetryStrategy.NONE;
    }

    public WorkflowOperationInstance(WorkflowOperationDefinition def) {
        this();
        this.setTemplate(def.getId());
        this.setState(OperationState.INSTANTIATED);
        this.setDescription(def.getDescription());
        this.setMaxAttempts(def.getMaxAttempts());
        this.setFailOnError(def.isFailWorkflowOnException());
        this.setExceptionHandlingWorkflow(def.getExceptionHandlingWorkflow());
        this.setExecutionCondition(def.getExecutionCondition());
        this.setRetryStrategy(def.getRetryStrategy());
        Set<String> defConfigs = def.getConfigurationKeys();
        this.configurations = new TreeMap<String, String>();
        if (defConfigs != null) {
            for (String key : defConfigs) {
                this.configurations.put(key, def.getConfiguration(key));
            }
        }
        if ((this.retryStrategy == RetryStrategy.RETRY || this.retryStrategy == RetryStrategy.HOLD) && this.maxAttempts < 2) {
            this.maxAttempts = 2;
        }
    }

    public WorkflowOperationInstance(String id, OperationState state) {
        this();
        this.setTemplate(id);
        this.setState(state);
    }

    public WorkflowOperationInstance(String template, Long jobId, OperationState state, String description, Map<String, String> configurations, boolean failOnError, String executeCondition, String exceptionHandlingWorkflow, Boolean abortable, Boolean continuable, Date dateStarted, Date dateCompleted, Long timeInQueue, int maxAttempts, int failedAttempts, String executionHost, RetryStrategy retryStrategy) {
        this.template = template;
        this.jobId = jobId;
        this.state = state;
        this.description = description;
        this.configurations = configurations;
        this.failOnError = failOnError;
        this.executeCondition = executeCondition;
        this.exceptionHandlingWorkflow = exceptionHandlingWorkflow;
        this.abortable = abortable;
        this.continuable = continuable;
        this.dateStarted = dateStarted;
        this.dateCompleted = dateCompleted;
        this.timeInQueue = timeInQueue;
        this.maxAttempts = maxAttempts;
        this.failedAttempts = failedAttempts;
        this.executionHost = executionHost;
        this.retryStrategy = retryStrategy;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getTemplate() {
        return this.template;
    }

    public Long getId() {
        return this.jobId;
    }

    public void setId(Long jobId) {
        this.jobId = jobId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public OperationState getState() {
        return this.state;
    }

    public void setState(OperationState state) {
        Date now = new Date();
        if (OperationState.RUNNING.equals((Object)state)) {
            this.dateStarted = now;
        } else if (OperationState.FAILED.equals((Object)state) || OperationState.SUCCEEDED.equals((Object)state)) {
            this.dateCompleted = now;
        }
        this.state = state;
    }

    public Map<String, String> getConfigurations() {
        return this.configurations;
    }

    @Override
    public String getConfiguration(String key) {
        if (key == null || this.configurations == null) {
            return null;
        }
        return this.configurations.get(key);
    }

    @Override
    public void removeConfiguration(String key) {
        if (key == null || this.configurations == null) {
            return;
        }
        this.configurations.remove(key);
    }

    @Override
    public void setConfiguration(String key, String value) {
        if (key == null) {
            return;
        }
        if (this.configurations == null) {
            this.configurations = new TreeMap<String, String>();
        }
        this.configurations.put(key, value);
    }

    @Override
    public Set<String> getConfigurationKeys() {
        if (this.configurations == null) {
            return Collections.emptySet();
        }
        return this.configurations.keySet();
    }

    public String getExceptionHandlingWorkflow() {
        return this.exceptionHandlingWorkflow;
    }

    public void setExceptionHandlingWorkflow(String exceptionHandlingWorkflow) {
        this.exceptionHandlingWorkflow = exceptionHandlingWorkflow;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public Date getDateStarted() {
        return this.dateStarted;
    }

    public Long getTimeInQueue() {
        return this.timeInQueue;
    }

    public void setTimeInQueue(long timeInQueue) {
        this.timeInQueue = timeInQueue;
    }

    public Date getDateCompleted() {
        return this.dateCompleted;
    }

    public String getExecutionCondition() {
        return this.executeCondition;
    }

    public void setExecutionCondition(String condition) {
        this.executeCondition = condition;
    }

    public Boolean isContinuable() {
        return this.continuable;
    }

    public void setContinuable(Boolean continuable) {
        this.continuable = continuable;
    }

    public Boolean isAbortable() {
        return this.abortable;
    }

    public void setAbortable(Boolean abortable) {
        this.abortable = abortable;
    }

    public RetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    private void setRetryStrategy(RetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    private void setMaxAttempts(int maxAttempts) {
        if (maxAttempts < 1) {
            throw new IllegalArgumentException("maxAttempts must be >=1");
        }
        this.maxAttempts = maxAttempts;
    }

    public int getFailedAttempts() {
        return this.failedAttempts;
    }

    public void setFailedAttempts(int failedAttempts) {
        this.failedAttempts = failedAttempts;
    }

    public String getExecutionHost() {
        return this.executionHost;
    }

    public void setExecutionHost(String executionHost) {
        this.executionHost = executionHost;
    }

    public WorkflowInstance getWorkflowInstance() {
        return this.instance;
    }

    public void setWorkflowInstance(WorkflowInstance instance) {
        this.instance = instance;
    }

    public int hashCode() {
        return Long.valueOf(this.id).hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof WorkflowOperationInstance) {
            WorkflowOperationInstance other = (WorkflowOperationInstance)o;
            return other.getTemplate().equals(this.getTemplate()) && Objects.equals(other.id, this.id);
        }
        return false;
    }

    public String toString() {
        return "operation:'" + this.template + ", state:'" + this.state + "'";
    }

    public static enum OperationState {
        INSTANTIATED,
        RUNNING,
        PAUSED,
        SUCCEEDED,
        FAILED,
        SKIPPED,
        RETRY;

    }
}

