/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.workflow.api.WorkflowDefinition;
import org.opencastproject.workflow.api.WorkflowOperationDefinition;
import org.opencastproject.workflow.api.WorkflowStateMapping;
import org.opencastproject.workflow.api.XmlWorkflowParser;

@XmlType(name="definition", namespace="http://workflow.opencastproject.org")
@XmlRootElement(name="definition", namespace="http://workflow.opencastproject.org")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class WorkflowDefinitionImpl
implements WorkflowDefinition {
    @XmlID
    @XmlElement(name="id")
    private String id;
    @XmlElement(name="title")
    private String title;
    @XmlElement(name="organization")
    private String organization;
    @XmlElementWrapper(name="tags")
    @XmlElement(name="tag")
    protected SortedSet<String> tags = new TreeSet<String>();
    @XmlElementWrapper(name="roles")
    @XmlElement(name="role")
    protected SortedSet<String> roles = new TreeSet<String>();
    @XmlElement(name="description")
    private String description;
    @XmlElement(name="displayOrder")
    private int displayOrder = 0;
    @XmlElement(name="configuration_panel")
    private String configurationPanel;
    @XmlElement(name="configuration_panel_json")
    private String configurationPanelJson;
    @XmlElement(name="operation")
    @XmlElementWrapper(name="operations")
    private List<WorkflowOperationDefinition> operations;
    @XmlElement(name="state-mapping")
    @XmlElementWrapper(name="state-mappings")
    private Set<WorkflowStateMapping> stateMappings;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public int getDisplayOrder() {
        return this.displayOrder;
    }

    @Override
    public void setDisplayOrder(int displayOrder) {
        this.displayOrder = displayOrder;
    }

    public void setConfigurationPanel(String panelXML) {
        this.configurationPanel = panelXML;
    }

    @Override
    public String getConfigurationPanel() {
        return this.configurationPanel;
    }

    public void setConfigurationPanelJson(String panelJson) {
        this.configurationPanelJson = panelJson;
    }

    @Override
    public String getConfigurationPanelJson() {
        return this.configurationPanelJson;
    }

    @Override
    public List<WorkflowOperationDefinition> getOperations() {
        if (this.operations == null) {
            this.operations = new ArrayList<WorkflowOperationDefinition>();
        }
        return this.operations;
    }

    @Override
    public Set<WorkflowStateMapping> getStateMappings() {
        if (this.stateMappings == null) {
            this.stateMappings = new HashSet<WorkflowStateMapping>();
        }
        return this.stateMappings;
    }

    @Override
    public WorkflowOperationDefinition get(int position) throws IndexOutOfBoundsException {
        if (this.operations == null) {
            this.operations = new ArrayList<WorkflowOperationDefinition>();
        }
        if (position < 0 || position >= this.operations.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.operations.get(position);
    }

    @Override
    public void add(WorkflowOperationDefinition operation) {
        if (this.operations == null) {
            this.operations = new ArrayList<WorkflowOperationDefinition>();
        }
        this.add(operation, this.operations.size());
    }

    @Override
    public void add(WorkflowOperationDefinition operation, int position) {
        if (this.operations == null) {
            this.operations = new ArrayList<WorkflowOperationDefinition>();
        }
        if (operation == null) {
            throw new IllegalArgumentException("Workflow operation cannot be null");
        }
        if (position < 0 || position > this.operations.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (position == this.operations.size()) {
            this.operations.add(operation);
        } else {
            this.operations.add(position, operation);
        }
    }

    @Override
    public WorkflowOperationDefinition remove(int position) throws IndexOutOfBoundsException {
        if (this.operations == null) {
            this.operations = new ArrayList<WorkflowOperationDefinition>();
        }
        return this.operations.remove(position);
    }

    @Override
    public void addTag(String tag) {
        if (tag == null) {
            throw new IllegalArgumentException("Tag must not be null");
        }
        this.tags.add(tag);
    }

    @Override
    public void removeTag(String tag) {
        if (tag == null) {
            return;
        }
        this.tags.remove(tag);
    }

    @Override
    public boolean containsTag(String tag) {
        if (tag == null || this.tags == null) {
            return false;
        }
        return this.tags.contains(tag);
    }

    @Override
    public boolean containsTag(Collection<String> tags) {
        if (tags.size() == 0) {
            return true;
        }
        for (String tag : tags) {
            if (!this.containsTag(tag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getTags() {
        return this.tags.toArray(new String[0]);
    }

    @Override
    public void clearTags() {
        if (this.tags != null) {
            this.tags.clear();
        }
    }

    public static WorkflowDefinitionImpl valueOf(String xmlString) throws Exception {
        return (WorkflowDefinitionImpl)XmlWorkflowParser.parseWorkflowDefinition(xmlString);
    }

    @Override
    public int compareTo(WorkflowDefinition workflowDefinition) {
        if (workflowDefinition == null) {
            throw new NullPointerException("WorkflowDefinition for comparison can't be null");
        }
        return StringUtils.compareIgnoreCase((String)this.getTitle(), (String)workflowDefinition.getTitle());
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getOrganization() {
        return this.organization;
    }

    @Override
    public Collection<String> getRoles() {
        if (this.roles == null) {
            return Collections.emptySet();
        }
        return this.roles;
    }

    public String toString() {
        if (this.organization != null) {
            return "Workflow definition {" + this.id + "/" + this.organization + "}";
        }
        return "Workflow definition {" + this.id + "}";
    }

    static class Adapter
    extends XmlAdapter<WorkflowDefinitionImpl, WorkflowDefinition> {
        Adapter() {
        }

        public WorkflowDefinitionImpl marshal(WorkflowDefinition op) {
            return (WorkflowDefinitionImpl)op;
        }

        public WorkflowDefinition unmarshal(WorkflowDefinitionImpl op) {
            return op;
        }
    }
}

