/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.api;

import com.entwinemedia.fn.data.Opt;
import com.entwinemedia.fn.fns.Strings;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobBarrier;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.data.Function;
import org.opencastproject.util.data.Function0;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.functions.Misc;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workflow.api.WorkflowOperationResultImpl;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWorkflowOperationHandler
implements WorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractWorkflowOperationHandler.class);
    protected String id = null;
    protected String description = null;
    protected ServiceRegistry serviceRegistry = null;
    private long jobBarrierPollingInterval = 5000L;
    public static final String TARGET_FLAVORS = "target-flavors";
    public static final String TARGET_FLAVOR = "target-flavor";
    public static final String TARGET_TAGS = "target-tags";
    public static final String TARGET_TAG = "target-tag";
    public static final String SOURCE_FLAVORS = "source-flavors";
    public static final String SOURCE_FLAVOR = "source-flavor";
    public static final String SOURCE_TAG = "source-tag";
    public static final String SOURCE_TAGS = "source-tags";
    protected Function<String, List<String>> asList = new Function<String, List<String>>(){

        public List<String> apply(String s) {
            return AbstractWorkflowOperationHandler.this.asList(s);
        }
    };

    @Activate
    protected void activate(ComponentContext cc) {
        this.id = (String)cc.getProperties().get("workflow.operation");
        this.description = (String)cc.getProperties().get("service.description");
    }

    @Override
    public abstract WorkflowOperationResult start(WorkflowInstance var1, JobContext var2) throws WorkflowOperationException;

    @Override
    public WorkflowOperationResult skip(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        return this.createResult(WorkflowOperationResult.Action.SKIP);
    }

    @Override
    public void destroy(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
    }

    protected List<String> asList(String elements) {
        elements = StringUtils.trimToEmpty((String)elements);
        ArrayList<String> list = new ArrayList<String>();
        for (String s : StringUtils.split((String)elements, (String)",")) {
            if (StringUtils.trimToNull((String)s) == null) continue;
            list.add(s.trim());
        }
        return list;
    }

    protected String getFileNameFromElements(MediaPackageElement source, MediaPackageElement derived) {
        String fileName = FilenameUtils.getBaseName((String)source.getURI().getPath());
        String fileExtension = FilenameUtils.getExtension((String)derived.getURI().getPath());
        return fileName + "." + fileExtension;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    protected WorkflowOperationResult createResult(WorkflowOperationResult.Action action) {
        return this.createResult(null, null, action, 0L);
    }

    protected WorkflowOperationResult createResult(MediaPackage mediaPackage, WorkflowOperationResult.Action action) {
        return this.createResult(mediaPackage, null, action, 0L);
    }

    protected WorkflowOperationResult createResult(MediaPackage mediaPackage, WorkflowOperationResult.Action action, long timeInQueue) {
        return this.createResult(mediaPackage, null, action, timeInQueue);
    }

    protected WorkflowOperationResult createResult(MediaPackage mediaPackage, Map<String, String> properties, WorkflowOperationResult.Action action, long timeInQueue) {
        return new WorkflowOperationResultImpl(mediaPackage, properties, action, timeInQueue);
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    protected JobBarrier.Result waitForStatus(Job ... jobs) throws IllegalStateException, IllegalArgumentException {
        return this.waitForStatus(0L, jobs);
    }

    protected JobBarrier.Result waitForStatus(long timeout, Job ... jobs) throws IllegalStateException, IllegalArgumentException {
        if (this.serviceRegistry == null) {
            throw new IllegalStateException("Can't wait for job status without providing a service registry first");
        }
        JobBarrier barrier = new JobBarrier(null, this.serviceRegistry, this.jobBarrierPollingInterval, jobs);
        return barrier.waitForJobs(timeout);
    }

    protected Option<String> getCfg(WorkflowInstance wi, String key) {
        return Option.option((Object)wi.getCurrentOperation().getConfiguration(key));
    }

    protected String getConfig(WorkflowInstance wi, String key) throws WorkflowOperationException {
        return this.getConfig(wi.getCurrentOperation(), key);
    }

    protected String getConfig(WorkflowInstance w, String key, String defaultValue) {
        Iterator iterator = this.getOptConfig(w.getCurrentOperation(), key).iterator();
        if (iterator.hasNext()) {
            String cfg = (String)iterator.next();
            return cfg;
        }
        return defaultValue;
    }

    protected String getConfig(WorkflowOperationInstance woi, String key) throws WorkflowOperationException {
        Iterator iterator = this.getOptConfig(woi, key).iterator();
        if (iterator.hasNext()) {
            String cfg = (String)iterator.next();
            return cfg;
        }
        throw new WorkflowOperationException(String.format("Configuration key '%s' is either missing or empty", key));
    }

    protected Opt<String> getOptConfig(WorkflowInstance wi, String key) {
        return this.getOptConfig(wi.getCurrentOperation(), key);
    }

    protected Opt<String> getOptConfig(WorkflowOperationInstance woi, String key) {
        return Opt.nul((Object)woi.getConfiguration(key)).flatMap(Strings.trimToNone);
    }

    protected ConfiguredTagsAndFlavors getTagsAndFlavors(WorkflowInstance workflow, Configuration srcTags, Configuration srcFlavors, Configuration targetTags, Configuration targetFlavors) throws WorkflowOperationException {
        MediaPackageElementFlavor flavor;
        WorkflowOperationInstance operation = workflow.getCurrentOperation();
        ConfiguredTagsAndFlavors tagsAndFlavors = new ConfiguredTagsAndFlavors();
        List<String> srcTagList = new ArrayList<String>();
        switch (srcTags) {
            case none: {
                break;
            }
            case one: {
                String srcTag = StringUtils.trimToNull((String)operation.getConfiguration(SOURCE_TAG));
                if (srcTag == null) {
                    throw new WorkflowOperationException("Configuration key 'source-tag' must be set");
                }
                srcTagList.add(srcTag);
                break;
            }
            case many: {
                srcTagList = this.asList(StringUtils.trimToNull((String)operation.getConfiguration(SOURCE_TAGS)));
                String srcTag = StringUtils.trimToNull((String)operation.getConfiguration(SOURCE_TAG));
                if (!srcTagList.isEmpty() || srcTag == null) break;
                srcTagList.add(srcTag);
                break;
            }
            default: {
                throw new WorkflowOperationException("Couldn't process srcTags configuration option!");
            }
        }
        tagsAndFlavors.setSrcTags(srcTagList);
        ArrayList<MediaPackageElementFlavor> srcFlavorList = new ArrayList<MediaPackageElementFlavor>();
        switch (srcFlavors) {
            case none: {
                break;
            }
            case one: {
                String singleSourceFlavor = StringUtils.trimToNull((String)operation.getConfiguration(SOURCE_FLAVOR));
                if (singleSourceFlavor == null) {
                    throw new WorkflowOperationException("Configuration key 'source-flavor' must be set");
                }
                try {
                    flavor = MediaPackageElementFlavor.parseFlavor((String)singleSourceFlavor);
                }
                catch (IllegalArgumentException e) {
                    throw new WorkflowOperationException(singleSourceFlavor + " is not a valid flavor!");
                }
                srcFlavorList.add(flavor);
                break;
            }
            case many: {
                List<String> srcFlavorString = this.asList(StringUtils.trimToNull((String)operation.getConfiguration(SOURCE_FLAVORS)));
                String singleSourceFlavor = StringUtils.trimToNull((String)operation.getConfiguration(SOURCE_FLAVOR));
                if (srcFlavorString.isEmpty() && singleSourceFlavor != null) {
                    srcFlavorString.add(singleSourceFlavor);
                }
                for (String elem : srcFlavorString) {
                    try {
                        flavor = MediaPackageElementFlavor.parseFlavor((String)elem);
                        srcFlavorList.add(flavor);
                    }
                    catch (IllegalArgumentException e) {
                        throw new WorkflowOperationException(elem + " is not a valid flavor!");
                    }
                }
                break;
            }
            default: {
                throw new WorkflowOperationException("Couldn't process srcFlavors configuration option!");
            }
        }
        tagsAndFlavors.setSrcFlavors(srcFlavorList);
        List<String> targetTagList = new ArrayList<String>();
        switch (targetTags) {
            case none: {
                break;
            }
            case one: {
                String targetTag = StringUtils.trimToNull((String)operation.getConfiguration(TARGET_TAG));
                if (targetTag == null) {
                    throw new WorkflowOperationException("Configuration key 'target-tag' must be set");
                }
                targetTagList.add(targetTag);
                break;
            }
            case many: {
                targetTagList = this.asList(StringUtils.trimToNull((String)operation.getConfiguration(TARGET_TAGS)));
                String targetTag = StringUtils.trimToNull((String)operation.getConfiguration(TARGET_TAG));
                if (!targetTagList.isEmpty() || targetTag == null) break;
                targetTagList.add(targetTag);
                break;
            }
            default: {
                throw new WorkflowOperationException("Couldn't process target-tag configuration option!");
            }
        }
        tagsAndFlavors.setTargetTags(targetTagList);
        ArrayList<MediaPackageElementFlavor> targetFlavorList = new ArrayList<MediaPackageElementFlavor>();
        switch (targetFlavors) {
            case none: {
                break;
            }
            case one: {
                String singleTargetFlavor = StringUtils.trimToNull((String)operation.getConfiguration(TARGET_FLAVOR));
                if (singleTargetFlavor == null) {
                    throw new WorkflowOperationException("Configuration key 'target-flavor' must be set");
                }
                try {
                    flavor = MediaPackageElementFlavor.parseFlavor((String)singleTargetFlavor);
                }
                catch (IllegalArgumentException e) {
                    throw new WorkflowOperationException(singleTargetFlavor + " is not a valid flavor!");
                }
                targetFlavorList.add(flavor);
                break;
            }
            case many: {
                List<String> targetFlavorString = this.asList(StringUtils.trimToNull((String)operation.getConfiguration(TARGET_FLAVORS)));
                String singleTargetFlavor = StringUtils.trimToNull((String)operation.getConfiguration(TARGET_FLAVOR));
                if (targetFlavorString.isEmpty() && singleTargetFlavor != null) {
                    targetFlavorString.add(singleTargetFlavor);
                }
                for (String elem : targetFlavorString) {
                    try {
                        flavor = MediaPackageElementFlavor.parseFlavor((String)elem);
                    }
                    catch (IllegalArgumentException e) {
                        throw new WorkflowOperationException(elem + " is not a valid flavor!");
                    }
                    targetFlavorList.add(flavor);
                }
                break;
            }
            default: {
                throw new WorkflowOperationException("Couldn't process targetFlavors configuration option!");
            }
        }
        tagsAndFlavors.setTargetFlavors(targetFlavorList);
        return tagsAndFlavors;
    }

    protected <A> Function0<A> cfgKeyMissing(final String key) {
        return new Function0<A>(){

            public A apply() {
                return Misc.chuck((Throwable)new WorkflowOperationException(key + " is missing or malformed"));
            }
        };
    }

    public void setJobBarrierPollingInterval(long interval) {
        this.jobBarrierPollingInterval = interval;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof WorkflowOperationHandler) {
            if (this.id != null) {
                return this.id.equals(((WorkflowOperationHandler)obj).getId());
            }
            return this == obj;
        }
        return false;
    }

    public String toString() {
        return this.getId();
    }

    protected static enum Configuration {
        none,
        one,
        many;

    }
}

