/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.waveform.ffmpeg;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.AbstractJobProducer;
import org.opencastproject.job.api.Job;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementBuilder;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.identifier.IdImpl;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.util.IoSupport;
import org.opencastproject.util.LoadUtil;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.waveform.api.WaveformService;
import org.opencastproject.waveform.api.WaveformServiceException;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WaveformService.class, ManagedService.class}, property={"service.description=Waveform Service"})
public class WaveformServiceImpl
extends AbstractJobProducer
implements WaveformService,
ManagedService {
    protected static final Logger logger = LoggerFactory.getLogger(WaveformServiceImpl.class);
    protected String binary = "ffmpeg";
    public static final String WAVEFORM_JOB_LOAD_CONFIG_KEY = "job.load.waveform";
    public static final float DEFAULT_WAVEFORM_JOB_LOAD = 0.1f;
    public static final String FFMPEG_BINARY_CONFIG_KEY = "org.opencastproject.composer.ffmpeg.path";
    public static final String DEFAULT_FFMPEG_BINARY = "ffmpeg";
    public static final String DEFAULT_WAVEFORM_SCALE = "lin";
    public static final String WAVEFORM_SCALE_CONFIG_KEY = "waveform.scale";
    public static final boolean DEFAULT_WAVEFORM_SPLIT_CHANNELS = false;
    public static final String WAVEFORM_SPLIT_CHANNELS_CONFIG_KEY = "waveform.split.channels";
    public static final String[] DEFAULT_WAVEFORM_COLOR = new String[]{"black"};
    public static final String WAVEFORM_COLOR_CONFIG_KEY = "waveform.color";
    public static final String DEFAULT_WAVEFORM_FILTER_MODE = "peak";
    public static final String WAVEFORM_FILTER_MODE_CONFIG_KEY = "waveform.filter-mode";
    public static final String DEFAULT_WAVEFORM_FILTER_PRE = null;
    public static final String WAVEFORM_FILTER_PRE_CONFIG_KEY = "waveform.filter.pre";
    public static final String DEFAULT_WAVEFORM_FILTER_POST = null;
    public static final String WAVEFORM_FILTER_POST_CONFIG_KEY = "waveform.filter.post";
    public static final String COLLECTION_ID = "waveform";
    private float waveformJobLoad = 0.1f;
    private String waveformScale = "lin";
    private boolean waveformSplitChannels = false;
    private String[] waveformColor = DEFAULT_WAVEFORM_COLOR;
    private String waveformFilterMode = "peak";
    private String waveformFilterPre = DEFAULT_WAVEFORM_FILTER_PRE;
    private String waveformFilterPost = DEFAULT_WAVEFORM_FILTER_POST;
    private ServiceRegistry serviceRegistry = null;
    private Workspace workspace = null;
    private SecurityService securityService = null;
    private UserDirectoryService userDirectoryService = null;
    private OrganizationDirectoryService organizationDirectoryService = null;

    public WaveformServiceImpl() {
        super("org.opencastproject.waveform");
    }

    @Activate
    public void activate(ComponentContext cc) {
        super.activate(cc);
        logger.info("Activate ffmpeg waveform service");
        String path = cc.getBundleContext().getProperty(FFMPEG_BINARY_CONFIG_KEY);
        this.binary = path == null ? DEFAULT_FFMPEG_BINARY : path;
        logger.debug("ffmpeg binary set to {}", (Object)this.binary);
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        String colorValue;
        if (properties == null) {
            return;
        }
        logger.debug("Configuring the waveform service");
        this.waveformJobLoad = LoadUtil.getConfiguredLoadValue(properties, (String)WAVEFORM_JOB_LOAD_CONFIG_KEY, (Float)Float.valueOf(0.1f), (ServiceRegistry)this.serviceRegistry);
        Object val = properties.get(WAVEFORM_SCALE_CONFIG_KEY);
        if (val != null && StringUtils.isNotEmpty((CharSequence)((String)val))) {
            if (!DEFAULT_WAVEFORM_SCALE.equals(val) && !"log".equals(val)) {
                logger.warn("Waveform scale configuration value '{}' is not in set of predefined values (lin, log). The waveform image extraction job may fail.", val);
            }
            this.waveformScale = (String)val;
        }
        if ((val = properties.get(WAVEFORM_SPLIT_CHANNELS_CONFIG_KEY)) != null) {
            this.waveformSplitChannels = Boolean.parseBoolean((String)val);
        }
        if ((val = properties.get(WAVEFORM_COLOR_CONFIG_KEY)) != null && StringUtils.isNotEmpty((CharSequence)((String)val)) && StringUtils.isNotEmpty((CharSequence)(colorValue = (String)val)) && StringUtils.isNotBlank((CharSequence)colorValue)) {
            this.waveformColor = StringUtils.split((String)colorValue, (String)", |:;");
        }
        if ((val = properties.get(WAVEFORM_FILTER_MODE_CONFIG_KEY)) != null && StringUtils.isNotEmpty((CharSequence)((String)val))) {
            if (!"average".equals(val) && !DEFAULT_WAVEFORM_FILTER_MODE.equals(val)) {
                logger.warn("Waveform filter mode configuration value '{}' is not in set of predefined values (average, peak). The waveform image extraction job may fail.", val);
            }
            this.waveformFilterMode = (String)val;
        }
        this.waveformFilterPre = (val = properties.get(WAVEFORM_FILTER_PRE_CONFIG_KEY)) != null ? StringUtils.trimToNull((String)((String)val)) : null;
        val = properties.get(WAVEFORM_FILTER_POST_CONFIG_KEY);
        this.waveformFilterPost = val != null ? StringUtils.trimToNull((String)((String)val)) : null;
    }

    public Job createWaveformImage(Track sourceTrack, int pixelsPerMinute, int minWidth, int maxWidth, int height, String color) throws MediaPackageException, WaveformServiceException {
        try {
            return this.serviceRegistry.createJob(this.jobType, Operation.Waveform.toString(), Arrays.asList(MediaPackageElementParser.getAsXml((MediaPackageElement)sourceTrack), Integer.toString(pixelsPerMinute), Integer.toString(minWidth), Integer.toString(maxWidth), Integer.toString(height), color), Float.valueOf(this.waveformJobLoad));
        }
        catch (ServiceRegistryException ex) {
            throw new WaveformServiceException("Unable to create waveform job", (Throwable)ex);
        }
    }

    protected String process(Job job) throws Exception {
        Operation op = null;
        String operation = job.getOperation();
        List arguments = job.getArguments();
        try {
            op = Operation.valueOf(operation);
            switch (op.ordinal()) {
                case 0: {
                    Track track = (Track)MediaPackageElementParser.getFromXml((String)((String)arguments.get(0)));
                    int pixelsPerMinute = Integer.parseInt((String)arguments.get(1));
                    int minWidth = Integer.parseInt((String)arguments.get(2));
                    int maxWidth = Integer.parseInt((String)arguments.get(3));
                    int height = Integer.parseInt((String)arguments.get(4));
                    String color = (String)arguments.get(5);
                    Attachment waveformMpe = this.extractWaveform(track, pixelsPerMinute, minWidth, maxWidth, height, color);
                    return MediaPackageElementParser.getAsXml((MediaPackageElement)waveformMpe);
                }
            }
            throw new ServiceRegistryException("This service can't handle operations of type '" + String.valueOf((Object)op) + "'");
        }
        catch (IndexOutOfBoundsException e) {
            throw new ServiceRegistryException("This argument list for operation '" + String.valueOf((Object)op) + "' does not meet expectations", (Throwable)e);
        }
        catch (MediaPackageException | WaveformServiceException e) {
            throw new ServiceRegistryException("Error handling operation '" + String.valueOf((Object)op) + "'", e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Attachment extractWaveform(Track track, int pixelsPerMinute, int minWidth, int maxWidth, int height, String color) throws WaveformServiceException {
        URI waveformFileUri;
        File mediaFile;
        if (!track.hasAudio()) {
            throw new WaveformServiceException("Track has no audio");
        }
        try {
            mediaFile = this.workspace.get(track.getURI());
        }
        catch (NotFoundException e) {
            throw new WaveformServiceException("Error finding the media file in the workspace", (Throwable)e);
        }
        catch (IOException e) {
            throw new WaveformServiceException("Error reading the media file in the workspace", (Throwable)e);
        }
        String waveformFilePath = FilenameUtils.removeExtension((String)mediaFile.getAbsolutePath()).concat("-" + track.getIdentifier()).concat("-waveform.png");
        int width = this.getWaveformImageWidth(track, pixelsPerMinute, minWidth, maxWidth);
        Object[] command = new String[]{this.binary, "-nostats", "-nostdin", "-hide_banner", "-i", mediaFile.getAbsolutePath(), "-lavfi", this.createWaveformFilter(width, height, color), "-frames:v", "1", "-an", "-vn", "-sn", waveformFilePath};
        logger.debug("Start waveform ffmpeg process: {}", (Object)StringUtils.join((Object[])command, (String)" "));
        logger.info("Create waveform image file for track '{}' at {}", (Object)track.getIdentifier(), (Object)waveformFilePath);
        ProcessBuilder pb = new ProcessBuilder((String[])command);
        pb.redirectErrorStream(true);
        Process ffmpegProcess = null;
        int exitCode = 1;
        BufferedReader errStream = null;
        try {
            ffmpegProcess = pb.start();
            errStream = new BufferedReader(new InputStreamReader(ffmpegProcess.getInputStream()));
            String line = errStream.readLine();
            while (line != null) {
                logger.debug(line);
                line = errStream.readLine();
            }
            exitCode = ffmpegProcess.waitFor();
        }
        catch (IOException ex) {
            try {
                throw new WaveformServiceException("Start ffmpeg process failed", (Throwable)ex);
                catch (InterruptedException ex2) {
                    throw new WaveformServiceException("Waiting for encoder process exited was interrupted unexpectedly", (Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                IoSupport.closeQuietly((Process)ffmpegProcess);
                IoSupport.closeQuietly(errStream);
                if (exitCode == 0) throw throwable;
                try {
                    FileUtils.forceDelete((File)new File(waveformFilePath));
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        IoSupport.closeQuietly((Process)ffmpegProcess);
        IoSupport.closeQuietly((Closeable)errStream);
        if (exitCode != 0) {
            try {
                FileUtils.forceDelete((File)new File(waveformFilePath));
            }
            catch (IOException line) {}
        }
        if (exitCode != 0) {
            throw new WaveformServiceException(String.format("The encoder process exited abnormally with exit code %s using command\n%s", exitCode, String.join((CharSequence)" ", (CharSequence[])command)));
        }
        FileInputStream waveformFileInputStream = null;
        try {
            waveformFileInputStream = new FileInputStream(waveformFilePath);
            waveformFileUri = this.workspace.putInCollection(COLLECTION_ID, FilenameUtils.getName((String)waveformFilePath), (InputStream)waveformFileInputStream);
            logger.info("Copied the created waveform to the workspace {}", (Object)waveformFileUri);
        }
        catch (FileNotFoundException ex) {
            try {
                throw new WaveformServiceException(String.format("Waveform image file '%s' not found", waveformFilePath), (Throwable)ex);
                catch (IOException ex3) {
                    throw new WaveformServiceException(String.format("Can't write waveform image file '%s' to workspace", waveformFilePath), (Throwable)ex3);
                }
                catch (IllegalArgumentException ex4) {
                    throw new WaveformServiceException((Throwable)ex4);
                }
            }
            catch (Throwable throwable) {
                IoSupport.closeQuietly(waveformFileInputStream);
                logger.info("Deleted local waveform image file at {}", (Object)waveformFilePath);
                FileUtils.deleteQuietly((File)new File(waveformFilePath));
                throw throwable;
            }
        }
        IoSupport.closeQuietly((Closeable)waveformFileInputStream);
        logger.info("Deleted local waveform image file at {}", (Object)waveformFilePath);
        FileUtils.deleteQuietly((File)new File(waveformFilePath));
        MediaPackageElementBuilder mpElementBuilder = MediaPackageElementBuilderFactory.newInstance().newElementBuilder();
        Attachment waveformMpe = (Attachment)mpElementBuilder.elementFromURI(waveformFileUri, MediaPackageElement.Type.Attachment, track.getFlavor());
        waveformMpe.setIdentifier(IdImpl.fromUUID().toString());
        return waveformMpe;
    }

    private String createWaveformFilter(int width, int height, String color) {
        StringBuilder filterBuilder = new StringBuilder();
        if (this.waveformFilterPre != null) {
            filterBuilder.append(this.waveformFilterPre);
            filterBuilder.append(",");
        }
        String[] waveformOperationColors = null;
        waveformOperationColors = StringUtils.isNotBlank((CharSequence)color) ? StringUtils.split((String)color, (String)"|") : this.waveformColor;
        filterBuilder.append("showwavespic=");
        filterBuilder.append("split_channels=");
        filterBuilder.append(this.waveformSplitChannels ? 1 : 0);
        filterBuilder.append(":s=");
        filterBuilder.append(width);
        filterBuilder.append("x");
        filterBuilder.append(height);
        filterBuilder.append(":scale=");
        filterBuilder.append(this.waveformScale);
        filterBuilder.append(":filter=");
        filterBuilder.append(this.waveformFilterMode);
        filterBuilder.append(":colors=");
        filterBuilder.append(StringUtils.join(Arrays.asList(waveformOperationColors), (String)"|"));
        if (this.waveformFilterPost != null) {
            filterBuilder.append(",");
            filterBuilder.append(this.waveformFilterPost);
        }
        return filterBuilder.toString();
    }

    private int getWaveformImageWidth(Track track, int pixelsPerMinute, int minWidth, int maxWidth) {
        int imageWidth = minWidth;
        if (track.getDuration() > 0L) {
            int trackDurationMinutes = (int)TimeUnit.MILLISECONDS.toMinutes(track.getDuration());
            if (pixelsPerMinute > 0 && trackDurationMinutes > 0) {
                imageWidth = Math.max(minWidth, trackDurationMinutes * pixelsPerMinute);
                imageWidth = Math.min(maxWidth, imageWidth);
            }
        }
        return imageWidth;
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    protected SecurityService getSecurityService() {
        return this.securityService;
    }

    protected UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    protected OrganizationDirectoryService getOrganizationDirectoryService() {
        return this.organizationDirectoryService;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectoryService) {
        this.organizationDirectoryService = organizationDirectoryService;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    static enum Operation {
        Waveform;

    }
}

