/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.videosegmenter.ffmpeg.endpoint;

import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.JaxbJob;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobProducer;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.rest.AbstractJobProducerEndpoint;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.opencastproject.videosegmenter.api.VideoSegmenterException;
import org.opencastproject.videosegmenter.api.VideoSegmenterService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/analysis/videosegmenter")
@RestService(name="videosegmentation", title="Video Segmentation Service", abstractText="This service performs segmentation of media files.", notes={"All paths above are relative to the REST endpoint base (something like http://your.server/files)", "If the service is down or not working it will return a status 503, this means the the underlying service is not working and is either restarting or has failed", "A status code 500 means a general failure has occurred which is not recoverable and was not anticipated. In other words, there is a bug! You should file an error report with your server logs from the time when the error occurred: <a href=\"https://github.com/opencast/opencast/issues\">Opencast Issue Tracker</a>"})
@Component(immediate=true, service={VideoSegmenterRestEndpoint.class}, property={"service.description=Video Segmentation REST Endpoint", "opencast.service.type=org.opencastproject.videosegmenter", "opencast.service.path=/analysis/videosegmenter", "opencast.service.jobproducer=true"})
@JaxrsResource
public class VideoSegmenterRestEndpoint
extends AbstractJobProducerEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(VideoSegmenterRestEndpoint.class);
    protected String docs;
    protected VideoSegmenterService service;
    protected ServiceRegistry serviceRegistry = null;

    @Reference
    protected void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Reference
    protected void setVideoSegmenter(VideoSegmenterService videoSegmenter) {
        this.service = videoSegmenter;
    }

    @POST
    @Path(value="")
    @Produces(value={"text/xml"})
    @RestQuery(name="segment", description="Submit a track for segmentation.", restParameters={@RestParameter(description="The track to segment.", isRequired=true, name="track", type=RestParameter.Type.FILE)}, responses={@RestResponse(description="The job ID to use when polling for the resulting mpeg7 catalog.", responseCode=200), @RestResponse(description="The \"segment\" is NULL or not a valid track type.", responseCode=400), @RestResponse(description="The underlying service could not segment the video.", responseCode=500)}, returnDescription="The job ID to use when polling for the resulting mpeg7 catalog.")
    public Response segment(@FormParam(value="track") String trackAsXml) throws Exception {
        if (StringUtils.isBlank((CharSequence)trackAsXml)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"track must not be null").build();
        }
        MediaPackageElement sourceTrack = MediaPackageElementParser.getFromXml((String)trackAsXml);
        if (!Track.TYPE.equals((Object)sourceTrack.getElementType())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"mediapackage element must be of type track").build();
        }
        try {
            Job job = this.service.segment((Track)sourceTrack);
            return Response.ok().entity((Object)new JaxbJob(job)).build();
        }
        catch (VideoSegmenterException e) {
            logger.warn("Segmentation failed: " + e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="docs")
    public String getDocs() {
        return this.docs;
    }

    public JobProducer getService() {
        if (this.service instanceof JobProducer) {
            return (JobProducer)this.service;
        }
        return null;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }
}

