/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.usertracking.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Dictionary;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.opencastproject.db.DBSession;
import org.opencastproject.db.DBSessionFactory;
import org.opencastproject.db.Queries;
import org.opencastproject.usertracking.api.FootprintList;
import org.opencastproject.usertracking.api.Report;
import org.opencastproject.usertracking.api.UserAction;
import org.opencastproject.usertracking.api.UserActionList;
import org.opencastproject.usertracking.api.UserSession;
import org.opencastproject.usertracking.api.UserTrackingException;
import org.opencastproject.usertracking.api.UserTrackingService;
import org.opencastproject.usertracking.endpoint.FootprintImpl;
import org.opencastproject.usertracking.endpoint.FootprintsListImpl;
import org.opencastproject.usertracking.endpoint.ReportImpl;
import org.opencastproject.usertracking.endpoint.ReportItemImpl;
import org.opencastproject.usertracking.impl.UserActionImpl;
import org.opencastproject.usertracking.impl.UserActionListImpl;
import org.opencastproject.util.NotFoundException;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={UserTrackingService.class, ManagedService.class}, property={"service.description=User Tracking Service", "service.pid=org.opencastproject.usertracking.impl.UserTrackingServiceImpl"})
public class UserTrackingServiceImpl
implements UserTrackingService,
ManagedService {
    public static final String PERSISTENCE_UNIT = "org.opencastproject.usertracking";
    public static final String FOOTPRINT_KEY = "FOOTPRINT";
    public static final String DETAILED_TRACKING = "org.opencastproject.usertracking.detailedtrack";
    public static final String IP_LOGGING = "org.opencastproject.usertracking.log.ip";
    public static final String USER_LOGGING = "org.opencastproject.usertracking.log.user";
    public static final String SESSION_LOGGING = "org.opencastproject.usertracking.log.session";
    private static final Logger logger = LoggerFactory.getLogger(UserTrackingServiceImpl.class);
    private boolean detailedTracking = false;
    private boolean logIp = true;
    private boolean logUser = true;
    private boolean logSession = true;
    protected EntityManagerFactory emf = null;
    protected DBSessionFactory dbSessionFactory;
    protected DBSession db;

    @Reference(target="(osgi.unit.name=org.opencastproject.usertracking)")
    void setEntityManagerFactory(EntityManagerFactory emf) {
        this.emf = emf;
    }

    @Reference
    public void setDBSessionFactory(DBSessionFactory dbSessionFactory) {
        this.dbSessionFactory = dbSessionFactory;
    }

    @Activate
    public void activate() {
        logger.debug("activate()");
        this.db = this.dbSessionFactory.createSession(this.emf);
    }

    public void updated(Dictionary props) throws ConfigurationException {
        if (props == null) {
            logger.debug("Null properties in user tracking service, not doing detailed logging");
            return;
        }
        Object val = props.get(DETAILED_TRACKING);
        if (val != null && String.class.isInstance(val)) {
            this.detailedTracking = Boolean.valueOf((String)val);
        }
        if ((val = props.get(IP_LOGGING)) != null && String.class.isInstance(val)) {
            this.logIp = Boolean.valueOf((String)val);
        }
        if ((val = props.get(USER_LOGGING)) != null && String.class.isInstance(val)) {
            this.logUser = Boolean.valueOf((String)val);
        }
        if ((val = props.get(SESSION_LOGGING)) != null && String.class.isInstance(val)) {
            this.logSession = Boolean.valueOf((String)val);
        }
    }

    @Override
    public int getViews(String mediapackageId) {
        return ((Long)this.db.exec(Queries.namedQuery.find("countSessionsOfMediapackage", Long.class, new Object[]{Pair.of((Object)"mediapackageId", (Object)mediapackageId)}))).intValue();
    }

    @Override
    public UserAction addUserFootprint(UserAction action, UserSession session) throws UserTrackingException {
        action.setType(FOOTPRINT_KEY);
        if (!this.logIp) {
            session.setUserIp("-omitted-");
        }
        if (!this.logUser) {
            session.setUserId("-omitted-");
        }
        if (!this.logSession) {
            session.setSessionId("-omitted-");
        }
        try {
            return (UserAction)this.db.execTx(em -> {
                UserSession userSession = this.populateSession((EntityManager)em, session);
                List userActions = em.createNamedQuery("findLastUserFootprintOfSession", UserAction.class).setParameter("session", (Object)userSession).setMaxResults(1).getResultList();
                if (userActions.isEmpty()) {
                    action.setSession(userSession);
                    em.persist((Object)action);
                    return action;
                }
                UserAction lastAction = (UserAction)userActions.iterator().next();
                if (lastAction.getMediapackageId().equals(action.getMediapackageId()) && lastAction.getType().equals(action.getType()) && lastAction.getOutpoint() == action.getInpoint()) {
                    action.setId(lastAction.getId());
                    lastAction.setOutpoint(action.getOutpoint());
                    em.persist((Object)lastAction);
                    return lastAction;
                }
                action.setSession(userSession);
                em.persist((Object)action);
                return action;
            });
        }
        catch (Exception e) {
            throw new UserTrackingException(e);
        }
    }

    @Override
    public UserAction addUserTrackingEvent(UserAction a, UserSession session) throws UserTrackingException {
        if (!this.logIp) {
            session.setUserIp("-omitted-");
        }
        if (!this.logUser) {
            session.setUserId("-omitted-");
        }
        if (!this.logSession) {
            session.setSessionId("-omitted-");
        }
        try {
            return (UserAction)this.db.execTx(em -> {
                UserSession userSession = this.populateSession((EntityManager)em, session);
                a.setSession(userSession);
                em.persist((Object)a);
                return a;
            });
        }
        catch (Exception e) {
            throw new UserTrackingException(e);
        }
    }

    private synchronized UserSession populateSession(EntityManager em, UserSession session) {
        try {
            return (UserSession)Queries.namedQuery.find("findUserSessionBySessionId", UserSession.class, new Object[]{Pair.of((Object)"sessionId", (Object)session.getSessionId())}).apply(em);
        }
        catch (NoResultException n) {
            em.persist((Object)session);
            EntityTransaction tx = em.getTransaction();
            tx.commit();
            tx.begin();
            return session;
        }
    }

    @Override
    public UserActionList getUserActions(int offset, int limit) {
        UserActionListImpl result = new UserActionListImpl();
        this.db.exec(em -> {
            result.setTotal(this.getTotalQuery().apply((EntityManager)em));
            result.setOffset(offset);
            result.setLimit(limit);
            TypedQuery q = em.createNamedQuery("findUserActions", UserAction.class).setFirstResult(offset);
            if (limit > 0) {
                q.setMaxResults(limit);
            }
            q.getResultList().forEach(result::add);
        });
        return result;
    }

    private Function<EntityManager, Integer> getTotalQuery() {
        return Queries.namedQuery.find("findTotal", Long.class, new Object[0]).andThen(Long::intValue);
    }

    @Override
    public UserActionList getUserActionsByType(String type, int offset, int limit) {
        UserActionListImpl result = new UserActionListImpl();
        this.db.exec(em -> {
            result.setTotal(this.getTotalQuery(type).apply((EntityManager)em));
            result.setOffset(offset);
            result.setLimit(limit);
            TypedQuery q = em.createNamedQuery("findUserActionsByType", UserAction.class).setParameter("type", (Object)type).setFirstResult(offset);
            if (limit > 0) {
                q.setMaxResults(limit);
            }
            q.getResultList().forEach(result::add);
        });
        return result;
    }

    private Function<EntityManager, Integer> getTotalQuery(String type) {
        return Queries.namedQuery.find("findTotalByType", Long.class, new Object[]{Pair.of((Object)"type", (Object)type)}).andThen(Long::intValue);
    }

    @Override
    public UserActionList getUserActionsByTypeAndMediapackageId(String type, String mediapackageId, int offset, int limit) {
        UserActionListImpl result = new UserActionListImpl();
        this.db.exec(em -> {
            result.setTotal(this.getTotalQuery(type, mediapackageId).apply((EntityManager)em));
            result.setOffset(offset);
            result.setLimit(limit);
            TypedQuery q = em.createNamedQuery("findUserActionsByTypeAndMediapackageId", UserAction.class).setParameter("type", (Object)type).setParameter("mediapackageId", (Object)mediapackageId).setFirstResult(offset);
            if (limit > 0) {
                q.setMaxResults(limit);
            }
            q.getResultList().forEach(result::add);
        });
        return result;
    }

    @Override
    public UserActionList getUserActionsByTypeAndDay(String type, String day, int offset, int limit) {
        UserActionListImpl result = new UserActionListImpl();
        int year = Integer.parseInt(day.substring(0, 4));
        int month = Integer.parseInt(day.substring(4, 6)) - 1;
        int date = Integer.parseInt(day.substring(6, 8));
        GregorianCalendar calBegin = new GregorianCalendar();
        calBegin.set(year, month, date, 0, 0);
        GregorianCalendar calEnd = new GregorianCalendar();
        calEnd.set(year, month, date, 23, 59);
        this.db.exec(em -> {
            result.setTotal(this.getTotalQuery(type, calBegin, calEnd).apply((EntityManager)em));
            result.setOffset(offset);
            result.setLimit(limit);
            TypedQuery q = em.createNamedQuery("findUserActionsByTypeAndIntervall", UserAction.class).setParameter("type", (Object)type).setParameter("begin", calBegin, TemporalType.TIMESTAMP).setParameter("end", calEnd, TemporalType.TIMESTAMP).setFirstResult(offset);
            if (limit > 0) {
                q.setMaxResults(limit);
            }
            q.getResultList().forEach(result::add);
        });
        return result;
    }

    @Override
    public UserActionList getUserActionsByTypeAndMediapackageIdByDate(String type, String mediapackageId, int offset, int limit) {
        UserActionListImpl result = new UserActionListImpl();
        this.db.exec(em -> {
            result.setTotal(this.getTotalQuery(type, mediapackageId).apply((EntityManager)em));
            result.setOffset(offset);
            result.setLimit(limit);
            TypedQuery q = em.createNamedQuery("findUserActionsByMediaPackageAndTypeAscendingByDate", UserAction.class).setParameter("type", (Object)type).setParameter("mediapackageId", (Object)mediapackageId).setFirstResult(offset);
            if (limit > 0) {
                q.setMaxResults(limit);
            }
            q.getResultList().forEach(result::add);
        });
        return result;
    }

    @Override
    public UserActionList getUserActionsByTypeAndMediapackageIdByDescendingDate(String type, String mediapackageId, int offset, int limit) {
        UserActionListImpl result = new UserActionListImpl();
        this.db.exec(em -> {
            result.setTotal(this.getTotalQuery(type, mediapackageId).apply((EntityManager)em));
            result.setOffset(offset);
            result.setLimit(limit);
            TypedQuery q = em.createNamedQuery("findUserActionsByMediaPackageAndTypeDescendingByDate", UserAction.class).setParameter("type", (Object)type).setParameter("mediapackageId", (Object)mediapackageId).setFirstResult(offset);
            if (limit > 0) {
                q.setMaxResults(limit);
            }
            q.getResultList().forEach(result::add);
        });
        return result;
    }

    private Function<EntityManager, Integer> getTotalQuery(String type, Calendar calBegin, Calendar calEnd) {
        return Queries.namedQuery.find("findTotalByTypeAndIntervall", Long.class, new Object[]{Pair.of((Object)"type", (Object)type), Pair.of((Object)"begin", (Object)calBegin), Pair.of((Object)"end", (Object)calEnd)}).andThen(Long::intValue);
    }

    private Function<EntityManager, Integer> getTotalQuery(String type, String mediapackageId) {
        return Queries.namedQuery.find("findTotalByTypeAndMediapackageId", Long.class, new Object[]{Pair.of((Object)"type", (Object)type), Pair.of((Object)"mediapackageId", (Object)mediapackageId)}).andThen(Long::intValue);
    }

    @Override
    public UserActionList getUserActionsByDay(String day, int offset, int limit) {
        UserActionListImpl result = new UserActionListImpl();
        int year = Integer.parseInt(day.substring(0, 4));
        int month = Integer.parseInt(day.substring(4, 6)) - 1;
        int date = Integer.parseInt(day.substring(6, 8));
        GregorianCalendar calBegin = new GregorianCalendar();
        calBegin.set(year, month, date, 0, 0);
        GregorianCalendar calEnd = new GregorianCalendar();
        calEnd.set(year, month, date, 23, 59);
        this.db.exec(em -> {
            result.setTotal(this.getTotalQuery(calBegin, calEnd).apply((EntityManager)em));
            result.setOffset(offset);
            result.setLimit(limit);
            TypedQuery q = em.createNamedQuery("findUserActionsByIntervall", UserAction.class).setParameter("begin", calBegin, TemporalType.TIMESTAMP).setParameter("end", calEnd, TemporalType.TIMESTAMP).setFirstResult(offset);
            if (limit > 0) {
                q.setMaxResults(limit);
            }
            q.getResultList().forEach(result::add);
        });
        return result;
    }

    private Function<EntityManager, Integer> getTotalQuery(Calendar calBegin, Calendar calEnd) {
        return Queries.namedQuery.find("findTotalByIntervall", Long.class, new Object[]{Pair.of((Object)"begin", (Object)calBegin), Pair.of((Object)"end", (Object)calEnd)}).andThen(Long::intValue);
    }

    @Override
    public Report getReport(int offset, int limit) {
        ReportImpl report = new ReportImpl();
        report.setLimit(limit);
        report.setOffset(offset);
        this.db.exec(em -> {
            TypedQuery q = em.createNamedQuery("countSessionsGroupByMediapackage", Object[].class).setFirstResult(offset);
            if (limit > 0) {
                q.setMaxResults(limit);
            }
            q.getResultList().forEach(row -> {
                ReportItemImpl item = new ReportItemImpl();
                item.setEpisodeId((String)row[0]);
                item.setViews((Long)row[1]);
                item.setPlayed((Long)row[2]);
                report.add(item);
            });
        });
        return report;
    }

    @Override
    public Report getReport(String from, String to, int offset, int limit) throws ParseException {
        ReportImpl report = new ReportImpl();
        report.setLimit(limit);
        report.setOffset(offset);
        GregorianCalendar calBegin = new GregorianCalendar();
        GregorianCalendar calEnd = new GregorianCalendar();
        SimpleDateFormat complex = new SimpleDateFormat("yyyyMMddhhmm");
        SimpleDateFormat simple = new SimpleDateFormat("yyyyMMdd");
        try {
            calBegin.setTime(complex.parse(from));
        }
        catch (ParseException e) {
            calBegin.setTime(simple.parse(from));
        }
        try {
            calEnd.setTime(complex.parse(to));
        }
        catch (ParseException e) {
            calEnd.setTime(simple.parse(to));
        }
        this.db.exec(em -> {
            TypedQuery q = em.createNamedQuery("countSessionsGroupByMediapackageByIntervall", Object[].class).setParameter("begin", calBegin, TemporalType.TIMESTAMP).setParameter("end", calEnd, TemporalType.TIMESTAMP).setFirstResult(offset);
            if (limit > 0) {
                q.setMaxResults(limit);
            }
            q.getResultList().forEach(row -> {
                ReportItemImpl item = new ReportItemImpl();
                item.setEpisodeId((String)row[0]);
                item.setViews((Long)row[1]);
                item.setPlayed((Long)row[2]);
                report.add(item);
            });
        });
        return report;
    }

    @Override
    public FootprintList getFootprints(String mediapackageId, String userId) {
        List userActions = (List)this.db.exec(em -> {
            TypedQuery q = !this.logUser || StringUtils.trimToNull((String)userId) == null ? em.createNamedQuery("findUserActionsByTypeAndMediapackageIdOrderByOutpointDESC", UserAction.class) : em.createNamedQuery("findUserActionsByTypeAndMediapackageIdByUserOrderByOutpointDESC", UserAction.class).setParameter("userid", (Object)userId);
            q.setParameter("type", (Object)FOOTPRINT_KEY);
            q.setParameter("mediapackageId", (Object)mediapackageId);
            return q.getResultList();
        });
        int[] resultArray = new int[1];
        boolean first = true;
        for (UserAction a : userActions) {
            if (first) {
                resultArray = new int[a.getOutpoint() + 1];
                first = false;
            }
            int i = a.getInpoint();
            while (i < a.getOutpoint()) {
                int n = i++;
                resultArray[n] = resultArray[n] + 1;
            }
        }
        FootprintsListImpl list = new FootprintsListImpl();
        int current = -1;
        int last = -1;
        for (int i = 0; i < resultArray.length; ++i) {
            current = resultArray[i];
            if (last != current) {
                FootprintImpl footprint = new FootprintImpl();
                footprint.setPosition(i);
                footprint.setViews(current);
                list.add(footprint);
            }
            last = current;
        }
        return list;
    }

    @Override
    public UserAction getUserAction(Long id) throws UserTrackingException, NotFoundException {
        try {
            return (UserAction)((Optional)this.db.exec(Queries.namedQuery.findByIdOpt(UserActionImpl.class, (Object)id))).orElseThrow(NoResultException::new);
        }
        catch (NoResultException e) {
            throw new NotFoundException("No UserAction found with id='" + id + "'");
        }
        catch (Exception e) {
            throw new UserTrackingException(e);
        }
    }

    @Override
    public boolean getUserTrackingEnabled() {
        return this.detailedTracking;
    }
}

