/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.textanalyzer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.composer.api.ComposerService;
import org.opencastproject.composer.api.EncoderException;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementBuilder;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.MediaPackageReference;
import org.opencastproject.mediapackage.MediaPackageReferenceImpl;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.metadata.mpeg7.MediaDuration;
import org.opencastproject.metadata.mpeg7.MediaRelTimePointImpl;
import org.opencastproject.metadata.mpeg7.MediaTime;
import org.opencastproject.metadata.mpeg7.MediaTimeImpl;
import org.opencastproject.metadata.mpeg7.MediaTimePoint;
import org.opencastproject.metadata.mpeg7.Mpeg7Catalog;
import org.opencastproject.metadata.mpeg7.Mpeg7CatalogService;
import org.opencastproject.metadata.mpeg7.Segment;
import org.opencastproject.metadata.mpeg7.SpatioTemporalDecomposition;
import org.opencastproject.metadata.mpeg7.SpatioTemporalLocator;
import org.opencastproject.metadata.mpeg7.SpatioTemporalLocatorImpl;
import org.opencastproject.metadata.mpeg7.TemporalDecomposition;
import org.opencastproject.metadata.mpeg7.Video;
import org.opencastproject.metadata.mpeg7.VideoSegment;
import org.opencastproject.metadata.mpeg7.VideoText;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.textanalyzer.api.TextAnalyzerException;
import org.opencastproject.textanalyzer.api.TextAnalyzerService;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class, ManagedService.class}, property={"service.description=Text Analysis Workflow Operation Handler", "workflow.operation=extract-text"})
public class TextAnalysisWorkflowOperationHandler
extends AbstractWorkflowOperationHandler
implements ManagedService {
    private static final Logger logger = LoggerFactory.getLogger(TextAnalysisWorkflowOperationHandler.class);
    public static final String IMAGE_EXTRACTION_PROFILE = "text-analysis.http";
    private static final int DEFAULT_STABILITY_THRESHOLD = 5;
    public static final String OPT_STABILITY_THRESHOLD = "stabilitythreshold";
    private int stabilityThreshold = 5;
    private Workspace workspace = null;
    private Mpeg7CatalogService mpeg7CatalogService = null;
    private TextAnalyzerService analysisService = null;
    protected ComposerService composer = null;

    @Reference
    protected void setTextAnalyzer(TextAnalyzerService analysisService) {
        this.analysisService = analysisService;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference(name="Mpeg7Service")
    protected void setMpeg7CatalogService(Mpeg7CatalogService catalogService) {
        this.mpeg7CatalogService = catalogService;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        logger.debug("Running segments preview workflow operation on {}", (Object)workflowInstance);
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.none);
        MediaPackage src = (MediaPackage)workflowInstance.getMediaPackage().clone();
        Catalog[] segmentCatalogs = src.getCatalogs(MediaPackageElements.SEGMENTS);
        if (segmentCatalogs.length == 0) {
            logger.info("Media package {} does not contain segment information", (Object)src);
            return this.createResult(WorkflowOperationResult.Action.CONTINUE);
        }
        try {
            return this.extractVideoText(src, workflowInstance.getCurrentOperation(), tagsAndFlavors);
        }
        catch (Exception e) {
            throw new WorkflowOperationException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WorkflowOperationResult extractVideoText(MediaPackage mediaPackage, WorkflowOperationInstance operation, ConfiguredTagsAndFlavors tagsAndFlavors) throws EncoderException, InterruptedException, ExecutionException, IOException, NotFoundException, MediaPackageException, TextAnalyzerException, WorkflowOperationException, ServiceRegistryException {
        long totalTimeInQueue = 0L;
        List sourceTagSet = tagsAndFlavors.getSrcTags();
        List targetTagSet = tagsAndFlavors.getTargetTags();
        Map<Catalog, Mpeg7Catalog> catalogs = this.loadSegmentCatalogs(mediaPackage, operation, tagsAndFlavors);
        if (catalogs.size() == 0) {
            logger.debug("Mediapackage {} has no suitable mpeg-7 catalogs based on tags {} to to run text analysis", (Object)mediaPackage, (Object)sourceTagSet);
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
        }
        for (Map.Entry<Catalog, Mpeg7Catalog> mapEntry : catalogs.entrySet()) {
            HashMap<VideoSegment, Job> jobs = new HashMap<VideoSegment, Job>();
            LinkedList<Attachment> images = new LinkedList<Attachment>();
            Catalog segmentCatalog = mapEntry.getKey();
            try {
                Object imageMpe22;
                MediaPackageReference catalogRef = segmentCatalog.getReference();
                if (catalogRef == null) {
                    logger.info("Skipping catalog {} since we can't determine the source track", (Object)segmentCatalog);
                } else if (mediaPackage.getElementByReference(catalogRef) == null) {
                    logger.info("Skipping catalog {} since we can't determine the source track", (Object)segmentCatalog);
                } else if (!(mediaPackage.getElementByReference(catalogRef) instanceof Track)) {
                    logger.info("Skipping catalog {} since it's source was not a track", (Object)segmentCatalog);
                }
                logger.info("Analyzing mpeg-7 segments catalog {} for text", (Object)segmentCatalog);
                Mpeg7Catalog textCatalog = mapEntry.getValue().clone();
                Track sourceTrack = mediaPackage.getTrack(catalogRef.getIdentifier());
                Video videoContent = (Video)textCatalog.videoContent().next();
                TemporalDecomposition decomposition = videoContent.getTemporalDecomposition();
                Iterator segmentIterator = decomposition.segments();
                LinkedList<VideoSegment> videoSegments = new LinkedList<VideoSegment>();
                while (segmentIterator.hasNext()) {
                    Segment segment = (Segment)segmentIterator.next();
                    if (!(segment instanceof VideoSegment)) continue;
                    videoSegments.add((VideoSegment)segment);
                }
                double[] times = new double[videoSegments.size()];
                for (int i = 0; i < videoSegments.size(); ++i) {
                    VideoSegment videoSegment = (VideoSegment)videoSegments.get(i);
                    MediaTimePoint segmentTimePoint = videoSegment.getMediaTime().getMediaTimePoint();
                    MediaDuration mediaDuration = videoSegment.getMediaTime().getMediaDuration();
                    MediaPackageReferenceImpl reference = null;
                    reference = catalogRef == null ? new MediaPackageReferenceImpl() : new MediaPackageReferenceImpl(catalogRef.getType(), catalogRef.getIdentifier());
                    reference.setProperty("time", segmentTimePoint.toString());
                    long startTimeSeconds = segmentTimePoint.getTimeInMilliseconds() / 1000L;
                    long durationSeconds = mediaDuration.getDurationInMilliseconds() / 1000L;
                    times[i] = Math.max(startTimeSeconds + durationSeconds - (long)this.stabilityThreshold + 1L, 0L);
                }
                Job imageJob = this.composer.image(sourceTrack, IMAGE_EXTRACTION_PROFILE, times);
                if (!this.waitForStatus(new Job[]{imageJob}).isSuccess()) {
                    throw new WorkflowOperationException("Extracting scene images from " + String.valueOf(sourceTrack) + " failed");
                }
                if (imageJob.getPayload() == null) {
                    throw new WorkflowOperationException("The payload of extracting images job from " + String.valueOf(sourceTrack) + " was null");
                }
                totalTimeInQueue += imageJob.getQueueTime().longValue();
                for (Object imageMpe22 : MediaPackageElementParser.getArrayFromXml((String)imageJob.getPayload())) {
                    Attachment attachment = (Attachment)imageMpe22;
                    images.add(attachment);
                }
                if (images.isEmpty() || images.size() != times.length) {
                    throw new WorkflowOperationException("There are no images produced for " + String.valueOf(sourceTrack) + " or the images count isn't equal the count of the video segments.");
                }
                Iterator it = videoSegments.iterator();
                for (MediaPackageElement mediaPackageElement : images) {
                    Attachment image = (Attachment)mediaPackageElement;
                    VideoSegment videoSegment = (VideoSegment)it.next();
                    jobs.put(videoSegment, this.analysisService.extract(image));
                }
                if (!this.waitForStatus(jobs.values().toArray(new Job[jobs.size()])).isSuccess()) {
                    throw new WorkflowOperationException("Text extraction failed on images from " + String.valueOf(sourceTrack));
                }
                imageMpe22 = jobs.entrySet().iterator();
                while (imageMpe22.hasNext()) {
                    Map.Entry entry = (Map.Entry)imageMpe22.next();
                    Job job = this.serviceRegistry.getJob(((Job)entry.getValue()).getId());
                    totalTimeInQueue += job.getQueueTime().longValue();
                    VideoSegment videoSegment = (VideoSegment)entry.getKey();
                    MediaDuration segmentDuration = videoSegment.getMediaTime().getMediaDuration();
                    Catalog catalog = (Catalog)MediaPackageElementParser.getFromXml((String)job.getPayload());
                    if (catalog == null) {
                        logger.warn("Text analysis did not return a valid mpeg7 for segment {}", (Object)videoSegment);
                        continue;
                    }
                    Mpeg7Catalog videoTextCatalog = this.loadMpeg7Catalog(catalog);
                    if (videoTextCatalog == null) {
                        throw new IllegalStateException("Text analysis service did not return a valid mpeg7");
                    }
                    Iterator videoTextContents = videoTextCatalog.videoContent();
                    if (videoTextContents == null || !videoTextContents.hasNext()) {
                        logger.debug("Text analysis was not able to extract any text from {}", job.getArguments().get(0));
                        break;
                    }
                    try {
                        Video textVideoContent = (Video)videoTextContents.next();
                        VideoSegment textVideoSegment = (VideoSegment)textVideoContent.getTemporalDecomposition().segments().next();
                        VideoText[] videoTexts = textVideoSegment.getSpatioTemporalDecomposition().getVideoText();
                        SpatioTemporalDecomposition std = videoSegment.createSpatioTemporalDecomposition(true, false);
                        for (VideoText videoText : videoTexts) {
                            MediaTimeImpl mediaTime = new MediaTimeImpl((MediaTimePoint)new MediaRelTimePointImpl(0L), segmentDuration);
                            SpatioTemporalLocatorImpl locator = new SpatioTemporalLocatorImpl((MediaTime)mediaTime);
                            videoText.setSpatioTemporalLocator((SpatioTemporalLocator)locator);
                            std.addVideoText(videoText);
                        }
                    }
                    catch (Exception e) {
                        logger.warn("The mpeg-7 structure returned by the text analyzer is not what is expected", (Throwable)e);
                    }
                }
                MediaPackageElementBuilder builder = MediaPackageElementBuilderFactory.newInstance().newElementBuilder();
                Catalog catalog = (Catalog)builder.newElement(MediaPackageElement.Type.Catalog, MediaPackageElements.TEXTS);
                catalog.setIdentifier(null);
                catalog.setReference(segmentCatalog.getReference());
                mediaPackage.add(catalog);
                InputStream in = this.mpeg7CatalogService.serialize(textCatalog);
                String filename = "slidetext.xml";
                URI workspaceURI = this.workspace.put(mediaPackage.getIdentifier().toString(), catalog.getIdentifier(), filename, in);
                catalog.setURI(workspaceURI);
                try {
                    mediaPackage.remove(segmentCatalog);
                    this.workspace.delete(segmentCatalog.getURI());
                }
                catch (Exception e) {
                    logger.warn("Unable to delete segment catalog {}", (Object)segmentCatalog.getURI(), (Object)e);
                }
                catalog.setFlavor(MediaPackageElements.TEXTS);
                for (String tag : targetTagSet) {
                    catalog.addTag(tag);
                }
            }
            finally {
                logger.debug("Removing temporary images");
                for (Attachment image : images) {
                    try {
                        this.workspace.delete(image.getURI());
                    }
                    catch (Exception e) {
                        logger.warn("Unable to delete temporary image {}", (Object)image.getURI(), (Object)e);
                    }
                }
                for (Job j : jobs.values()) {
                    Catalog catalog = null;
                    try {
                        Job job = this.serviceRegistry.getJob(j.getId());
                        if (!Job.Status.FINISHED.equals((Object)job.getStatus()) || (catalog = (Catalog)MediaPackageElementParser.getFromXml((String)job.getPayload())) == null) continue;
                        this.workspace.delete(catalog.getURI());
                    }
                    catch (Exception e) {
                        if (catalog != null) {
                            logger.warn("Unable to delete temporary text file {}", (Object)catalog.getURI(), (Object)e);
                            continue;
                        }
                        logger.warn("Unable to parse textextraction payload of job {}", (Object)j.getId());
                    }
                }
            }
        }
        logger.debug("Text analysis completed");
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE, totalTimeInQueue);
    }

    protected Mpeg7Catalog loadMpeg7Catalog(Catalog catalog) throws IOException {
        Mpeg7Catalog mpeg7Catalog;
        FileInputStream in = null;
        try {
            File f = this.workspace.get(catalog.getURI());
            in = new FileInputStream(f);
            mpeg7Catalog = this.mpeg7CatalogService.load((InputStream)in);
        }
        catch (NotFoundException e) {
            try {
                throw new IOException("Unable to open catalog " + String.valueOf(catalog) + ": " + e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return mpeg7Catalog;
    }

    protected Map<Catalog, Mpeg7Catalog> loadSegmentCatalogs(MediaPackage mediaPackage, WorkflowOperationInstance operation, ConfiguredTagsAndFlavors tagsAndFlavors) throws IOException {
        Catalog[] catalogsWithTags;
        HashMap<Catalog, Mpeg7Catalog> catalogs = new HashMap<Catalog, Mpeg7Catalog>();
        List sourceFlavors = tagsAndFlavors.getSrcFlavors();
        List sourceTagSet = tagsAndFlavors.getSrcTags();
        for (Catalog mediaPackageCatalog : catalogsWithTags = mediaPackage.getCatalogsByTags((Collection)sourceTagSet)) {
            Track t;
            if (!MediaPackageElements.SEGMENTS.equals((Object)mediaPackageCatalog.getFlavor()) || sourceFlavors != null && (mediaPackageCatalog.getReference() == null || (t = mediaPackage.getTrack(mediaPackageCatalog.getReference().getIdentifier())) == null || sourceFlavors.stream().noneMatch(flavor -> t.getFlavor().matches(flavor))) || !mediaPackageCatalog.containsTag((Collection)sourceTagSet)) continue;
            Mpeg7Catalog mpeg7 = this.loadMpeg7Catalog(mediaPackageCatalog);
            if (mpeg7.videoContent() == null || !mpeg7.videoContent().hasNext()) {
                logger.debug("Mpeg-7 segments catalog {} does not contain any video content", (Object)mpeg7);
                continue;
            }
            Video videoContent = (Video)mpeg7.videoContent().next();
            TemporalDecomposition decomposition = videoContent.getTemporalDecomposition();
            if (decomposition == null || !decomposition.hasSegments()) {
                logger.debug("Mpeg-7 catalog {} does not contain a temporal decomposition", (Object)mpeg7);
                continue;
            }
            catalogs.put(mediaPackageCatalog, mpeg7);
        }
        return catalogs;
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        if (properties != null && properties.get(OPT_STABILITY_THRESHOLD) != null) {
            String threshold = StringUtils.trimToNull((String)((String)properties.get(OPT_STABILITY_THRESHOLD)));
            try {
                this.stabilityThreshold = Integer.parseInt(threshold);
                logger.info("The videosegmenter's stability threshold has been set to {} frames", (Object)this.stabilityThreshold);
            }
            catch (Exception e) {
                this.stabilityThreshold = 5;
                logger.warn("Found illegal value '{}' for the videosegmenter stability threshold. Falling back to default value of {} frames", (Object)threshold, (Object)5);
            }
        } else {
            this.stabilityThreshold = 5;
            logger.info("Using the default value of {} frames for the videosegmenter stability threshold", (Object)5);
        }
    }

    @Reference
    void setComposerService(ComposerService composerService) {
        this.composer = composerService;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

