/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.subtitleparser.webvttparser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.input.BOMInputStream;
import org.opencastproject.subtitleparser.SubtitleParsingException;
import org.opencastproject.subtitleparser.webvttparser.WebVTTSubtitle;
import org.opencastproject.subtitleparser.webvttparser.WebVTTSubtitleCue;
import org.opencastproject.subtitleparser.webvttparser.WebVTTSubtitleRegion;
import org.opencastproject.subtitleparser.webvttparser.WebVTTSubtitleStyle;

public class WebVTTParser {
    private static final String WEBVTT_METADATA_HEADER_STRING = "\\S*[:=]\\S*";
    private static final Pattern WEBVTT_METADATA_HEADER = Pattern.compile("\\S*[:=]\\S*");
    private static final String WEBVTT_CUE_IDENTIFIER_STRING = "^(?!.*(-->)).*$";
    private static final Pattern WEBVTT_CUE_IDENTIFIER = Pattern.compile("^(?!.*(-->)).*$");
    private static final String WEBVTT_TIMESTAMP_STRING = "(\\d+:)?[0-5]\\d:[0-5]\\d\\.\\d{3}";
    private static final Pattern WEBVTT_TIMESTAMP = Pattern.compile("(\\d+:)?[0-5]\\d:[0-5]\\d\\.\\d{3}");
    private Charset charset;

    public WebVTTParser() {
        this.charset = StandardCharsets.UTF_8;
    }

    public WebVTTParser(Charset charset) {
        this.charset = charset;
    }

    public WebVTTSubtitle parse(InputStream is) throws IOException, SubtitleParsingException {
        BOMInputStream bomIn = new BOMInputStream(is, false);
        WebVTTSubtitle subtitle = new WebVTTSubtitle();
        BufferedReader webvttReader = new BufferedReader(new InputStreamReader((InputStream)bomIn, this.charset));
        String line = "";
        line = webvttReader.readLine();
        if (line == null) {
            throw new SubtitleParsingException("WEBVTT Header line is null");
        }
        if (!line.startsWith("WEBVTT")) {
            throw new SubtitleParsingException("Header line did not start with WEBVTT. Got " + line);
        }
        subtitle.addHeaderLine(line);
        while ((line = webvttReader.readLine()) != null && !line.isEmpty()) {
            subtitle.addHeaderLine(line);
        }
        while ((line = webvttReader.readLine()) != null) {
            WebVTTSubtitleCue cue = new WebVTTSubtitleCue();
            if (line.isEmpty()) continue;
            if (line.startsWith("REGION")) {
                WebVTTSubtitleRegion region = new WebVTTSubtitleRegion();
                region.addLine(line);
                while ((line = webvttReader.readLine()) != null && !line.isEmpty()) {
                    region.addLine(line);
                }
                subtitle.addRegion(region);
                continue;
            }
            if (line.startsWith("STYLE")) {
                WebVTTSubtitleStyle style = new WebVTTSubtitleStyle();
                style.addLine(line);
                while ((line = webvttReader.readLine()) != null && !line.isEmpty()) {
                    style.addLine(line);
                }
                subtitle.addStyle(style);
                continue;
            }
            if (line.startsWith("NOTE")) {
                while ((line = webvttReader.readLine()) != null && !line.isEmpty()) {
                }
                continue;
            }
            Matcher matcher = WEBVTT_CUE_IDENTIFIER.matcher(line);
            if (matcher.find()) {
                cue.setId(line);
                line = webvttReader.readLine();
            }
            if (!(matcher = WEBVTT_TIMESTAMP.matcher(line)).find()) {
                throw new SubtitleParsingException("Expected cue start time: " + line);
            }
            cue.setStartTime(WebVTTParser.parseTimestamp(matcher.group()));
            if (!matcher.find()) {
                throw new SubtitleParsingException("Expected cue end time: " + line);
            }
            cue.setEndTime(WebVTTParser.parseTimestamp(matcher.group()));
            String cueSettings = line.substring(matcher.end()).trim();
            if (!cueSettings.isEmpty()) {
                cue.setCueSettingsList(cueSettings);
            }
            while ((line = webvttReader.readLine()) != null && !line.isEmpty()) {
                cue.addLine(line);
            }
            subtitle.addCue(cue);
        }
        webvttReader.close();
        is.close();
        return subtitle;
    }

    private static long parseTimestamp(String s) throws NumberFormatException {
        if (!s.matches(WEBVTT_TIMESTAMP_STRING)) {
            throw new NumberFormatException("has invalid format");
        }
        String[] parts = s.split("\\.", 2);
        long value = 0L;
        for (String group : parts[0].split(":")) {
            value = value * 60L + Long.parseLong(group);
        }
        return value * 1000L + Long.parseLong(parts[1]);
    }
}

