/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.silencedetection.remote;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobParser;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.serviceregistry.api.RemoteBase;
import org.opencastproject.silencedetection.api.SilenceDetectionFailedException;
import org.opencastproject.silencedetection.api.SilenceDetectionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SilenceDetectionServiceRemote
extends RemoteBase
implements SilenceDetectionService {
    private static final Logger logger = LoggerFactory.getLogger(SilenceDetectionServiceRemote.class);

    public SilenceDetectionServiceRemote() {
        super("org.opencastproject.silencedetection");
    }

    public Job detect(Track sourceTrack) throws SilenceDetectionFailedException {
        return this.detect(sourceTrack, null);
    }

    public Job detect(Track sourceTrack, Track[] referencedTracks) throws SilenceDetectionFailedException {
        HttpPost post = new HttpPost("/detect");
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        try {
            params.add(new BasicNameValuePair("track", MediaPackageElementParser.getAsXml((MediaPackageElement)sourceTrack)));
            if (referencedTracks != null && referencedTracks.length > 0) {
                String referencedTracksXml = MediaPackageElementParser.getArrayAsXml(Arrays.asList(referencedTracks));
                params.add(new BasicNameValuePair("referenceTracks", referencedTracksXml));
            }
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (Exception e) {
            throw new SilenceDetectionFailedException("Unable to assemble a remote silence detection request for track " + sourceTrack.getIdentifier());
        }
        HttpResponse response = null;
        try {
            String entity;
            response = this.getResponse((HttpRequestBase)post);
            if (response != null && StringUtils.isNotEmpty((CharSequence)(entity = EntityUtils.toString((HttpEntity)response.getEntity())))) {
                Job resultJob = JobParser.parseJob((String)entity);
                logger.info("Start silence detection for track '{}' on remote silence detection service", (Object)sourceTrack.getIdentifier());
                Job job = resultJob;
                return job;
            }
        }
        catch (Exception e) {
            throw new SilenceDetectionFailedException("Unable to run silence detection for track " + sourceTrack.getIdentifier() + " on remote silence detection service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new SilenceDetectionFailedException("Unable to run silence detection for track " + sourceTrack.getIdentifier() + " on remote silence detection service");
    }
}

