/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.silencedetection.endpoint;

import java.util.List;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.opencastproject.job.api.JaxbJob;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobProducer;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.rest.AbstractJobProducerEndpoint;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.silencedetection.api.SilenceDetectionService;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;

@Path(value="/silencedetection")
@RestService(name="SilenceDetectionServiceEndpoint", title="Silence Detection Service REST Endpoint", abstractText="Detect silent sequences in audio file.", notes={"All paths above are relative to the REST endpoint base (/silencedetection)"})
@Component(property={"service.description=Silence Detection Service REST Endpoint", "opencast.service.type=org.opencastproject.silencedetection", "opencast.service.path=/silencedetection", "opencast.service.jobproducer=true"}, immediate=true, service={SilenceDetectionServiceEndpoint.class})
@JaxrsResource
public class SilenceDetectionServiceEndpoint
extends AbstractJobProducerEndpoint {
    private SilenceDetectionService silenceDetectionService;
    private ServiceRegistry serviceRegistry;

    @POST
    @Path(value="/detect")
    @Produces(value={"application/xml"})
    @RestQuery(name="detect", description="Create silence detection job.", returnDescription="Silence detection job.", restParameters={@RestParameter(name="track", type=RestParameter.Type.TEXT, description="Track where to run silence detection.", isRequired=true), @RestParameter(name="referenceTracks", type=RestParameter.Type.TEXT, description="Tracks referenced by resulting smil (as sources).", isRequired=false)}, responses={@RestResponse(description="Silence detection job created successfully.", responseCode=200), @RestResponse(description="Create silence detection job failed.", responseCode=500)})
    public Response detect(@FormParam(value="track") String trackXml, @FormParam(value="referenceTracks") String referenceTracksXml) {
        try {
            Track track = (Track)MediaPackageElementParser.getFromXml((String)trackXml);
            Job job = null;
            if (referenceTracksXml != null) {
                List referenceTracks = null;
                referenceTracks = MediaPackageElementParser.getArrayFromXml((String)referenceTracksXml);
                job = this.silenceDetectionService.detect(track, referenceTracks.toArray(new Track[referenceTracks.size()]));
            } else {
                job = this.silenceDetectionService.detect(track);
            }
            return Response.ok((Object)new JaxbJob(job)).build();
        }
        catch (Exception ex) {
            return Response.serverError().entity((Object)ex.getMessage()).build();
        }
    }

    public JobProducer getService() {
        if (this.silenceDetectionService instanceof JobProducer) {
            return (JobProducer)this.silenceDetectionService;
        }
        return null;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Reference
    public void setSilenceDetectionService(SilenceDetectionService silenceDetectionService) {
        this.silenceDetectionService = silenceDetectionService;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }
}

