/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.assetmanager.api.Property;
import org.opencastproject.assetmanager.api.PropertyId;
import org.opencastproject.assetmanager.api.Value;
import org.opencastproject.assetmanager.api.query.AQueryBuilder;
import org.opencastproject.assetmanager.api.query.ARecord;
import org.opencastproject.assetmanager.api.query.AResult;
import org.opencastproject.assetmanager.api.query.Target;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElements;

public final class WorkflowPropertiesUtil {
    private static final Set<MediaPackageElementFlavor> SECURITY_FLAVORS = new HashSet<MediaPackageElementFlavor>(Arrays.asList(MediaPackageElements.XACML_POLICY_EPISODE, MediaPackageElements.XACML_POLICY_SERIES));

    private WorkflowPropertiesUtil() {
    }

    public static Map<String, Map<String, String>> getLatestWorkflowPropertiesForEvents(AssetManager assetManager, Collection<String> eventIds) {
        AQueryBuilder query = assetManager.createQuery();
        AResult result = query.select(new Target[]{query.snapshot(), query.propertiesOf(new String[]{"org.opencastproject.workflow.configuration"})}).where(query.mediaPackageIds(eventIds.toArray(new String[0])).and(query.version().isLatest())).run();
        HashMap<String, Map<String, String>> workflowProperties = new HashMap<String, Map<String, String>>(eventIds.size());
        for (ARecord record : result.getRecords()) {
            List recordProps = record.getProperties();
            HashMap<String, String> eventMap = new HashMap<String, String>(recordProps.size());
            for (Property property : recordProps) {
                eventMap.put(property.getId().getName(), (String)property.getValue().get((Value.ValueType)Value.STRING));
            }
            String eventId = record.getMediaPackageId();
            workflowProperties.put(eventId, eventMap);
        }
        return workflowProperties;
    }

    public static Map<String, String> getLatestWorkflowProperties(AssetManager assetManager, String mediaPackageId) {
        return assetManager.selectProperties(mediaPackageId, "org.opencastproject.workflow.configuration").parallelStream().collect(Collectors.toMap(p -> p.getId().getName(), p -> (String)p.getValue().get((Value.ValueType)Value.STRING)));
    }

    public static void storeProperties(AssetManager assetManager, MediaPackage mediaPackage, Map<String, String> properties) {
        if (!assetManager.snapshotExists(mediaPackage.getIdentifier().toString())) {
            MediaPackage simplifiedMediaPackage = (MediaPackage)mediaPackage.clone();
            for (MediaPackageElement element : mediaPackage.getElements()) {
                if (element instanceof Catalog || element instanceof Attachment && SECURITY_FLAVORS.contains(element.getFlavor())) continue;
                simplifiedMediaPackage.remove(element);
            }
            assetManager.takeSnapshot("default", simplifiedMediaPackage);
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            PropertyId propertyId = PropertyId.mk((String)mediaPackage.getIdentifier().toString(), (String)"org.opencastproject.workflow.configuration", (String)entry.getKey());
            Property property = Property.mk((PropertyId)propertyId, (Value)Value.mk((String)entry.getValue()));
            assetManager.setProperty(property);
        }
    }

    public static void storeProperty(AssetManager assetManager, MediaPackage mediaPackage, String name, String value) {
        WorkflowPropertiesUtil.storeProperties(assetManager, mediaPackage, Collections.singletonMap(name, value));
    }
}

