/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.scheduler.impl.persistence;

import com.google.gson.Gson;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.tuple.Pair;
import org.joda.time.DateTime;
import org.opencastproject.db.DBSession;
import org.opencastproject.db.DBSessionFactory;
import org.opencastproject.db.Queries;
import org.opencastproject.scheduler.impl.SchedulerServiceDatabase;
import org.opencastproject.scheduler.impl.SchedulerServiceDatabaseException;
import org.opencastproject.scheduler.impl.persistence.EventIdPK;
import org.opencastproject.scheduler.impl.persistence.ExtendedEventDto;
import org.opencastproject.scheduler.impl.persistence.LastModifiedDto;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.util.NotFoundException;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={SchedulerServiceDatabase.class})
public class SchedulerServiceDatabaseImpl
implements SchedulerServiceDatabase {
    public static final String PERSISTENCE_UNIT = "org.opencastproject.scheduler.impl.persistence";
    private static final Logger logger = LoggerFactory.getLogger(SchedulerServiceDatabaseImpl.class);
    private EntityManagerFactory emf;
    private DBSessionFactory dbSessionFactory;
    private DBSession db;
    private SecurityService securityService;
    private static final Gson gson = new Gson();

    @Reference(target="(osgi.unit.name=org.opencastproject.scheduler.impl.persistence)")
    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.emf = emf;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setDBSessionFactory(DBSessionFactory dbSessionFactory) {
        this.dbSessionFactory = dbSessionFactory;
    }

    @Activate
    public void activate(ComponentContext cc) {
        logger.info("Activating persistence manager for scheduler");
        this.db = this.dbSessionFactory.createSession(this.emf);
    }

    @Override
    public synchronized void touchLastEntry(String agentId) throws SchedulerServiceDatabaseException {
        try {
            this.db.execTx(em -> {
                LastModifiedDto entity = (LastModifiedDto)em.find(LastModifiedDto.class, (Object)agentId);
                if (entity == null) {
                    entity = new LastModifiedDto();
                    entity.setCaptureAgentId(agentId);
                    entity.setLastModifiedDate(new Date());
                    em.persist((Object)entity);
                } else {
                    entity.setLastModifiedDate(new Date());
                    em.merge((Object)entity);
                }
            });
        }
        catch (Exception e) {
            throw new SchedulerServiceDatabaseException(e);
        }
    }

    @Override
    public Date getLastModified(String agentId) throws NotFoundException, SchedulerServiceDatabaseException {
        try {
            return ((Optional)this.db.exec(Queries.namedQuery.findByIdOpt(LastModifiedDto.class, (Object)agentId))).map(LastModifiedDto::getLastModifiedDate).orElseThrow(() -> new NotFoundException("Agent with ID " + agentId + " does not exist"));
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchedulerServiceDatabaseException(e);
        }
    }

    @Override
    public Map<String, Date> getLastModifiedDates() throws SchedulerServiceDatabaseException {
        try {
            return ((List)this.db.exec(Queries.namedQuery.findAll("LastModified.findAll", LastModifiedDto.class, new Object[0]))).stream().collect(Collectors.toMap(LastModifiedDto::getCaptureAgentId, LastModifiedDto::getLastModifiedDate));
        }
        catch (Exception e) {
            throw new SchedulerServiceDatabaseException(e);
        }
    }

    @Override
    public void storeEvent(String mediapackageId, String organizationId, Optional<String> captureAgentId, Optional<Date> start, Optional<Date> end, Optional<String> source, Optional<String> recordingState, Optional<Long> recordingLastHeard, Optional<String> presenters, Optional<Date> lastModifiedDate, Optional<String> checksum, Optional<Map<String, String>> workflowProperties, Optional<Map<String, String>> caProperties) throws SchedulerServiceDatabaseException {
        try {
            this.db.execTxChecked(em -> {
                Optional<ExtendedEventDto> entityOpt = this.getExtendedEventDtoQuery(mediapackageId, organizationId).apply((EntityManager)em);
                ExtendedEventDto entity = entityOpt.orElse(new ExtendedEventDto());
                entity.setMediaPackageId(mediapackageId);
                entity.setOrganization(organizationId);
                if (captureAgentId.isPresent()) {
                    entity.setCaptureAgentId((String)captureAgentId.get());
                }
                if (start.isPresent()) {
                    entity.setStartDate((Date)start.get());
                }
                if (end.isPresent()) {
                    entity.setEndDate((Date)end.get());
                }
                if (source.isPresent()) {
                    entity.setSource((String)source.get());
                }
                if (recordingState.isPresent()) {
                    entity.setRecordingState((String)recordingState.get());
                }
                if (recordingLastHeard.isPresent()) {
                    entity.setRecordingLastHeard((Long)recordingLastHeard.get());
                }
                if (presenters.isPresent()) {
                    entity.setPresenters((String)presenters.get());
                }
                if (lastModifiedDate.isPresent()) {
                    entity.setLastModifiedDate((Date)lastModifiedDate.get());
                }
                if (checksum.isPresent()) {
                    entity.setChecksum((String)checksum.get());
                }
                if (workflowProperties.isPresent()) {
                    entity.setWorkflowProperties(gson.toJson(workflowProperties.get()));
                }
                if (caProperties.isPresent()) {
                    entity.setCaptureAgentProperties(gson.toJson(caProperties.get()));
                }
                if (entityOpt.isEmpty()) {
                    em.persist((Object)entity);
                } else {
                    em.merge((Object)entity);
                }
            });
        }
        catch (Exception e) {
            throw new SchedulerServiceDatabaseException(e);
        }
    }

    @Override
    public List<String> getEvents(String captureAgentId, Date start, Date end, int separationMillis) throws SchedulerServiceDatabaseException {
        Date extendedStart = Date.from(start.toInstant().minusMillis(separationMillis));
        Date extendedEnd = Date.from(end.toInstant().plusMillis(separationMillis));
        try {
            return (List)this.db.exec(Queries.namedQuery.findAll("ExtendedEvent.findEvents", String.class, new Object[]{Pair.of((Object)"org", (Object)this.securityService.getOrganization().getId()), Pair.of((Object)"ca", (Object)captureAgentId), Pair.of((Object)"start", (Object)extendedStart), Pair.of((Object)"end", (Object)extendedEnd)}));
        }
        catch (Exception e) {
            throw new SchedulerServiceDatabaseException(e);
        }
    }

    @Override
    public List<ExtendedEventDto> search(Optional<String> captureAgentId, Optional<Date> optStartsFrom, Optional<Date> optStartsTo, Optional<Date> optEndFrom, Optional<Date> optEndTo, Optional<Integer> limit) throws SchedulerServiceDatabaseException {
        Date startsFrom = optStartsFrom.orElse(new Date(0L));
        Date farIntoTheFuture = DateTime.now().plusYears(30).toDate();
        Date startsTo = optStartsTo.orElse(farIntoTheFuture);
        Date endFrom = optEndFrom.orElse(new Date(0L));
        Date endTo = optEndTo.orElse(farIntoTheFuture);
        try {
            return (List)this.db.exec(em -> {
                TypedQuery query = captureAgentId.isPresent() ? em.createNamedQuery("ExtendedEvent.searchEventsCA", ExtendedEventDto.class).setParameter("org", (Object)this.securityService.getOrganization().getId()).setParameter("ca", captureAgentId.get()).setParameter("startFrom", (Object)startsFrom).setParameter("startTo", (Object)startsTo).setParameter("endFrom", (Object)endFrom).setParameter("endTo", (Object)endTo) : em.createNamedQuery("ExtendedEvent.searchEvents", ExtendedEventDto.class).setParameter("org", (Object)this.securityService.getOrganization().getId()).setParameter("startFrom", (Object)startsFrom).setParameter("startTo", (Object)startsTo).setParameter("endFrom", (Object)endFrom).setParameter("endTo", (Object)endTo);
                if (limit.isPresent()) {
                    return query.setMaxResults(((Integer)limit.get()).intValue()).getResultList();
                }
                return query.getResultList();
            });
        }
        catch (Exception e) {
            throw new SchedulerServiceDatabaseException(e);
        }
    }

    @Override
    public List<ExtendedEventDto> getKnownRecordings() throws SchedulerServiceDatabaseException {
        try {
            return (List)this.db.exec(Queries.namedQuery.findAll("ExtendedEvent.knownRecordings", ExtendedEventDto.class, new Object[]{Pair.of((Object)"org", (Object)this.securityService.getOrganization().getId())}));
        }
        catch (Exception e) {
            throw new SchedulerServiceDatabaseException(e);
        }
    }

    @Override
    public void deleteEvent(String mediapackageId) throws NotFoundException, SchedulerServiceDatabaseException {
        try {
            this.db.execTxChecked(em -> {
                String orgId = this.securityService.getOrganization().getId();
                Optional<ExtendedEventDto> entity = this.getExtendedEventDtoQuery(mediapackageId, orgId).apply((EntityManager)em);
                if (entity.isEmpty()) {
                    throw new NotFoundException("Event with ID " + mediapackageId + " does not exist");
                }
                em.remove((Object)entity.get());
            });
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchedulerServiceDatabaseException(e);
        }
    }

    @Override
    public List<ExtendedEventDto> getEvents() throws SchedulerServiceDatabaseException {
        String organization = this.securityService.getOrganization().getId();
        try {
            return (List)this.db.exec(Queries.namedQuery.findAll("ExtendedEvent.findAll", ExtendedEventDto.class, new Object[]{Pair.of((Object)"org", (Object)organization)}));
        }
        catch (Exception e) {
            throw new SchedulerServiceDatabaseException(e);
        }
    }

    @Override
    public Optional<ExtendedEventDto> getEvent(String mediapackageId, String orgId) throws SchedulerServiceDatabaseException {
        try {
            return (Optional)this.db.exec(this.getExtendedEventDtoQuery(mediapackageId, orgId));
        }
        catch (Exception e) {
            throw new SchedulerServiceDatabaseException(e);
        }
    }

    @Override
    public Optional<ExtendedEventDto> getEvent(String mediapackageId) throws SchedulerServiceDatabaseException {
        try {
            String orgId = this.securityService.getOrganization().getId();
            return this.getEvent(mediapackageId, orgId);
        }
        catch (SchedulerServiceDatabaseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchedulerServiceDatabaseException(e);
        }
    }

    @Override
    public void resetRecordingState(String mediapackageId) throws NotFoundException, SchedulerServiceDatabaseException {
        try {
            this.db.execTxChecked(em -> {
                String orgId = this.securityService.getOrganization().getId();
                Optional<ExtendedEventDto> entity = this.getExtendedEventDtoQuery(mediapackageId, orgId).apply((EntityManager)em);
                if (entity.isEmpty()) {
                    throw new NotFoundException("Event with ID " + mediapackageId + " does not exist");
                }
                entity.get().setRecordingState(null);
                entity.get().setRecordingLastHeard(null);
                em.merge((Object)entity.get());
            });
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchedulerServiceDatabaseException(e);
        }
    }

    @Override
    public int countEvents() throws SchedulerServiceDatabaseException {
        try {
            return ((Number)this.db.exec(Queries.namedQuery.find("ExtendedEvent.countAll", Number.class, new Object[0]))).intValue();
        }
        catch (Exception e) {
            throw new SchedulerServiceDatabaseException(e);
        }
    }

    private Function<EntityManager, Optional<ExtendedEventDto>> getExtendedEventDtoQuery(String id, String orgId) {
        return Queries.namedQuery.findByIdOpt(ExtendedEventDto.class, (Object)new EventIdPK(id, orgId));
    }
}

