/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.scheduler.impl;

import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.Dictionary;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.metadata.dublincore.DCMIPeriod;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreUtil;
import org.opencastproject.metadata.dublincore.EncodingSchemeUtils;
import org.opencastproject.metadata.dublincore.Precision;
import org.opencastproject.scheduler.api.SchedulerException;
import org.opencastproject.scheduler.api.SchedulerService;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.security.api.User;
import org.opencastproject.security.util.SecurityUtil;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ManagedService.class, CaptureNowProlongingService.class}, property={"service.description=Capture Prolonging Service"})
public class CaptureNowProlongingService
implements ManagedService {
    private static final Logger logger = LoggerFactory.getLogger(CaptureNowProlongingService.class);
    private static final String CFG_KEY_INITIAL_TIME = "initial-time";
    private static final String CFG_KEY_PROLONGING_TIME = "prolonging-time";
    private static final String JOB_NAME = "mh-capture-prolonging-job";
    private static final String JOB_GROUP = "mh-capture-prolonging-job-group";
    private static final String TRIGGER_GROUP = "mh-capture-prolonging-trigger-group";
    private static final String JOB_PARAM_PARENT = "parent";
    private int initialTime = -1;
    private int prolongingTime = -1;
    private Scheduler quartz;
    private SchedulerService schedulerService;
    private SecurityService securityService;
    private ServiceRegistry serviceRegistry;
    private OrganizationDirectoryService orgDirectoryService;
    private Workspace workspace;
    private ComponentContext componentContext;

    @Reference
    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Reference
    public void setOrgDirectoryService(OrganizationDirectoryService orgDirectoryService) {
        this.orgDirectoryService = orgDirectoryService;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Activate
    public void activate(ComponentContext cc) {
        this.componentContext = cc;
        try {
            this.quartz = new StdSchedulerFactory().getScheduler();
            this.quartz.start();
            JobDetail job = new JobDetail(JOB_NAME, JOB_GROUP, Runner.class);
            job.setDurability(true);
            job.setVolatility(true);
            job.getJobDataMap().put((Object)JOB_PARAM_PARENT, (Object)this);
            this.quartz.addJob(job, true);
        }
        catch (org.quartz.SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Deactivate
    public void deactivate(ComponentContext cc) {
        this.componentContext = null;
        this.shutdown();
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        try {
            this.initialTime = Integer.parseInt((String)StringUtils.defaultIfBlank((CharSequence)((String)properties.get(CFG_KEY_INITIAL_TIME)), (CharSequence)"300"));
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException(CFG_KEY_INITIAL_TIME, "Not an integer", (Throwable)e);
        }
        this.initialTime = Math.max(this.initialTime, 90) * 1000;
        try {
            this.prolongingTime = Integer.parseInt((String)StringUtils.defaultIfBlank((CharSequence)((String)properties.get(CFG_KEY_PROLONGING_TIME)), (CharSequence)"300"));
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException(CFG_KEY_PROLONGING_TIME, "Not an integer", (Throwable)e);
        }
        this.prolongingTime = Math.max(this.prolongingTime, 90) * 1000;
    }

    public void schedule(String agentId) throws org.quartz.SchedulerException {
        logger.debug("Capture prolonging job for agent '{}' is run every minute.", (Object)agentId);
        Trigger trigger = TriggerUtils.makeMinutelyTrigger();
        trigger.setStartTime(DateTime.now().plusMinutes(1).toDate());
        trigger.setName(agentId);
        trigger.setGroup(TRIGGER_GROUP);
        trigger.setJobName(JOB_NAME);
        trigger.setJobGroup(JOB_GROUP);
        if (this.quartz.getTrigger(agentId, TRIGGER_GROUP) == null) {
            this.quartz.scheduleJob(trigger);
        } else {
            this.quartz.rescheduleJob(agentId, TRIGGER_GROUP, trigger);
        }
    }

    public void stop(String agentId) {
        try {
            this.quartz.unscheduleJob(agentId, TRIGGER_GROUP);
            logger.info("Stopped prolonging capture for agent '{}'", (Object)agentId);
        }
        catch (Exception e) {
            logger.error("Error stopping Quartz job for agent '{}'", (Object)agentId, (Object)e);
        }
    }

    public void shutdown() {
        try {
            this.quartz.shutdown();
        }
        catch (org.quartz.SchedulerException schedulerException) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.shutdown();
    }

    public int getInitialTime() {
        return this.initialTime;
    }

    public int getProlongingTime() {
        return this.prolongingTime;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public ComponentContext getComponentContext() {
        return this.componentContext;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public OrganizationDirectoryService getOrgDirectoryService() {
        return this.orgDirectoryService;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public MediaPackage getCurrentRecording(String agentId) throws NotFoundException, UnauthorizedException, SchedulerException {
        Optional current = this.schedulerService.getCurrentRecording(agentId);
        if (current.isEmpty()) {
            logger.warn("Unable to load the current recording for agent '{}': no recording found", (Object)agentId);
            throw new NotFoundException("No current recording found for agent '" + agentId + "'");
        }
        return (MediaPackage)current.get();
    }

    public void prolongEvent(MediaPackage event, DublinCoreCatalog dublinCore, String agentId) throws UnauthorizedException, NotFoundException, SchedulerException, IllegalArgumentException, IOException {
        Catalog[] episodeCatalogs;
        String eventId = event.getIdentifier().toString();
        DCMIPeriod period = EncodingSchemeUtils.decodeMandatoryPeriod((String)dublinCore.getFirst(DublinCore.PROPERTY_TEMPORAL));
        Date prolongedEndDate = new DateTime((Object)period.getEnd()).plus((long)this.getProlongingTime()).toDate();
        dublinCore.set(DublinCore.PROPERTY_TEMPORAL, EncodingSchemeUtils.encodePeriod((DCMIPeriod)new DCMIPeriod(period.getStart(), prolongedEndDate), (Precision)Precision.Second));
        List events = this.schedulerService.findConflictingEvents(agentId, period.getStart(), prolongedEndDate);
        for (MediaPackage conflictMediaPackage : events) {
            Optional conflictingDc;
            if (eventId.equals(conflictMediaPackage.getIdentifier().toString()) || (conflictingDc = DublinCoreUtil.loadEpisodeDublinCore((Workspace)this.workspace, (MediaPackage)conflictMediaPackage)).isEmpty()) continue;
            Date conflictingStartDate = EncodingSchemeUtils.decodeMandatoryPeriod((String)((DublinCoreCatalog)conflictingDc.get()).getFirst(DublinCore.PROPERTY_TEMPORAL)).getStart();
            prolongedEndDate = new DateTime((Object)conflictingStartDate).minusMinutes(1).toDate();
            dublinCore.set(DublinCore.PROPERTY_TEMPORAL, EncodingSchemeUtils.encodePeriod((DCMIPeriod)new DCMIPeriod(period.getStart(), prolongedEndDate), (Precision)Precision.Second));
            logger.info("A scheduled event is preventing the current recording on agent '{}' to be further extended. Extending to one minute before the conflicting event", (Object)agentId);
            this.stop(agentId);
            break;
        }
        if ((episodeCatalogs = event.getCatalogs(MediaPackageElements.EPISODE)).length > 0) {
            Catalog c = episodeCatalogs[0];
            String filename = FilenameUtils.getName((String)c.getURI().toString());
            URI uri = this.workspace.put(event.getIdentifier().toString(), c.getIdentifier(), filename, IOUtils.toInputStream((String)dublinCore.toXmlString(), (String)"UTF-8"));
            c.setURI(uri);
            c.setChecksum(null);
        }
        this.schedulerService.updateEvent(eventId, Optional.empty(), Optional.of(prolongedEndDate), Optional.empty(), Optional.empty(), Optional.of(event), Optional.empty(), Optional.empty());
    }

    public static class Runner
    implements Job {
        public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
            logger.debug("Starting ad-hoc prolonging job for agent '{}'", (Object)jobExecutionContext.getTrigger().getName());
            try {
                this.execute((CaptureNowProlongingService)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)CaptureNowProlongingService.JOB_PARAM_PARENT), jobExecutionContext.getTrigger().getName());
            }
            catch (Exception e) {
                throw new JobExecutionException("An error occurred while prolonging ad-hoc recordings", (Throwable)e);
            }
            logger.debug("Finished ad-hoc prolonging job for agent '{}'", (Object)jobExecutionContext.getTrigger().getName());
        }

        private void execute(CaptureNowProlongingService prolongingService, String agentId) {
            for (Organization organization : prolongingService.getOrgDirectoryService().getOrganizations()) {
                User user = SecurityUtil.createSystemUser((ComponentContext)prolongingService.getComponentContext(), (Organization)organization);
                SecurityUtil.runAs((SecurityService)prolongingService.getSecurityService(), (Organization)organization, (User)user, () -> {
                    try {
                        MediaPackage mp = prolongingService.getCurrentRecording(agentId);
                        Optional dublinCore = DublinCoreUtil.loadEpisodeDublinCore((Workspace)prolongingService.getWorkspace(), (MediaPackage)mp);
                        if (dublinCore.isPresent() && EncodingSchemeUtils.decodeMandatoryPeriod((String)((DublinCoreCatalog)dublinCore.get()).getFirst(DublinCore.PROPERTY_TEMPORAL)).getEnd().before(DateTime.now().plusSeconds(90).toDate())) {
                            this.prolong(prolongingService, mp, (DublinCoreCatalog)dublinCore.get(), agentId);
                        } else {
                            logger.debug("Wait another minute before extending the ad-hoc recording for agent '{}'", (Object)agentId);
                        }
                    }
                    catch (NotFoundException e) {
                        logger.info("Unable to extend the ad-hoc recording for agent '{}': No ad-hoc recording found", (Object)agentId);
                    }
                    catch (Exception e) {
                        logger.error("Error extending the ad-hoc recording for agent '{}'", (Object)agentId, (Object)e);
                    }
                });
            }
        }

        private void prolong(CaptureNowProlongingService prolongingService, MediaPackage event, DublinCoreCatalog dublinCore, String agentId) throws NotFoundException, ServiceRegistryException {
            try {
                logger.info("Extending ad-hoc recording for agent '{}'", (Object)agentId);
                prolongingService.prolongEvent(event, dublinCore, agentId);
            }
            catch (UnauthorizedException e) {
                logger.error("Error extending the ad-hoc recording for agent '{}': Permission denied", (Object)agentId);
            }
            catch (NotFoundException e) {
                logger.warn("Error extending the ad-hoc recording for agent '{}': No ad-hoc recording found", (Object)agentId);
            }
            catch (Exception e) {
                logger.error("Error extending the ad-hoc recording for agent '{}'", (Object)agentId, (Object)e);
            }
        }
    }
}

