/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.scheduler.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Encoding;
import net.fortuna.ical4j.model.parameter.FmtType;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.parameter.XParameter;
import net.fortuna.ical4j.model.property.Attach;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.LastModified;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.RelatedTo;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Version;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.series.api.SeriesException;
import org.opencastproject.series.api.SeriesService;
import org.opencastproject.util.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarGenerator {
    private static final Logger logger = LoggerFactory.getLogger(CalendarGenerator.class);
    protected Calendar cal;
    protected SeriesService seriesService;
    private final Map<String, DublinCoreCatalog> series = new HashMap<String, DublinCoreCatalog>();

    public CalendarGenerator(SeriesService seriesService) {
        this.cal = new Calendar();
        this.cal.getProperties().add((Property)new ProdId("Opencast Calendar File 0.5"));
        this.cal.getProperties().add((Property)Version.VERSION_2_0);
        this.cal.getProperties().add((Property)CalScale.GREGORIAN);
        this.seriesService = seriesService;
    }

    public Calendar getCalendar() {
        return this.cal;
    }

    public void setCalendar(Calendar cal) {
        this.cal = cal;
    }

    public boolean addEvent(MediaPackage mp, DublinCoreCatalog catalog, String agentId, java.util.Date start, java.util.Date end, java.util.Date lastModified, String captureAgentMetadata) {
        String eventId = mp.getIdentifier().toString();
        logger.debug("Creating iCalendar VEvent from scheduled event '{}'", (Object)eventId);
        net.fortuna.ical4j.model.DateTime startDate = new net.fortuna.ical4j.model.DateTime(start);
        net.fortuna.ical4j.model.DateTime endDate = new net.fortuna.ical4j.model.DateTime(end);
        java.util.Date marginEndDate = new DateTime(endDate.getTime()).plusHours(1).toDate();
        if (marginEndDate.before(new java.util.Date())) {
            logger.debug("Event has already passed more than an hour, skipping!");
            return false;
        }
        startDate.setUtc(true);
        endDate.setUtc(true);
        String seriesID = null;
        VEvent event = new VEvent((Date)startDate, (Date)endDate, catalog.getFirst(DublinCore.PROPERTY_TITLE));
        try {
            event.getProperties().add((Property)new Uid(eventId));
            net.fortuna.ical4j.model.DateTime lastModifiedDate = new net.fortuna.ical4j.model.DateTime(lastModified);
            lastModifiedDate.setUtc(true);
            event.getProperties().add((Property)new LastModified(lastModifiedDate));
            if (StringUtils.isNotEmpty((CharSequence)catalog.getFirst(DublinCore.PROPERTY_DESCRIPTION))) {
                event.getProperties().add((Property)new Description(catalog.getFirst(DublinCore.PROPERTY_DESCRIPTION)));
            }
            event.getProperties().add((Property)new Location(agentId));
            if (StringUtils.isNotEmpty((CharSequence)catalog.getFirst(DublinCore.PROPERTY_IS_PART_OF))) {
                seriesID = catalog.getFirst(DublinCore.PROPERTY_IS_PART_OF);
                event.getProperties().add((Property)new RelatedTo(seriesID));
            }
            ParameterList dcParameters = new ParameterList();
            dcParameters.add((Parameter)new FmtType("application/xml"));
            dcParameters.add((Parameter)Value.BINARY);
            dcParameters.add((Parameter)Encoding.BASE64);
            dcParameters.add((Parameter)new XParameter("X-APPLE-FILENAME", "episode.xml"));
            Attach metadataAttachment = new Attach(dcParameters, catalog.toXmlString().getBytes("UTF-8"));
            event.getProperties().add((Property)metadataAttachment);
            String seriesDC = this.getSeriesDublinCoreAsString(seriesID);
            if (seriesDC != null) {
                logger.debug("Attaching series {} information to event {}", (Object)seriesID, (Object)eventId);
                ParameterList sDcParameters = new ParameterList();
                sDcParameters.add((Parameter)new FmtType("application/xml"));
                sDcParameters.add((Parameter)Value.BINARY);
                sDcParameters.add((Parameter)Encoding.BASE64);
                sDcParameters.add((Parameter)new XParameter("X-APPLE-FILENAME", "series.xml"));
                Attach seriesAttachment = new Attach(sDcParameters, seriesDC.getBytes("UTF-8"));
                event.getProperties().add((Property)seriesAttachment);
            } else {
                logger.debug("No series provided for event {}.", (Object)eventId);
            }
            ParameterList caParameters = new ParameterList();
            caParameters.add((Parameter)new FmtType("application/text"));
            caParameters.add((Parameter)Value.BINARY);
            caParameters.add((Parameter)Encoding.BASE64);
            caParameters.add((Parameter)new XParameter("X-APPLE-FILENAME", "org.opencastproject.capture.agent.properties"));
            Attach agentsAttachment = new Attach(caParameters, captureAgentMetadata.getBytes("UTF-8"));
            event.getProperties().add((Property)agentsAttachment);
        }
        catch (Exception e) {
            logger.error("Unable to add event '{}' to recording calendar", (Object)eventId, (Object)e);
            return false;
        }
        this.cal.getComponents().add((Object)event);
        logger.debug("new VEvent = {} ", (Object)event.toString());
        return true;
    }

    private String getSeriesDublinCoreAsString(String seriesID) throws UnauthorizedException, NotFoundException {
        if (StringUtils.isBlank((CharSequence)seriesID)) {
            return null;
        }
        if (this.seriesService == null) {
            logger.warn("No SeriesService available");
            return null;
        }
        DublinCoreCatalog seriesDC = this.series.get(seriesID);
        if (seriesDC == null) {
            try {
                seriesDC = this.seriesService.getSeries(seriesID);
                this.series.put(seriesID, seriesDC);
            }
            catch (SeriesException e) {
                logger.error("Error loading DublinCoreCatalog for series '{}'", (Object)seriesID, (Object)e);
                return null;
            }
        }
        try {
            return seriesDC.toXmlString();
        }
        catch (IOException e) {
            logger.error("Error serializing DublinCoreCatalog of series '{}'", (Object)seriesID, (Object)e);
            return null;
        }
    }
}

