/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.scheduler.api;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.property.RRule;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.scheduler.api.Recording;
import org.opencastproject.scheduler.api.SchedulerConflictException;
import org.opencastproject.scheduler.api.SchedulerException;
import org.opencastproject.scheduler.api.TechnicalMetadata;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.util.NotFoundException;

public interface SchedulerService {
    public static final String JOB_TYPE = "org.opencastproject.scheduler";
    public static final String WORKFLOW_CONFIG_PREFIX = "org.opencastproject.workflow.config.";

    public void addEvent(Date var1, Date var2, String var3, Set<String> var4, MediaPackage var5, Map<String, String> var6, Map<String, String> var7, Optional<String> var8) throws UnauthorizedException, SchedulerConflictException, SchedulerException;

    public Map<String, Period> addMultipleEvents(RRule var1, Date var2, Date var3, Long var4, TimeZone var5, String var6, Set<String> var7, MediaPackage var8, Map<String, String> var9, Map<String, String> var10, Optional<String> var11) throws UnauthorizedException, SchedulerConflictException, SchedulerException;

    public void updateEvent(String var1, Optional<Date> var2, Optional<Date> var3, Optional<String> var4, Optional<Set<String>> var5, Optional<MediaPackage> var6, Optional<Map<String, String>> var7, Optional<Map<String, String>> var8) throws NotFoundException, UnauthorizedException, SchedulerConflictException, SchedulerException;

    public void updateEvent(String var1, Optional<Date> var2, Optional<Date> var3, Optional<String> var4, Optional<Set<String>> var5, Optional<MediaPackage> var6, Optional<Map<String, String>> var7, Optional<Map<String, String>> var8, boolean var9) throws NotFoundException, UnauthorizedException, SchedulerConflictException, SchedulerException;

    public void removeEvent(String var1) throws NotFoundException, UnauthorizedException, SchedulerException;

    public MediaPackage getMediaPackage(String var1) throws NotFoundException, UnauthorizedException, SchedulerException;

    public DublinCoreCatalog getDublinCore(String var1) throws NotFoundException, UnauthorizedException, SchedulerException;

    public TechnicalMetadata getTechnicalMetadata(String var1) throws NotFoundException, UnauthorizedException, SchedulerException;

    public Map<String, String> getWorkflowConfig(String var1) throws NotFoundException, UnauthorizedException, SchedulerException;

    public Map<String, String> getCaptureAgentConfiguration(String var1) throws NotFoundException, UnauthorizedException, SchedulerException;

    public int getEventCount() throws SchedulerException, UnauthorizedException;

    public List<MediaPackage> search(Optional<String> var1, Optional<Date> var2, Optional<Date> var3, Optional<Date> var4, Optional<Date> var5) throws SchedulerException, UnauthorizedException;

    public Optional<MediaPackage> getCurrentRecording(String var1) throws SchedulerException, UnauthorizedException;

    public Optional<MediaPackage> getUpcomingRecording(String var1) throws SchedulerException, UnauthorizedException;

    public List<MediaPackage> findConflictingEvents(String var1, Date var2, Date var3) throws UnauthorizedException, SchedulerException;

    public List<MediaPackage> findConflictingEvents(String var1, RRule var2, Date var3, Date var4, long var5, TimeZone var7) throws UnauthorizedException, SchedulerException;

    public String getCalendar(Optional<String> var1, Optional<String> var2, Optional<Date> var3) throws SchedulerException;

    public String getScheduleLastModified(String var1) throws SchedulerException;

    public boolean updateRecordingState(String var1, String var2) throws NotFoundException, SchedulerException;

    public Recording getRecordingState(String var1) throws NotFoundException, SchedulerException;

    public void removeRecording(String var1) throws NotFoundException, SchedulerException;

    public Map<String, Recording> getKnownRecordings() throws SchedulerException;

    public void removeScheduledRecordingsBeforeBuffer(long var1) throws UnauthorizedException, SchedulerException;
}

