/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.runtimeinfo.rest;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.runtimeinfo.rest.RestDocData;
import org.opencastproject.runtimeinfo.rest.RestFormData;
import org.opencastproject.runtimeinfo.rest.RestFormatData;
import org.opencastproject.runtimeinfo.rest.RestParamData;
import org.opencastproject.runtimeinfo.rest.StatusData;
import org.opencastproject.util.JaxbXmlSchemaGenerator;
import org.opencastproject.util.doc.DocData;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestResponse;

public class RestEndpointData
implements Comparable<RestEndpointData> {
    private String name;
    private String httpMethod;
    private String path;
    private String description;
    private RestParamData bodyParam;
    private List<RestParamData> pathParams;
    private List<RestParamData> requiredParams;
    private List<RestParamData> optionalParams;
    private List<String> notes;
    private List<RestFormatData> formats;
    private List<StatusData> statuses;
    private RestFormData form;
    private String returnTypeSchema = null;

    public RestEndpointData(Class<?> returnType, String name, String httpMethod, String path, String description) throws IllegalArgumentException {
        if (!DocData.isValidName((String)name)) {
            throw new IllegalArgumentException("Name must not be null and must be alphanumeric.");
        }
        if (httpMethod == null || httpMethod.isEmpty()) {
            throw new IllegalArgumentException("Method must not be null and must not be empty.");
        }
        if (!RestDocData.isValidPath(path)) {
            throw new IllegalArgumentException(String.format("Path '%s' must not be null and must look something like /a/b/{c}.", path));
        }
        this.returnTypeSchema = JaxbXmlSchemaGenerator.getXmlSchema(returnType);
        this.name = name;
        this.httpMethod = httpMethod.toUpperCase();
        this.path = path;
        this.description = description;
    }

    public String toString() {
        return "ENDP:" + this.name + ":" + this.httpMethod + " " + this.path + " :body=" + String.valueOf(this.bodyParam) + " :req=" + String.valueOf(this.requiredParams) + " :opt=" + String.valueOf(this.optionalParams) + " :formats=" + String.valueOf(this.formats) + " :status=" + String.valueOf(this.statuses) + " :form=" + String.valueOf(this.form);
    }

    public RestParamData addBodyParam(RestParameter restParam) {
        RestParamData.Type type = RestParamData.Type.valueOf(restParam.type().name());
        RestParamData param = new RestParamData("BODY", type, restParam.defaultValue(), restParam.description(), null);
        param.setRequired(true);
        this.bodyParam = param;
        return param;
    }

    public void addPathParam(RestParamData param) throws IllegalStateException {
        if (RestParamData.Type.FILE.name().equals(param.getType()) || RestParamData.Type.TEXT.name().equals(param.getType())) {
            throw new IllegalStateException("Cannot add path param of type FILE or TEXT.");
        }
        param.setRequired(true);
        param.setPath(true);
        if (this.pathParams == null) {
            this.pathParams = new Vector<RestParamData>(3);
        }
        this.pathParams.add(param);
    }

    public void addRequiredParam(RestParamData param) throws IllegalStateException {
        param.setRequired(true);
        param.setPath(false);
        if (this.requiredParams == null) {
            this.requiredParams = new Vector<RestParamData>(3);
        }
        this.requiredParams.add(param);
    }

    public void addOptionalParam(RestParamData param) {
        param.setRequired(false);
        param.setPath(false);
        if (this.optionalParams == null) {
            this.optionalParams = new Vector<RestParamData>(3);
        }
        this.optionalParams.add(param);
    }

    public void addFormat(RestFormatData format) {
        if (this.formats == null) {
            this.formats = new Vector<RestFormatData>(2);
        }
        this.formats.add(format);
    }

    public void addStatus(RestResponse restResponse) {
        if (this.statuses == null) {
            this.statuses = new Vector<StatusData>(3);
        }
        this.statuses.add(new StatusData(restResponse));
    }

    public void addNote(String note) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)note)) {
            throw new IllegalArgumentException("Note must not be null or blank.");
        }
        if (this.notes == null) {
            this.notes = new Vector<String>(3);
        }
        this.notes.add(note);
    }

    public void setTestForm(RestFormData form) {
        this.form = form;
    }

    public boolean isGetMethod() {
        return "GET".equals(this.httpMethod);
    }

    public String getQueryString() {
        String qs = "";
        if (this.isGetMethod() && this.optionalParams != null && !this.optionalParams.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("?");
            for (RestParamData p : this.optionalParams) {
                if (sb.length() > 2) {
                    sb.append("&");
                }
                sb.append(p.getName());
                sb.append("=");
                if (p.getDefaultValue() != null) {
                    sb.append(p.getDefaultValue());
                    continue;
                }
                sb.append("{");
                sb.append(p.getName());
                sb.append("}");
            }
            qs = StringEscapeUtils.escapeHtml4((String)sb.toString());
        }
        return qs;
    }

    public String getName() {
        return this.name;
    }

    public String getMethod() {
        return this.httpMethod;
    }

    public String getPath() {
        return this.path;
    }

    public String getDescription() {
        return this.description;
    }

    public RestParamData getBodyParam() {
        return this.bodyParam;
    }

    public List<RestParamData> getPathParams() {
        if (this.pathParams == null) {
            this.pathParams = new ArrayList<RestParamData>(0);
        }
        return this.pathParams;
    }

    public List<RestParamData> getRequiredParams() {
        if (this.requiredParams == null) {
            this.requiredParams = new ArrayList<RestParamData>(0);
        }
        return this.requiredParams;
    }

    public List<RestParamData> getOptionalParams() {
        if (this.optionalParams == null) {
            this.optionalParams = new ArrayList<RestParamData>(0);
        }
        return this.optionalParams;
    }

    public List<RestFormatData> getFormats() {
        if (this.formats == null) {
            this.formats = new ArrayList<RestFormatData>(0);
        }
        return this.formats;
    }

    public List<StatusData> getStatuses() {
        if (this.statuses == null) {
            this.statuses = new ArrayList<StatusData>(0);
        }
        return this.statuses;
    }

    public List<String> getNotes() {
        if (this.notes == null) {
            this.notes = new ArrayList<String>(0);
        }
        return this.notes;
    }

    public RestFormData getForm() {
        return this.form;
    }

    @Override
    public int compareTo(RestEndpointData otherEndpoint) {
        return this.name.compareToIgnoreCase(otherEndpoint.name);
    }

    public String getReturnTypeSchema() {
        return this.returnTypeSchema;
    }

    public String getEscapedReturnTypeSchema() {
        return StringEscapeUtils.escapeXml((String)this.returnTypeSchema);
    }
}

