/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.runtimeinfo.rest;

import org.opencastproject.util.doc.rest.RestResponse;

public class StatusData {
    private int code;
    private String name;
    private String description;
    private String xmlSchema;

    public StatusData(RestResponse restResponse) throws IllegalArgumentException {
        this(restResponse.responseCode(), restResponse.description());
    }

    public StatusData(int code, String description, String xmlSchema) throws IllegalArgumentException {
        if (code < 100 || code > 1100) {
            throw new IllegalArgumentException("Code (" + code + ") is outside of the valid range: 100-1100.");
        }
        this.code = code;
        this.name = StatusData.findName(code);
        this.description = description.isEmpty() ? null : description;
        this.xmlSchema = xmlSchema;
    }

    public StatusData(int code, String description) throws IllegalArgumentException {
        this(code, description, null);
    }

    public String toString() {
        return "SC:" + this.code + ":" + this.name;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public static String findName(int code) throws IllegalArgumentException {
        String result;
        if (code < 100 || code > 1100) {
            throw new IllegalArgumentException("Code (" + code + ") is outside of the valid range: 100-1100.");
        }
        switch (code) {
            case 100: {
                result = "Continue";
                break;
            }
            case 101: {
                result = "Switching Protocols";
                break;
            }
            case 200: {
                result = "OK";
                break;
            }
            case 201: {
                result = "Created";
                break;
            }
            case 202: {
                result = "Accepted";
                break;
            }
            case 203: {
                result = "Non-Authoritative Information";
                break;
            }
            case 204: {
                result = "No Content";
                break;
            }
            case 205: {
                result = "Reset Content";
                break;
            }
            case 206: {
                result = "Partial Content";
                break;
            }
            case 300: {
                result = "Multiple Choices";
                break;
            }
            case 301: {
                result = "Moved Permanently";
                break;
            }
            case 302: {
                result = "Found";
                break;
            }
            case 303: {
                result = "See Other";
                break;
            }
            case 304: {
                result = "Not Modified";
                break;
            }
            case 305: {
                result = "Use Proxy";
                break;
            }
            case 307: {
                result = "Temporary Redirect";
                break;
            }
            case 400: {
                result = "Bad Request";
                break;
            }
            case 401: {
                result = "Unauthorized";
                break;
            }
            case 402: {
                result = "Payment Required";
                break;
            }
            case 403: {
                result = "Forbidden";
                break;
            }
            case 404: {
                result = "Not Found";
                break;
            }
            case 405: {
                result = "Method Not Allowed";
                break;
            }
            case 406: {
                result = "Not Acceptable";
                break;
            }
            case 407: {
                result = "Proxy Authentication Required";
                break;
            }
            case 408: {
                result = "Request Timeout";
                break;
            }
            case 409: {
                result = "Conflict";
                break;
            }
            case 410: {
                result = "Gone";
                break;
            }
            case 411: {
                result = "Length Required";
                break;
            }
            case 412: {
                result = "Precondition Failed";
                break;
            }
            case 413: {
                result = "Request Entity Too Large";
                break;
            }
            case 414: {
                result = "Request URI Too Long";
                break;
            }
            case 415: {
                result = "Unsupported Media Type";
                break;
            }
            case 416: {
                result = "Requested Range Not Satisfiable";
                break;
            }
            case 417: {
                result = "Expectation Failed";
                break;
            }
            case 500: {
                result = "Internal Server Error";
                break;
            }
            case 501: {
                result = "Not Implemented";
                break;
            }
            case 502: {
                result = "Bad Gateway";
                break;
            }
            case 503: {
                result = "Service Unavailable";
                break;
            }
            case 504: {
                result = "Gateway Timeout";
                break;
            }
            case 505: {
                result = "Version Not Supported";
                break;
            }
            default: {
                result = "UNKNOWN";
            }
        }
        return result;
    }

    public String getXmlSchema() {
        return this.xmlSchema;
    }

    public void setXmlSchema(String xmlSchema) {
        this.xmlSchema = xmlSchema;
    }
}

