/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.runtimeinfo.rest;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;
import org.opencastproject.util.JaxbXmlSchemaGenerator;
import org.opencastproject.util.doc.DocData;
import org.opencastproject.util.doc.rest.RestParameter;

public final class RestParamData {
    private String name;
    private String defaultValue;
    private String type;
    private String description;
    private String xmlSchema;
    private boolean required = false;
    private boolean path = false;
    private Map<String, String> attributes = new HashMap<String, String>();

    public RestParamData(RestParameter restParam) {
        this(restParam.name(), Type.valueOf(restParam.type().name()), restParam.defaultValue(), restParam.description(), JaxbXmlSchemaGenerator.getXmlSchema((Class)restParam.jaxbClass()));
    }

    public RestParamData(String name, Type type, String defaultValue, String description, String xmlSchema) throws IllegalArgumentException {
        if (!DocData.isValidName((String)name)) {
            throw new IllegalArgumentException("Name must not be null and must be alphanumeric.");
        }
        if (type == null) {
            type = Type.STRING;
        }
        this.name = name;
        this.type = type.name().toLowerCase();
        this.defaultValue = defaultValue == null || defaultValue.isEmpty() ? (type == Type.INTEGER || type == Type.FLOAT || type == Type.LONG ? "0" : null) : defaultValue;
        this.description = description == null || description.isEmpty() ? null : description;
        this.xmlSchema = xmlSchema;
    }

    public void setAttribute(String key, String value) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null.");
        }
        if (value == null) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, value);
        }
    }

    public String getAttribute(String key) {
        if (key == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getEscapedDefaultValue() {
        return StringEscapeUtils.escapeHtml4((String)this.defaultValue);
    }

    public String getEscapedXmlSchema() {
        return StringEscapeUtils.escapeXml((String)this.xmlSchema);
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isPath() {
        return this.path;
    }

    public void setPath(boolean path) {
        this.path = path;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String toString() {
        return "PAR:" + this.name + ":(" + this.type + "):" + this.defaultValue;
    }

    public String getXmlSchema() {
        return this.xmlSchema;
    }

    public void setXmlSchema(String xmlSchema) {
        this.xmlSchema = xmlSchema;
    }

    public static enum Type {
        BOOLEAN,
        FILE,
        STRING,
        TEXT,
        INTEGER,
        FLOAT,
        LONG;

    }
}

