/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.plugin.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.opencastproject.plugin.PluginManager;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Plugin Manager Service"}, immediate=true)
public class PluginManagerImpl
implements PluginManager {
    private static final Logger logger = LoggerFactory.getLogger(PluginManagerImpl.class);
    private static final String OPENCAST_FEATURE_PREFIX = "opencast-";
    private static final String PLUGIN_FEATURE_PREFIX = "opencast-plugin-";
    private static final String VERBOSE = "verbose";
    private ExecutorService executor;
    private FeaturesService featuresService;
    private Set<String> activePlugins;
    private boolean verbose;

    @Reference
    public void setFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
    }

    @Activate
    @Modified
    void activate(Map<String, Object> properties) {
        logger.debug("Activating {}", PluginManagerImpl.class);
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadExecutor(runnable -> new Thread(runnable, PluginManager.class.getSimpleName()));
        }
        this.activePlugins = properties.entrySet().stream().filter(e -> BooleanUtils.toBoolean((String)Objects.toString(e.getValue(), "").trim())).map(Map.Entry::getKey).collect(Collectors.toSet());
        logger.debug("Active plugin configuration: {}", this.activePlugins);
        this.verbose = BooleanUtils.toBoolean((String)Objects.toString(properties.get(VERBOSE)));
        this.executor.submit(new PluginStarter());
    }

    @Deactivate
    void deactivate() {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
    }

    @Override
    public Set<String> listAvailablePlugins() {
        try {
            return Arrays.stream(this.featuresService.listFeatures()).map(Feature::getName).filter(feature -> feature.startsWith(PLUGIN_FEATURE_PREFIX)).collect(Collectors.toSet());
        }
        catch (Exception e) {
            return Collections.emptySet();
        }
    }

    @Override
    public Set<String> listInstalledPlugins() {
        try {
            return Arrays.stream(this.featuresService.listInstalledFeatures()).map(Feature::getName).filter(feature -> feature.startsWith(PLUGIN_FEATURE_PREFIX)).collect(Collectors.toSet());
        }
        catch (Exception e) {
            return Collections.emptySet();
        }
    }

    public class PluginStarter
    implements Runnable {
        @Override
        public void run() {
            EnumSet<FeaturesService.Option> options = EnumSet.noneOf(FeaturesService.Option.class);
            options.add(FeaturesService.Option.NoAutoRefreshBundles);
            if (PluginManagerImpl.this.verbose) {
                options.add(FeaturesService.Option.Verbose);
            }
            try {
                Set ocFeatures = Arrays.stream(PluginManagerImpl.this.featuresService.listInstalledFeatures()).map(Feature::getName).filter(feature -> feature.startsWith(PluginManagerImpl.OPENCAST_FEATURE_PREFIX)).filter(feature -> !feature.startsWith(PluginManagerImpl.PLUGIN_FEATURE_PREFIX)).collect(Collectors.toSet());
                logger.debug("Detected active Opencast features: {}", ocFeatures);
                Set<String> installedPlugins = PluginManagerImpl.this.listInstalledPlugins();
                logger.debug("Detected, already active Opencast plugins: {}", installedPlugins);
                logger.info("Loading plug-ins\u2026");
                for (Feature feature2 : PluginManagerImpl.this.featuresService.listFeatures()) {
                    if (!feature2.getName().startsWith(PluginManagerImpl.PLUGIN_FEATURE_PREFIX)) {
                        logger.debug("Skipping non-plugin feature {}", (Object)feature2);
                        continue;
                    }
                    String baseName = feature2.getName().split("_")[0];
                    if (!PluginManagerImpl.this.activePlugins.contains(baseName)) {
                        logger.info("Skipping disabled plugin {}", (Object)feature2);
                        continue;
                    }
                    Boolean conditionsMatch = feature2.getConditional().stream().flatMap(conditional -> conditional.getCondition().stream()).map(ocFeatures::contains).reduce(Boolean::logicalOr).orElse(true);
                    if (!conditionsMatch.booleanValue()) {
                        logger.info("Plugin conditions do not match. Skipping {}", (Object)feature2);
                        continue;
                    }
                    logger.info("Installing plugin {}", (Object)feature2);
                    PluginManagerImpl.this.featuresService.installFeature(feature2, options);
                }
                for (String plugin : installedPlugins) {
                    if (PluginManagerImpl.this.activePlugins.contains(plugin)) continue;
                    logger.info("Uninstalling plugin {}", (Object)plugin);
                    PluginManagerImpl.this.featuresService.uninstallFeature(plugin, options);
                }
            }
            catch (Exception e) {
                logger.error("Installing plugins failed", (Throwable)e);
            }
        }
    }
}

