/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.liveschedule.message;

import org.opencastproject.liveschedule.api.LiveScheduleService;
import org.opencastproject.liveschedule.message.UpdateHandler;
import org.opencastproject.mediapackage.Publication;
import org.opencastproject.message.broker.api.assetmanager.AssetManagerItem;
import org.opencastproject.message.broker.api.update.AssetManagerUpdateHandler;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={UpdateHandler.class, AssetManagerUpdateHandler.class}, property={"service.description=Asset Manager Update Listener for Live Schedule Service"})
public class AssetManagerEventUpdateHandler
extends UpdateHandler
implements AssetManagerUpdateHandler {
    private static final Logger logger = LoggerFactory.getLogger(AssetManagerEventUpdateHandler.class);

    @Override
    @Activate
    public void activate(ComponentContext cc) {
        super.activate(cc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void execute(AssetManagerItem item) {
        mpId = item.getId();
        try {
            AssetManagerEventUpdateHandler.logger.debug("Asset Manager message handler START for mp {} event type {} in thread {}", new Object[]{mpId, item.getType(), Thread.currentThread().getId()});
            switch (1.$SwitchMap$org$opencastproject$message$broker$api$assetmanager$AssetManagerItem$Type[item.getType().ordinal()]) {
                case 1: {
                    if (!(item instanceof AssetManagerItem.TakeSnapshot) || (snapshotItem = (AssetManagerItem.TakeSnapshot)item).getEpisodeDublincore().isEmpty()) break;
                    for (Publication pub : snapshotItem.getMediapackage().getPublications()) {
                        if (!"engage-live".equals(pub.getChannel())) continue;
                        this.liveScheduleService.createOrUpdateLiveEvent(mpId, (DublinCoreCatalog)snapshotItem.getEpisodeDublincore().get());
                    }
                    break;
                }
                case 2: {
                    if (item instanceof AssetManagerItem.DeleteEpisode) {
                        this.liveScheduleService.deleteLiveEvent(mpId);
                        ** break;
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled type of AssetManagerItem");
lbl21:
                    // 1 sources

                    break;
                }
            }
        }
        catch (Exception e) {
            try {
                AssetManagerEventUpdateHandler.logger.warn("Exception occurred for mp {}, event type {}", new Object[]{mpId, item.getType(), e});
            }
            catch (Throwable var8_9) {
                AssetManagerEventUpdateHandler.logger.debug("Asset Manager message handler END for mp {} event type {} in thread {}", new Object[]{mpId, item.getType(), Thread.currentThread().getId()});
                throw var8_9;
            }
            AssetManagerEventUpdateHandler.logger.debug("Asset Manager message handler END for mp {} event type {} in thread {}", new Object[]{mpId, item.getType(), Thread.currentThread().getId()});
        }
        AssetManagerEventUpdateHandler.logger.debug("Asset Manager message handler END for mp {} event type {} in thread {}", new Object[]{mpId, item.getType(), Thread.currentThread().getId()});
    }

    @Override
    @Reference
    public void setLiveScheduleService(LiveScheduleService liveScheduleService) {
        super.setLiveScheduleService(liveScheduleService);
    }
}

