/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.consumer.rememberme;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.security.oauth.consumer.OAuthConsumerToken;
import org.springframework.security.oauth.consumer.rememberme.OAuthRememberMeServices;

public class HttpSessionOAuthRememberMeServices
implements OAuthRememberMeServices {
    public static final String REMEMBERED_TOKENS_KEY = HttpSessionOAuthRememberMeServices.class.getName() + "#REMEMBERED_TOKENS";
    private boolean storeAccessTokens = true;

    @Override
    public Map<String, OAuthConsumerToken> loadRememberedTokens(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            return (Map)session.getAttribute(REMEMBERED_TOKENS_KEY);
        }
        return null;
    }

    @Override
    public void rememberTokens(Map<String, OAuthConsumerToken> tokens, HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        HashMap<String, OAuthConsumerToken> requestTokensOnly = new HashMap<String, OAuthConsumerToken>();
        for (Map.Entry<String, OAuthConsumerToken> token : tokens.entrySet()) {
            if (!this.storeAccessTokens || token.getValue().isAccessToken()) continue;
            requestTokensOnly.put(token.getKey(), token.getValue());
        }
        session.setAttribute(REMEMBERED_TOKENS_KEY, requestTokensOnly);
    }
}

