/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.rest;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.Job;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.NotFoundException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;
import org.osgi.service.component.propertytypes.ServiceRanking;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardContextSelect;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardFilterName;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardFilterPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Filter.class}, scope=ServiceScope.PROTOTYPE, property={"service.description=Current Job Filter"})
@ServiceRanking(value=9)
@HttpWhiteboardFilterName(value="CurrentJobFilter")
@HttpWhiteboardFilterPattern(value={"/*"})
@HttpWhiteboardContextSelect(value="(osgi.http.whiteboard.context.name=opencast)")
public class CurrentJobFilter
implements Filter {
    public static final String CURRENT_JOB_HEADER = "X-Opencast-Matterhorn-Current-Job-Id";
    private static final Logger logger = LoggerFactory.getLogger(CurrentJobFilter.class);
    private ServiceRegistry serviceRegistry = null;

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        try {
            this.setCurrentJob(httpRequest, httpResponse);
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
        }
        finally {
            this.serviceRegistry.setCurrentJob(null);
        }
    }

    private void setCurrentJob(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        String currentJobId = httpRequest.getHeader(CURRENT_JOB_HEADER);
        try {
            if (StringUtils.isNotBlank((CharSequence)currentJobId)) {
                Job currentJob = this.serviceRegistry.getJob(Long.parseLong(currentJobId));
                this.serviceRegistry.setCurrentJob(currentJob);
            }
        }
        catch (NotFoundException e) {
            logger.debug("Unable to set non-existing current job {}", (Object)currentJobId, (Object)e);
        }
        catch (Exception e) {
            logger.error("Unable to set the current job {}", (Object)currentJobId, (Object)e);
            httpResponse.sendError(500, "Was not able to set the current job id {} to the service registry" + currentJobId);
        }
    }

    public void destroy() {
    }
}

