/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.bundleinfo;

import org.opencastproject.kernel.bundleinfo.BundleInfo;
import org.opencastproject.kernel.bundleinfo.BundleInfoDb;
import org.opencastproject.kernel.bundleinfo.BundleInfoImpl;
import org.opencastproject.kernel.bundleinfo.BundleInfos;
import org.opencastproject.util.OsgiUtil;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.functions.Strings;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class BundleInfoLogger
implements BundleListener {
    private static final Logger logger = LoggerFactory.getLogger(BundleInfoLogger.class);
    private Option<BundleInfoDb> db;
    private String host;

    @Reference(unbind="unsetDb")
    public void setDb(BundleInfoDb db) {
        this.db = Option.some((Object)db);
    }

    public void unsetDb(BundleInfoDb db) {
        this.db = Option.none();
    }

    @Activate
    public void activate(ComponentContext cc) {
        this.host = (String)Option.option((Object)OsgiUtil.getContextProperty((ComponentContext)cc, (String)"org.opencastproject.server.url")).bind(Strings.trimToNone).getOrElse((Object)"http://localhost:8080");
        for (BundleInfoDb a : this.db) {
            a.clear(this.host);
        }
        cc.getBundleContext().addBundleListener((BundleListener)this);
        for (Bundle b : cc.getBundleContext().getBundles()) {
            this.logBundle(b);
        }
    }

    @Deactivate
    public void deactivate() {
        for (BundleInfoDb a : this.db) {
            logger.info("Clearing versions");
            a.clear(this.host);
        }
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 1: {
                this.logBundle(event.getBundle());
                break;
            }
            case 4: 
            case 16: {
                for (BundleInfoDb a : this.db) {
                    a.delete(this.host, event.getBundle().getBundleId());
                }
                break;
            }
        }
    }

    private void logBundle(Bundle bundle) {
        BundleInfo info = BundleInfoImpl.bundleInfo(this.host, bundle.getSymbolicName(), bundle.getBundleId(), bundle.getVersion().toString(), BundleInfos.getBuildNumber(bundle));
        String log = String.format("Bundle %s, id %d, version %s, build number %s", info.getBundleSymbolicName(), info.getBundleId(), info.getBundleVersion(), info.getBuildNumber().getOrElse((Object)"n/a"));
        logger.info(log);
        for (BundleInfoDb a : this.db) {
            a.store(info);
        }
    }
}

