/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.security;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.util.NotFoundException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;
import org.osgi.service.component.propertytypes.ServiceRanking;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardContextSelect;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardFilterName;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardFilterPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Filter.class}, scope=ServiceScope.PROTOTYPE, property={"service.description=Organization Filter"})
@ServiceRanking(value=980)
@HttpWhiteboardFilterName(value="OrganizationFilter")
@HttpWhiteboardFilterPattern(value={"/*"})
@HttpWhiteboardContextSelect(value="(osgi.http.whiteboard.context.name=opencast)")
public class OrganizationFilter
implements Filter {
    private static final String X_FORWARDED_FOR = "X-Forwarded-For";
    private static final Logger logger = LoggerFactory.getLogger(OrganizationFilter.class);
    protected SecurityService securityService = null;
    protected OrganizationDirectoryService organizationDirectory = null;

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectory) {
        this.organizationDirectory = organizationDirectory;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        URL url = new URL(httpRequest.getRequestURL().toString());
        Organization org = null;
        try {
            block9: {
                try {
                    org = this.organizationDirectory.getOrganization(url);
                }
                catch (NotFoundException e) {
                    logger.trace("No organization mapped to {}", (Object)url);
                    List orgs = this.organizationDirectory.getOrganizations();
                    if (orgs.size() != 1) break block9;
                    org = (Organization)orgs.get(0);
                    logger.trace("Defaulting organization to {}", (Object)org);
                }
            }
            if (org == null) {
                logger.debug("No organization is mapped to handle {}", (Object)url);
                httpResponse.sendError(404, "No organization is mapped to handle " + url);
                return;
            }
            this.securityService.setOrganization(org);
            if (StringUtils.isNotBlank((CharSequence)httpRequest.getHeader(X_FORWARDED_FOR))) {
                logger.trace("Found '{}' header for client IP '{}'", (Object)X_FORWARDED_FOR, (Object)httpRequest.getHeader(X_FORWARDED_FOR));
                this.securityService.setUserIP(httpRequest.getHeader(X_FORWARDED_FOR));
            } else {
                logger.trace("Using client IP from request '{}'", (Object)httpRequest.getRemoteAddr());
                this.securityService.setUserIP(httpRequest.getRemoteAddr());
            }
            chain.doFilter(request, response);
        }
        finally {
            this.securityService.setOrganization(null);
            this.securityService.setUser(null);
            this.securityService.setUserIP(null);
        }
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }
}

