/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.security;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.encoding.PasswordEncoder;
import org.springframework.security.crypto.bcrypt.BCrypt;

public class CustomPasswordEncoder
implements PasswordEncoder {
    private Logger logger = LoggerFactory.getLogger(CustomPasswordEncoder.class);

    public String encodePassword(String rawPassword) {
        return this.encodePassword(rawPassword, null);
    }

    public String encodePassword(String rawPassword, Object ignored) {
        return BCrypt.hashpw((String)rawPassword, (String)BCrypt.gensalt());
    }

    public boolean isPasswordValid(String encodedPassword, String rawPassword, Object salt) {
        if (encodedPassword.length() == 32) {
            String hash = CustomPasswordEncoder.md5Encode(rawPassword, salt);
            this.logger.debug("Checking md5 hashed password '{}' against encoded password '{}'", (Object)hash, (Object)encodedPassword);
            return hash.equals(encodedPassword);
        }
        this.logger.debug("Verifying bcrypt hash {}", (Object)encodedPassword);
        try {
            return StringUtils.startsWith((CharSequence)encodedPassword, (CharSequence)"$") && BCrypt.checkpw((String)rawPassword, (String)encodedPassword);
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("bcrypt hash verification failed", (Throwable)e);
            return false;
        }
    }

    public static String md5Encode(String clearText, Object salt) throws IllegalArgumentException {
        if (clearText == null || salt == null) {
            throw new IllegalArgumentException("clearText and salt must not be null");
        }
        return DigestUtils.md5Hex((String)(clearText + "{" + salt.toString() + "}"));
    }
}

