/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ServiceScope;
import org.osgi.service.component.propertytypes.ServiceRanking;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardContextSelect;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardFilterName;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardFilterPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Filter.class}, scope=ServiceScope.PROTOTYPE, property={"service.description=JSONP Filter"})
@ServiceRanking(value=5)
@HttpWhiteboardFilterName(value="JsonpFilter")
@HttpWhiteboardFilterPattern(value={"/*"})
@HttpWhiteboardContextSelect(value="(osgi.http.whiteboard.context.name=opencast)")
public class JsonpFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(JsonpFilter.class);
    public static final String CONTENT_TYPE_HEADER = "Content-Type";
    public static final String CALLBACK_PARAM = "jsonp";
    public static final Pattern SAFE_PATTERN = Pattern.compile("[a-zA-Z0-9\\.\\_]+");
    public static final String JS_CONTENT_TYPE = "application/x-javascript";
    public static final String CHARACTER_ENCODING = "UTF-8";
    public static final String DEFAULT_CALLBACK = "handleMatterhornData";
    public static final String OPEN_PARENS = "(";
    public static final String POST_PADDING = ");";

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        String callbackValue = request.getParameter(CALLBACK_PARAM);
        if (callbackValue == null || callbackValue.isEmpty()) {
            logger.debug("No json padding requested from {}", (Object)request);
            chain.doFilter((ServletRequest)request, resp);
        } else {
            logger.debug("Json padding '{}' requested from {}", (Object)callbackValue, (Object)request);
            if (!SAFE_PATTERN.matcher(callbackValue).matches()) {
                callbackValue = DEFAULT_CALLBACK;
            }
            HttpServletResponse originalResponse = (HttpServletResponse)resp;
            HttpServletResponseContentWrapper wrapper = new HttpServletResponseContentWrapper(originalResponse, callbackValue);
            chain.doFilter((ServletRequest)request, (ServletResponse)wrapper);
            wrapper.flushWrapper();
        }
    }

    static class ByteArrayServletOutputStream
    extends ServletOutputStream {
        protected byte[] buf;
        protected int count;

        ByteArrayServletOutputStream() {
            this(32);
        }

        ByteArrayServletOutputStream(int size) {
            if (size < 0) {
                throw new IllegalArgumentException("Negative initial size: " + size);
            }
            this.buf = new byte[size];
        }

        public synchronized byte[] toByteArray() {
            return Arrays.copyOf(this.buf, this.count);
        }

        public synchronized void reset() {
            this.count = 0;
        }

        public synchronized int size() {
            return this.count;
        }

        public void enlarge(int size) {
            if (size > this.buf.length) {
                this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, size));
            }
        }

        public synchronized void write(int b) throws IOException {
            int newcount = this.count + 1;
            this.enlarge(newcount);
            this.buf[this.count] = (byte)b;
            this.count = newcount;
        }

        public boolean isReady() {
            return false;
        }

        public void setWriteListener(WriteListener arg0) {
        }
    }

    static class HttpServletResponseContentWrapper
    extends HttpServletResponseWrapper {
        protected ByteArrayServletOutputStream buffer;
        protected PrintWriter bufferWriter;
        protected boolean committed = false;
        protected boolean enableWrapping = false;
        protected String preWrapper;

        HttpServletResponseContentWrapper(HttpServletResponse response, String callbackValue) {
            super(response);
            this.preWrapper = callbackValue + JsonpFilter.OPEN_PARENS;
            this.buffer = new ByteArrayServletOutputStream();
        }

        public void flushWrapper() throws IOException {
            if (this.enableWrapping) {
                if (this.bufferWriter != null) {
                    this.bufferWriter.close();
                }
                if (this.buffer != null) {
                    this.buffer.close();
                }
                this.getResponse().setContentType(JsonpFilter.JS_CONTENT_TYPE);
                this.getResponse().setContentLength(this.preWrapper.getBytes(JsonpFilter.CHARACTER_ENCODING).length + this.buffer.size() + JsonpFilter.POST_PADDING.getBytes().length);
                this.getResponse().setCharacterEncoding(JsonpFilter.CHARACTER_ENCODING);
                this.getResponse().getOutputStream().write(this.preWrapper.getBytes(JsonpFilter.CHARACTER_ENCODING));
                this.getResponse().getOutputStream().write(this.buffer.toByteArray());
                this.getResponse().getOutputStream().write(JsonpFilter.POST_PADDING.getBytes());
                this.getResponse().flushBuffer();
                this.committed = true;
            }
        }

        public void setHeader(String name, String value) {
            if (JsonpFilter.CONTENT_TYPE_HEADER.equalsIgnoreCase(name) && "application/json".equals(value)) {
                this.enableWrapping = true;
            }
            super.setHeader(name, value);
        }

        public void addHeader(String name, String value) {
            if (JsonpFilter.CONTENT_TYPE_HEADER.equalsIgnoreCase(name) && "application/json".equals(value)) {
                this.enableWrapping = true;
            }
            super.addHeader(name, value);
        }

        public String getContentType() {
            return this.enableWrapping ? JsonpFilter.JS_CONTENT_TYPE : this.getResponse().getContentType();
        }

        public void setContentType(String type) {
            this.enableWrapping = "application/json".equals(type);
            super.setContentType(type);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return this.enableWrapping ? this.buffer : this.getResponse().getOutputStream();
        }

        public PrintWriter getWriter() throws IOException {
            if (this.enableWrapping) {
                if (this.bufferWriter == null) {
                    this.bufferWriter = new PrintWriter(new OutputStreamWriter((OutputStream)((Object)this.buffer), this.getCharacterEncoding()));
                }
                return this.bufferWriter;
            }
            return this.getResponse().getWriter();
        }

        public void setBufferSize(int size) {
            if (this.enableWrapping) {
                this.buffer.enlarge(size);
            } else {
                this.getResponse().setBufferSize(size);
            }
        }

        public int getBufferSize() {
            return this.enableWrapping ? this.buffer.size() : this.getResponse().getBufferSize();
        }

        public void flushBuffer() throws IOException {
            if (!this.enableWrapping) {
                this.getResponse().flushBuffer();
            }
        }

        public boolean isCommitted() {
            return this.enableWrapping ? this.committed : this.getResponse().isCommitted();
        }

        public void reset() {
            this.getResponse().reset();
            this.buffer.reset();
        }

        public void resetBuffer() {
            this.getResponse().resetBuffer();
            this.buffer.reset();
        }
    }
}

