/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.kernel.mail;

import java.util.Dictionary;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.kernel.mail.BaseSmtpService;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ManagedService.class, SmtpService.class}, property={"service.description=SMTP Service"})
public class SmtpService
extends BaseSmtpService
implements ManagedService {
    private static final Logger logger = LoggerFactory.getLogger(SmtpService.class);
    private static final String OPT_MAIL_TEST = "mail.test";
    private static final String OPT_MAIL_MODE = "mail.mode";
    private static final String SPLIT_PATTERN = "[\\s,]+";
    private static final String TEXT_PLAIN = "text/plain; charset=UTF-8";
    private static final String TEXT_HTML = "text/html; charset=UTF-8";

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        String mailFrom;
        String mailPassword;
        String propName;
        String mailHost;
        String optMode = StringUtils.trimToNull((String)((String)properties.get(OPT_MAIL_MODE)));
        if (optMode != null) {
            try {
                BaseSmtpService.Mode mode = BaseSmtpService.Mode.valueOf(optMode);
                this.setProductionMode(BaseSmtpService.Mode.production.equals((Object)mode));
            }
            catch (Exception e) {
                logger.error("Error parsing smtp service mode '{}': {}", (Object)optMode, (Object)e.getMessage());
                throw new ConfigurationException(OPT_MAIL_MODE, e.getMessage());
            }
        }
        logger.info("Smtp service is in {} mode", (Object)(this.isProductionMode() ? "production" : "test"));
        String optMailTransport = StringUtils.trimToNull((String)((String)properties.get("mail.transport.protocol")));
        if (StringUtils.isNotBlank((CharSequence)optMailTransport)) {
            this.setMailTransport(optMailTransport);
        }
        if (StringUtils.isBlank((CharSequence)(mailHost = (String)properties.get(propName = "mail." + this.mailTransport + ".host")))) {
            throw new ConfigurationException(propName, "is not set");
        }
        this.setHost(mailHost);
        propName = "mail." + this.mailTransport + ".port";
        String mailPort = (String)properties.get(propName);
        if (StringUtils.isNotBlank((CharSequence)mailPort)) {
            this.setPort(Integer.parseInt(mailPort));
        }
        propName = "mail." + this.mailTransport + ".starttls.enable";
        this.setSsl(BooleanUtils.toBoolean((String)((String)properties.get(propName))));
        String mailUser = (String)properties.get("mail.user");
        if (StringUtils.isNotBlank((CharSequence)mailUser)) {
            this.setUser(mailUser);
        }
        if (StringUtils.isNotBlank((CharSequence)(mailPassword = (String)properties.get("mail.password")))) {
            this.setPassword(mailPassword);
        }
        if (StringUtils.isNotBlank((CharSequence)(mailFrom = (String)properties.get("mail.from")))) {
            this.setSender(mailFrom);
        }
        this.setDebug(BooleanUtils.toBoolean((String)((String)properties.get("mail.debug"))));
        this.configure();
        String mailTest = StringUtils.trimToNull((String)((String)properties.get(OPT_MAIL_TEST)));
        if (mailTest != null && Boolean.parseBoolean(mailTest)) {
            logger.info("Sending test message to {}", (Object)mailFrom);
            try {
                this.sendTestMessage(mailFrom);
            }
            catch (MessagingException e) {
                logger.error("Error sending test message to " + mailFrom + ": " + e.getMessage());
                while (e.getNextException() != null) {
                    Exception ne = e.getNextException();
                    logger.error("Error sending test message to " + mailFrom + ": " + ne.getMessage());
                    if (!(ne instanceof MessagingException)) break;
                    e = (MessagingException)((Object)ne);
                }
                throw new ConfigurationException("mail." + this.mailTransport + ".host", "Failed to send test message to " + mailFrom);
            }
        }
    }

    private void sendTestMessage(String recipient) throws MessagingException {
        this.send(recipient, "Test from Opencast", "Hello world");
    }

    public void send(String to, String subject, String bodyText) throws MessagingException {
        this.send(to, subject, bodyText, null);
    }

    public void send(String to, String subject, String bodyText, String bodyHTML) throws MessagingException {
        this.send(to, null, null, subject, bodyText, bodyHTML);
    }

    public void send(String to, String cc, String bcc, String subject, String bodyText) throws MessagingException {
        this.send(to, cc, bcc, subject, bodyText, null);
    }

    public void send(String to, String cc, String bcc, String subject, String bodyText, String bodyHTML) throws MessagingException {
        String[] toArray = null;
        String[] ccArray = null;
        String[] bccArray = null;
        if (to != null) {
            toArray = to.trim().split(SPLIT_PATTERN, 0);
        }
        if (cc != null) {
            ccArray = cc.trim().split(SPLIT_PATTERN, 0);
        }
        if (bcc != null) {
            bccArray = bcc.trim().split(SPLIT_PATTERN, 0);
        }
        this.send(toArray, ccArray, bccArray, subject, bodyText, bodyHTML);
    }

    public void send(String[] to, String[] cc, String[] bcc, String subject, String bodyText) throws MessagingException {
        this.send(to, cc, bcc, subject, bodyText, null);
    }

    public void send(String[] to, String[] cc, String[] bcc, String subject, String bodyText, String bodyHTML) throws MessagingException {
        MimeBodyPart part;
        if (bodyText == null && bodyHTML == null) {
            throw new IllegalArgumentException("bodyText and bodyHTML cannot both be empty");
        }
        MimeMessage message = this.createMessage();
        SmtpService.addRecipients(message, Message.RecipientType.TO, to);
        SmtpService.addRecipients(message, Message.RecipientType.CC, cc);
        SmtpService.addRecipients(message, Message.RecipientType.BCC, bcc);
        message.setSubject(subject);
        MimeMultipart mp = new MimeMultipart("alternative");
        if (bodyText != null) {
            part = new MimeBodyPart();
            part.setContent((Object)bodyText, TEXT_PLAIN);
            mp.addBodyPart((BodyPart)part);
        }
        if (bodyHTML != null) {
            part = new MimeBodyPart();
            part.setContent((Object)bodyHTML, TEXT_HTML);
            mp.addBodyPart((BodyPart)part);
        }
        message.setContent((Multipart)mp);
        message.saveChanges();
        this.send(message);
    }

    private static void addRecipients(MimeMessage message, Message.RecipientType type, String ... strAddresses) throws MessagingException {
        if (strAddresses != null) {
            InternetAddress[] addresses = new InternetAddress[strAddresses.length];
            for (int i = 0; i < strAddresses.length; ++i) {
                addresses[i] = new InternetAddress(strAddresses[i]);
            }
            message.addRecipients(type, (Address[])addresses);
        }
    }
}

