/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.helloworld.impl;

import java.util.Map;
import java.util.Objects;
import org.opencastproject.helloworld.api.HelloWorldService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Hello World Service"}, immediate=true, service={HelloWorldService.class})
public class HelloWorldServiceImpl
implements HelloWorldService {
    private static final Logger logger = LoggerFactory.getLogger(HelloWorldServiceImpl.class);
    private String message = "Hello World";

    @Activate
    @Modified
    void activate(Map<String, Object> properties) {
        this.message = Objects.toString(properties.get("message"), "Hello World");
        logger.debug("Activated/Updated hello world service");
    }

    public String helloWorld() {
        logger.info(this.message);
        return this.message;
    }

    public String helloName(String name) {
        logger.info("Name is {}.", (Object)name);
        if ("".equals(name)) {
            return "Hello!";
        }
        return "Hello " + name + "!";
    }
}

