/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.external.endpoint;

import com.entwinemedia.fn.data.Opt;
import com.entwinemedia.fn.data.json.Field;
import com.entwinemedia.fn.data.json.JValue;
import com.entwinemedia.fn.data.json.Jsons;
import com.entwinemedia.fn.fns.Strings;
import java.text.ParseException;
import java.util.Date;
import java.util.Dictionary;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.opencastproject.external.common.ApiResponseBuilder;
import org.opencastproject.security.urlsigning.exception.UrlSigningException;
import org.opencastproject.security.urlsigning.service.UrlSigningService;
import org.opencastproject.util.DateTimeSupport;
import org.opencastproject.util.OsgiUtil;
import org.opencastproject.util.RestUtil;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/api/security")
@Produces(value={"application/json", "application/v1.0.0+json", "application/v1.1.0+json", "application/v1.2.0+json", "application/v1.3.0+json", "application/v1.4.0+json", "application/v1.5.0+json", "application/v1.6.0+json", "application/v1.7.0+json", "application/v1.8.0+json", "application/v1.9.0+json", "application/v1.10.0+json", "application/v1.11.0+json"})
@RestService(name="externalapisecurity", title="External API Security Service", notes={}, abstractText="Provides security operations related to the external API")
@Component(immediate=true, service={SecurityEndpoint.class, ManagedService.class}, property={"service.description=External API - Security Endpoint", "opencast.service.type=org.opencastproject.external.security", "opencast.service.path=/api/security"})
@JaxrsResource
public class SecurityEndpoint
implements ManagedService {
    protected static final String URL_SIGNING_EXPIRES_DURATION_SECONDS_KEY = "url.signing.expires.seconds";
    protected static final long DEFAULT_URL_SIGNING_EXPIRE_DURATION = 7200L;
    private static final Logger log = LoggerFactory.getLogger(SecurityEndpoint.class);
    private long expireSeconds = 7200L;
    private UrlSigningService urlSigningService;

    @Reference
    void setUrlSigningService(UrlSigningService urlSigningService) {
        this.urlSigningService = urlSigningService;
    }

    @Activate
    void activate() {
        log.info("Activating External API - Security Endpoint");
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        if (properties == null) {
            log.info("No configuration available, using defaults");
            return;
        }
        Opt expiration = OsgiUtil.getOptCfg(properties, (String)URL_SIGNING_EXPIRES_DURATION_SECONDS_KEY).toOpt().map(Strings.toLongF);
        if (expiration.isSome()) {
            this.expireSeconds = (Long)expiration.get();
            log.info("The property {} has been configured to expire signed URLs in {}.", (Object)URL_SIGNING_EXPIRES_DURATION_SECONDS_KEY, (Object)DateTimeSupport.humanReadableTime((long)this.expireSeconds));
        } else {
            this.expireSeconds = 7200L;
            log.info("The property {} has not been configured, so the default is being used to expire signed URLs in {}.", (Object)URL_SIGNING_EXPIRES_DURATION_SECONDS_KEY, (Object)DateTimeSupport.humanReadableTime((long)this.expireSeconds));
        }
    }

    @POST
    @Path(value="sign")
    @RestQuery(name="signurl", description="Returns a signed URL that can be played back for the indicated period of time, while access is optionally restricted to the specified IP address.", returnDescription="", restParameters={@RestParameter(name="url", isRequired=true, description="The linke to encode.", type=RestParameter.Type.STRING), @RestParameter(name="valid-until", description="Until when is the signed url valid", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="valid-source", description="The IP address from which the url can be accessed", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The signed URL is returned.", responseCode=200), @RestResponse(description="The caller is not authorized to have the link signed.", responseCode=401)})
    public Response signUrl(@HeaderParam(value="Accept") String acceptHeader, @FormParam(value="url") String url, @FormParam(value="valid-until") String validUntilUtc, @FormParam(value="valid-source") String validSource) {
        DateTime validUntil;
        if (StringUtils.isBlank((CharSequence)url)) {
            return RestUtil.R.badRequest((String)"Query parameter 'url' is mandatory");
        }
        if (StringUtils.isNotBlank((CharSequence)validUntilUtc)) {
            try {
                validUntil = new DateTime(DateTimeSupport.fromUTC((String)validUntilUtc));
            }
            catch (IllegalStateException | ParseException e) {
                return RestUtil.R.badRequest((String)"Query parameter 'valid-until' is not a valid ISO-8601 date string");
            }
        } else {
            validUntil = new DateTime(new Date().getTime() + this.expireSeconds * 1000L);
        }
        if (this.urlSigningService.accepts(url)) {
            String signedUrl = "";
            try {
                signedUrl = this.urlSigningService.sign(url, validUntil, null, validSource);
            }
            catch (UrlSigningException e) {
                log.warn("Error while trying to sign url '{}':", (Object)url, (Object)e);
                return ApiResponseBuilder.Json.ok(acceptHeader, (JValue)Jsons.obj((Field[])new Field[]{Jsons.f((String)"error", (String)"Error while signing url")}));
            }
            return ApiResponseBuilder.Json.ok(acceptHeader, (JValue)Jsons.obj((Field[])new Field[]{Jsons.f((String)"url", (String)signedUrl), Jsons.f((String)"valid-until", (String)DateTimeSupport.toUTC((long)validUntil.getMillis()))}));
        }
        return ApiResponseBuilder.Json.ok(acceptHeader, (JValue)Jsons.obj((Field[])new Field[]{Jsons.f((String)"error", (String)"Given URL cannot be signed")}));
    }
}

