/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.external.endpoint;

import com.entwinemedia.fn.data.json.JValue;
import com.entwinemedia.fn.data.json.Jsons;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.opencastproject.capture.admin.api.Agent;
import org.opencastproject.capture.admin.api.CaptureAgentStateService;
import org.opencastproject.external.common.ApiResponseBuilder;
import org.opencastproject.external.util.CaptureAgentUtils;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/api/agents")
@Produces(value={"application/json", "application/v1.1.0+json", "application/v1.2.0+json", "application/v1.3.0+json", "application/v1.4.0+json", "application/v1.5.0+json", "application/v1.6.0+json", "application/v1.7.0+json", "application/v1.8.0+json", "application/v1.9.0+json", "application/v1.10.0+json", "application/v1.11.0+json"})
@RestService(name="externalapicaptureagents", title="External API Capture Agents Service", notes={}, abstractText="Provides resources and operations related to the capture agents")
@Component(immediate=true, service={CaptureAgentsEndpoint.class}, property={"service.description=External API - Capture Agents Endpoint", "opencast.service.type=org.opencastproject.external.agents", "opencast.service.path=/api/agents"})
@JaxrsResource
public class CaptureAgentsEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(CaptureAgentsEndpoint.class);
    private CaptureAgentStateService agentStateService;

    public CaptureAgentStateService getAgentStateService() {
        return this.agentStateService;
    }

    @Reference
    public void setAgentStateService(CaptureAgentStateService agentStateService) {
        this.agentStateService = agentStateService;
    }

    @Activate
    void activate(ComponentContext cc) {
        logger.info("Activating External API - Capture Agents Endpoint");
    }

    @GET
    @Path(value="{agentId}")
    @RestQuery(name="getagent", description="Returns a single capture agent.", returnDescription="", pathParameters={@RestParameter(name="agentId", description="The agent id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The agent is returned.", responseCode=200), @RestResponse(description="The specified agent does not exist.", responseCode=404)})
    public Response getAgent(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="agentId") String id) throws Exception {
        Agent agent = this.agentStateService.getAgent(id);
        if (agent == null) {
            return ApiResponseBuilder.notFound("Cannot find an agent with id '%s'.", id);
        }
        return ApiResponseBuilder.Json.ok(acceptHeader, CaptureAgentUtils.generateJsonAgent(agent));
    }

    @GET
    @Path(value="/")
    @RestQuery(name="getagents", description="Returns a list of agents.", returnDescription="", restParameters={@RestParameter(name="limit", description="The maximum number of results to return for a single request.", isRequired=false, type=RestParameter.Type.INTEGER), @RestParameter(name="offset", description="The index of the first result to return.", isRequired=false, type=RestParameter.Type.INTEGER)}, responses={@RestResponse(description="A (potentially empty) list of agents is returned.", responseCode=200)})
    public Response getAgents(@HeaderParam(value="Accept") String acceptHeader, @QueryParam(value="offset") Integer offset, @QueryParam(value="limit") Integer limit) {
        List<Object> agents = new ArrayList(this.agentStateService.getKnownAgents().values());
        if (offset != null && offset > 0) {
            agents = agents.subList(Math.min(offset, agents.size()), agents.size());
        }
        if (limit != null && limit > 0) {
            agents = agents.subList(0, Math.min(limit, agents.size()));
        }
        List agentsJSON = agents.stream().map(a -> CaptureAgentUtils.generateJsonAgent(a)).collect(Collectors.toList());
        return ApiResponseBuilder.Json.ok(acceptHeader, (JValue)Jsons.arr(agentsJSON));
    }
}

