/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.external.userdirectory;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.security.api.User;
import org.opencastproject.security.impl.jpa.JpaGroup;
import org.opencastproject.security.impl.jpa.JpaOrganization;
import org.opencastproject.security.impl.jpa.JpaRole;
import org.opencastproject.security.util.SecurityUtil;
import org.opencastproject.userdirectory.JpaGroupRoleProvider;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.UrlSupport;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ExternalGroupLoader.class}, property={"service.description=External group loader"})
public class ExternalGroupLoader {
    private static final Logger logger = LoggerFactory.getLogger(ExternalGroupLoader.class);
    public static final String SHOULD_CREATE_DEFAULT_GROUPS_CONFIG_KEY = "create_default_groups";
    public static final String EXTERNAL_GROUP_SUFFIX = "_EXTERNAL_APPLICATIONS";
    public static final String ROLES_PATH_PREFIX = "/roles";
    public static final String EXTERNAL_APPLICATIONS_ROLES_FILE = "external-applications";
    protected JpaGroupRoleProvider groupRoleProvider;
    protected OrganizationDirectoryService organizationDirectoryService;
    protected SecurityService securityService;

    @Reference
    public void setGroupRoleProvider(JpaGroupRoleProvider groupRoleProvider) {
        this.groupRoleProvider = groupRoleProvider;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectoryService) {
        this.organizationDirectoryService = organizationDirectoryService;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Activate
    public void activate(ComponentContext cc) throws Exception {
        logger.debug("Activate external group loader");
        Dictionary properties = cc.getProperties();
        boolean shouldCreateDefaultGroups = BooleanUtils.toBoolean((String)Objects.toString(properties.get(SHOULD_CREATE_DEFAULT_GROUPS_CONFIG_KEY), "true"));
        if (shouldCreateDefaultGroups) {
            this.createDefaultGroups(cc);
        } else {
            logger.info("Disabled generation of External Application group");
        }
    }

    private void createDefaultGroups(ComponentContext cc) {
        for (Organization organization : this.organizationDirectoryService.getOrganizations()) {
            SecurityUtil.runAs((SecurityService)this.securityService, (Organization)organization, (User)SecurityUtil.createSystemUser((ComponentContext)cc, (Organization)organization), () -> {
                try {
                    Organization testOrg = this.organizationDirectoryService.getOrganization(organization.getId());
                    if (!(testOrg instanceof JpaOrganization)) {
                        logger.info("Note: Ignoring organization with id " + testOrg.getId() + " because it is not a JpaOrganization");
                        return;
                    }
                    JpaOrganization org = (JpaOrganization)testOrg;
                    String externalApplicationsGroupId = org.getId().toUpperCase().concat(EXTERNAL_GROUP_SUFFIX);
                    JpaGroup externalApplicationGroup = this.groupRoleProvider.loadGroup(externalApplicationsGroupId, org.getId());
                    if (externalApplicationGroup == null) {
                        String externalApplicationsGroupname = org.getName().concat(" External Applications");
                        String externalApplicationsGroupDescription = "External application users of '" + org.getName() + "'";
                        HashSet<JpaRole> roles = new HashSet<JpaRole>();
                        for (String role : this.loadRoles(EXTERNAL_APPLICATIONS_ROLES_FILE)) {
                            roles.add(new JpaRole(role, org));
                        }
                        roles.add(new JpaRole("ROLE_SUDO", org));
                        externalApplicationGroup = new JpaGroup(externalApplicationsGroupId, org, externalApplicationsGroupname, externalApplicationsGroupDescription, roles, new HashSet());
                        this.groupRoleProvider.addGroup(externalApplicationGroup);
                    }
                }
                catch (IOException | IllegalStateException | UnauthorizedException | NotFoundException e) {
                    logger.error("Unable to load external API groups", e);
                }
            });
        }
    }

    private Set<String> loadRoles(String roleFileName) throws IllegalStateException, IOException {
        TreeSet<String> treeSet;
        block8: {
            String propertiesFile = UrlSupport.concat((String)ROLES_PATH_PREFIX, (String)roleFileName);
            InputStream rolesIS = this.getClass().getResourceAsStream(propertiesFile);
            try {
                treeSet = new TreeSet<String>(IOUtils.readLines((InputStream)rolesIS, (Charset)StandardCharsets.UTF_8));
                if (rolesIS == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rolesIS != null) {
                        try {
                            rolesIS.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.error("Error loading roles from file {}", (Object)propertiesFile);
                    throw e;
                }
            }
            rolesIS.close();
        }
        return treeSet;
    }
}

