/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.external.endpoint;

import com.entwinemedia.fn.Fn;
import com.entwinemedia.fn.Stream;
import com.entwinemedia.fn.data.Opt;
import com.entwinemedia.fn.data.json.Field;
import com.entwinemedia.fn.data.json.JArray;
import com.entwinemedia.fn.data.json.JObject;
import com.entwinemedia.fn.data.json.JValue;
import com.entwinemedia.fn.data.json.Jsons;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.api.SearchResult;
import org.opencastproject.elasticsearch.api.SearchResultItem;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.QueryPreprocessor;
import org.opencastproject.elasticsearch.index.objects.series.Series;
import org.opencastproject.elasticsearch.index.objects.series.SeriesSearchQuery;
import org.opencastproject.external.common.ApiMediaType;
import org.opencastproject.external.common.ApiResponses;
import org.opencastproject.external.common.ApiVersion;
import org.opencastproject.external.util.AclUtils;
import org.opencastproject.external.util.ExternalMetadataUtils;
import org.opencastproject.index.service.api.IndexService;
import org.opencastproject.index.service.exception.IndexServiceException;
import org.opencastproject.index.service.util.RequestUtils;
import org.opencastproject.index.service.util.RestUtils;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreMetadataCollection;
import org.opencastproject.metadata.dublincore.MetadataField;
import org.opencastproject.metadata.dublincore.MetadataJson;
import org.opencastproject.metadata.dublincore.MetadataList;
import org.opencastproject.metadata.dublincore.SeriesCatalogUIAdapter;
import org.opencastproject.security.api.AccessControlEntry;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AccessControlParser;
import org.opencastproject.security.api.Permissions;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.series.api.SeriesException;
import org.opencastproject.series.api.SeriesService;
import org.opencastproject.util.DateTimeSupport;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.RestUtil;
import org.opencastproject.util.UrlSupport;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.opencastproject.util.requests.SortCriterion;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@Produces(value={"application/json", "application/v1.0.0+json", "application/v1.1.0+json", "application/v1.2.0+json", "application/v1.3.0+json", "application/v1.4.0+json", "application/v1.5.0+json", "application/v1.6.0+json", "application/v1.7.0+json", "application/v1.8.0+json", "application/v1.9.0+json", "application/v1.10.0+json", "application/v1.11.0+json"})
@RestService(name="externalapiseries", title="External API Series Service", notes={}, abstractText="Provides resources and operations related to the series")
@Component(immediate=true, service={SeriesEndpoint.class}, property={"service.description=External API - Series Endpoint", "opencast.service.type=org.opencastproject.external", "opencast.service.path=/api/series"})
public class SeriesEndpoint {
    private static final int CREATED_BY_UI_ORDER = 9;
    private static final int DEFAULT_LIMIT = 100;
    private static final Logger logger = LoggerFactory.getLogger(SeriesEndpoint.class);
    protected String endpointBaseUrl;
    private ElasticsearchIndex elasticsearchIndex;
    private IndexService indexService;
    private SecurityService securityService;
    private SeriesService seriesService;

    @Reference
    void setElasticsearchIndex(ElasticsearchIndex elasticsearchIndex) {
        this.elasticsearchIndex = elasticsearchIndex;
    }

    @Reference
    void setIndexService(IndexService indexService) {
        this.indexService = indexService;
    }

    @Reference
    void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    void setSeriesService(SeriesService seriesService) {
        this.seriesService = seriesService;
    }

    @Activate
    void activate(ComponentContext cc) {
        logger.info("Activating External API - Series Endpoint");
        Tuple endpointUrl = RestUtil.getEndpointUrl((ComponentContext)cc, (String)"org.opencastproject.external.api.url", (String)"opencast.service.path");
        this.endpointBaseUrl = UrlSupport.concat((String)((String)endpointUrl.getA()), (String)((String)endpointUrl.getB()));
        logger.debug("Configured service endpoint is {}", (Object)this.endpointBaseUrl);
    }

    @GET
    @Path(value="")
    @RestQuery(name="getseries", description="Returns a list of series.", returnDescription="", restParameters={@RestParameter(name="onlyWithWriteAccess", isRequired=false, description="Whether only to get the series to which we have write access.", type=RestParameter.Type.BOOLEAN), @RestParameter(name="filter", isRequired=false, description="Usage <Filter Name>:<Value to Filter With>. Filters can combine using a comma \",\". Available Filters: managedAcl, contributors, CreationDate, Creator, textFilter, language, license, organizers, subject, title. If API ver > 1.1.0 also: identifier, description, creator, publishers, rightsholder.", type=RestParameter.Type.STRING), @RestParameter(name="sort", description="Sort the results based upon a list of comma seperated sorting criteria. In the comma seperated list each type of sorting is specified as a pair such as: <Sort Name>:ASC or <Sort Name>:DESC. Adding the suffix ASC or DESC sets the order as ascending or descending order and is mandatory.", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="limit", description="The maximum number of results to return for a single request.", isRequired=false, type=RestParameter.Type.INTEGER), @RestParameter(name="offset", description="The index of the first result to return.", isRequired=false, type=RestParameter.Type.INTEGER), @RestParameter(name="withacl", isRequired=false, description="Whether the acl should be included in the response.", type=RestParameter.Type.BOOLEAN)}, responses={@RestResponse(description="A (potentially empty) list of series is returned.", responseCode=200)})
    public Response getSeriesList(@HeaderParam(value="Accept") String acceptHeader, @QueryParam(value="filter") String filter, @QueryParam(value="sort") String sort, @QueryParam(value="order") String order, @QueryParam(value="offset") int offset, @QueryParam(value="limit") int limit, @QueryParam(value="onlyWithWriteAccess") Boolean onlyWithWriteAccess, @QueryParam(value="withacl") Boolean withAcl) throws UnauthorizedException {
        ApiVersion requestedVersion = ApiMediaType.parse(acceptHeader).getVersion();
        if (requestedVersion.isSmallerThan(ApiVersion.VERSION_1_5_0)) {
            withAcl = false;
        }
        try {
            SeriesSearchQuery query = new SeriesSearchQuery(this.securityService.getOrganization().getId(), this.securityService.getUser());
            Option optSort = Option.option((Object)StringUtils.trimToNull((String)sort));
            if (offset > 0) {
                query.withOffset(offset);
            }
            query.withLimit(limit < 1 ? 100 : limit);
            if (StringUtils.isNotBlank((CharSequence)filter)) {
                for (String f : filter.split(",")) {
                    String[] filterTuple = f.split(":", 2);
                    if (filterTuple.length < 2) {
                        logger.debug("Filter {} not valid: {}", (Object)filterTuple[0], (Object)filter);
                        continue;
                    }
                    String name = filterTuple[0];
                    String value = !requestedVersion.isSmallerThan(ApiVersion.VERSION_1_1_0) ? f.substring(name.length() + 1) : filterTuple[1];
                    if ("managedAcl".equals(name)) {
                        query.withManagedAcl(value);
                        continue;
                    }
                    if ("contributors".equals(name)) {
                        query.withContributor(value);
                        continue;
                    }
                    if ("CreationDate".equals(name)) {
                        try {
                            Tuple<Date, Date> fromAndToCreationRange = this.getFromAndToCreationRange(value.split("/")[0], value.split("/")[1]);
                            query.withCreatedFrom((Date)fromAndToCreationRange.getA());
                            query.withCreatedTo((Date)fromAndToCreationRange.getB());
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            return RestUtil.R.badRequest((String)e.getMessage());
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            String dateErrorMsg = String.format("Filter Series API error: Malformed date period. Correct UTC time period format: yyyy-MM-ddTHH:mm:ssZ/yyyy-MM-ddTHH:mm:ssZ, stated date period string: \"%s\"", value);
                            logger.warn(dateErrorMsg);
                            return RestUtil.R.badRequest((String)dateErrorMsg);
                        }
                    }
                    if ("Creator".equals(name)) {
                        query.withCreator(value);
                        continue;
                    }
                    if ("textFilter".equals(name)) {
                        query.withText(QueryPreprocessor.sanitize((String)value));
                        continue;
                    }
                    if ("language".equals(name)) {
                        query.withLanguage(value);
                        continue;
                    }
                    if ("license".equals(name)) {
                        query.withLicense(value);
                        continue;
                    }
                    if ("organizers".equals(name)) {
                        query.withOrganizer(value);
                        continue;
                    }
                    if ("subject".equals(name)) {
                        query.withSubject(value);
                        continue;
                    }
                    if ("title".equals(name)) {
                        query.withTitle(value);
                        continue;
                    }
                    if (requestedVersion.isSmallerThan(ApiVersion.VERSION_1_1_0)) continue;
                    if ("identifier".equals(name)) {
                        query.withIdentifier(value);
                        continue;
                    }
                    if ("description".equals(name)) {
                        query.withDescription(value);
                        continue;
                    }
                    if ("creator".equals(name)) {
                        query.withCreator(value);
                        continue;
                    }
                    if ("publishers".equals(name)) {
                        query.withPublisher(value);
                        continue;
                    }
                    if ("rightsholder".equals(name)) {
                        query.withRightsHolder(value);
                        continue;
                    }
                    logger.warn("Unknown filter criteria {}", (Object)name);
                    return Response.status((int)400).build();
                }
            }
            if (optSort.isSome()) {
                Set sortCriteria = RestUtils.parseSortQueryParameter((String)((String)optSort.get()));
                block18: for (SortCriterion criterion : sortCriteria) {
                    switch (criterion.getFieldName()) {
                        case "title": {
                            query.sortByTitle(criterion.getOrder());
                            continue block18;
                        }
                        case "contributors": {
                            query.sortByContributors(criterion.getOrder());
                            continue block18;
                        }
                        case "creator": {
                            query.sortByOrganizers(criterion.getOrder());
                            continue block18;
                        }
                        case "created": {
                            query.sortByCreatedDateTime(criterion.getOrder());
                            continue block18;
                        }
                    }
                    logger.info("Unknown sort criteria {}", (Object)criterion.getFieldName());
                    return Response.status((int)400).build();
                }
            }
            if (onlyWithWriteAccess != null && onlyWithWriteAccess.booleanValue()) {
                query.withoutActions();
                query.withAction(Permissions.Action.WRITE);
            }
            logger.trace("Using Query: " + query.toString());
            SearchResult result = this.elasticsearchIndex.getByQuery(query);
            boolean includeAcl = withAcl != null && withAcl != false;
            return this.queryResultToJson((SearchResult<Series>)result, includeAcl, requestedVersion);
        }
        catch (Exception e) {
            logger.warn("Could not perform search query", (Throwable)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private Response queryResultToJson(SearchResult<Series> result, final boolean includeAcl, final ApiVersion requestedVersion) {
        return ApiResponses.Json.ok(requestedVersion, (JValue)Jsons.arr((Iterable)Stream.$((Object[])result.getItems()).map((Fn)new Fn<SearchResultItem<Series>, JValue>(){

            public JValue apply(SearchResultItem<Series> a) {
                JObject result;
                Series s = (Series)a.getSource();
                JArray subjects = s.getSubject() == null ? Jsons.arr() : Jsons.arr(SeriesEndpoint.this.splitSubjectIntoArray(s.getSubject()));
                Date createdDate = s.getCreatedDateTime();
                if (requestedVersion.isSmallerThan(ApiVersion.VERSION_1_1_0)) {
                    result = Jsons.obj((Field[])new Field[]{Jsons.f((String)"identifier", (JValue)Jsons.v((String)s.getIdentifier())), Jsons.f((String)"title", (JValue)Jsons.v((String)s.getTitle())), Jsons.f((String)"creator", (JValue)Jsons.v((Object)s.getCreator(), (JValue)Jsons.BLANK)), Jsons.f((String)"created", (JValue)Jsons.v((Object)(createdDate != null ? DateTimeSupport.toUTC((long)createdDate.getTime()) : null), (JValue)Jsons.BLANK)), Jsons.f((String)"subjects", (JValue)subjects), Jsons.f((String)"contributors", (JValue)Jsons.arr((Iterable)Stream.$((Iterable)s.getContributors()).map(Jsons.Functions.stringToJValue))), Jsons.f((String)"organizers", (JValue)Jsons.arr((Iterable)Stream.$((Iterable)s.getOrganizers()).map(Jsons.Functions.stringToJValue))), Jsons.f((String)"publishers", (JValue)Jsons.arr((Iterable)Stream.$((Iterable)s.getPublishers()).map(Jsons.Functions.stringToJValue)))});
                } else {
                    result = Jsons.obj((Field[])new Field[]{Jsons.f((String)"identifier", (JValue)Jsons.v((String)s.getIdentifier())), Jsons.f((String)"title", (JValue)Jsons.v((String)s.getTitle())), Jsons.f((String)"description", (JValue)Jsons.v((Object)s.getDescription(), (JValue)Jsons.BLANK)), Jsons.f((String)"creator", (JValue)Jsons.v((Object)s.getCreator(), (JValue)Jsons.BLANK)), Jsons.f((String)"created", (JValue)Jsons.v((Object)(createdDate != null ? DateTimeSupport.toUTC((long)createdDate.getTime()) : null), (JValue)Jsons.BLANK)), Jsons.f((String)"subjects", (JValue)subjects), Jsons.f((String)"contributors", (JValue)Jsons.arr((Iterable)Stream.$((Iterable)s.getContributors()).map(Jsons.Functions.stringToJValue))), Jsons.f((String)"organizers", (JValue)Jsons.arr((Iterable)Stream.$((Iterable)s.getOrganizers()).map(Jsons.Functions.stringToJValue))), Jsons.f((String)"language", (JValue)Jsons.v((Object)s.getLanguage(), (JValue)Jsons.BLANK)), Jsons.f((String)"license", (JValue)Jsons.v((Object)s.getLicense(), (JValue)Jsons.BLANK)), Jsons.f((String)"rightsholder", (JValue)Jsons.v((Object)s.getRightsHolder(), (JValue)Jsons.BLANK)), Jsons.f((String)"publishers", (JValue)Jsons.arr((Iterable)Stream.$((Iterable)s.getPublishers()).map(Jsons.Functions.stringToJValue)))});
                    if (includeAcl) {
                        AccessControlList acl = SeriesEndpoint.getAclFromSeries(s);
                        result = result.merge(Jsons.f((String)"acl", (JValue)Jsons.arr(AclUtils.serializeAclToJson(acl))));
                    }
                }
                return result;
            }
        }).toList()));
    }

    private static AccessControlList getAclFromSeries(Series series) {
        AccessControlList activeAcl = new AccessControlList();
        try {
            if (series.getAccessPolicy() != null) {
                activeAcl = AccessControlParser.parseAcl((String)series.getAccessPolicy());
            }
        }
        catch (Exception e) {
            logger.error("Unable to parse access policy", (Throwable)e);
        }
        return activeAcl;
    }

    @GET
    @Path(value="{seriesId}")
    @RestQuery(name="getseries", description="Returns a single series.", returnDescription="", pathParameters={@RestParameter(name="seriesId", description="The series id", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="withacl", isRequired=false, type=RestParameter.Type.BOOLEAN, description="Whether the acl should be included in the response.")}, responses={@RestResponse(description="The series is returned.", responseCode=200), @RestResponse(description="The specified series does not exist.", responseCode=404)})
    public Response getSeries(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="seriesId") String id, @QueryParam(value="withacl") Boolean withAcl) throws Exception {
        Optional optSeries;
        ApiVersion requestedVersion = ApiMediaType.parse(acceptHeader).getVersion();
        if (requestedVersion.isSmallerThan(ApiVersion.VERSION_1_5_0)) {
            withAcl = false;
        }
        if ((optSeries = this.elasticsearchIndex.getSeries(id, this.securityService.getOrganization().getId(), this.securityService.getUser())).isPresent()) {
            JObject responseContent;
            Series s = (Series)optSeries.get();
            JArray subjects = s.getSubject() == null ? Jsons.arr() : Jsons.arr(this.splitSubjectIntoArray(s.getSubject()));
            Date createdDate = s.getCreatedDateTime();
            if (requestedVersion.isSmallerThan(ApiVersion.VERSION_1_1_0)) {
                responseContent = Jsons.obj((Field[])new Field[]{Jsons.f((String)"identifier", (JValue)Jsons.v((String)s.getIdentifier())), Jsons.f((String)"title", (JValue)Jsons.v((String)s.getTitle())), Jsons.f((String)"description", (JValue)Jsons.v((Object)s.getDescription(), (JValue)Jsons.BLANK)), Jsons.f((String)"creator", (JValue)Jsons.v((Object)s.getCreator(), (JValue)Jsons.BLANK)), Jsons.f((String)"subjects", (JValue)subjects), Jsons.f((String)"organization", (JValue)Jsons.v((String)s.getOrganization())), Jsons.f((String)"created", (JValue)Jsons.v((Object)(createdDate != null ? DateTimeSupport.toUTC((long)createdDate.getTime()) : null), (JValue)Jsons.BLANK)), Jsons.f((String)"contributors", (JValue)Jsons.arr((Iterable)Stream.$((Iterable)s.getContributors()).map(Jsons.Functions.stringToJValue))), Jsons.f((String)"organizers", (JValue)Jsons.arr((Iterable)Stream.$((Iterable)s.getOrganizers()).map(Jsons.Functions.stringToJValue))), Jsons.f((String)"opt_out", (Boolean)false), Jsons.f((String)"publishers", (JValue)Jsons.arr((Iterable)Stream.$((Iterable)s.getPublishers()).map(Jsons.Functions.stringToJValue)))});
            } else {
                responseContent = Jsons.obj((Field[])new Field[]{Jsons.f((String)"identifier", (JValue)Jsons.v((String)s.getIdentifier())), Jsons.f((String)"title", (JValue)Jsons.v((String)s.getTitle())), Jsons.f((String)"description", (JValue)Jsons.v((Object)s.getDescription(), (JValue)Jsons.BLANK)), Jsons.f((String)"creator", (JValue)Jsons.v((Object)s.getCreator(), (JValue)Jsons.BLANK)), Jsons.f((String)"subjects", (JValue)subjects), Jsons.f((String)"organization", (JValue)Jsons.v((String)s.getOrganization())), Jsons.f((String)"created", (JValue)Jsons.v((Object)(createdDate != null ? DateTimeSupport.toUTC((long)createdDate.getTime()) : null), (JValue)Jsons.BLANK)), Jsons.f((String)"contributors", (JValue)Jsons.arr((Iterable)Stream.$((Iterable)s.getContributors()).map(Jsons.Functions.stringToJValue))), Jsons.f((String)"organizers", (JValue)Jsons.arr((Iterable)Stream.$((Iterable)s.getOrganizers()).map(Jsons.Functions.stringToJValue))), Jsons.f((String)"opt_out", (Boolean)false), Jsons.f((String)"publishers", (JValue)Jsons.arr((Iterable)Stream.$((Iterable)s.getPublishers()).map(Jsons.Functions.stringToJValue))), Jsons.f((String)"language", (JValue)Jsons.v((Object)s.getLanguage(), (JValue)Jsons.BLANK)), Jsons.f((String)"license", (JValue)Jsons.v((Object)s.getLicense(), (JValue)Jsons.BLANK)), Jsons.f((String)"rightsholder", (JValue)Jsons.v((Object)s.getRightsHolder(), (JValue)Jsons.BLANK))});
                if (withAcl != null && withAcl.booleanValue()) {
                    AccessControlList acl = SeriesEndpoint.getAclFromSeries(s);
                    responseContent = responseContent.merge(Jsons.f((String)"acl", (JValue)Jsons.arr(AclUtils.serializeAclToJson(acl))));
                }
            }
            return ApiResponses.Json.ok(requestedVersion, (JValue)responseContent);
        }
        return ApiResponses.notFound("Cannot find an series with id '%s'.", id);
    }

    private List<JValue> splitSubjectIntoArray(String subject) {
        return Stream.$((Object[])subject.split(",")).map((Fn)new Fn<String, JValue>(){

            public JValue apply(String a) {
                return Jsons.v((String)a.trim());
            }
        }).toList();
    }

    @GET
    @Path(value="{seriesId}/metadata")
    @RestQuery(name="getseriesmetadata", description="Returns a series' metadata of all types or returns a series' metadata collection of the given type when the query string parameter type is specified. For each metadata catalog there is a unique property called the flavor such as dublincore/series so the type in this example would be 'dublincore/series'", returnDescription="", pathParameters={@RestParameter(name="seriesId", description="The series id", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="type", isRequired=false, description="The type of metadata to return", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The series' metadata are returned.", responseCode=200), @RestResponse(description="The specified series does not exist.", responseCode=404)})
    public Response getSeriesMetadata(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="seriesId") String id, @QueryParam(value="type") String type) throws Exception {
        ApiVersion requestedVersion = ApiMediaType.parse(acceptHeader).getVersion();
        if (StringUtils.trimToNull((String)type) == null) {
            return this.getAllMetadata(id, requestedVersion);
        }
        return this.getMetadataByType(id, type, requestedVersion);
    }

    private Response getAllMetadata(String id, ApiVersion requestedVersion) throws SearchIndexException {
        Optional optSeries = this.elasticsearchIndex.getSeries(id, this.securityService.getOrganization().getId(), this.securityService.getUser());
        if (optSeries.isEmpty()) {
            return ApiResponses.notFound("Cannot find a series with id '%s'.", id);
        }
        MetadataList metadataList = new MetadataList();
        List catalogUIAdapters = this.indexService.getSeriesCatalogUIAdapters();
        catalogUIAdapters.remove(this.indexService.getCommonSeriesCatalogUIAdapter());
        for (SeriesCatalogUIAdapter adapter : catalogUIAdapters) {
            Opt optSeriesMetadata = adapter.getFields(id);
            if (!optSeriesMetadata.isSome()) continue;
            metadataList.add(adapter.getFlavor().toString(), adapter.getUITitle(), (DublinCoreMetadataCollection)optSeriesMetadata.get());
        }
        DublinCoreMetadataCollection collection = this.getSeriesMetadata((Series)optSeries.get());
        ExternalMetadataUtils.changeSubjectToSubjects(collection);
        metadataList.add(this.indexService.getCommonSeriesCatalogUIAdapter(), collection);
        return ApiResponses.Json.ok(requestedVersion, MetadataJson.listToJson((MetadataList)metadataList, (boolean)false));
    }

    private Response getMetadataByType(String id, String type, ApiVersion requestedVersion) throws SearchIndexException {
        Optional optSeries = this.elasticsearchIndex.getSeries(id, this.securityService.getOrganization().getId(), this.securityService.getUser());
        if (optSeries.isEmpty()) {
            return ApiResponses.notFound("Cannot find a series with id '%s'.", id);
        }
        if (this.typeMatchesSeriesCatalogUIAdapter(type, this.indexService.getCommonSeriesCatalogUIAdapter())) {
            DublinCoreMetadataCollection collection = this.getSeriesMetadata((Series)optSeries.get());
            ExternalMetadataUtils.changeSubjectToSubjects(collection);
            return ApiResponses.Json.ok(requestedVersion, MetadataJson.collectionToJson((DublinCoreMetadataCollection)collection, (boolean)false));
        }
        List catalogUIAdapters = this.indexService.getSeriesCatalogUIAdapters();
        catalogUIAdapters.remove(this.indexService.getCommonSeriesCatalogUIAdapter());
        for (SeriesCatalogUIAdapter adapter : catalogUIAdapters) {
            Opt optSeriesMetadata;
            if (!this.typeMatchesSeriesCatalogUIAdapter(type, adapter) || !(optSeriesMetadata = adapter.getFields(id)).isSome()) continue;
            return ApiResponses.Json.ok(requestedVersion, MetadataJson.collectionToJson((DublinCoreMetadataCollection)((DublinCoreMetadataCollection)optSeriesMetadata.get()), (boolean)true));
        }
        return ApiResponses.notFound("Cannot find a catalog with type '%s' for series with id '%s'.", type, id);
    }

    private DublinCoreMetadataCollection getSeriesMetadata(Series series) {
        DublinCoreMetadataCollection metadata = this.indexService.getCommonSeriesCatalogUIAdapter().getRawFields();
        MetadataField title = (MetadataField)metadata.getOutputFields().get(DublinCore.PROPERTY_TITLE.getLocalName());
        metadata.removeField(title);
        MetadataField newTitle = new MetadataField(title);
        newTitle.setValue((Object)series.getTitle());
        metadata.addField(newTitle);
        MetadataField subject = (MetadataField)metadata.getOutputFields().get(DublinCore.PROPERTY_SUBJECT.getLocalName());
        metadata.removeField(subject);
        MetadataField newSubject = new MetadataField(subject);
        newSubject.setValue((Object)series.getSubject());
        metadata.addField(newSubject);
        MetadataField description = (MetadataField)metadata.getOutputFields().get(DublinCore.PROPERTY_DESCRIPTION.getLocalName());
        metadata.removeField(description);
        MetadataField newDescription = new MetadataField(description);
        newDescription.setValue((Object)series.getDescription());
        metadata.addField(newDescription);
        MetadataField language = (MetadataField)metadata.getOutputFields().get(DublinCore.PROPERTY_LANGUAGE.getLocalName());
        metadata.removeField(language);
        MetadataField newLanguage = new MetadataField(language);
        newLanguage.setValue((Object)series.getLanguage());
        metadata.addField(newLanguage);
        MetadataField rightsHolder = (MetadataField)metadata.getOutputFields().get(DublinCore.PROPERTY_RIGHTS_HOLDER.getLocalName());
        metadata.removeField(rightsHolder);
        MetadataField newRightsHolder = new MetadataField(rightsHolder);
        newRightsHolder.setValue((Object)series.getRightsHolder());
        metadata.addField(newRightsHolder);
        MetadataField license = (MetadataField)metadata.getOutputFields().get(DublinCore.PROPERTY_LICENSE.getLocalName());
        metadata.removeField(license);
        MetadataField newLicense = new MetadataField(license);
        newLicense.setValue((Object)series.getLicense());
        metadata.addField(newLicense);
        MetadataField organizers = (MetadataField)metadata.getOutputFields().get(DublinCore.PROPERTY_CREATOR.getLocalName());
        metadata.removeField(organizers);
        MetadataField newOrganizers = new MetadataField(organizers);
        newOrganizers.setValue((Object)StringUtils.join((Iterable)series.getOrganizers(), (String)", "));
        metadata.addField(newOrganizers);
        MetadataField contributors = (MetadataField)metadata.getOutputFields().get(DublinCore.PROPERTY_CONTRIBUTOR.getLocalName());
        metadata.removeField(contributors);
        MetadataField newContributors = new MetadataField(contributors);
        newContributors.setValue((Object)StringUtils.join((Iterable)series.getContributors(), (String)", "));
        metadata.addField(newContributors);
        MetadataField publishers = (MetadataField)metadata.getOutputFields().get(DublinCore.PROPERTY_PUBLISHER.getLocalName());
        metadata.removeField(publishers);
        MetadataField newPublishers = new MetadataField(publishers);
        newPublishers.setValue((Object)StringUtils.join((Iterable)series.getPublishers(), (String)", "));
        metadata.addField(newPublishers);
        MetadataField createdBy = new MetadataField("createdBy", null, "EVENTS.SERIES.DETAILS.METADATA.CREATED_BY", true, false, null, null, MetadataField.Type.TEXT, null, null, Integer.valueOf(9), null, null, null, null);
        createdBy.setValue((Object)series.getCreator());
        metadata.addField(createdBy);
        MetadataField uid = (MetadataField)metadata.getOutputFields().get(DublinCore.PROPERTY_IDENTIFIER.getLocalName());
        metadata.removeField(uid);
        MetadataField newUID = new MetadataField(uid);
        newUID.setValue((Object)series.getIdentifier());
        metadata.addField(newUID);
        ExternalMetadataUtils.removeCollectionList(metadata);
        return metadata;
    }

    private boolean typeMatchesSeriesCatalogUIAdapter(String type, SeriesCatalogUIAdapter catalog) {
        if (StringUtils.trimToNull((String)type) == null) {
            return false;
        }
        MediaPackageElementFlavor catalogFlavor = MediaPackageElementFlavor.parseFlavor((String)catalog.getFlavor().toString());
        try {
            MediaPackageElementFlavor flavor = MediaPackageElementFlavor.parseFlavor((String)type);
            return flavor.equals((Object)catalogFlavor);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private Opt<MediaPackageElementFlavor> getFlavor(String flavorString) {
        try {
            MediaPackageElementFlavor flavor = MediaPackageElementFlavor.parseFlavor((String)flavorString);
            return Opt.some((Object)flavor);
        }
        catch (IllegalArgumentException e) {
            return Opt.none();
        }
    }

    @PUT
    @Path(value="{seriesId}/metadata")
    @RestQuery(name="updateseriesmetadata", description="Update a series' metadata of the given type. For a metadata catalog there is the flavor such as 'dublincore/series' and this is the unique type.", returnDescription="", pathParameters={@RestParameter(name="seriesId", description="The series id", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="type", isRequired=true, description="The type of metadata to update", type=RestParameter.Type.STRING), @RestParameter(name="metadata", description="Series metadata as Form param", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The series' metadata have been updated.", responseCode=200), @RestResponse(description="The request is invalid or inconsistent.", responseCode=400), @RestResponse(description="The specified series does not exist.", responseCode=404)})
    public Response updateSeriesMetadata(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="seriesId") String id, @QueryParam(value="type") String type, @FormParam(value="metadata") String metadataJSON) throws Exception {
        Map updatedFields;
        if (StringUtils.trimToNull((String)metadataJSON) == null) {
            return RestUtil.R.badRequest((String)"Unable to update metadata for series as the metadata provided is empty.");
        }
        try {
            updatedFields = RequestUtils.getKeyValueMap((String)metadataJSON);
        }
        catch (ParseException e) {
            logger.debug("Unable to update series '{}' with metadata type '{}' and content '{}'", new Object[]{id, type, metadataJSON, e});
            return RestUtil.R.badRequest((String)String.format("Unable to parse metadata fields as json from '%s' because '%s'", metadataJSON, e.getMessage()));
        }
        catch (IllegalArgumentException e) {
            return RestUtil.R.badRequest((String)e.getMessage());
        }
        if (updatedFields == null || updatedFields.size() == 0) {
            return RestUtil.R.badRequest((String)String.format("Unable to parse metadata fields as json from '%s' because there were no fields to update.", metadataJSON));
        }
        Opt optCollection = Opt.none();
        SeriesCatalogUIAdapter adapter = null;
        Optional optSeries = this.elasticsearchIndex.getSeries(id, this.securityService.getOrganization().getId(), this.securityService.getUser());
        if (optSeries.isEmpty()) {
            return ApiResponses.notFound("Cannot find a series with id '%s'.", id);
        }
        MetadataList metadataList = new MetadataList();
        if (this.typeMatchesSeriesCatalogUIAdapter(type, this.indexService.getCommonSeriesCatalogUIAdapter())) {
            optCollection = Opt.some((Object)this.getSeriesMetadata((Series)optSeries.get()));
            adapter = this.indexService.getCommonSeriesCatalogUIAdapter();
        } else {
            metadataList.add(this.indexService.getCommonSeriesCatalogUIAdapter(), this.getSeriesMetadata((Series)optSeries.get()));
        }
        List catalogUIAdapters = this.indexService.getSeriesCatalogUIAdapters();
        catalogUIAdapters.remove(this.indexService.getCommonSeriesCatalogUIAdapter());
        if (catalogUIAdapters.size() > 0) {
            for (SeriesCatalogUIAdapter catalogUIAdapter : catalogUIAdapters) {
                if (this.typeMatchesSeriesCatalogUIAdapter(type, catalogUIAdapter)) {
                    optCollection = catalogUIAdapter.getFields(id);
                    adapter = catalogUIAdapter;
                    continue;
                }
                Opt current = catalogUIAdapter.getFields(id);
                if (!current.isSome()) continue;
                metadataList.add(catalogUIAdapter, (DublinCoreMetadataCollection)current.get());
            }
        }
        if (optCollection.isNone()) {
            return ApiResponses.notFound("Cannot find a catalog with type '%s' for series with id '%s'.", type, id);
        }
        DublinCoreMetadataCollection collection = (DublinCoreMetadataCollection)optCollection.get();
        for (String key : updatedFields.keySet()) {
            MetadataField field = (MetadataField)collection.getOutputFields().get(key);
            if (field == null) {
                return ApiResponses.notFound("Cannot find a metadata field with id '%s' from event with id '%s' and the metadata type '%s'.", key, id, type);
            }
            if (field.isRequired() && StringUtils.isBlank((CharSequence)((CharSequence)updatedFields.get(key)))) {
                return RestUtil.R.badRequest((String)String.format("The series metadata field with id '%s' and the metadata type '%s' is required and can not be empty!.", key, type));
            }
            collection.removeField(field);
            collection.addField(MetadataJson.copyWithDifferentJsonValue((MetadataField)field, (String)((String)updatedFields.get(key))));
        }
        metadataList.add(adapter, collection);
        this.indexService.updateAllSeriesMetadata(id, metadataList, this.elasticsearchIndex);
        return ApiResponses.Json.ok(acceptHeader, "");
    }

    @DELETE
    @Path(value="{seriesId}/metadata")
    @RestQuery(name="deleteseriesmetadata", description="Deletes a series' metadata catalog of the given type. All fields and values of that catalog will be deleted.", returnDescription="", pathParameters={@RestParameter(name="seriesId", description="The series id", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="type", isRequired=true, description="The type of metadata to delete", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The metadata have been deleted.", responseCode=204), @RestResponse(description="The main metadata catalog dublincore/series cannot be deleted as it has mandatory fields.", responseCode=403), @RestResponse(description="The specified series does not exist.", responseCode=404)})
    public Response deleteSeriesMetadataByType(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="seriesId") String id, @QueryParam(value="type") String type) throws Exception {
        if (StringUtils.trimToNull((String)type) == null) {
            return RestUtil.R.badRequest((String)String.format("A type of catalog needs to be specified for series '%s' to delete it.", id));
        }
        Opt<MediaPackageElementFlavor> flavor = this.getFlavor(type);
        if (flavor.isNone()) {
            return RestUtil.R.badRequest((String)String.format("Unable to parse flavor '%s' it should look something like dublincore/series.", type));
        }
        if (this.typeMatchesSeriesCatalogUIAdapter(type, this.indexService.getCommonSeriesCatalogUIAdapter())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)String.format("Unable to delete mandatory metadata catalog with type '%s' for series '%s'", type, id)).build();
        }
        Optional optSeries = this.elasticsearchIndex.getSeries(id, this.securityService.getOrganization().getId(), this.securityService.getUser());
        if (optSeries.isEmpty()) {
            return ApiResponses.notFound("Cannot find a series with id '%s'.", id);
        }
        try {
            this.indexService.removeCatalogByFlavor((Series)optSeries.get(), MediaPackageElementFlavor.parseFlavor((String)type));
        }
        catch (NotFoundException e) {
            return ApiResponses.notFound(e.getMessage(), new Object[0]);
        }
        return Response.noContent().build();
    }

    @GET
    @Path(value="{seriesId}/acl")
    @RestQuery(name="getseriesacl", description="Returns a series' access policy.", returnDescription="", pathParameters={@RestParameter(name="seriesId", description="The series id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The series' access policy is returned.", responseCode=200), @RestResponse(description="The specified series does not exist.", responseCode=404)})
    public Response getSeriesAcl(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="seriesId") String id) throws Exception {
        ApiVersion requestedVersion = ApiMediaType.parse(acceptHeader).getVersion();
        JSONParser parser = new JSONParser();
        Optional optSeries = this.elasticsearchIndex.getSeries(id, this.securityService.getOrganization().getId(), this.securityService.getUser());
        if (optSeries.isPresent()) {
            Series series = (Series)optSeries.get();
            if (series.getAccessPolicy() == null) {
                return ApiResponses.notFound("Acl for series with id '%s' is not defined.", id);
            }
            JSONObject acl = (JSONObject)parser.parse(series.getAccessPolicy());
            if (!((JSONObject)acl.get((Object)"acl")).containsKey((Object)"ace")) {
                return ApiResponses.notFound("Cannot find acl for series with id '%s'.", id);
            }
            return ApiResponses.Json.ok(requestedVersion, ((JSONArray)((JSONObject)acl.get((Object)"acl")).get((Object)"ace")).toJSONString());
        }
        return ApiResponses.notFound("Cannot find an series with id '%s'.", id);
    }

    @GET
    @Path(value="{seriesId}/properties")
    @RestQuery(name="getseriesproperties", description="Returns a series' properties", returnDescription="", pathParameters={@RestParameter(name="seriesId", description="The series id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The series' properties are returned.", responseCode=200), @RestResponse(description="The specified series does not exist.", responseCode=404)})
    public Response getSeriesProperties(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="seriesId") String id) throws Exception {
        if (this.elasticsearchIndex.getSeries(id, this.securityService.getOrganization().getId(), this.securityService.getUser()).isPresent()) {
            Map properties = this.seriesService.getSeriesProperties(id);
            return ApiResponses.Json.ok(acceptHeader, (JValue)Jsons.obj((Iterable)Stream.$(properties.entrySet()).map((Fn)new Fn<Map.Entry<String, String>, Field>(){

                public Field apply(Map.Entry<String, String> a) {
                    return Jsons.f((String)a.getKey(), (JValue)Jsons.v((Object)a.getValue(), (JValue)Jsons.BLANK));
                }
            }).toList()));
        }
        return ApiResponses.notFound("Cannot find an series with id '%s'.", id);
    }

    @DELETE
    @Path(value="{seriesId}")
    @RestQuery(name="deleteseries", description="Deletes a series.", returnDescription="", pathParameters={@RestParameter(name="seriesId", description="The series id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The series has been deleted.", responseCode=204), @RestResponse(description="The specified series does not exist.", responseCode=404)})
    public Response deleteSeries(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="seriesId") String id) throws NotFoundException {
        try {
            this.indexService.removeSeries(id);
            return Response.noContent().build();
        }
        catch (NotFoundException e) {
            return ApiResponses.notFound("Cannot find a series with id '%s'.", id);
        }
        catch (Exception e) {
            logger.error("Unable to delete the series '{}' due to", (Object)id, (Object)e);
            return Response.serverError().build();
        }
    }

    @PUT
    @Path(value="{seriesId}")
    @RestQuery(name="updateallseriesmetadata", description="Update all series metadata.", returnDescription="", pathParameters={@RestParameter(name="seriesId", description="The series id", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="metadata", description="Series metadata as Form param", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The series' metadata have been updated.", responseCode=200), @RestResponse(description="The request is invalid or inconsistent.", responseCode=400), @RestResponse(description="The specified series does not exist.", responseCode=404)})
    public Response updateSeriesMetadata(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="seriesId") String seriesID, @FormParam(value="metadata") String metadataJSON) throws UnauthorizedException, NotFoundException, SearchIndexException {
        try {
            MetadataList metadataList = this.indexService.updateAllSeriesMetadata(seriesID, metadataJSON, this.elasticsearchIndex);
            return ApiResponses.Json.ok(acceptHeader, MetadataJson.listToJson((MetadataList)metadataList, (boolean)true));
        }
        catch (IllegalArgumentException e) {
            logger.debug("Unable to update series '{}' with metadata '{}'", new Object[]{seriesID, metadataJSON, e});
            return RestUtil.R.badRequest((String)e.getMessage());
        }
        catch (IndexServiceException e) {
            logger.error("Unable to update series '{}' with metadata '{}'", new Object[]{seriesID, metadataJSON, e});
            return RestUtil.R.serverError();
        }
    }

    @POST
    @Path(value="")
    @RestQuery(name="createseries", description="Creates a series.", returnDescription="", restParameters={@RestParameter(name="metadata", isRequired=true, description="Series metadata", type=RestParameter.Type.STRING), @RestParameter(name="acl", description="A collection of roles with their possible action", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="theme", description="The theme ID to be applied to the series", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="A new series is created and its identifier is returned in the Location header.", responseCode=201), @RestResponse(description="The request is invalid or inconsistent..", responseCode=400), @RestResponse(description="The user doesn't have the rights to create the series.", responseCode=401)})
    public Response createNewSeries(@HeaderParam(value="Accept") String acceptHeader, @FormParam(value="metadata") String metadataParam, @FormParam(value="acl") String aclParam, @FormParam(value="theme") String themeIdParam) throws UnauthorizedException, NotFoundException {
        AccessControlList acl;
        MetadataList metadataList;
        if (StringUtils.isBlank((CharSequence)metadataParam)) {
            return RestUtil.R.badRequest((String)"Required parameter 'metadata' is missing or invalid");
        }
        if (StringUtils.isBlank((CharSequence)aclParam)) {
            return RestUtil.R.badRequest((String)"Required parameter 'acl' is missing or invalid");
        }
        try {
            metadataList = this.deserializeMetadataList(metadataParam);
        }
        catch (ParseException e) {
            logger.debug("Unable to parse series metadata '{}'", (Object)metadataParam, (Object)e);
            return RestUtil.R.badRequest((String)String.format("Unable to parse metadata because '%s'", e.getMessage()));
        }
        catch (NotFoundException e) {
            return RestUtil.R.badRequest((String)e.getMessage());
        }
        catch (IllegalArgumentException e) {
            logger.debug("Unable to create series with metadata '{}'", (Object)metadataParam, (Object)e);
            return RestUtil.R.badRequest((String)e.getMessage());
        }
        TreeMap options = new TreeMap();
        Opt optThemeId = Opt.none();
        if (StringUtils.trimToNull((String)themeIdParam) != null) {
            try {
                Long themeId = Long.parseLong(themeIdParam);
                optThemeId = Opt.some((Object)themeId);
            }
            catch (NumberFormatException e) {
                return RestUtil.R.badRequest((String)String.format("Unable to parse the theme id '%s' into a number", themeIdParam));
            }
        }
        try {
            acl = AclUtils.deserializeJsonToAcl(aclParam, false);
        }
        catch (ParseException e) {
            logger.debug("Unable to parse acl '{}'", (Object)aclParam, (Object)e);
            return RestUtil.R.badRequest((String)String.format("Unable to parse acl '%s' because '%s'", aclParam, e.getMessage()));
        }
        catch (IllegalArgumentException e) {
            logger.debug("Unable to create new series with acl '{}'", (Object)aclParam, (Object)e);
            return RestUtil.R.badRequest((String)e.getMessage());
        }
        try {
            String seriesId = this.indexService.createSeries(metadataList, options, Opt.some((Object)acl), optThemeId);
            return ApiResponses.Json.created(acceptHeader, URI.create(this.getSeriesUrl(seriesId)), (JValue)Jsons.obj((Field[])new Field[]{Jsons.f((String)"identifier", (JValue)Jsons.v((Object)seriesId, (JValue)Jsons.BLANK))}));
        }
        catch (IndexServiceException e) {
            logger.error("Unable to create series with metadata '{}', acl '{}', theme '{}'", new Object[]{metadataParam, aclParam, themeIdParam, e});
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    protected MetadataList deserializeMetadataList(String json) throws ParseException, NotFoundException {
        MetadataList metadataList = new MetadataList();
        JSONParser parser = new JSONParser();
        JSONArray jsonCatalogs = (JSONArray)parser.parse(json);
        for (int i = 0; i < jsonCatalogs.size(); ++i) {
            JSONObject catalog = (JSONObject)jsonCatalogs.get(i);
            if (catalog.get((Object)"flavor") == null || StringUtils.isBlank((CharSequence)catalog.get((Object)"flavor").toString())) {
                throw new IllegalArgumentException("Unable to create new series as no flavor was given for one of the metadata collections");
            }
            String flavorString = catalog.get((Object)"flavor").toString();
            MediaPackageElementFlavor flavor = MediaPackageElementFlavor.parseFlavor((String)flavorString);
            DublinCoreMetadataCollection collection = null;
            SeriesCatalogUIAdapter adapter = null;
            for (SeriesCatalogUIAdapter seriesCatalogUIAdapter : this.indexService.getSeriesCatalogUIAdapters()) {
                MediaPackageElementFlavor catalogFlavor = MediaPackageElementFlavor.parseFlavor((String)seriesCatalogUIAdapter.getFlavor().toString());
                if (!catalogFlavor.equals((Object)flavor)) continue;
                adapter = seriesCatalogUIAdapter;
                collection = seriesCatalogUIAdapter.getRawFields();
            }
            if (collection == null) {
                throw new IllegalArgumentException(String.format("Unable to find an SeriesCatalogUIAdapter with Flavor '%s'", flavorString));
            }
            String fieldsJson = catalog.get((Object)"fields").toString();
            if (StringUtils.trimToNull((String)fieldsJson) != null) {
                Map fields = RequestUtils.getKeyValueMap((String)fieldsJson);
                for (String key : fields.keySet()) {
                    MetadataField field;
                    if ("subjects".equals(key)) {
                        field = (MetadataField)collection.getOutputFields().get("subject");
                        if (field == null) {
                            throw new NotFoundException(String.format("Cannot find a metadata field with id '%s' from Catalog with Flavor '%s'.", key, flavorString));
                        }
                        collection.removeField(field);
                        try {
                            JSONArray subjects = (JSONArray)parser.parse((String)fields.get(key));
                            collection.addField(MetadataJson.copyWithDifferentJsonValue((MetadataField)field, (String)StringUtils.join((Iterator)subjects.iterator(), (String)",")));
                            continue;
                        }
                        catch (ParseException e) {
                            throw new IllegalArgumentException(String.format("Unable to parse the 'subjects' metadata array field because: %s", e.toString()));
                        }
                    }
                    field = (MetadataField)collection.getOutputFields().get(key);
                    if (field == null) {
                        throw new NotFoundException(String.format("Cannot find a metadata field with id '%s' from Catalog with Flavor '%s'.", key, flavorString));
                    }
                    collection.removeField(field);
                    collection.addField(MetadataJson.copyWithDifferentJsonValue((MetadataField)field, (String)((String)fields.get(key))));
                }
            }
            metadataList.add(adapter, collection);
        }
        return metadataList;
    }

    @PUT
    @Path(value="{seriesId}/acl")
    @RestQuery(name="updateseriesacl", description="Updates a series' access policy.", returnDescription="", pathParameters={@RestParameter(name="seriesId", description="The series id", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="acl", isRequired=true, description="Access policy", type=RestParameter.Type.STRING), @RestParameter(name="override", isRequired=false, description="If true the series ACL will take precedence over any existing episode ACL", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The access control list for the specified series is updated.", responseCode=200), @RestResponse(description="The specified series does not exist.", responseCode=404)})
    public Response updateSeriesAcl(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="seriesId") String seriesID, @FormParam(value="acl") String aclJson, @DefaultValue(value="false") @FormParam(value="override") boolean override) throws NotFoundException, SeriesException, UnauthorizedException {
        JSONArray acl;
        if (StringUtils.isBlank((CharSequence)aclJson)) {
            return RestUtil.R.badRequest((String)"Missing form parameter 'acl'");
        }
        ApiVersion requestedVersion = ApiMediaType.parse(acceptHeader).getVersion();
        if (requestedVersion.isSmallerThan(ApiVersion.VERSION_1_2_0)) {
            override = false;
        }
        JSONParser parser = new JSONParser();
        try {
            acl = (JSONArray)parser.parse(aclJson);
        }
        catch (ParseException e) {
            logger.debug("Could not parse ACL ({})", (Object)aclJson, (Object)e);
            return RestUtil.R.badRequest((String)"Could not parse ACL");
        }
        List accessControlEntries = Stream.$((Object[])acl.toArray()).map((Fn)new Fn<Object, AccessControlEntry>(){

            public AccessControlEntry apply(Object a) {
                JSONObject ace = (JSONObject)a;
                return new AccessControlEntry((String)ace.get((Object)"role"), (String)ace.get((Object)"action"), ((Boolean)ace.get((Object)"allow")).booleanValue());
            }
        }).toList();
        this.seriesService.updateAccessControl(seriesID, new AccessControlList(accessControlEntries), override);
        return ApiResponses.Json.ok(acceptHeader, aclJson);
    }

    @PUT
    @Path(value="{seriesId}/properties")
    @RestQuery(name="updateseriesproperties", description="Updates a series' properties", returnDescription="", pathParameters={@RestParameter(name="seriesId", description="The series id", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="properties", isRequired=true, description="Series properties", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Successfully updated the series' properties.", responseCode=200), @RestResponse(description="The specified series does not exist.", responseCode=404)})
    public Response updateSeriesProperties(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="seriesId") String seriesID, @FormParam(value="properties") String propertiesJson) throws NotFoundException, SeriesException, UnauthorizedException {
        JSONObject props;
        if (StringUtils.isBlank((CharSequence)propertiesJson)) {
            return RestUtil.R.badRequest((String)"Missing form parameter 'acl'");
        }
        JSONParser parser = new JSONParser();
        try {
            props = (JSONObject)parser.parse(propertiesJson);
        }
        catch (ParseException e) {
            logger.debug("Could not parse properties ({})", (Object)propertiesJson, (Object)e);
            return RestUtil.R.badRequest((String)"Could not parse series properties");
        }
        for (Object prop : props.entrySet()) {
            Map.Entry field = (Map.Entry)prop;
            this.seriesService.updateSeriesProperty(seriesID, (String)field.getKey(), field.getValue().toString());
        }
        return ApiResponses.Json.ok(acceptHeader, propertiesJson);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="series.json")
    @RestQuery(name="listSeriesAsJson", description="Returns the series matching the query parameters", returnDescription="Returns the series search results as JSON", restParameters={@RestParameter(name="q", isRequired=false, description="Free text search", type=RestParameter.Type.STRING), @RestParameter(name="edit", isRequired=false, description="Whether this query should return only series that are editable", type=RestParameter.Type.BOOLEAN), @RestParameter(name="fuzzyMatch", isRequired=false, description="Whether a partial match on series id is allowed, default is false", type=RestParameter.Type.BOOLEAN), @RestParameter(name="seriesId", isRequired=false, description="The series identifier", type=RestParameter.Type.STRING), @RestParameter(name="seriesTitle", isRequired=false, description="The series title", type=RestParameter.Type.STRING), @RestParameter(name="creator", isRequired=false, description="The series creator", type=RestParameter.Type.STRING), @RestParameter(name="contributor", isRequired=false, description="The series contributor", type=RestParameter.Type.STRING), @RestParameter(name="publisher", isRequired=false, description="The series publisher", type=RestParameter.Type.STRING), @RestParameter(name="rightsholder", isRequired=false, description="The series rights holder", type=RestParameter.Type.STRING), @RestParameter(name="createdfrom", isRequired=false, description="Filter results by created from (yyyy-MM-dd'T'HH:mm:ss'Z')", type=RestParameter.Type.STRING), @RestParameter(name="createdto", isRequired=false, description="Filter results by created to (yyyy-MM-dd'T'HH:mm:ss'Z')", type=RestParameter.Type.STRING), @RestParameter(name="language", isRequired=false, description="The series language", type=RestParameter.Type.STRING), @RestParameter(name="license", isRequired=false, description="The series license", type=RestParameter.Type.STRING), @RestParameter(name="subject", isRequired=false, description="The series subject", type=RestParameter.Type.STRING), @RestParameter(name="description", isRequired=false, description="The series description", type=RestParameter.Type.STRING), @RestParameter(name="sort", isRequired=false, description="The sort order. May include any of the following: TITLE, SUBJECT, CREATOR, PUBLISHERS, CONTRIBUTORS, DESCRIPTION, CREATED_DATE_TIME, LANGUAGE, RIGHTS_HOLDER, MANAGED_ACL, LICENCE. Add '_DESC' to reverse the sort order (e.g. TITLE_DESC).", type=RestParameter.Type.STRING), @RestParameter(name="offset", isRequired=false, description="The offset", type=RestParameter.Type.STRING), @RestParameter(name="count", isRequired=false, description="Results per page (max 100)", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The access control list."), @RestResponse(responseCode=401, description="If the current user is not authorized to perform this action")})
    public Response getSeriesAsJson(@QueryParam(value="q") String text, @QueryParam(value="seriesId") String seriesId, @QueryParam(value="edit") Boolean edit, @QueryParam(value="fuzzyMatch") Boolean fuzzyMatch, @QueryParam(value="seriesTitle") String seriesTitle, @QueryParam(value="creator") String creator, @QueryParam(value="contributor") String contributor, @QueryParam(value="publisher") String publisher, @QueryParam(value="rightsholder") String rightsHolder, @QueryParam(value="createdfrom") String createdFrom, @QueryParam(value="createdto") String createdTo, @QueryParam(value="language") String language, @QueryParam(value="license") String license, @QueryParam(value="subject") String subject, @QueryParam(value="description") String description, @QueryParam(value="sort") String sort, @QueryParam(value="offset") String offset, @QueryParam(value="count") String count) throws UnauthorizedException {
        try {
            SearchResult<Series> items = this.getSeries(text, seriesId, edit, seriesTitle, creator, contributor, publisher, rightsHolder, createdFrom, createdTo, language, license, subject, description, sort, offset, count, fuzzyMatch);
            return this.queryResultToJson(items, false, ApiVersion.VERSION_1_7_0);
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("Could not perform search query: {}", (Object)e.getMessage());
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private SearchResult<Series> getSeries(String text, String seriesId, Boolean edit, String seriesTitle, String creator, String contributor, String publisher, String rightsHolder, String createdFrom, String createdTo, String language, String license, String subject, String description, String sort, String offsetString, String countString, Boolean fuzzyMatch) throws SeriesException, UnauthorizedException {
        int offset = 0;
        if (StringUtils.isNotEmpty((CharSequence)offsetString)) {
            try {
                offset = Integer.parseInt(offsetString);
            }
            catch (NumberFormatException e) {
                logger.warn("Bad start page parameter");
            }
            if (offset < 0) {
                offset = 0;
            }
        }
        int count = 100;
        if (StringUtils.isNotEmpty((CharSequence)countString)) {
            try {
                count = Integer.parseInt(countString);
            }
            catch (NumberFormatException e) {
                logger.warn("Bad count parameter");
            }
            if (count < 1) {
                count = 100;
            }
        }
        SeriesSearchQuery q = new SeriesSearchQuery(this.securityService.getOrganization().getId(), this.securityService.getUser());
        q.withLimit(count);
        q.withOffset(offset);
        if (edit != null) {
            q.withEdit(edit);
        }
        if (StringUtils.isNotEmpty((CharSequence)text)) {
            q.withText(fuzzyMatch.booleanValue(), QueryPreprocessor.sanitize((String)text));
        }
        if (StringUtils.isNotEmpty((CharSequence)seriesId)) {
            q.withIdentifier(seriesId);
        }
        if (StringUtils.isNotEmpty((CharSequence)seriesTitle)) {
            q.withTitle(seriesTitle);
        }
        if (StringUtils.isNotEmpty((CharSequence)creator)) {
            q.withCreator(creator);
        }
        if (StringUtils.isNotEmpty((CharSequence)contributor)) {
            q.withContributor(contributor);
        }
        if (StringUtils.isNotEmpty((CharSequence)language)) {
            q.withLanguage(language);
        }
        if (StringUtils.isNotEmpty((CharSequence)license)) {
            q.withLicense(license);
        }
        if (StringUtils.isNotEmpty((CharSequence)subject)) {
            q.withSubject(subject);
        }
        if (StringUtils.isNotEmpty((CharSequence)publisher)) {
            q.withPublisher(publisher);
        }
        if (StringUtils.isNotEmpty((CharSequence)description)) {
            q.withDescription(description);
        }
        if (StringUtils.isNotEmpty((CharSequence)rightsHolder)) {
            q.withRightsHolder(rightsHolder);
        }
        try {
            Date date;
            SimpleDateFormat formatter;
            if (StringUtils.isNotEmpty((CharSequence)createdFrom)) {
                formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH);
                date = formatter.parse(createdFrom);
                q.withCreatedFrom(date);
            }
            if (StringUtils.isNotEmpty((CharSequence)createdTo)) {
                formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH);
                date = formatter.parse(createdTo);
                q.withCreatedFrom(date);
            }
        }
        catch (java.text.ParseException e1) {
            logger.warn("Could not parse date parameter: {}", (Throwable)e1);
        }
        if (StringUtils.isNotBlank((CharSequence)sort)) {
            SortCriterion.Order order;
            String enumKey;
            if (sort.endsWith("_DESC")) {
                enumKey = sort.substring(0, sort.length() - "_DESC".length()).toUpperCase();
                order = SortCriterion.Order.Descending;
            } else {
                enumKey = sort;
                order = SortCriterion.Order.Ascending;
            }
            try {
                switch (enumKey) {
                    case "title": {
                        q.sortByTitle(order);
                        break;
                    }
                    case "subject": {
                        q.sortBySubject(order);
                        break;
                    }
                    case "creator": {
                        q.sortByCreator(order);
                        break;
                    }
                    case "publisher": {
                        q.sortByPublishers(order);
                        break;
                    }
                    case "contributors": {
                        q.sortByContributors(order);
                        break;
                    }
                    case "description": {
                        q.sortByDescription(order);
                        break;
                    }
                    case "language": {
                        q.sortByLanguage(order);
                        break;
                    }
                    case "rights_holder": {
                        q.sortByRightsHolder(order);
                        break;
                    }
                    case "license": {
                        q.sortByLicense(order);
                        break;
                    }
                    case "createdDateTime": {
                        q.sortByCreatedDateTime(order);
                        break;
                    }
                    case "managed_acl": {
                        q.sortByManagedAcl(order);
                        break;
                    }
                    default: {
                        logger.info("Unknown filter criteria {}", (Object)enumKey);
                        throw new IllegalArgumentException("Unknown filter criteria " + enumKey);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                logger.warn("No sort enum matches '{}'", (Object)enumKey);
            }
        }
        try {
            return this.elasticsearchIndex.getByQuery(q);
        }
        catch (SearchIndexException e) {
            logger.error("Failed to execute search query: {}", (Object)e.getMessage());
            throw new SeriesException((Throwable)e);
        }
    }

    private Tuple<Date, Date> getFromAndToCreationRange(String createdFrom, String createdTo) {
        Date createdFromDate = null;
        Date createdToDate = null;
        if (StringUtils.isNotBlank((CharSequence)createdFrom) && StringUtils.isBlank((CharSequence)createdTo) || StringUtils.isBlank((CharSequence)createdFrom) && StringUtils.isNotBlank((CharSequence)createdTo)) {
            logger.error("Both createdTo '{}' and createdFrom '{}' have to be specified or neither of them", (Object)createdTo, (Object)createdFrom);
            throw new IllegalArgumentException("Both createdTo '" + createdTo + "' and createdFrom '" + createdFrom + "' have to be specified or neither of them");
        }
        if (StringUtils.isNotBlank((CharSequence)createdFrom)) {
            try {
                createdFromDate = new Date(DateTimeSupport.fromUTC((String)createdFrom));
            }
            catch (IllegalStateException e) {
                logger.error("Unable to parse createdFrom parameter '{}'", (Object)createdFrom, (Object)e);
                throw new IllegalArgumentException("Unable to parse createdFrom parameter.");
            }
            catch (java.text.ParseException e) {
                logger.error("Unable to parse createdFrom parameter '{}'", (Object)createdFrom, (Object)e);
                throw new IllegalArgumentException("Unable to parse createdFrom parameter.");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)createdTo)) {
            try {
                createdToDate = new Date(DateTimeSupport.fromUTC((String)createdTo));
            }
            catch (IllegalStateException e) {
                logger.error("Unable to parse createdTo parameter '{}'", (Object)createdTo, (Object)e);
                throw new IllegalArgumentException("Unable to parse createdTo parameter.");
            }
            catch (java.text.ParseException e) {
                logger.error("Unable to parse createdTo parameter '{}'", (Object)createdTo, (Object)e);
                throw new IllegalArgumentException("Unable to parse createdTo parameter.");
            }
        }
        return new Tuple((Object)createdFromDate, createdToDate);
    }

    private String getSeriesUrl(String seriesId) {
        return UrlSupport.concat((String)this.endpointBaseUrl, (String)seriesId);
    }
}

