/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.external.endpoint;

import com.entwinemedia.fn.data.json.Field;
import com.entwinemedia.fn.data.json.JValue;
import com.entwinemedia.fn.data.json.Jsons;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.parser.ParseException;
import org.opencastproject.external.common.ApiResponses;
import org.opencastproject.external.endpoint.ListProviderEndpoint;
import org.opencastproject.playlists.Playlist;
import org.opencastproject.playlists.PlaylistAccessControlEntry;
import org.opencastproject.playlists.PlaylistEntry;
import org.opencastproject.playlists.PlaylistRestService;
import org.opencastproject.playlists.PlaylistService;
import org.opencastproject.playlists.serialization.JaxbPlaylist;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.util.DateTimeSupport;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.RestUtil;
import org.opencastproject.util.UrlSupport;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.opencastproject.util.requests.SortCriterion;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@Produces(value={"application/json", "application/v1.11.0+json"})
@RestService(name="externalapiplaylists", title="External API Playlists Service", notes={}, abstractText="Provides access to playlist structures")
@Component(immediate=true, service={PlaylistsEndpoint.class}, property={"service.description=External API - Playlists Endpoint", "opencast.service.type=org.opencastproject.external.playlists", "opencast.service.path=/api/playlists"})
public class PlaylistsEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(ListProviderEndpoint.class);
    protected String endpointBaseUrl;
    private PlaylistService service;
    private PlaylistRestService restService;

    @Reference
    public void setPlaylistService(PlaylistService playlistService) {
        this.service = playlistService;
    }

    @Reference
    public void setPlaylistRestService(PlaylistRestService playlistRestService) {
        this.restService = playlistRestService;
    }

    @Activate
    void activate(ComponentContext cc) {
        logger.info("Activating External API - Playlists Endpoint");
        Tuple endpointUrl = RestUtil.getEndpointUrl((ComponentContext)cc, (String)"org.opencastproject.external.api.url", (String)"opencast.service.path");
        this.endpointBaseUrl = UrlSupport.concat((String)((String)endpointUrl.getA()), (String)((String)endpointUrl.getB()));
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json", "application/v1.11.0+json"})
    @RestQuery(name="playlist", description="Get a playlist.", returnDescription="A playlist as JSON", pathParameters={@RestParameter(name="id", isRequired=true, description="The playlist identifier", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns the playlist.", responseCode=200), @RestResponse(description="The specified playlist instance does not exist.", responseCode=404), @RestResponse(description="The user doesn't have the rights to make this request.", responseCode=403), @RestResponse(description="The request is invalid or inconsistent.", responseCode=400)})
    public Response getPlaylistAsJson(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="id") String id) {
        try {
            Playlist playlist = this.service.getPlaylistById(id);
            return ApiResponses.Json.ok(acceptHeader, this.playlistToJson(playlist));
        }
        catch (NotFoundException e) {
            return ApiResponses.notFound("Cannot find playlist instance with id '%s'.", id);
        }
        catch (UnauthorizedException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        catch (IllegalStateException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @GET
    @Produces(value={"application/json", "application/v1.11.0+json"})
    @Path(value="")
    @RestQuery(name="playlists", description="Get playlists. Playlists that you do not have read access to will not show up.", returnDescription="A JSON object containing an array.", restParameters={@RestParameter(name="limit", isRequired=false, type=RestParameter.Type.INTEGER, description="The maximum number of results to return for a single request.", defaultValue="100"), @RestParameter(name="offset", isRequired=false, type=RestParameter.Type.INTEGER, description="The index of the first result to return."), @RestParameter(name="sort", isRequired=false, type=RestParameter.Type.STRING, description="Sort the results based upon a sorting criteria. A criteria is specified as a pair such as:<Sort Name>:ASC or <Sort Name>:DESC. Adding the suffix ASC or DESC sets the order as ascending ordescending order and is mandatory. Sort Name is case sensitive. Supported Sort Names are 'updated'", defaultValue="updated:ASC")}, responses={@RestResponse(description="Returns the playlist.", responseCode=200), @RestResponse(description="The request is invalid or inconsistent.", responseCode=400)})
    public Response getPlaylistsAsJson(@HeaderParam(value="Accept") String acceptHeader, @QueryParam(value="limit") int limit, @QueryParam(value="offset") int offset, @QueryParam(value="sort") String sort) {
        if (offset < 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (limit < 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        SortCriterion sortCriterion = new SortCriterion("", SortCriterion.Order.None);
        Option optSort = Option.option((Object)StringUtils.trimToNull((String)sort));
        if (optSort.isSome()) {
            sortCriterion = SortCriterion.parse((String)((String)optSort.get()));
            switch (sortCriterion.getFieldName()) {
                case "updated": {
                    break;
                }
                default: {
                    logger.info("Unknown sort criteria {}", (Object)sortCriterion.getFieldName());
                    return Response.serverError().status(Response.Status.BAD_REQUEST).build();
                }
            }
        }
        List playlists = this.service.getPlaylists(limit, offset, sortCriterion);
        List playlistsJson = playlists.stream().map(p -> this.playlistToJson((Playlist)p)).collect(Collectors.toList());
        return ApiResponses.Json.ok(acceptHeader, (JValue)Jsons.arr(playlistsJson));
    }

    @POST
    @Produces(value={"application/json", "application/v1.11.0+json"})
    @Path(value="")
    @RestQuery(name="create", description="Creates a playlist.", returnDescription="The created playlist.", restParameters={@RestParameter(name="playlist", isRequired=false, description="Playlist in JSON format", type=RestParameter.Type.TEXT, jaxbClass=JaxbPlaylist.class, defaultValue="{\n        \"title\": \"Opencast Playlist\",\n        \"description\": \"This is a playlist about Opencast\",\n        \"creator\": \"Opencast\",\n        \"entries\": [\n            {\n                \"contentId\": \"ID-about-opencast\",\n                \"type\": \"EVENT\"\n            },\n            {\n                \"contentId\": \"ID-3d-print\",\n                \"type\": \"EVENT\"\n            }\n        ],\n        \"accessControlEntries\": [\n            {\n                \"allow\": true,\n                \"role\": \"ROLE_USER_BOB\",\n                \"action\": \"read\"\n            }\n        ]\n}")}, responses={@RestResponse(description="Playlist created.", responseCode=201), @RestResponse(description="The user doesn't have the rights to make this request.", responseCode=403), @RestResponse(description="The request is invalid or inconsistent.", responseCode=400)})
    public Response createAsJson(@HeaderParam(value="Accept") String acceptHeader, @FormParam(value="playlist") String playlistText) {
        try {
            Playlist playlist = this.restService.parseJsonToPlaylist(playlistText);
            playlist = this.service.update(playlist);
            return ApiResponses.Json.created(acceptHeader, URI.create(this.getPlaylistUrl(playlist.getId())), this.playlistToJson(playlist));
        }
        catch (UnauthorizedException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        catch (IOException | IllegalArgumentException | ParseException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @PUT
    @Produces(value={"application/json", "application/v1.11.0+json"})
    @Path(value="{id}")
    @RestQuery(name="update", description="Updates a playlist.", returnDescription="The updated playlist.", pathParameters={@RestParameter(name="id", isRequired=true, description="Playlist identifier", type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="playlist", isRequired=false, description="Playlist in JSON format", type=RestParameter.Type.TEXT, jaxbClass=JaxbPlaylist.class, defaultValue="{\n        \"title\": \"Opencast Playlist\",\n        \"description\": \"This is a playlist about Opencast\",\n        \"creator\": \"Opencast\",\n        \"entries\": [\n            {\n                \"contentId\": \"ID-about-opencast\",\n                \"type\": \"EVENT\"\n            },\n            {\n                \"contentId\": \"ID-3d-print\",\n                \"type\": \"EVENT\"\n            }\n        ],\n        \"accessControlEntries\": [\n            {\n                \"allow\": true,\n                \"role\": \"ROLE_USER_BOB\",\n                \"action\": \"read\"\n            }\n        ]\n}")}, responses={@RestResponse(description="Playlist updated.", responseCode=200), @RestResponse(description="The user doesn't have the rights to make this request.", responseCode=403), @RestResponse(description="The request is invalid or inconsistent.", responseCode=400)})
    public Response updateAsJson(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="id") String id, @FormParam(value="playlist") String playlistText) {
        try {
            Playlist playlist = this.service.updateWithJson(id, playlistText);
            return ApiResponses.Json.ok(acceptHeader, this.playlistToJson(playlist));
        }
        catch (UnauthorizedException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        catch (IOException | IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @DELETE
    @Produces(value={"application/json", "application/v1.11.0+json"})
    @Path(value="{id}")
    @RestQuery(name="remove", description="Removes a playlist.", returnDescription="The removed playlist.", pathParameters={@RestParameter(name="id", isRequired=true, description="Playlist identifier", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="Playlist removed."), @RestResponse(responseCode=404, description="No playlist with that identifier exists."), @RestResponse(responseCode=401, description="Not authorized to perform this action")})
    public Response remove(@HeaderParam(value="Accept") String acceptHeader, @PathParam(value="id") String id) {
        try {
            Playlist playlist = this.service.remove(id);
            return ApiResponses.Json.ok(acceptHeader, this.playlistToJson(playlist));
        }
        catch (NotFoundException e) {
            return ApiResponses.notFound("Cannot find playlist instance with id '%s'.", id);
        }
        catch (UnauthorizedException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
    }

    private JValue playlistToJson(Playlist playlist) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(Jsons.f((String)"id", (JValue)Jsons.v((String)playlist.getId())));
        fields.add(Jsons.f((String)"entries", (JValue)Jsons.arr((Iterable)playlist.getEntries().stream().map(this::playlistEntryToJson).collect(Collectors.toList()))));
        fields.add(Jsons.f((String)"title", (JValue)Jsons.v((Object)playlist.getTitle(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"description", (JValue)Jsons.v((Object)playlist.getDescription(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"creator", (JValue)Jsons.v((Object)playlist.getCreator(), (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"updated", (JValue)Jsons.v(playlist.getUpdated() != null ? DateTimeSupport.toUTC((long)playlist.getUpdated().getTime()) : null, (JValue)Jsons.BLANK)));
        fields.add(Jsons.f((String)"accessControlEntries", (JValue)Jsons.arr((Iterable)playlist.getAccessControlEntries().stream().map(this::playlistAccessControlEntryToJson).collect(Collectors.toList()))));
        return Jsons.obj(fields);
    }

    private JValue playlistEntryToJson(PlaylistEntry playlistEntry) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(Jsons.f((String)"id", (JValue)Jsons.v((Number)playlistEntry.getId())));
        fields.add(Jsons.f((String)"contentId", (JValue)Jsons.v((Object)playlistEntry.getContentId(), (JValue)Jsons.NULL)));
        fields.add(Jsons.f((String)"type", (JValue)this.enumToJSON((Enum)playlistEntry.getType())));
        return Jsons.obj(fields);
    }

    private JValue playlistAccessControlEntryToJson(PlaylistAccessControlEntry playlistAccessControlEntry) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(Jsons.f((String)"id", (JValue)Jsons.v((Number)playlistAccessControlEntry.getId())));
        fields.add(Jsons.f((String)"allow", (JValue)Jsons.v((Boolean)playlistAccessControlEntry.isAllow())));
        fields.add(Jsons.f((String)"role", (JValue)Jsons.v((String)playlistAccessControlEntry.getRole())));
        fields.add(Jsons.f((String)"action", (JValue)Jsons.v((String)playlistAccessControlEntry.getAction())));
        return Jsons.obj(fields);
    }

    private JValue enumToJSON(Enum e) {
        return e == null ? null : Jsons.v((String)e.toString());
    }

    private String getPlaylistUrl(String playlistId) {
        return UrlSupport.concat((String)this.endpointBaseUrl, (String)playlistId);
    }
}

