/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.external.endpoint;

import com.entwinemedia.fn.data.json.Field;
import com.entwinemedia.fn.data.json.JObject;
import com.entwinemedia.fn.data.json.JString;
import com.entwinemedia.fn.data.json.JValue;
import com.entwinemedia.fn.data.json.Jsons;
import com.entwinemedia.fn.data.json.SimpleSerializer;
import java.util.ArrayList;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.external.common.ApiVersion;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.User;
import org.opencastproject.userdirectory.UserIdRoleProvider;
import org.opencastproject.util.RestUtil;
import org.opencastproject.util.UrlSupport;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@Produces(value={"application/json", "application/v1.0.0+json", "application/v1.1.0+json", "application/v1.2.0+json", "application/v1.3.0+json", "application/v1.4.0+json", "application/v1.5.0+json", "application/v1.6.0+json", "application/v1.7.0+json", "application/v1.8.0+json", "application/v1.9.0+json", "application/v1.10.0+json", "application/v1.11.0+json"})
@RestService(name="externalapiservice", title="External API Service", notes={}, abstractText="Provides a location for external apis to query the current server of the API.")
@Component(immediate=true, service={BaseEndpoint.class}, property={"service.description=External API - Base Endpoint", "opencast.service.type=org.opencastproject.external", "opencast.service.path=/api"})
public class BaseEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(BaseEndpoint.class);
    private static final SimpleSerializer serializer = new SimpleSerializer();
    protected String endpointBaseUrl;
    private SecurityService securityService;

    @Reference
    void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Activate
    void activate(ComponentContext cc) {
        logger.info("Activating External API - Base Endpoint");
        Tuple endpointUrl = RestUtil.getEndpointUrl((ComponentContext)cc, (String)"org.opencastproject.external.api.url", (String)"opencast.service.path");
        this.endpointBaseUrl = UrlSupport.concat((String)((String)endpointUrl.getA()), (String)((String)endpointUrl.getB()));
        logger.debug("Configured service endpoint is {}", (Object)this.endpointBaseUrl);
    }

    @GET
    @Path(value="")
    @RestQuery(name="getendpointinfo", description="Returns key characteristics of the API such as the server name and the default version.", returnDescription="", responses={@RestResponse(description="The api information is returned.", responseCode=200)})
    public Response getEndpointInfo() {
        Organization organization = this.securityService.getOrganization();
        String orgExternalAPIUrl = (String)organization.getProperties().get("org.opencastproject.external.api.url");
        JString url = StringUtils.isNotBlank((CharSequence)orgExternalAPIUrl) ? Jsons.v((String)orgExternalAPIUrl) : Jsons.v((String)this.endpointBaseUrl);
        JObject json = Jsons.obj((Field[])new Field[]{Jsons.f((String)"url", (JValue)url), Jsons.f((String)"version", (JValue)Jsons.v((String)ApiVersion.CURRENT_VERSION.toString()))});
        return RestUtil.R.ok((MediaType)MediaType.APPLICATION_JSON_TYPE, (Object)serializer.toJson((JValue)json));
    }

    @GET
    @Path(value="info/me")
    @RestQuery(name="getuserinfo", description="Returns information on the logged in user.", returnDescription="", responses={@RestResponse(description="The user information is returned.", responseCode=200)})
    public Response getUserInfo() {
        User user = this.securityService.getUser();
        JObject json = Jsons.obj((Field[])new Field[]{Jsons.f((String)"email", (JValue)Jsons.v((Object)user.getEmail(), (JValue)Jsons.BLANK)), Jsons.f((String)"name", (JValue)Jsons.v((String)user.getName())), Jsons.f((String)"provider", (JValue)Jsons.v((String)user.getProvider())), Jsons.f((String)"userrole", (JValue)Jsons.v((String)UserIdRoleProvider.getUserIdRole((String)user.getUsername()))), Jsons.f((String)"username", (JValue)Jsons.v((String)user.getUsername()))});
        return RestUtil.R.ok((MediaType)MediaType.APPLICATION_JSON_TYPE, (Object)serializer.toJson((JValue)json));
    }

    @GET
    @Path(value="info/me/roles")
    @RestQuery(name="getuserroles", description="Returns current user's roles.", returnDescription="", responses={@RestResponse(description="The set of roles is returned.", responseCode=200)})
    public Response getUserRoles() {
        User user = this.securityService.getUser();
        ArrayList<JString> roles = new ArrayList<JString>();
        for (Role role : user.getRoles()) {
            roles.add(Jsons.v((String)role.getName()));
        }
        return RestUtil.R.ok((MediaType)MediaType.APPLICATION_JSON_TYPE, (Object)serializer.toJson((JValue)Jsons.arr(roles)));
    }

    @GET
    @Path(value="info/organization")
    @RestQuery(name="getorganizationinfo", description="Returns the current organization.", returnDescription="", responses={@RestResponse(description="The organization details are returned.", responseCode=200)})
    public Response getOrganizationInfo() {
        Organization org = this.securityService.getOrganization();
        JObject json = Jsons.obj((Field[])new Field[]{Jsons.f((String)"adminRole", (JValue)Jsons.v((String)org.getAdminRole())), Jsons.f((String)"anonymousRole", (JValue)Jsons.v((String)org.getAnonymousRole())), Jsons.f((String)"id", (JValue)Jsons.v((String)org.getId())), Jsons.f((String)"name", (JValue)Jsons.v((String)org.getName()))});
        return RestUtil.R.ok((MediaType)MediaType.APPLICATION_JSON_TYPE, (Object)serializer.toJson((JValue)json));
    }

    @GET
    @Path(value="info/organization/properties")
    @RestQuery(name="getorganizationproperties", description="Returns the current organization's properties.", returnDescription="", responses={@RestResponse(description="The organization properties are returned.", responseCode=200)})
    public Response getOrganizationProperties() {
        Organization org = this.securityService.getOrganization();
        ArrayList<Field> props = new ArrayList<Field>();
        for (Map.Entry prop : org.getProperties().entrySet()) {
            props.add(Jsons.f((String)((String)prop.getKey()), (JValue)Jsons.v(prop.getValue(), (JValue)Jsons.BLANK)));
        }
        return RestUtil.R.ok((MediaType)MediaType.APPLICATION_JSON_TYPE, (Object)serializer.toJson((JValue)Jsons.obj(props)));
    }

    @GET
    @Path(value="info/organization/properties/engageuiurl")
    @RestQuery(name="getorganizationpropertiesengageuiurl", description="Returns the engage ui url property.", returnDescription="", responses={@RestResponse(description="The engage ui url is returned.", responseCode=200)})
    public Response getOrganizationPropertiesEngageUiUrl() {
        Organization org = this.securityService.getOrganization();
        ArrayList<Field> props = new ArrayList<Field>();
        for (Map.Entry prop : org.getProperties().entrySet()) {
            if (!((String)prop.getKey()).equals("org.opencastproject.engage.ui.url")) continue;
            props.add(Jsons.f((String)((String)prop.getKey()), (JValue)Jsons.v(prop.getValue(), (JValue)Jsons.BLANK)));
            break;
        }
        if (props.size() == 0) {
            props.add(Jsons.f((String)"org.opencastproject.engage.ui.url", (JValue)Jsons.v((Object)"http://localhost:8080", (JValue)Jsons.BLANK)));
        }
        return RestUtil.R.ok((MediaType)MediaType.APPLICATION_JSON_TYPE, (Object)serializer.toJson((JValue)Jsons.obj(props)));
    }

    @GET
    @Path(value="version")
    @RestQuery(name="getversion", description="Returns a list of available version as well as the default version.", returnDescription="", responses={@RestResponse(description="The default version is returned.", responseCode=200)})
    public Response getVersion() throws Exception {
        ArrayList<JString> versions = new ArrayList<JString>();
        versions.add(Jsons.v((String)ApiVersion.VERSION_1_0_0.toString()));
        versions.add(Jsons.v((String)ApiVersion.VERSION_1_1_0.toString()));
        versions.add(Jsons.v((String)ApiVersion.VERSION_1_2_0.toString()));
        versions.add(Jsons.v((String)ApiVersion.VERSION_1_3_0.toString()));
        versions.add(Jsons.v((String)ApiVersion.VERSION_1_4_0.toString()));
        versions.add(Jsons.v((String)ApiVersion.VERSION_1_5_0.toString()));
        versions.add(Jsons.v((String)ApiVersion.VERSION_1_6_0.toString()));
        versions.add(Jsons.v((String)ApiVersion.VERSION_1_7_0.toString()));
        versions.add(Jsons.v((String)ApiVersion.VERSION_1_8_0.toString()));
        versions.add(Jsons.v((String)ApiVersion.VERSION_1_9_0.toString()));
        versions.add(Jsons.v((String)ApiVersion.VERSION_1_10_0.toString()));
        versions.add(Jsons.v((String)ApiVersion.VERSION_1_11_0.toString()));
        JObject json = Jsons.obj((Field[])new Field[]{Jsons.f((String)"versions", (JValue)Jsons.arr(versions)), Jsons.f((String)"default", (JValue)Jsons.v((String)ApiVersion.CURRENT_VERSION.toString()))});
        return RestUtil.R.ok((MediaType)MediaType.APPLICATION_JSON_TYPE, (Object)serializer.toJson((JValue)json));
    }

    @GET
    @Path(value="version/default")
    @RestQuery(name="getversiondefault", description="Returns the default version.", returnDescription="", responses={@RestResponse(description="The default version is returned.", responseCode=200)})
    public Response getVersionDefault() throws Exception {
        JObject json = Jsons.obj((Field[])new Field[]{Jsons.f((String)"default", (JValue)Jsons.v((String)ApiVersion.CURRENT_VERSION.toString()))});
        return RestUtil.R.ok((MediaType)MediaType.APPLICATION_JSON_TYPE, (Object)serializer.toJson((JValue)json));
    }
}

