/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.execute.remote;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.opencastproject.execute.api.ExecuteException;
import org.opencastproject.execute.api.ExecuteService;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobParser;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.security.api.TrustedHttpClient;
import org.opencastproject.serviceregistry.api.RemoteBase;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ExecuteService.class}, property={"service.description=Execute Service Remote Service Proxy"})
public class ExecuteServiceRemoteImpl
extends RemoteBase
implements ExecuteService {
    private static final Logger logger = LoggerFactory.getLogger(ExecuteServiceRemoteImpl.class);

    public ExecuteServiceRemoteImpl() {
        super("org.opencastproject.execute");
    }

    public Job execute(String exec, String params, MediaPackageElement inElement, String outFileName, MediaPackageElement.Type type, float load) throws ExecuteException {
        HttpResponse response;
        block9: {
            HttpPost post = null;
            response = null;
            String inElementStr = MediaPackageElementParser.getAsXml((MediaPackageElement)inElement);
            ArrayList<BasicNameValuePair> formStringParams = new ArrayList<BasicNameValuePair>();
            formStringParams.add(new BasicNameValuePair("exec", exec));
            formStringParams.add(new BasicNameValuePair("params", params));
            formStringParams.add(new BasicNameValuePair("load", String.valueOf(load)));
            formStringParams.add(new BasicNameValuePair("inputElement", inElementStr));
            if (outFileName != null) {
                formStringParams.add(new BasicNameValuePair("outputFilename", outFileName));
            }
            if (type != null) {
                formStringParams.add(new BasicNameValuePair("expectedType", type.toString()));
            }
            logger.info("Executing command {} using a remote execute service", (Object)exec);
            post = new HttpPost("/execute");
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(formStringParams, "UTF-8"));
            response = this.getResponse((HttpRequestBase)post);
            if (response == null) break block9;
            Job job = JobParser.parseJob((InputStream)response.getEntity().getContent());
            logger.info("Completing execution of command {} using a remote execute service", (Object)exec);
            Job job2 = job;
            this.closeConnection(response);
            return job2;
        }
        try {
            try {
                throw new ExecuteException(String.format("Failed to execute the command %s using a remote execute service", exec));
            }
            catch (MediaPackageException e) {
                throw new ExecuteException("Error serializing the MediaPackage element", (Throwable)e);
            }
            catch (IllegalStateException e) {
                throw new ExecuteException((Throwable)e);
            }
            catch (IOException e) {
                throw new ExecuteException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            this.closeConnection(response);
            throw throwable;
        }
    }

    public Job execute(String exec, String params, MediaPackage mp, String outFileName, MediaPackageElement.Type type, float load) throws ExecuteException {
        HttpResponse response;
        block8: {
            HttpPost post = null;
            response = null;
            String mpStr = MediaPackageParser.getAsXml((MediaPackage)mp);
            ArrayList<BasicNameValuePair> formStringParams = new ArrayList<BasicNameValuePair>();
            formStringParams.add(new BasicNameValuePair("exec", exec));
            formStringParams.add(new BasicNameValuePair("params", params));
            formStringParams.add(new BasicNameValuePair("load", String.valueOf(load)));
            formStringParams.add(new BasicNameValuePair("inputMediaPackage", mpStr));
            if (outFileName != null) {
                formStringParams.add(new BasicNameValuePair("outputFilename", outFileName));
            }
            if (type != null) {
                formStringParams.add(new BasicNameValuePair("expectedType", type.toString()));
            }
            logger.info("Executing command {} using a remote execute service", (Object)exec);
            post = new HttpPost("/execute");
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(formStringParams, "UTF-8"));
            response = this.getResponse((HttpRequestBase)post);
            if (response == null) break block8;
            Job job = JobParser.parseJob((InputStream)response.getEntity().getContent());
            logger.info("Completing execution of command {} using a remote execute service", (Object)exec);
            Job job2 = job;
            this.closeConnection(response);
            return job2;
        }
        try {
            try {
                logger.error("Failed to execute the command {} using a remote execute service", (Object)exec);
                throw new ExecuteException(String.format("Failed to execute the command %s using a remote execute service", exec));
            }
            catch (IllegalStateException e) {
                throw new ExecuteException((Throwable)e);
            }
            catch (IOException e) {
                throw new ExecuteException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            this.closeConnection(response);
            throw throwable;
        }
    }

    @Reference
    public void setTrustedHttpClient(TrustedHttpClient trustedHttpClient) {
        super.setTrustedHttpClient(trustedHttpClient);
    }

    @Reference
    public void setRemoteServiceManager(ServiceRegistry serviceRegistry) {
        super.setRemoteServiceManager(serviceRegistry);
    }
}

