/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.distribution;

import java.util.HashSet;
import java.util.List;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.publication.api.OaiPmhPublicationService;
import org.opencastproject.publication.api.PublicationException;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.JobUtil;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Republish OAI-PMH Workflow Operation Handler", "workflow.operation=republish-oaipmh"})
public final class RepublishOaiPmhWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(RepublishOaiPmhWorkflowOperationHandler.class);
    private OaiPmhPublicationService oaiPmhPublicationService = null;
    private static final String OPT_SOURCE_FLAVORS = "source-flavors";
    private static final String OPT_SOURCE_TAGS = "source-tags";
    private static final String OPT_REPOSITORY = "repository";

    @Activate
    public void activate(ComponentContext cc) {
        super.activate(cc);
    }

    public WorkflowOperationResult start(WorkflowInstance wi, JobContext context) throws WorkflowOperationException {
        MediaPackage mp = wi.getMediaPackage();
        HashSet<String> flavors = new HashSet<String>();
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(wi, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.none);
        List configuredFlavors = tagsAndFlavors.getSrcFlavors();
        for (MediaPackageElementFlavor flavor : configuredFlavors) {
            flavors.add(flavor.toString());
        }
        HashSet tags = new HashSet(tagsAndFlavors.getSrcTags());
        String repository = this.getConfig(wi, OPT_REPOSITORY);
        logger.debug("Start updating metadata of the media package {} in OAI-PMH repository {}", (Object)mp.getIdentifier().toString(), (Object)repository);
        try {
            Job updateMetadataJob = this.oaiPmhPublicationService.updateMetadata(mp, repository, flavors, tags, true);
            if (updateMetadataJob == null) {
                logger.info("Unable to create an OAI-PMH update metadata job for the media package {} in repository {}", (Object)mp.getIdentifier().toString(), (Object)repository);
                return this.createResult(mp, WorkflowOperationResult.Action.CONTINUE);
            }
            if (!JobUtil.waitForJobs((ServiceRegistry)this.serviceRegistry, (Job[])new Job[]{updateMetadataJob}).isSuccess()) {
                throw new WorkflowOperationException(String.format("OAI-PMH update metadata job for the media package %s did not end successfully", mp.getIdentifier().toString()));
            }
        }
        catch (IllegalArgumentException | IllegalStateException | MediaPackageException | PublicationException e) {
            throw new WorkflowOperationException(String.format("Unable to create an OAI-PMH update metadata job for the media package %s in repository %s", mp.getIdentifier().toString(), repository), e);
        }
        logger.debug("Updating metadata of the media package {} in OAI-PMH repository {} done", (Object)mp.getIdentifier().toString(), (Object)repository);
        return this.createResult(mp, WorkflowOperationResult.Action.CONTINUE);
    }

    @Reference
    public void setOaiPmhPublicationService(OaiPmhPublicationService oaiPmhPublicationService) {
        this.oaiPmhPublicationService = oaiPmhPublicationService;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

