/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.distribution;

import java.util.Collection;
import java.util.List;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Publication;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.selector.SimpleElementSelector;
import org.opencastproject.publication.api.PublicationException;
import org.opencastproject.publication.api.YouTubePublicationService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=YouTube Publication Workflow Handler", "workflow.operation=publish-youtube"})
public class PublishYouTubeWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(PublishYouTubeWorkflowOperationHandler.class);
    private YouTubePublicationService publicationService = null;

    @Reference
    public void setPublicationService(YouTubePublicationService publicationService) {
        this.publicationService = publicationService;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        logger.debug("Running youtube publication workflow operation");
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.none);
        List sourceTags = tagsAndFlavors.getSrcTags();
        List sourceFlavors = tagsAndFlavors.getSrcFlavors();
        if (sourceTags == null && sourceFlavors == null) {
            logger.warn("No tags or flavor have been specified");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
        }
        SimpleElementSelector elementSelector = new SimpleElementSelector();
        if (!sourceFlavors.isEmpty()) {
            for (MediaPackageElementFlavor flavor : sourceFlavors) {
                elementSelector.addFlavor(flavor);
            }
        }
        if (!sourceTags.isEmpty()) {
            for (String tag : sourceTags) {
                elementSelector.addTag(tag);
            }
        }
        try {
            Job youtubeJob;
            Collection elements = elementSelector.select(mediaPackage, true);
            if (elements.size() > 1) {
                throw new WorkflowOperationException("More than one element has been found for publishing to youtube: " + String.valueOf(elements));
            }
            if (elements.size() < 1) {
                logger.info("No mediapackage element was found for publishing");
                return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
            }
            try {
                Track track = mediaPackage.getTrack(((MediaPackageElement)elements.iterator().next()).getIdentifier());
                youtubeJob = this.publicationService.publish(mediaPackage, track);
            }
            catch (PublicationException e) {
                throw new WorkflowOperationException((Throwable)e);
            }
            if (!this.waitForStatus(new Job[]{youtubeJob}).isSuccess()) {
                throw new WorkflowOperationException("The youtube publication jobs did not complete successfully");
            }
            Job job = this.serviceRegistry.getJob(youtubeJob.getId());
            if (job.getPayload() == null) {
                throw new WorkflowOperationException("Publish to youtube failed, no payload from publication job: " + job.getId());
            }
            Publication newElement = null;
            try {
                newElement = (Publication)MediaPackageElementParser.getFromXml((String)job.getPayload());
            }
            catch (MediaPackageException e) {
                throw new WorkflowOperationException((Throwable)e);
            }
            if (newElement == null) {
                throw new WorkflowOperationException(String.format("Publication to youtube failed, unable to parse the payload '%s' from job '%d' to a mediapackage element", job.getPayload(), job.getId()));
            }
            mediaPackage.add((MediaPackageElement)newElement);
            logger.debug("Publication to youtube operation completed");
        }
        catch (Exception e) {
            if (e instanceof WorkflowOperationException) {
                throw (WorkflowOperationException)e;
            }
            throw new WorkflowOperationException((Throwable)e);
        }
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
    }
}

