/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.distribution;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIUtils;
import org.opencastproject.distribution.api.DistributionException;
import org.opencastproject.distribution.api.DownloadDistributionService;
import org.opencastproject.distribution.api.StreamingDistributionService;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.MediaPackageReference;
import org.opencastproject.mediapackage.MediaPackageReferenceImpl;
import org.opencastproject.mediapackage.Publication;
import org.opencastproject.mediapackage.PublicationImpl;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.selector.SimpleElementSelector;
import org.opencastproject.mediapackage.track.TrackImpl;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreValue;
import org.opencastproject.metadata.dublincore.DublinCoreXmlFormat;
import org.opencastproject.search.api.SearchException;
import org.opencastproject.search.api.SearchService;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.util.MimeType;
import org.opencastproject.util.MimeTypes;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.UrlSupport;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.functions.Strings;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Engage Publication Workflow Handler", "workflow.operation=publish-engage"})
public class PublishEngageWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(PublishEngageWorkflowOperationHandler.class);
    static final String ENGAGE_URL_PROPERTY = "org.opencastproject.engage.ui.url";
    static final String STREAMING_PUBLISH_PROPERTY = "org.opencastproject.publish.streaming.formats";
    static final String DOWNLOAD_SOURCE_FLAVORS = "download-source-flavors";
    static final String DOWNLOAD_TARGET_SUBFLAVOR = "download-target-subflavor";
    static final String DOWNLOAD_SOURCE_TAGS = "download-source-tags";
    static final String DOWNLOAD_TARGET_TAGS = "download-target-tags";
    static final String STREAMING_SOURCE_TAGS = "streaming-source-tags";
    static final String STREAMING_TARGET_TAGS = "streaming-target-tags";
    static final String STREAMING_SOURCE_FLAVORS = "streaming-source-flavors";
    static final String STREAMING_TARGET_SUBFLAVOR = "streaming-target-subflavor";
    static final String CHECK_AVAILABILITY = "check-availability";
    static final String STRATEGY = "strategy";
    static final String MERGE_FORCE_FLAVORS = "merge-force-flavors";
    static final String ADD_FORCE_FLAVORS = "add-force-flavors";
    private static final String MERGE_FORCE_FLAVORS_DEFAULT = "dublincore/*,security/*";
    private static final String ADD_FORCE_FLAVORS_DEFAULT = "";
    static final String PLAYER_PATH = "/play/";
    static final String PUBLISH_STRATEGY_MERGE = "merge";
    static final String PUBLISH_STRATEGY_DEFAULT = "default";
    private StreamingDistributionService streamingDistributionService = null;
    private DownloadDistributionService downloadDistributionService = null;
    private SearchService searchService = null;
    private Workspace workspace;
    private URL serverUrl;
    private OrganizationDirectoryService organizationDirectoryService = null;
    private List<String> publishedStreamingFormats = null;
    private static final Set<TrackImpl.StreamingProtocol> STREAMING_FORMATS = new HashSet<TrackImpl.StreamingProtocol>(Arrays.asList(TrackImpl.StreamingProtocol.RTMP, TrackImpl.StreamingProtocol.RTMPE, TrackImpl.StreamingProtocol.HLS, TrackImpl.StreamingProtocol.DASH, TrackImpl.StreamingProtocol.HDS, TrackImpl.StreamingProtocol.SMOOTH));

    @Reference(target="(distribution.channel=streaming)")
    protected void setStreamingDistributionService(StreamingDistributionService streamingDistributionService) {
        this.streamingDistributionService = streamingDistributionService;
    }

    @Reference(target="(distribution.channel=download)")
    protected void setDownloadDistributionService(DownloadDistributionService downloadDistributionService) {
        this.downloadDistributionService = downloadDistributionService;
    }

    @Reference
    protected void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectoryService) {
        this.organizationDirectoryService = organizationDirectoryService;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Activate
    protected void activate(ComponentContext cc) {
        super.activate(cc);
        BundleContext bundleContext = cc.getBundleContext();
        this.serverUrl = UrlSupport.url((String)bundleContext.getProperty("org.opencastproject.server.url"));
        this.publishedStreamingFormats = Arrays.asList(Optional.ofNullable(StringUtils.split((String)bundleContext.getProperty(STREAMING_PUBLISH_PROPERTY), (String)",")).orElse(new String[0]));
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        logger.debug("Running engage publication workflow operation");
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        WorkflowOperationInstance op = workflowInstance.getCurrentOperation();
        String downloadSourceTags = StringUtils.trimToEmpty((String)op.getConfiguration(DOWNLOAD_SOURCE_TAGS));
        String downloadTargetTags = StringUtils.trimToEmpty((String)op.getConfiguration(DOWNLOAD_TARGET_TAGS));
        String downloadSourceFlavors = StringUtils.trimToEmpty((String)op.getConfiguration(DOWNLOAD_SOURCE_FLAVORS));
        String downloadTargetSubflavor = StringUtils.trimToNull((String)op.getConfiguration(DOWNLOAD_TARGET_SUBFLAVOR));
        String streamingSourceTags = StringUtils.trimToEmpty((String)op.getConfiguration(STREAMING_SOURCE_TAGS));
        String streamingTargetTags = StringUtils.trimToEmpty((String)op.getConfiguration(STREAMING_TARGET_TAGS));
        String streamingSourceFlavors = StringUtils.trimToEmpty((String)op.getConfiguration(STREAMING_SOURCE_FLAVORS));
        String streamingTargetSubflavor = StringUtils.trimToNull((String)op.getConfiguration(STREAMING_TARGET_SUBFLAVOR));
        String republishStrategy = StringUtils.trimToEmpty((String)StringUtils.defaultString((String)op.getConfiguration(STRATEGY), (String)PUBLISH_STRATEGY_DEFAULT));
        String mergeForceFlavorsStr = StringUtils.trimToEmpty((String)StringUtils.defaultString((String)op.getConfiguration(MERGE_FORCE_FLAVORS), (String)MERGE_FORCE_FLAVORS_DEFAULT));
        String addForceFlavorsStr = StringUtils.trimToEmpty((String)StringUtils.defaultString((String)op.getConfiguration(ADD_FORCE_FLAVORS), (String)ADD_FORCE_FLAVORS_DEFAULT));
        boolean checkAvailability = (Boolean)Option.option((Object)op.getConfiguration(CHECK_AVAILABILITY)).bind(Strings.trimToNone).map(Strings.toBool).getOrElse((Object)true);
        MediaPackage distributedMp = null;
        try {
            distributedMp = this.searchService.get(mediaPackage.getIdentifier().toString());
        }
        catch (NotFoundException e) {
            logger.debug("No published mediapackage found for {}", (Object)mediaPackage.getIdentifier().toString());
        }
        catch (UnauthorizedException e) {
            throw new WorkflowOperationException("Unauthorized for " + mediaPackage.getIdentifier().toString(), (Throwable)e);
        }
        if (PUBLISH_STRATEGY_MERGE.equals(republishStrategy) && distributedMp == null) {
            logger.info("Skipping republish for {} since it is not currently published", (Object)mediaPackage.getIdentifier().toString());
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        String[] sourceDownloadTags = StringUtils.split((String)downloadSourceTags, (String)",");
        String[] targetDownloadTags = StringUtils.split((String)downloadTargetTags, (String)",");
        String[] sourceDownloadFlavors = StringUtils.split((String)downloadSourceFlavors, (String)",");
        String[] sourceStreamingTags = StringUtils.split((String)streamingSourceTags, (String)",");
        String[] targetStreamingTags = StringUtils.split((String)streamingTargetTags, (String)",");
        String[] sourceStreamingFlavors = StringUtils.split((String)streamingSourceFlavors, (String)",");
        if (sourceDownloadTags.length == 0 && sourceDownloadFlavors.length == 0 && sourceStreamingTags.length == 0 && sourceStreamingFlavors.length == 0) {
            logger.warn("No tags or flavors have been specified, so nothing will be published to the engage publication channel");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
        }
        List<MediaPackageElementFlavor> mergeForceFlavors = Arrays.stream(StringUtils.split((String)mergeForceFlavorsStr, (String)", ")).map(MediaPackageElementFlavor::parseFlavor).collect(Collectors.toList());
        List<MediaPackageElementFlavor> addForceFlavors = Arrays.stream(StringUtils.split((String)addForceFlavorsStr, (String)", ")).map(MediaPackageElementFlavor::parseFlavor).collect(Collectors.toList());
        MediaPackageElementFlavor downloadSubflavor = null;
        if (downloadTargetSubflavor != null) {
            try {
                downloadSubflavor = MediaPackageElementFlavor.parseFlavor((String)downloadTargetSubflavor);
            }
            catch (IllegalArgumentException e) {
                throw new WorkflowOperationException((Throwable)e);
            }
        }
        MediaPackageElementFlavor streamingSubflavor = null;
        if (streamingTargetSubflavor != null) {
            try {
                streamingSubflavor = MediaPackageElementFlavor.parseFlavor((String)streamingTargetSubflavor);
            }
            catch (IllegalArgumentException e) {
                throw new WorkflowOperationException((Throwable)e);
            }
        }
        SimpleElementSelector downloadElementSelector = new SimpleElementSelector();
        for (String flavor : sourceDownloadFlavors) {
            downloadElementSelector.addFlavor(MediaPackageElementFlavor.parseFlavor((String)flavor));
        }
        for (String tag : sourceDownloadTags) {
            downloadElementSelector.addTag(tag);
        }
        SimpleElementSelector streamingElementSelector = new SimpleElementSelector();
        for (String flavor : sourceStreamingFlavors) {
            streamingElementSelector.addFlavor(MediaPackageElementFlavor.parseFlavor((String)flavor));
        }
        for (String tag : sourceStreamingTags) {
            streamingElementSelector.addTag(tag);
        }
        Collection downloadElements = downloadElementSelector.select(mediaPackage, false);
        Collection streamingElements = streamingElementSelector.select(mediaPackage, false);
        try {
            HashSet<String> downloadElementIds = new HashSet<String>();
            HashSet<String> streamingElementIds = new HashSet<String>();
            for (MediaPackageElement elem : downloadElements) {
                downloadElementIds.add(elem.getIdentifier());
            }
            for (MediaPackageElement elem : streamingElements) {
                streamingElementIds.add(elem.getIdentifier());
            }
            this.removePublicationElement(mediaPackage);
            if (republishStrategy.equals(PUBLISH_STRATEGY_DEFAULT)) {
                this.retractFromEngage(distributedMp);
            }
            ArrayList<Job> jobs = new ArrayList<Job>();
            try {
                Object job;
                if (downloadElementIds.size() > 0 && (job = this.downloadDistributionService.distribute("engage-player", mediaPackage, downloadElementIds, checkAvailability)) != null) {
                    jobs.add((Job)job);
                }
                if (this.streamingDistributionService != null && this.streamingDistributionService.publishToStreaming()) {
                    for (String elementId : streamingElementIds) {
                        Job job2 = this.streamingDistributionService.distribute("engage-player", mediaPackage, elementId);
                        if (job2 == null) continue;
                        jobs.add(job2);
                    }
                }
            }
            catch (DistributionException e) {
                throw new WorkflowOperationException((Throwable)e);
            }
            if (jobs.size() < 1) {
                logger.info("No mediapackage element was found for distribution to engage");
                return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
            }
            if (!this.waitForStatus(jobs.toArray(new Job[jobs.size()])).isSuccess()) {
                throw new WorkflowOperationException("One of the distribution jobs did not complete successfully");
            }
            logger.debug("Distribute of mediapackage {} completed", (Object)mediaPackage);
            String engageUrlString = null;
            try {
                URL engageBaseUrl;
                Optional<URI> dcUri;
                MediaPackage mediaPackageForSearch = this.getMediaPackageForSearchIndex(mediaPackage, jobs, downloadSubflavor, targetDownloadTags, downloadElementIds, streamingSubflavor, streamingElementIds, targetStreamingTags);
                this.removePublicationElement(mediaPackage);
                if (republishStrategy.equals(PUBLISH_STRATEGY_MERGE)) {
                    mediaPackageForSearch = this.mergePackages(mediaPackageForSearch, distributedMp, mergeForceFlavors, addForceFlavors);
                }
                if (StringUtils.isBlank((CharSequence)mediaPackageForSearch.getTitle()) && (dcUri = Arrays.stream(mediaPackageForSearch.getCatalogs(MediaPackageElements.EPISODE)).findFirst().map(MediaPackageElement::getURI)).isPresent()) {
                    try (InputStream in = this.workspace.read(dcUri.get());){
                        DublinCoreXmlFormat.read((InputStream)in).get(DublinCore.PROPERTY_TITLE).stream().findFirst().map(DublinCoreValue::getValue).ifPresent(arg_0 -> ((MediaPackage)mediaPackageForSearch).setTitle(arg_0));
                    }
                }
                if (StringUtils.isBlank((CharSequence)mediaPackageForSearch.getTitle())) {
                    throw new WorkflowOperationException("Media package does not meet publication criteria: Missing title");
                }
                if (!mediaPackageForSearch.hasTracks()) {
                    throw new WorkflowOperationException("Media package does not meet publication criteria: No tracks selected");
                }
                MediaPackageElement[] mediaPackageElements = mediaPackageForSearch.getElements();
                logger.info("Publishing media package {} to search index", (Object)mediaPackageForSearch);
                Organization organization = this.organizationDirectoryService.getOrganization(workflowInstance.getOrganizationId());
                engageUrlString = StringUtils.trimToNull((String)((String)organization.getProperties().get(ENGAGE_URL_PROPERTY)));
                if (engageUrlString != null) {
                    engageBaseUrl = new URL(engageUrlString);
                } else {
                    engageBaseUrl = this.serverUrl;
                    logger.info("Using 'server.url' as a fallback for the non-existing organization level key '{}' for the publication url", (Object)ENGAGE_URL_PROPERTY);
                }
                URI engageUri = this.createEngageUri(engageBaseUrl.toURI(), mediaPackage);
                Publication publicationElement = PublicationImpl.publication((String)UUID.randomUUID().toString(), (String)"engage-player", (URI)engageUri, (MimeType)MimeTypes.parseMimeType((String)"text/html"));
                for (MediaPackageElement mediaPackageElement : mediaPackageElements) {
                    mediaPackageElement.setIdentifier(null);
                    PublicationImpl.addElementToPublication((Publication)publicationElement, (MediaPackageElement)mediaPackageElement);
                }
                mediaPackage.add((MediaPackageElement)publicationElement);
                if (this.streamingDistributionService != null && this.streamingDistributionService.publishToStreaming() && !this.publishedStreamingFormats.isEmpty()) {
                    for (MediaPackageElement mediaPackageElement : mediaPackageForSearch.getTracks()) {
                        String mimeType = mediaPackageElement.getMimeType().toString();
                        if (!this.isStreamingFormat(mediaPackageElement) || !this.publishedStreamingFormats.contains(mimeType) && !this.publishedStreamingFormats.contains("*")) continue;
                        publicationElement.addTrack((Track)mediaPackageElement);
                    }
                    for (MediaPackageElement mediaPackageElement : mediaPackageForSearch.getAttachments()) {
                        publicationElement.addAttachment((Attachment)mediaPackageElement);
                    }
                    for (MediaPackageElement mediaPackageElement : mediaPackageForSearch.getCatalogs()) {
                        publicationElement.addCatalog((Catalog)mediaPackageElement);
                    }
                }
                Job publishJob = null;
                try {
                    publishJob = this.searchService.add(mediaPackageForSearch);
                    if (!this.waitForStatus(new Job[]{publishJob}).isSuccess()) {
                        throw new WorkflowOperationException("Mediapackage " + String.valueOf(mediaPackageForSearch.getIdentifier()) + " could not be published");
                    }
                }
                catch (SearchException e) {
                    throw new WorkflowOperationException("Error publishing media package", (Throwable)e);
                }
                catch (MediaPackageException e) {
                    throw new WorkflowOperationException("Error parsing media package", (Throwable)e);
                }
                logger.debug("Publishing of mediapackage {} completed", (Object)mediaPackage);
                return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
            }
            catch (MalformedURLException e) {
                logger.error("{} is malformed: {}", (Object)ENGAGE_URL_PROPERTY, engageUrlString);
                throw new WorkflowOperationException((Throwable)e);
            }
            catch (Throwable t) {
                if (t instanceof WorkflowOperationException) {
                    throw (WorkflowOperationException)t;
                }
                throw new WorkflowOperationException(t);
            }
        }
        catch (Exception e) {
            if (e instanceof WorkflowOperationException) {
                throw (WorkflowOperationException)e;
            }
            throw new WorkflowOperationException((Throwable)e);
        }
    }

    URI createEngageUri(URI engageUri, MediaPackage mp) {
        return URIUtils.resolve((URI)engageUri, (String)(PLAYER_PATH + mp.getIdentifier().toString()));
    }

    protected MediaPackage getMediaPackageForSearchIndex(MediaPackage current, List<Job> jobs, MediaPackageElementFlavor downloadSubflavor, String[] downloadTargetTags, Set<String> downloadElementIds, MediaPackageElementFlavor streamingSubflavor, Set<String> streamingElementIds, String[] streamingTargetTags) throws MediaPackageException, NotFoundException, ServiceRegistryException, WorkflowOperationException {
        MediaPackage mp = (MediaPackage)current.clone();
        ArrayList<String> elementsToPublish = new ArrayList<String>();
        HashMap<String, String> distributedElementIds = new HashMap<String, String>();
        for (Job entry : jobs) {
            Job job = this.serviceRegistry.getJob(entry.getId());
            if (job.getPayload() == null) continue;
            List distributedElements = null;
            try {
                distributedElements = MediaPackageElementParser.getArrayFromXml((String)job.getPayload());
            }
            catch (MediaPackageException e) {
                throw new WorkflowOperationException((Throwable)e);
            }
            if (distributedElements == null || distributedElements.size() < 1) continue;
            for (MediaPackageElement distributedElement : distributedElements) {
                String sourceElementId = distributedElement.getIdentifier();
                if (sourceElementId != null) {
                    MediaPackageElement sourceElement = mp.getElementById(sourceElementId);
                    distributedElement.setIdentifier(null);
                    if (sourceElement != null) {
                        MediaPackageReference ref;
                        MediaPackageElementFlavor flavor;
                        if (downloadElementIds.contains(sourceElementId)) {
                            if (downloadSubflavor != null && (flavor = sourceElement.getFlavor()) != null) {
                                newFlavor = new MediaPackageElementFlavor(flavor.getType(), downloadSubflavor.getSubtype());
                                distributedElement.setFlavor(newFlavor);
                            }
                        } else if (streamingElementIds.contains(sourceElementId) && streamingSubflavor != null && streamingElementIds.contains(sourceElementId) && (flavor = sourceElement.getFlavor()) != null) {
                            newFlavor = new MediaPackageElementFlavor(flavor.getType(), streamingSubflavor.getSubtype());
                            distributedElement.setFlavor(newFlavor);
                        }
                        if ((ref = sourceElement.getReference()) != null && mp.getElementByReference(ref) != null) {
                            MediaPackageReference newReference = (MediaPackageReference)ref.clone();
                            distributedElement.setReference(newReference);
                        }
                    }
                }
                if (this.isStreamingFormat(distributedElement)) {
                    this.applyTags(distributedElement, streamingTargetTags);
                } else {
                    this.applyTags(distributedElement, downloadTargetTags);
                }
                mp.add(distributedElement);
                elementsToPublish.add(distributedElement.getIdentifier());
                distributedElementIds.put(sourceElementId, distributedElement.getIdentifier());
            }
        }
        ArrayList<MediaPackageElement> removals = new ArrayList<MediaPackageElement>();
        for (MediaPackageElement element : mp.getElements()) {
            if (elementsToPublish.contains(element.getIdentifier())) continue;
            removals.add(element);
        }
        for (MediaPackageElement element : mp.getElements()) {
            String distributedElementId;
            MediaPackageReference reference;
            if (removals.contains(element) || (reference = element.getReference()) == null || (distributedElementId = (String)distributedElementIds.get(reference.getIdentifier())) == null) continue;
            MediaPackageReferenceImpl translatedReference = new MediaPackageReferenceImpl(mp.getElementById(distributedElementId));
            if (reference.getProperties() != null) {
                translatedReference.getProperties().putAll(reference.getProperties());
            }
            element.setReference((MediaPackageReference)translatedReference);
        }
        for (MediaPackageElement element : removals) {
            mp.remove(element);
        }
        return mp;
    }

    private boolean isStreamingFormat(MediaPackageElement element) {
        return element instanceof TrackImpl && STREAMING_FORMATS.contains(((TrackImpl)element).getTransport());
    }

    private void applyTags(MediaPackageElement element, String[] tags) {
        for (String tag : tags) {
            element.addTag(tag);
        }
    }

    protected MediaPackage mergePackages(MediaPackage updatedMp, MediaPackage publishedMp, List<MediaPackageElementFlavor> mergeForceFlavors, List<MediaPackageElementFlavor> addForceFlavors) {
        if (publishedMp == null) {
            return updatedMp;
        }
        MediaPackage mergedMediaPackage = (MediaPackage)updatedMp.clone();
        for (MediaPackageElement element : publishedMp.elements()) {
            String type = element.getElementType().toString().toLowerCase();
            boolean elementHasFlavorThatAlreadyExists = updatedMp.getElementsByFlavor(element.getFlavor()).length > 0;
            boolean elementHasForceMergeFlavor = mergeForceFlavors.stream().anyMatch(f -> element.getFlavor().matches(f));
            boolean elementHasForceAddFlavor = addForceFlavors.stream().anyMatch(f -> element.getFlavor().matches(f));
            if (elementHasForceAddFlavor) {
                logger.info("Adding {} '{}' into the updated mediapackage", (Object)type, (Object)element.getIdentifier());
                mergedMediaPackage.add((MediaPackageElement)element.clone());
                continue;
            }
            if (!elementHasFlavorThatAlreadyExists) {
                if (elementHasForceMergeFlavor) {
                    logger.info("Forcing removal of {} {} due to the absence of a new element with flavor {}", new Object[]{type, element.getIdentifier(), element.getFlavor().toString()});
                    continue;
                }
                logger.info("Merging {} '{}' into the updated mediapackage", (Object)type, (Object)element.getIdentifier());
                mergedMediaPackage.add((MediaPackageElement)element.clone());
                continue;
            }
            logger.info("Overwriting existing {} '{}' with '{}' in the updated mediapackage", new Object[]{type, element.getIdentifier(), updatedMp.getElementsByFlavor(element.getFlavor())[0].getIdentifier()});
        }
        return mergedMediaPackage;
    }

    private void removePublicationElement(MediaPackage mediaPackage) {
        for (Publication publicationElement : mediaPackage.getPublications()) {
            if (!"engage-player".equals(publicationElement.getChannel())) continue;
            mediaPackage.remove((MediaPackageElement)publicationElement);
        }
    }

    private void retractFromEngage(MediaPackage distributedMediaPackage) throws WorkflowOperationException {
        ArrayList<Object> jobs = new ArrayList<Object>();
        HashSet<String> elementIds = new HashSet<String>();
        try {
            if (distributedMediaPackage != null) {
                MediaPackageElement[] retractDownloadDistributionJob;
                for (MediaPackageElement element : distributedMediaPackage.getElements()) {
                    elementIds.add(element.getIdentifier());
                }
                if (elementIds.size() > 0 && (retractDownloadDistributionJob = this.downloadDistributionService.retract("engage-player", distributedMediaPackage, elementIds)) != null) {
                    jobs.add(retractDownloadDistributionJob);
                }
                if (this.streamingDistributionService != null && this.streamingDistributionService.publishToStreaming()) {
                    for (MediaPackageElement element : distributedMediaPackage.getElements()) {
                        Job retractStreamingJob = this.streamingDistributionService.retract("engage-player", distributedMediaPackage, element.getIdentifier());
                        if (retractStreamingJob == null) continue;
                        jobs.add(retractStreamingJob);
                    }
                }
                Job deleteSearchJob = null;
                logger.info("Retracting already published Elements for Mediapackage: {}", (Object)distributedMediaPackage.getIdentifier().toString());
                deleteSearchJob = this.searchService.delete(distributedMediaPackage.getIdentifier().toString());
                if (deleteSearchJob != null) {
                    jobs.add(deleteSearchJob);
                }
            }
            if (!this.waitForStatus(jobs.toArray(new Job[jobs.size()])).isSuccess()) {
                throw new WorkflowOperationException("One of the retraction jobs did not complete successfully");
            }
        }
        catch (DistributionException e) {
            throw new WorkflowOperationException((Throwable)e);
        }
        catch (SearchException e) {
            throw new WorkflowOperationException("Error retracting media package", (Throwable)e);
        }
        catch (UnauthorizedException | NotFoundException ex) {
            logger.error("Retraction failed of Mediapackage: {}", (Object)distributedMediaPackage.getIdentifier().toString(), (Object)ex);
        }
    }
}

