/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.distribution;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.distribution.api.DistributionException;
import org.opencastproject.distribution.api.DownloadDistributionService;
import org.opencastproject.distribution.api.StreamingDistributionService;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Publication;
import org.opencastproject.mediapackage.PublicationImpl;
import org.opencastproject.mediapackage.selector.SimpleElementSelector;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.MimeType;
import org.opencastproject.util.MimeTypes;
import org.opencastproject.util.RequireUtil;
import org.opencastproject.util.doc.DocUtil;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workflow.handler.distribution.ConfigurableWorkflowOperationHandlerBase;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Configurable Publication Workflow Handler", "workflow.operation=publish-configure"})
public class ConfigurablePublishWorkflowOperationHandler
extends ConfigurableWorkflowOperationHandlerBase {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurablePublishWorkflowOperationHandler.class);
    protected static final String EVENT_ID_TEMPLATE_KEY = "event_id";
    protected static final String PLAYER_PATH_TEMPLATE_KEY = "player_path";
    protected static final String PUBLICATION_ID_TEMPLATE_KEY = "publication_id";
    protected static final String SERIES_ID_TEMPLATE_KEY = "series_id";
    protected static final String PLAYER_PROPERTY = "player";
    protected static final String ORG_TEMPLATE_KEY_PREFIX = "org_";
    private DownloadDistributionService downloadDistributionService;
    private StreamingDistributionService streamingDistributionService;
    private SecurityService securityService;
    static final String DOWNLOAD_SOURCE_FLAVORS = "download-source-flavors";
    static final String DOWNLOAD_SOURCE_TAGS = "download-source-tags";
    static final String STREAMING_SOURCE_TAGS = "streaming-source-tags";
    static final String STREAMING_SOURCE_FLAVORS = "streaming-source-flavors";
    static final String CHANNEL_ID_KEY = "channel-id";
    static final String MIME_TYPE = "mimetype";
    static final String WITH_PUBLISHED_ELEMENTS = "with-published-elements";
    static final String CHECK_AVAILABILITY = "check-availability";
    static final String STRATEGY = "strategy";
    static final String MODE = "mode";
    static final String MODE_SINGLE = "single";
    static final String MODE_MIXED = "mixed";
    static final String MODE_BULK = "bulk";
    static final String[] KNOWN_MODES = new String[]{"single", "mixed", "bulk"};
    static final String DEFAULT_MODE = "bulk";
    static final String URL_PATTERN = "url-pattern";
    static final String RETRACT_STREAMING = "retract-streaming";
    static final boolean RETRACT_STREAMING_DEFAULT = false;

    @Reference(target="(distribution.channel=download)")
    void setDownloadDistributionService(DownloadDistributionService distributionService) {
        this.downloadDistributionService = distributionService;
    }

    @Reference(target="(distribution.channel=streaming)")
    void setStreamingDistributionService(StreamingDistributionService streamingDistributionService) {
        this.streamingDistributionService = streamingDistributionService;
    }

    @Reference
    protected void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Override
    protected DownloadDistributionService getDownloadDistributionService() {
        assert (this.downloadDistributionService != null);
        return this.downloadDistributionService;
    }

    @Override
    protected StreamingDistributionService getStreamingDistributionService() {
        assert (this.streamingDistributionService != null);
        return this.streamingDistributionService;
    }

    public URI populateUrlWithVariables(String urlPattern, MediaPackage mp, String pubUUID) throws WorkflowOperationException {
        URI publicationURI;
        HashMap<Object, String> values = new HashMap<Object, String>();
        values.put(EVENT_ID_TEMPLATE_KEY, mp.getIdentifier().toString());
        values.put(PUBLICATION_ID_TEMPLATE_KEY, pubUUID);
        String playerPath = (String)this.securityService.getOrganization().getProperties().get(PLAYER_PROPERTY);
        values.put(PLAYER_PATH_TEMPLATE_KEY, playerPath);
        values.put(SERIES_ID_TEMPLATE_KEY, StringUtils.trimToEmpty((String)mp.getSeries()));
        Map orgProperties = this.securityService.getOrganization().getProperties();
        orgProperties.put("id", this.securityService.getOrganization().getId());
        orgProperties.put("name", this.securityService.getOrganization().getName());
        orgProperties.put("admin_role", this.securityService.getOrganization().getAdminRole());
        orgProperties.put("anonymous_role", this.securityService.getOrganization().getAnonymousRole());
        for (Map.Entry orgProperty : orgProperties.entrySet()) {
            values.put(ORG_TEMPLATE_KEY_PREFIX + ((String)orgProperty.getKey()).replace('.', '_').toLowerCase(), (String)orgProperty.getValue());
        }
        String uriWithVariables = DocUtil.processTextTemplate((String)"Replacing Variables in Publish URL", (String)urlPattern, values);
        try {
            publicationURI = new URI(uriWithVariables);
        }
        catch (URISyntaxException e) {
            throw new WorkflowOperationException(String.format("Unable to create URI from template '%s', replacement was: '%s'", urlPattern, uriWithVariables), (Throwable)e);
        }
        return publicationURI;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        String mode;
        RequireUtil.notNull((Object)workflowInstance, (String)"workflowInstance");
        MediaPackage mp = workflowInstance.getMediaPackage();
        WorkflowOperationInstance op = workflowInstance.getCurrentOperation();
        String channelId = StringUtils.trimToEmpty((String)op.getConfiguration(CHANNEL_ID_KEY));
        if ("".equals(channelId)) {
            throw new WorkflowOperationException("Unable to publish this mediapackage as the configuration key channel-id is missing. Unable to determine where to publish these elements.");
        }
        String urlPattern = StringUtils.trimToEmpty((String)op.getConfiguration(URL_PATTERN));
        MimeType mimetype = null;
        String mimetypeString = StringUtils.trimToEmpty((String)op.getConfiguration(MIME_TYPE));
        if (!"".equals(mimetypeString)) {
            try {
                mimetype = MimeTypes.parseMimeType((String)mimetypeString);
            }
            catch (IllegalArgumentException e) {
                throw new WorkflowOperationException("Unable to parse the provided configuration for mimetype", (Throwable)e);
            }
        }
        boolean withPublishedElements = BooleanUtils.toBoolean((String)StringUtils.trimToEmpty((String)op.getConfiguration(WITH_PUBLISHED_ELEMENTS)));
        boolean checkAvailability = BooleanUtils.toBoolean((String)StringUtils.trimToEmpty((String)op.getConfiguration(CHECK_AVAILABILITY)));
        boolean retractStreaming = false;
        String retractStreamingString = workflowInstance.getConfiguration(RETRACT_STREAMING);
        if (retractStreamingString != null) {
            retractStreaming = BooleanUtils.toBoolean((String)StringUtils.trimToEmpty((String)retractStreamingString));
        }
        if (this.getPublications(mp, channelId).size() > 0) {
            String rePublishStrategy;
            switch (rePublishStrategy = StringUtils.trimToEmpty((String)op.getConfiguration(STRATEGY))) {
                case "fail": {
                    this.fail(mp);
                    break;
                }
                case "merge": {
                    break;
                }
                default: {
                    this.retract(mp, channelId, retractStreaming);
                }
            }
        }
        if ("".equals(mode = StringUtils.trimToEmpty((String)op.getConfiguration(MODE)))) {
            mode = "bulk";
        } else if (!ArrayUtils.contains((Object[])KNOWN_MODES, (Object)mode)) {
            logger.error("Unknown value for configuration key mode: '{}'", (Object)mode);
            throw new IllegalArgumentException("Unknown value for configuration key mode");
        }
        String[] downloadSourceFlavors = StringUtils.split((String)StringUtils.trimToEmpty((String)op.getConfiguration(DOWNLOAD_SOURCE_FLAVORS)), (String)",");
        String[] downloadSourceTags = StringUtils.split((String)StringUtils.trimToEmpty((String)op.getConfiguration(DOWNLOAD_SOURCE_TAGS)), (String)",");
        String[] streamingSourceFlavors = StringUtils.split((String)StringUtils.trimToEmpty((String)op.getConfiguration(STREAMING_SOURCE_FLAVORS)), (String)",");
        String[] streamingSourceTags = StringUtils.split((String)StringUtils.trimToEmpty((String)op.getConfiguration(STREAMING_SOURCE_TAGS)), (String)",");
        String publicationUUID = UUID.randomUUID().toString();
        Publication publication = PublicationImpl.publication((String)publicationUUID, (String)channelId, null, null);
        SimpleElementSelector downloadSelector = new SimpleElementSelector();
        for (String flavor : downloadSourceFlavors) {
            downloadSelector.addFlavor(MediaPackageElementFlavor.parseFlavor((String)flavor));
        }
        for (String tag : downloadSourceTags) {
            downloadSelector.addTag(tag);
        }
        SimpleElementSelector streamingSelector = new SimpleElementSelector();
        for (String flavor : streamingSourceFlavors) {
            streamingSelector.addFlavor(MediaPackageElementFlavor.parseFlavor((String)flavor));
        }
        for (String tag : streamingSourceTags) {
            streamingSelector.addTag(tag);
        }
        boolean streamingElementsDistributed = false;
        boolean downloadElementsDistributed = false;
        if (this.streamingDistributionService != null && this.streamingDistributionService.publishToStreaming() && (streamingSourceFlavors.length > 0 || streamingSourceTags.length > 0)) {
            streamingElementsDistributed = this.distributeElements(streamingSelector, mp, publication, channelId, mode, withPublishedElements, checkAvailability, true);
        }
        if (downloadSourceFlavors.length > 0 || downloadSourceTags.length > 0) {
            downloadElementsDistributed = this.distributeElements(downloadSelector, mp, publication, channelId, mode, withPublishedElements, checkAvailability, false);
        }
        if (!(downloadElementsDistributed || streamingElementsDistributed || downloadSourceFlavors.length <= 0 && downloadSourceTags.length <= 0 && streamingSourceFlavors.length <= 0 && streamingSourceTags.length <= 0)) {
            return this.createResult(mp, WorkflowOperationResult.Action.SKIP);
        }
        if (!"".equals(urlPattern)) {
            publication.setURI(this.populateUrlWithVariables(urlPattern, mp, publicationUUID));
        }
        if (mimetype != null) {
            publication.setMimeType(mimetype);
        }
        mp.add((MediaPackageElement)publication);
        return this.createResult(mp, WorkflowOperationResult.Action.CONTINUE);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean distributeElements(SimpleElementSelector selector, MediaPackage mp, Publication publication, String channelId, String mode, boolean withPublishedElements, boolean checkAvailability, boolean streaming) throws WorkflowOperationException {
        String target;
        String string = target = streaming ? "streaming" : "download";
        if (!withPublishedElements) {
            Set<MediaPackageElement> elements = this.distribute(selector.select(mp, false), mp, channelId, mode, checkAvailability, streaming);
            if (elements.size() <= 0) {
                logger.info("No element found for distribution to " + target + " in media package '{}'", (Object)mp);
                return false;
            }
            for (MediaPackageElement element : elements) {
                element.setIdentifier(null);
                PublicationImpl.addElementToPublication((Publication)publication, (MediaPackageElement)element);
            }
            return true;
        } else {
            ArrayList<Object> publishedElements = new ArrayList<Object>();
            for (Publication alreadyPublished : mp.getPublications()) {
                publishedElements.addAll(Arrays.asList(alreadyPublished.getAttachments()));
                publishedElements.addAll(Arrays.asList(alreadyPublished.getCatalogs()));
                publishedElements.addAll(Arrays.asList(alreadyPublished.getTracks()));
            }
            Collection elements = selector.select(publishedElements, false);
            if (elements.size() <= 0) {
                logger.info("No elements found for publication to " + target + " in media package '{}'", (Object)mp);
                return false;
            }
            for (MediaPackageElement element : elements) {
                PublicationImpl.addElementToPublication((Publication)publication, (MediaPackageElement)element);
            }
        }
        return true;
    }

    private Set<MediaPackageElement> distribute(Collection<MediaPackageElement> elements, MediaPackage mediapackage, String channelId, String mode, boolean checkAvailability, boolean streaming) throws WorkflowOperationException {
        HashSet<MediaPackageElement> result = new HashSet<MediaPackageElement>();
        HashSet<String> bulkElementIds = new HashSet<String>();
        HashSet<String> singleElementIds = new HashSet<String>();
        for (MediaPackageElement element : elements) {
            if ("bulk".equals(mode) || MODE_MIXED.equals(mode) && element.getElementType() != MediaPackageElement.Type.Track) {
                bulkElementIds.add(element.getIdentifier());
                continue;
            }
            singleElementIds.add(element.getIdentifier());
        }
        HashSet<Job> jobs = new HashSet<Job>();
        if (bulkElementIds.size() > 0) {
            logger.info("Start bulk publishing of {} elements of media package '{}' to publication channel '{}'", new Object[]{bulkElementIds.size(), mediapackage, channelId});
            try {
                Job job = streaming ? this.streamingDistributionService.distribute(channelId, mediapackage, bulkElementIds) : this.downloadDistributionService.distribute(channelId, mediapackage, bulkElementIds, checkAvailability);
                jobs.add(job);
            }
            catch (DistributionException | MediaPackageException e) {
                logger.error("Creating the distribution job for {} elements of media package '{}' failed", new Object[]{bulkElementIds.size(), mediapackage, e});
                throw new WorkflowOperationException(e);
            }
        }
        if (singleElementIds.size() > 0) {
            logger.info("Start single publishing of {} elements of media package '{}' to publication channel '{}'", new Object[]{singleElementIds.size(), mediapackage, channelId});
            for (String elementId : singleElementIds) {
                try {
                    Job job = streaming ? this.streamingDistributionService.distribute(channelId, mediapackage, elementId) : this.downloadDistributionService.distribute(channelId, mediapackage, elementId, checkAvailability);
                    jobs.add(job);
                }
                catch (DistributionException | MediaPackageException e) {
                    logger.error("Creating the distribution job for element '{}' of media package '{}' failed", new Object[]{elementId, mediapackage, e});
                    throw new WorkflowOperationException(e);
                }
            }
        }
        if (jobs.size() > 0) {
            if (!this.waitForStatus(jobs.toArray(new Job[jobs.size()])).isSuccess()) {
                throw new WorkflowOperationException("At least one of the distribution jobs did not complete successfully");
            }
            for (Job job : jobs) {
                try {
                    List elems = MediaPackageElementParser.getArrayFromXml((String)job.getPayload());
                    result.addAll(elems);
                }
                catch (MediaPackageException e) {
                    logger.error("Job '{}' returned payload ({}) that could not be parsed to media package elements", new Object[]{job, job.getPayload(), e});
                    throw new WorkflowOperationException((Throwable)e);
                }
            }
            logger.info("Published {} elements of media package {} to publication channel {}", new Object[]{bulkElementIds.size() + singleElementIds.size(), mediapackage, channelId});
        }
        return result;
    }

    private void fail(MediaPackage mp) throws WorkflowOperationException {
        logger.error("There is already a Published Media, fail Stragy for Mediapackage {}", (Object)mp.getIdentifier());
        throw new WorkflowOperationException("There is already a Published Media, fail Stragy for Mediapackage ");
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

