/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.distribution;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Publication;
import org.opencastproject.mediapackage.selector.SimpleElementSelector;
import org.opencastproject.search.api.SearchException;
import org.opencastproject.search.api.SearchService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Tag Engage Workflow Operation Handler", "workflow.operation=tag-engage"})
public class TagEngageWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(TagEngageWorkflowOperationHandler.class);
    private static final String PLUS = "+";
    private static final String MINUS = "-";
    private SearchService searchService = null;

    @Reference
    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Activate
    protected void activate(ComponentContext cc) {
        super.activate(cc);
        logger.info("Registering tag engage workflow operation handler");
    }

    public WorkflowOperationResult start(WorkflowInstance instance, JobContext context) throws WorkflowOperationException {
        MediaPackage currentMediaPackage = instance.getMediaPackage();
        String mediaPackageId = currentMediaPackage.getIdentifier().toString();
        ConfiguredTagsAndFlavors config = this.getTagsAndFlavors(instance, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many);
        HashSet<String> removeTags = new HashSet<String>();
        HashSet<String> addTags = new HashSet<String>();
        HashSet<String> overrideTags = new HashSet<String>();
        for (Object tag : config.getTargetTags()) {
            if (((String)tag).startsWith(MINUS)) {
                removeTags.add((String)tag);
                continue;
            }
            if (((String)tag).startsWith(PLUS)) {
                addTags.add((String)tag);
                continue;
            }
            overrideTags.add((String)tag);
        }
        SimpleElementSelector mpeSelector = new SimpleElementSelector();
        for (MediaPackageElementFlavor flavor : config.getSrcFlavors()) {
            mpeSelector.addFlavor(flavor);
        }
        for (String tag : config.getSrcTags()) {
            mpeSelector.addTag(tag);
        }
        MediaPackage mediaPackageForSearch = null;
        try {
            mediaPackageForSearch = this.searchService.get(mediaPackageId);
        }
        catch (UnauthorizedException | NotFoundException e) {
            throw new WorkflowOperationException(e);
        }
        Collection searchElements = mpeSelector.select(mediaPackageForSearch, false);
        boolean changedMediaPackageForSearch = this.updateTagsAndFlavors(searchElements, config, removeTags, addTags, overrideTags);
        if (!changedMediaPackageForSearch) {
            logger.info("No element changed, not publishing anything.");
            return this.createResult(currentMediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        boolean changedPublication = false;
        for (Publication publication : currentMediaPackage.getPublications()) {
            if (!"engage-player".equals(publication.getChannel())) continue;
            List publicationElements = Stream.of(publication.getAttachments(), publication.getCatalogs(), publication.getTracks()).flatMap(Stream::of).collect(Collectors.toList());
            Collection selectedElements = mpeSelector.select(publicationElements, false);
            changedPublication = this.updateTagsAndFlavors(selectedElements, config, removeTags, addTags, overrideTags);
        }
        if (!changedPublication) {
            throw new WorkflowOperationException("Publication for " + mediaPackageId + " couldn't be updated.");
        }
        try {
            Job publishJob = this.searchService.add(mediaPackageForSearch);
            if (!this.waitForStatus(new Job[]{publishJob}).isSuccess()) {
                throw new WorkflowOperationException("Media package " + mediaPackageId + " could not be published.");
            }
        }
        catch (MediaPackageException | SearchException | UnauthorizedException | ServiceRegistryException e) {
            throw new WorkflowOperationException("Error publishing media package", e);
        }
        return this.createResult(currentMediaPackage, WorkflowOperationResult.Action.CONTINUE);
    }

    private boolean updateTagsAndFlavors(Collection<MediaPackageElement> elements, ConfiguredTagsAndFlavors config, Set<String> removeTags, Set<String> addTags, Set<String> overrideTags) {
        boolean changed = false;
        for (MediaPackageElement element : elements) {
            HashSet<String> newTags;
            if (!config.getTargetFlavors().isEmpty()) {
                MediaPackageElementFlavor newFlavor;
                MediaPackageElementFlavor currentFlavor = element.getFlavor();
                MediaPackageElementFlavor targetFlavor = (MediaPackageElementFlavor)config.getTargetFlavors().get(0);
                String newFlavorType = targetFlavor.getType();
                String newFlavorSubtype = targetFlavor.getSubtype();
                if ("*".equals(newFlavorType)) {
                    newFlavorType = currentFlavor.getType();
                }
                if ("*".equals(newFlavorSubtype)) {
                    newFlavorSubtype = currentFlavor.getSubtype();
                }
                if (!(newFlavor = MediaPackageElementFlavor.parseFlavor((String)(newFlavorType + "/" + newFlavorSubtype))).equals((Object)currentFlavor)) {
                    element.setFlavor(newFlavor);
                    changed = true;
                }
            }
            HashSet<String> currentTags = new HashSet<String>(Arrays.asList(element.getTags()));
            if (overrideTags.size() > 0) {
                element.clearTags();
                for (String tag : overrideTags) {
                    element.addTag(tag);
                }
            } else {
                for (String tag : removeTags) {
                    element.removeTag(tag.substring(MINUS.length()));
                }
                for (String tag : addTags) {
                    element.addTag(tag.substring(PLUS.length()));
                }
            }
            if (currentTags.equals(newTags = new HashSet<String>(Arrays.asList(element.getTags())))) continue;
            changed = true;
        }
        return changed;
    }
}

