/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.distribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.opencastproject.distribution.api.DistributionException;
import org.opencastproject.distribution.api.DownloadDistributionService;
import org.opencastproject.distribution.api.StreamingDistributionService;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.Publication;
import org.opencastproject.search.api.SearchService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Engage Retraction Workflow Operation Handler", "workflow.operation=retract-engage"})
public class RetractEngageWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(RetractEngageWorkflowOperationHandler.class);
    protected StreamingDistributionService streamingDistributionService = null;
    protected DownloadDistributionService downloadDistributionService = null;
    protected SearchService searchService = null;

    @Reference(target="(distribution.channel=streaming)")
    protected void setStreamingDistributionService(StreamingDistributionService streamingDistributionService) {
        this.streamingDistributionService = streamingDistributionService;
    }

    @Reference(target="(distribution.channel=download)")
    protected void setDownloadDistributionService(DownloadDistributionService downloadDistributionService) {
        this.downloadDistributionService = downloadDistributionService;
    }

    @Reference
    protected void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }

    @Activate
    protected void activate(ComponentContext cc) {
        super.activate(cc);
    }

    protected List<Job> retractElements(Set<String> retractElementIds, MediaPackage searchMediaPackage) throws DistributionException {
        if (retractElementIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Job> jobs = new ArrayList<Job>();
        jobs.add(this.downloadDistributionService.retract("engage-player", searchMediaPackage, retractElementIds));
        if (this.streamingDistributionService != null && this.streamingDistributionService.publishToStreaming()) {
            jobs.add(this.streamingDistributionService.retract("engage-player", searchMediaPackage, retractElementIds));
        }
        return jobs;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        try {
            Publication[] publications;
            MediaPackage searchMediaPackage = null;
            try {
                searchMediaPackage = this.searchService.get(mediaPackage.getIdentifier().toString());
            }
            catch (NotFoundException e) {
                logger.info("The search service doesn't know media package {}", (Object)mediaPackage);
                return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
            }
            logger.info("Retracting media package {} from download/streaming distribution channel", (Object)searchMediaPackage);
            Set<String> retractElementIds = Arrays.stream(searchMediaPackage.getElements()).map(MediaPackageElement::getIdentifier).collect(Collectors.toSet());
            List<Job> jobs = this.retractElements(retractElementIds, searchMediaPackage);
            if (!this.waitForStatus(jobs.toArray(new Job[0])).isSuccess()) {
                throw new WorkflowOperationException("One of the download/streaming retract job did not complete successfully");
            }
            logger.debug("Retraction operation complete");
            logger.info("Removing media package {} from the search index", (Object)mediaPackage);
            Job deleteFromSearch = this.searchService.delete(mediaPackage.getIdentifier().toString());
            if (!this.waitForStatus(new Job[]{deleteFromSearch}).isSuccess()) {
                throw new WorkflowOperationException("Removing media package from search did not complete successfully");
            }
            logger.debug("Remove from search operation complete");
            logger.info("Removing engage publication element from media package {}", (Object)mediaPackage);
            for (Publication publication : publications = mediaPackage.getPublications()) {
                if (!"engage-player".equals(publication.getChannel())) continue;
                mediaPackage.remove((MediaPackageElement)publication);
                logger.debug("Remove engage publication element '{}' complete", (Object)publication);
            }
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
        }
        catch (Throwable t) {
            throw new WorkflowOperationException(t);
        }
    }
}

