/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.composer;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.composer.api.ComposerService;
import org.opencastproject.composer.api.EncoderException;
import org.opencastproject.composer.api.EncodingProfile;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.selector.TrackSelector;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Demux Workflow Operation Handler", "workflow.operation=demux"})
public class DemuxWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(DemuxWorkflowOperationHandler.class);
    private ComposerService composerService = null;
    private Workspace workspace = null;

    @Reference
    protected void setComposerService(ComposerService composerService) {
        this.composerService = composerService;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        logger.debug("Running demux workflow operation on workflow {}", (Object)workflowInstance.getId());
        try {
            return this.demux(workflowInstance.getMediaPackage(), workflowInstance);
        }
        catch (Exception e) {
            throw new WorkflowOperationException((Throwable)e);
        }
    }

    private WorkflowOperationResult demux(MediaPackage src, WorkflowInstance workflowInstance) throws EncoderException, IOException, NotFoundException, MediaPackageException, WorkflowOperationException {
        MediaPackage mediaPackage = (MediaPackage)src.clone();
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        String sectionSeparator = ";";
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many);
        List sourceTagsOption = tagsAndFlavors.getSrcTags();
        List sourceFlavorsOption = tagsAndFlavors.getSrcFlavors();
        String targetTagsOption = StringUtils.trimToNull((String)operation.getConfiguration("target-tags"));
        List targetFlavorsOption = tagsAndFlavors.getTargetFlavors();
        String encodingProfile = StringUtils.trimToEmpty((String)operation.getConfiguration("encoding-profile"));
        if (sourceTagsOption.isEmpty() && sourceFlavorsOption.isEmpty()) {
            logger.info("No source tags or flavors have been specified, not matching anything");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
        }
        List targetFlavors = targetFlavorsOption;
        String[] targetTags = StringUtils.split((String)targetTagsOption, (String)";");
        TrackSelector elementSelector = new TrackSelector();
        for (MediaPackageElementFlavor flavor : sourceFlavorsOption) {
            elementSelector.addFlavor(flavor);
        }
        for (String tag : sourceTagsOption) {
            elementSelector.addTag(tag);
        }
        EncodingProfile profile = this.composerService.getProfile(encodingProfile);
        if (profile == null) {
            throw new WorkflowOperationException(String.format("Encoding profile '%s' was not found", encodingProfile));
        }
        Collection sourceTracks = elementSelector.select(mediaPackage, false);
        if (sourceTracks.isEmpty()) {
            logger.info("No matching tracks found");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
        }
        long totalTimeInQueue = 0L;
        HashMap<Job, Track> encodingJobs = new HashMap<Job, Track>();
        for (Track track : sourceTracks) {
            logger.info("Demuxing track {} using encoding profile '{}'", (Object)track, (Object)profile);
            encodingJobs.put(this.composerService.demux(track, profile.getIdentifier()), track);
        }
        if (!this.waitForStatus(encodingJobs.keySet().toArray(new Job[encodingJobs.size()])).isSuccess()) {
            throw new WorkflowOperationException("One of the encoding jobs did not complete successfully");
        }
        for (Map.Entry entry : encodingJobs.entrySet()) {
            Job job = (Job)entry.getKey();
            Track sourceTrack = (Track)entry.getValue();
            totalTimeInQueue += job.getQueueTime().longValue();
            if (job.getPayload().length() <= 0) {
                logger.warn("No output from Demux operation");
                continue;
            }
            List composedTracks = MediaPackageElementParser.getArrayFromXml((String)job.getPayload());
            if (composedTracks.size() != targetFlavors.size() && targetFlavors.size() != 1) {
                throw new WorkflowOperationException(String.format("Number of target flavors (%d) and output tracks (%d) do not match", targetFlavors.size(), composedTracks.size()));
            }
            if (composedTracks.size() != targetTags.length && targetTags.length != 1 && targetTags.length != 0) {
                throw new WorkflowOperationException(String.format("Number of target tag groups (%d) and output tracks (%d) do not match", targetTags.length, composedTracks.size()));
            }
            int flavorIndex = 0;
            int tagsIndex = 0;
            for (Track composedTrack : composedTracks) {
                composedTrack.setFlavor(this.newFlavor(sourceTrack, ((MediaPackageElementFlavor)targetFlavors.get(flavorIndex)).toString()));
                if (targetFlavors.size() > 1) {
                    ++flavorIndex;
                }
                if (targetTags.length > 0) {
                    this.asList(targetTags[tagsIndex]).forEach(arg_0 -> ((Track)composedTrack).addTag(arg_0));
                    logger.trace("Tagging composed track with '{}'", (Object)targetTags[tagsIndex]);
                    if (targetTags.length > 1) {
                        ++tagsIndex;
                    }
                }
                String fileName = this.getFileNameFromElements((MediaPackageElement)sourceTrack, (MediaPackageElement)composedTrack);
                composedTrack.setURI(this.workspace.moveTo(composedTrack.getURI(), mediaPackage.getIdentifier().toString(), composedTrack.getIdentifier(), fileName));
                mediaPackage.addDerived((MediaPackageElement)composedTrack, (MediaPackageElement)sourceTrack);
            }
        }
        logger.debug("Demux operation completed");
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE, totalTimeInQueue);
    }

    private MediaPackageElementFlavor newFlavor(Track track, String flavor) throws WorkflowOperationException {
        try {
            MediaPackageElementFlavor targetFlavor = MediaPackageElementFlavor.parseFlavor((String)flavor);
            String flavorType = targetFlavor.getType();
            String flavorSubtype = targetFlavor.getSubtype();
            if ("*".equals(flavorType)) {
                flavorType = track.getFlavor().getType();
            }
            if ("*".equals(flavorSubtype)) {
                flavorSubtype = track.getFlavor().getSubtype();
            }
            return new MediaPackageElementFlavor(flavorType, flavorSubtype);
        }
        catch (IllegalArgumentException e) {
            throw new WorkflowOperationException(String.format("Target flavor '%s' is malformed", flavor));
        }
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

