/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.composer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.opencastproject.composer.api.ComposerService;
import org.opencastproject.composer.api.EncoderException;
import org.opencastproject.composer.api.EncodingProfile;
import org.opencastproject.composer.layout.Dimension;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Stream;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.TrackSupport;
import org.opencastproject.mediapackage.VideoStream;
import org.opencastproject.mediapackage.selector.TrackSelector;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Concat Workflow Operation Handler", "workflow.operation=concat"})
public class ConcatWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final String SOURCE_TAGS_PREFIX = "source-tags-part-";
    private static final String SOURCE_FLAVOR_PREFIX = "source-flavor-part-";
    private static final String MANDATORY_SUFFIX = "-mandatory";
    private static final String ENCODING_PROFILE = "encoding-profile";
    private static final String OUTPUT_RESOLUTION = "output-resolution";
    private static final String OUTPUT_FRAMERATE = "output-framerate";
    private static final String OUTPUT_PART_PREFIX = "part-";
    private static final String SOURCE_FLAVOR_NUMBERED_FILES = "source-flavor-numbered-files";
    private static final String SAME_CODEC = "same-codec";
    private static final Logger logger = LoggerFactory.getLogger(ConcatWorkflowOperationHandler.class);
    private ComposerService composerService = null;
    private Workspace workspace = null;

    @Reference
    public void setComposerService(ComposerService composerService) {
        this.composerService = composerService;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        logger.debug("Running concat workflow operation on workflow {}", (Object)workflowInstance.getId());
        try {
            return this.concat(workflowInstance.getMediaPackage(), workflowInstance);
        }
        catch (Exception e) {
            throw new WorkflowOperationException((Throwable)e);
        }
    }

    private WorkflowOperationResult concat(MediaPackage src, WorkflowInstance workflowInstance) throws EncoderException, IOException, NotFoundException, MediaPackageException, WorkflowOperationException {
        MediaPackage mediaPackage = (MediaPackage)src.clone();
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        Map<Integer, Tuple<TrackSelector, Boolean>> trackSelectors = this.getTrackSelectors(operation);
        String outputResolution = StringUtils.trimToNull((String)operation.getConfiguration(OUTPUT_RESOLUTION));
        String outputFrameRate = StringUtils.trimToNull((String)operation.getConfiguration(OUTPUT_FRAMERATE));
        String encodingProfile = StringUtils.trimToNull((String)operation.getConfiguration(ENCODING_PROFILE));
        boolean sameCodec = BooleanUtils.toBoolean((String)operation.getConfiguration(SAME_CODEC));
        if (trackSelectors.isEmpty()) {
            logger.warn("No source-tags or source-flavors has been set.");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.one);
        List targetTagsOption = tagsAndFlavors.getTargetTags();
        List targetFlavorOption = tagsAndFlavors.getTargetFlavors();
        if (targetFlavorOption.isEmpty()) {
            throw new WorkflowOperationException("Target flavor must be set!");
        }
        if (encodingProfile == null) {
            throw new WorkflowOperationException("Encoding profile must be set!");
        }
        EncodingProfile profile = this.composerService.getProfile(encodingProfile);
        if (profile == null) {
            throw new WorkflowOperationException("Encoding profile '" + encodingProfile + "' was not found");
        }
        if (!sameCodec && outputResolution == null) {
            throw new WorkflowOperationException("Output resolution must be set!");
        }
        Dimension outputDimension = null;
        if (!sameCodec) {
            if (outputResolution.startsWith(OUTPUT_PART_PREFIX)) {
                if (!trackSelectors.keySet().contains(Integer.parseInt(outputResolution.substring(OUTPUT_PART_PREFIX.length())))) {
                    throw new WorkflowOperationException("Output resolution part not set!");
                }
            } else {
                try {
                    String[] outputResolutionArray = StringUtils.split((String)outputResolution, (String)"x");
                    if (outputResolutionArray.length != 2) {
                        throw new WorkflowOperationException("Invalid format of output resolution!");
                    }
                    outputDimension = Dimension.dimension((int)Integer.parseInt(outputResolutionArray[0]), (int)Integer.parseInt(outputResolutionArray[1]));
                }
                catch (WorkflowOperationException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new WorkflowOperationException("Unable to parse output resolution!", (Throwable)e);
                }
            }
        }
        float fps = -1.0f;
        if (!sameCodec && StringUtils.isNotEmpty((CharSequence)outputFrameRate)) {
            if (StringUtils.startsWith((CharSequence)outputFrameRate, (CharSequence)OUTPUT_PART_PREFIX)) {
                if (!NumberUtils.isCreatable((String)outputFrameRate.substring(OUTPUT_PART_PREFIX.length())) || !trackSelectors.keySet().contains(Integer.parseInt(outputFrameRate.substring(OUTPUT_PART_PREFIX.length())))) {
                    throw new WorkflowOperationException("Output frame rate part not set or invalid!");
                }
            } else if (NumberUtils.isCreatable((String)outputFrameRate)) {
                fps = NumberUtils.toFloat((String)outputFrameRate);
            } else {
                throw new WorkflowOperationException("Unable to parse output frame rate!");
            }
        }
        MediaPackageElementFlavor targetFlavor = null;
        try {
            targetFlavor = (MediaPackageElementFlavor)targetFlavorOption.get(0);
            if ("*".equals(targetFlavor.getType()) || "*".equals(targetFlavor.getSubtype())) {
                throw new WorkflowOperationException("Target flavor must have a type and a subtype, '*' are not allowed!");
            }
        }
        catch (IllegalArgumentException e) {
            throw new WorkflowOperationException("Target flavor '" + targetFlavorOption + "' is malformed");
        }
        ArrayList<Track> tracks = new ArrayList<Track>();
        for (Map.Entry<Integer, Tuple<TrackSelector, Boolean>> trackSelector : trackSelectors.entrySet()) {
            ArrayList tracksForSelector = ((TrackSelector)trackSelector.getValue().getA()).select(mediaPackage, false);
            String currentFlavor = StringUtils.join((Object[])((TrackSelector)trackSelector.getValue().getA()).getFlavors());
            String currentTag = StringUtils.join((Object[])((TrackSelector)trackSelector.getValue().getA()).getTags());
            if (trackSelectors.size() == 1) {
                ArrayList list = new ArrayList(tracksForSelector);
                list.sort((left, right) -> {
                    String l = new File(left.getURI().getPath()).getName();
                    String r = new File(right.getURI().getPath()).getName();
                    return l.compareTo(r);
                });
                tracksForSelector = list;
            } else {
                if (tracksForSelector.size() > 1) {
                    logger.warn("More than one track has been found with flavor '{}' and/or tag '{}' for concat operation, skipping concatenation!", (Object)currentFlavor, (Object)currentTag);
                    return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
                }
                if (tracksForSelector.size() == 0 && ((Boolean)trackSelector.getValue().getB()).booleanValue()) {
                    logger.warn("No track has been found with flavor '{}' and/or tag '{}' for concat operation, skipping concatenation!", (Object)currentFlavor, (Object)currentTag);
                    return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
                }
                if (tracksForSelector.size() == 0 && !((Boolean)trackSelector.getValue().getB()).booleanValue()) {
                    logger.info("No track has been found with flavor '{}' and/or tag '{}' for concat operation, skipping track!", (Object)currentFlavor, (Object)currentTag);
                    continue;
                }
            }
            for (Track t : tracksForSelector) {
                tracks.add(t);
                VideoStream[] videoStreams = (VideoStream[])TrackSupport.byType((Stream[])t.getStreams(), VideoStream.class);
                if (videoStreams.length == 0) {
                    logger.info("No video stream available in the track with flavor {}! {}", (Object)currentFlavor, (Object)t);
                    return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
                }
                if (StringUtils.startsWith((CharSequence)outputResolution, (CharSequence)OUTPUT_PART_PREFIX) && NumberUtils.isCreatable((String)outputResolution.substring(OUTPUT_PART_PREFIX.length())) && trackSelector.getKey() == Integer.parseInt(outputResolution.substring(OUTPUT_PART_PREFIX.length()))) {
                    outputDimension = new Dimension(videoStreams[0].getFrameWidth().intValue(), videoStreams[0].getFrameHeight().intValue());
                    if (!((Boolean)trackSelector.getValue().getB()).booleanValue()) {
                        logger.warn("Output resolution track {} must be mandatory, skipping concatenation!", (Object)outputResolution);
                        return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
                    }
                }
                if (!(fps <= 0.0f) || !StringUtils.startsWith((CharSequence)outputFrameRate, (CharSequence)OUTPUT_PART_PREFIX) || !NumberUtils.isCreatable((String)outputFrameRate.substring(OUTPUT_PART_PREFIX.length())) || trackSelector.getKey() != Integer.parseInt(outputFrameRate.substring(OUTPUT_PART_PREFIX.length()))) continue;
                fps = videoStreams[0].getFrameRate().floatValue();
            }
        }
        if (tracks.size() == 0) {
            logger.warn("No tracks found for concating operation, skipping concatenation!");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        if (tracks.size() == 1) {
            Track track = (Track)((Track)tracks.get(0)).clone();
            track.setIdentifier(null);
            this.addNewTrack(mediaPackage, track, targetTagsOption, targetFlavor);
            logger.info("At least two tracks are needed for the concating operation, skipping concatenation!");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        Job concatJob = fps > 0.0f ? this.composerService.concat(profile.getIdentifier(), outputDimension, fps, sameCodec, tracks.toArray(new Track[tracks.size()])) : this.composerService.concat(profile.getIdentifier(), outputDimension, sameCodec, tracks.toArray(new Track[tracks.size()]));
        if (!this.waitForStatus(new Job[]{concatJob}).isSuccess()) {
            throw new WorkflowOperationException("The concat job did not complete successfully");
        }
        if (concatJob.getPayload().length() > 0) {
            Track concatTrack = (Track)MediaPackageElementParser.getFromXml((String)concatJob.getPayload());
            concatTrack.setURI(this.workspace.moveTo(concatTrack.getURI(), mediaPackage.getIdentifier().toString(), concatTrack.getIdentifier(), "concat." + FilenameUtils.getExtension((String)concatTrack.getURI().toString())));
            this.addNewTrack(mediaPackage, concatTrack, targetTagsOption, targetFlavor);
            WorkflowOperationResult result = this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE, concatJob.getQueueTime());
            logger.debug("Concat operation completed");
            return result;
        }
        logger.info("concat operation unsuccessful, no payload returned: {}", (Object)concatJob);
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
    }

    private void addNewTrack(MediaPackage mediaPackage, Track track, List<String> targetTags, MediaPackageElementFlavor targetFlavor) {
        for (String tag : targetTags) {
            logger.trace("Tagging compound track with '{}'", (Object)tag);
            track.addTag(tag);
        }
        track.setFlavor(targetFlavor);
        logger.debug("Compound track has flavor '{}'", (Object)track.getFlavor());
        mediaPackage.add(track);
    }

    private Map<Integer, Tuple<TrackSelector, Boolean>> getTrackSelectors(WorkflowOperationInstance operation) throws WorkflowOperationException {
        HashMap<Integer, Tuple<TrackSelector, Boolean>> trackSelectors = new HashMap<Integer, Tuple<TrackSelector, Boolean>>();
        SourceType flavorType = SourceType.None;
        String srcFlavor = null;
        for (String key : operation.getConfigurationKeys()) {
            if (key.startsWith(SOURCE_FLAVOR_PREFIX) || key.startsWith(SOURCE_TAGS_PREFIX)) {
                if (flavorType == SourceType.None) {
                    flavorType = SourceType.PrefixedFile;
                } else if (flavorType != SourceType.PrefixedFile) {
                    throw new WorkflowOperationException("Cannot mix source prefix flavor/tags with source numbered files - use one type of selector only");
                }
            }
            if (!key.equals(SOURCE_FLAVOR_NUMBERED_FILES)) continue;
            srcFlavor = operation.getConfiguration(key);
            if (flavorType == SourceType.None) {
                flavorType = SourceType.NumberedFile;
                srcFlavor = operation.getConfiguration(key);
                continue;
            }
            if (flavorType == SourceType.NumberedFile) continue;
            throw new WorkflowOperationException("Cannot mix source prefix flavor/tags with source numbered files - use one type of selector only");
        }
        if (srcFlavor != null) {
            int number = 0;
            Tuple selectorTuple = (Tuple)trackSelectors.get(number);
            selectorTuple = Tuple.tuple((Object)new TrackSelector(), (Object)true);
            TrackSelector trackSelector = (TrackSelector)selectorTuple.getA();
            trackSelector.addFlavor(srcFlavor);
            trackSelectors.put(number, (Tuple<TrackSelector, Boolean>)selectorTuple);
            return trackSelectors;
        }
        for (String key : operation.getConfigurationKeys()) {
            String tags = null;
            String flavor = null;
            Boolean mandatory = true;
            int number = -1;
            if (key.startsWith(SOURCE_TAGS_PREFIX) && !key.endsWith(MANDATORY_SUFFIX)) {
                number = NumberUtils.toInt((String)key.substring(SOURCE_TAGS_PREFIX.length()), (int)-1);
                tags = operation.getConfiguration(key);
                mandatory = BooleanUtils.toBooleanObject((String)operation.getConfiguration(SOURCE_TAGS_PREFIX.concat(Integer.toString(number)).concat(MANDATORY_SUFFIX)));
            } else if (key.startsWith(SOURCE_FLAVOR_PREFIX) && !key.endsWith(MANDATORY_SUFFIX)) {
                number = NumberUtils.toInt((String)key.substring(SOURCE_FLAVOR_PREFIX.length()), (int)-1);
                flavor = operation.getConfiguration(key);
                mandatory = BooleanUtils.toBooleanObject((String)operation.getConfiguration(SOURCE_FLAVOR_PREFIX.concat(Integer.toString(number)).concat(MANDATORY_SUFFIX)));
            }
            if (number < 0) continue;
            Tuple selectorTuple = (Tuple)trackSelectors.get(number);
            selectorTuple = selectorTuple == null ? Tuple.tuple((Object)new TrackSelector(), (Object)BooleanUtils.toBooleanDefaultIfNull((Boolean)mandatory, (boolean)false)) : Tuple.tuple((Object)((TrackSelector)selectorTuple.getA()), (Object)((Boolean)selectorTuple.getB() != false || BooleanUtils.toBooleanDefaultIfNull((Boolean)mandatory, (boolean)false) ? 1 : 0));
            TrackSelector trackSelector = (TrackSelector)selectorTuple.getA();
            if (StringUtils.isNotBlank((CharSequence)tags)) {
                for (String tag : StringUtils.split((String)tags, (String)",")) {
                    trackSelector.addTag(tag);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)flavor)) {
                try {
                    trackSelector.addFlavor(flavor);
                }
                catch (IllegalArgumentException e) {
                    throw new WorkflowOperationException("Source flavor '" + flavor + "' is malformed");
                }
            }
            trackSelectors.put(number, (Tuple<TrackSelector, Boolean>)selectorTuple);
        }
        return trackSelectors;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }

    static enum SourceType {
        None,
        PrefixedFile,
        NumberedFile;

    }
}

