/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.comments;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.event.comment.EventComment;
import org.opencastproject.event.comment.EventCommentException;
import org.opencastproject.event.comment.EventCommentService;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.data.Option;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Comment Workflow Operation Handler", "workflow.operation=comment"})
public class CommentWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    protected static final String ACTION = "action";
    protected static final String DESCRIPTION = "description";
    protected static final String REASON = "reason";
    private static final Logger logger = LoggerFactory.getLogger(CommentWorkflowOperationHandler.class);
    private EventCommentService eventCommentService;
    private SecurityService securityService;
    private UserDirectoryService userDirectoryService;

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        logger.debug("Running comment workflow operation on workflow {}", (Object)workflowInstance.getId());
        try {
            return this.handleCommentOperation(workflowInstance);
        }
        catch (Exception e) {
            throw new WorkflowOperationException((Throwable)e);
        }
    }

    private WorkflowOperationResult handleCommentOperation(WorkflowInstance workflowInstance) throws EventCommentException, NotFoundException {
        Date date = new Date();
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        String inputAction = StringUtils.trimToNull((String)operation.getConfiguration(ACTION));
        Operation action = inputAction == null ? Operation.create : Operation.valueOf(inputAction.toLowerCase());
        String reason = StringUtils.trimToNull((String)operation.getConfiguration(REASON));
        String description = StringUtils.trimToNull((String)operation.getConfiguration(DESCRIPTION));
        switch (action.ordinal()) {
            case 0: {
                this.createComment(workflowInstance, reason, description);
                break;
            }
            case 1: {
                this.resolveComment(workflowInstance, reason, description);
                break;
            }
            case 2: {
                this.deleteComment(workflowInstance, reason, description);
                break;
            }
            default: {
                logger.warn("Unknown action '{}' for comment with description '{}' and reason '{}'. It should be one of the following: {}", new Object[]{inputAction, description, reason, StringUtils.join((Object[])Operation.values(), (String)",")});
            }
        }
        WorkflowOperationResult result = this.createResult(workflowInstance.getMediaPackage(), WorkflowOperationResult.Action.CONTINUE, new Date().getTime() - date.getTime());
        return result;
    }

    private void createComment(WorkflowInstance workflowInstance, String reason, String description) throws EventCommentException {
        String mpId = workflowInstance.getMediaPackage().getIdentifier().toString();
        Optional<EventComment> optComment = this.findComment(mpId, reason, description);
        if (optComment.isEmpty()) {
            User user = this.userDirectoryService.loadUser(workflowInstance.getCreatorName());
            EventComment comment = EventComment.create((Option)Option.none(), (String)mpId, (String)this.securityService.getOrganization().getId(), (String)description, (User)user, (String)reason, (boolean)false);
            this.eventCommentService.updateComment(comment);
        } else {
            logger.debug("Not creating comment with '{}' text and '{}' reason as it already exists for this event.", (Object)description, (Object)reason);
        }
    }

    private void resolveComment(WorkflowInstance workflowInstance, String reason, String description) throws EventCommentException {
        String mpId = workflowInstance.getMediaPackage().getIdentifier().toString();
        Optional<EventComment> optComment = this.findComment(mpId, reason, description);
        if (optComment.isPresent()) {
            EventComment comment = EventComment.create((Option)optComment.get().getId(), (String)mpId, (String)this.securityService.getOrganization().getId(), (String)optComment.get().getText(), (User)optComment.get().getAuthor(), (String)optComment.get().getReason(), (boolean)true, (Date)optComment.get().getCreationDate(), (Date)optComment.get().getModificationDate(), (List)optComment.get().getReplies());
            this.eventCommentService.updateComment(comment);
        } else {
            logger.debug("Not resolving comment with '{}' text and/or '{}' reason as it doesn't exist.", (Object)description, (Object)reason);
        }
    }

    private void deleteComment(WorkflowInstance workflowInstance, String reason, String description) throws EventCommentException, NotFoundException {
        String mpId = workflowInstance.getMediaPackage().getIdentifier().toString();
        Optional<EventComment> optComment = this.findComment(mpId, reason, description);
        if (optComment.isPresent()) {
            try {
                this.eventCommentService.deleteComment(((Long)optComment.get().getId().get()).longValue());
            }
            catch (NotFoundException e) {
                logger.debug("Not deleting comment with '{}' text and '{}' reason and id '{}' as it doesn't exist.", new Object[]{description, reason, optComment.get().getId()});
            }
        } else {
            logger.debug("Not deleting comment with '{}' text and/or '{}' reason as it doesn't exist.", (Object)description, (Object)reason);
        }
    }

    private Optional<EventComment> findComment(String eventId, String reason, String description) throws EventCommentException {
        Optional<EventComment> comment = Optional.empty();
        List eventComments = this.eventCommentService.getComments(eventId);
        for (EventComment existingComment : eventComments) {
            if (reason != null && description != null && reason.equals(existingComment.getReason()) && description.equals(existingComment.getText())) {
                comment = Optional.of(existingComment);
                break;
            }
            if (reason != null && description == null && reason.equals(existingComment.getReason())) {
                comment = Optional.of(existingComment);
                break;
            }
            if (reason != null || description == null || !description.equals(existingComment.getText())) continue;
            comment = Optional.of(existingComment);
            break;
        }
        return comment;
    }

    @Reference
    public void setEventCommentService(EventCommentService eventCommentService) {
        this.eventCommentService = eventCommentService;
    }

    @Reference
    void setSecurityService(SecurityService service) {
        this.securityService = service;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }

    public static enum Operation {
        create,
        resolve,
        delete;

    }
}

