/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.capture.admin.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.opencastproject.capture.admin.api.CaptureAgentStateService;
import org.opencastproject.security.api.JaxbOrganization;
import org.opencastproject.security.api.JaxbRole;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.RoleProvider;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.util.SecurityUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.description=Manages Roles for each capture agent"}, immediate=true, service={RoleProvider.class})
public class CaptureAgentAdminRoleProviderImpl
implements RoleProvider {
    private SecurityService securityService;
    private CaptureAgentStateService captureAgentService;

    @Reference
    public void setSecurityService(SecurityService service) {
        this.securityService = service;
    }

    @Reference
    public void setCaptureAgentStateService(CaptureAgentStateService service) {
        this.captureAgentService = service;
    }

    private Role generateCaRole(String name) {
        String roleName = SecurityUtil.getCaptureAgentRole((String)name);
        JaxbOrganization organization = JaxbOrganization.fromOrganization((Organization)this.securityService.getOrganization());
        String description = "Role for capture agent \"" + name + "\"";
        Role.Type system = Role.Type.INTERNAL;
        return new JaxbRole(roleName, organization, description, system);
    }

    private Stream<Role> getRolesStream() {
        return this.captureAgentService.getKnownAgents().keySet().stream().map(this::generateCaRole);
    }

    public List<Role> getRolesForUser(String userName) {
        return Collections.emptyList();
    }

    public String getOrganization() {
        return "*";
    }

    public Iterator<Role> findRoles(String query, Role.Target target, int offset, int limit) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be set");
        }
        if (target == Role.Target.ACL) {
            return Collections.emptyIterator();
        }
        Stream<Role> roleStream = this.getRolesStream().filter(e -> CaptureAgentAdminRoleProviderImpl.like(e.getName(), query) || CaptureAgentAdminRoleProviderImpl.like(e.getDescription(), query)).skip(offset);
        if (limit != 0) {
            roleStream = roleStream.limit(limit);
        }
        return roleStream.iterator();
    }

    private static boolean like(String string, String query) {
        String regex = query.replace("_", ".").replace("%", ".*?");
        Pattern p = Pattern.compile(regex, 34);
        return p.matcher(string).matches();
    }
}

