/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.capture.admin.endpoint;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.capture.admin.api.Agent;
import org.opencastproject.capture.admin.api.AgentState;
import org.opencastproject.capture.admin.api.AgentStateUpdate;
import org.opencastproject.capture.admin.api.CaptureAgentStateService;
import org.opencastproject.capture.admin.endpoint.AgentStateUpdateList;
import org.opencastproject.capture.admin.impl.RecordingStateUpdate;
import org.opencastproject.scheduler.api.Recording;
import org.opencastproject.scheduler.api.SchedulerException;
import org.opencastproject.scheduler.api.SchedulerService;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.PropertiesResponse;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RestService(name="captureadminservice", title="Capture Admin Service", abstractText="This service is a registry of capture agents and their recordings.", notes={"All paths above are relative to the REST endpoint base (something like http://your.server/files)", "If the service is down or not working it will return a status 503, this means the the underlying service is not working and is either restarting or has failed", "A status code 500 means a general failure has occurred which is not recoverable and was not anticipated. In other words, there is a bug! You should file an error report with your server logs from the time when the error occurred: <a href=\"https://github.com/opencast/opencast/issues\">Opencast Issue Tracker</a>"})
@Component(immediate=true, service={CaptureAgentStateRestService.class}, property={"service.description=Capture Agent Admin REST Endpoint", "opencast.service.type=org.opencastproject.capture.admin", "opencast.service.path=/capture-admin"})
public class CaptureAgentStateRestService {
    private static final Logger logger = LoggerFactory.getLogger(CaptureAgentStateRestService.class);
    private CaptureAgentStateService service;
    private SchedulerService schedulerService;

    @Activate
    public void activate(ComponentContext cc) {
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetService")
    public void setService(CaptureAgentStateService service) {
        this.service = service;
    }

    public void unsetService(CaptureAgentStateService service) {
        this.service = null;
    }

    @Reference
    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="agents/{name}.{format:xml|json}")
    @RestQuery(name="getAgent", description="Return the state of a given capture agent", pathParameters={@RestParameter(name="name", description="Name of the capture agent", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="format", description="The output format (json or xml) of the response body.", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={}, responses={@RestResponse(description="{agentState}", responseCode=200), @RestResponse(description="The agent {agentName} does not exist", responseCode=404), @RestResponse(description="If the {format} is not xml or json", responseCode=405), @RestResponse(description="iCapture agent state service unavailable", responseCode=503)}, returnDescription="")
    public Response getAgentState(@PathParam(value="name") String agentName, @PathParam(value="format") String format) throws NotFoundException {
        if (this.service == null) {
            return Response.serverError().status(Response.Status.SERVICE_UNAVAILABLE).build();
        }
        Agent ret = this.service.getAgent(agentName);
        logger.debug("Returning agent state for {}", (Object)agentName);
        if ("json".equals(format)) {
            return Response.ok((Object)new AgentStateUpdate(ret)).type("application/json").build();
        }
        return Response.ok((Object)new AgentStateUpdate(ret)).type("application/xml").build();
    }

    @POST
    @Produces(value={"text/html"})
    @Path(value="agents/{name}")
    @RestQuery(name="setAgentState", description="Set the status of a given capture agent", pathParameters={@RestParameter(name="name", isRequired=true, type=RestParameter.Type.STRING, description="Name of the capture agent")}, restParameters={@RestParameter(name="address", isRequired=false, type=RestParameter.Type.STRING, description="Address of the agent"), @RestParameter(name="state", isRequired=true, type=RestParameter.Type.STRING, description="The state of the capture agent. Known states are: idle, shutting_down, capturing, uploading, unknown, offline, error")}, responses={@RestResponse(description="{agentName} set to {state}", responseCode=200), @RestResponse(description="{state} is empty or not known", responseCode=400), @RestResponse(description="Capture agent state service not available", responseCode=503)}, returnDescription="")
    public Response setAgentState(@Context HttpServletRequest request, @FormParam(value="address") String address, @PathParam(value="name") String agentName, @FormParam(value="state") String state) throws NotFoundException {
        if (this.service == null) {
            return Response.serverError().status(Response.Status.SERVICE_UNAVAILABLE).build();
        }
        if (!AgentState.KNOWN_STATES.contains(state)) {
            logger.debug("'{}' is not a valid state", (Object)state);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (StringUtils.isEmpty((CharSequence)address)) {
            address = request.getRemoteHost();
        }
        logger.debug("Agents URL: {}", (Object)address);
        boolean agentStateUpdated = this.service.setAgentState(agentName, state);
        boolean agentUrlUpdated = this.service.setAgentUrl(agentName, address);
        if (!agentStateUpdated && !agentUrlUpdated) {
            logger.debug("{}'s state '{}' and url '{}' has not changed, nothing has been updated", new Object[]{agentName, state, address});
            return Response.ok().build();
        }
        logger.debug("{}'s state successfully set to {}", (Object)agentName, (Object)state);
        return Response.ok((Object)(agentName + " set to " + state)).build();
    }

    @DELETE
    @Path(value="agents/{name}")
    @Produces(value={"text/html"})
    @RestQuery(name="removeAgent", description="Remove record of a given capture agent", pathParameters={@RestParameter(name="name", description="Name of the capture agent", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={}, responses={@RestResponse(description="{agentName} removed", responseCode=200), @RestResponse(description="The agent {agentname} does not exist", responseCode=404)}, returnDescription="")
    public Response removeAgent(@PathParam(value="name") String agentName) throws NotFoundException {
        if (this.service == null) {
            return Response.serverError().status(Response.Status.SERVICE_UNAVAILABLE).build();
        }
        this.service.removeAgent(agentName);
        logger.debug("The agent {} was successfully removed", (Object)agentName);
        return Response.ok((Object)(agentName + " removed")).build();
    }

    @GET
    @Produces(value={"text/xml", "application/json"})
    @Path(value="agents.{type:xml|json}")
    @RestQuery(name="getKnownAgents", description="Return all of the known capture agents on the system", pathParameters={@RestParameter(description="The Document type", isRequired=true, name="type", type=RestParameter.Type.STRING)}, restParameters={}, responses={@RestResponse(description="An XML representation of the agent capabilities", responseCode=200)}, returnDescription="")
    public Response getKnownAgents(@PathParam(value="type") String type) {
        if (this.service == null) {
            return Response.serverError().status(Response.Status.SERVICE_UNAVAILABLE).build();
        }
        logger.debug("Returning list of known agents...");
        LinkedList<AgentStateUpdate> update = new LinkedList<AgentStateUpdate>();
        Map<String, Agent> data = this.service.getKnownAgents();
        logger.debug("Agents: {}", data);
        for (Map.Entry<String, Agent> e : data.entrySet()) {
            update.add(new AgentStateUpdate(e.getValue()));
        }
        if ("json".equals(type)) {
            return Response.ok((Object)new AgentStateUpdateList(update)).type("application/json").build();
        }
        return Response.ok((Object)new AgentStateUpdateList(update)).type("text/xml").build();
    }

    @GET
    @Produces(value={"text/xml", "application/json"})
    @Path(value="agents/{name}/capabilities.{type:xml|json}")
    @RestQuery(name="getAgentCapabilities", description="Return the capabilities of a given capture agent", pathParameters={@RestParameter(description="Name of the capture agent", isRequired=true, name="name", type=RestParameter.Type.STRING), @RestParameter(description="The Document type", isRequired=true, name="type", type=RestParameter.Type.STRING)}, restParameters={}, responses={@RestResponse(description="An XML representation of the agent capabilities", responseCode=200), @RestResponse(description="The agent {name} does not exist in the system", responseCode=404)}, returnDescription="")
    public Response getCapabilities(@PathParam(value="name") String agentName, @PathParam(value="type") String type) throws NotFoundException {
        if (this.service == null) {
            return Response.serverError().status(Response.Status.SERVICE_UNAVAILABLE).build();
        }
        PropertiesResponse r = new PropertiesResponse(this.service.getAgentCapabilities(agentName));
        if ("json".equals(type)) {
            return Response.ok((Object)r).type("application/json").build();
        }
        return Response.ok((Object)r).type("text/xml").build();
    }

    @GET
    @Produces(value={"text/xml", "application/json"})
    @Path(value="agents/{name}/configuration.{type:xml|json}")
    @RestQuery(name="getAgentConfiguration", description="Return the configuration of a given capture agent", pathParameters={@RestParameter(description="Name of the capture agent", isRequired=true, name="name", type=RestParameter.Type.STRING), @RestParameter(description="The Document type", isRequired=true, name="type", type=RestParameter.Type.STRING)}, restParameters={}, responses={@RestResponse(description="An XML or JSON representation of the agent configuration", responseCode=200), @RestResponse(description="The agent {name} does not exist in the system", responseCode=404)}, returnDescription="")
    public Response getConfiguration(@PathParam(value="name") String agentName, @PathParam(value="type") String type) throws NotFoundException {
        if (this.service == null) {
            return Response.serverError().status(Response.Status.SERVICE_UNAVAILABLE).build();
        }
        PropertiesResponse r = new PropertiesResponse(this.service.getAgentConfiguration(agentName));
        logger.debug("Returning configuration for the agent {}", (Object)agentName);
        if ("json".equals(type)) {
            return Response.ok((Object)r).type("application/json").build();
        }
        return Response.ok((Object)r).type("text/xml").build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Produces(value={"text/xml", "application/json"})
    @Path(value="agents/{name}/configuration")
    @RestQuery(name="setAgentStateConfiguration", description="Set the configuration of a given capture agent, registering it if it does not exist", pathParameters={@RestParameter(description="Name of the capture agent", isRequired=true, name="name", type=RestParameter.Type.STRING)}, restParameters={@RestParameter(description="An XML or JSON representation of the capabilities. XML as specified in http://java.sun.com/dtd/properties.dtd (friendly names as keys, device locations as corresponding values)", type=RestParameter.Type.TEXT, isRequired=true, name="configuration")}, responses={@RestResponse(description="An XML or JSON representation of the agent configuration", responseCode=200), @RestResponse(description="The configuration format is incorrect OR the agent name is blank or null", responseCode=400)}, returnDescription="")
    public Response setConfiguration(@PathParam(value="name") String agentName, @FormParam(value="configuration") String configuration) {
        Response response;
        if (this.service == null) {
            return Response.serverError().status(Response.Status.SERVICE_UNAVAILABLE).build();
        }
        if (StringUtils.isBlank((CharSequence)configuration)) {
            logger.debug("The configuration data cannot be blank");
            return Response.serverError().status(Response.Status.BAD_REQUEST).build();
        }
        if (StringUtils.startsWith((CharSequence)configuration, (CharSequence)"{")) {
            Gson gson = new Gson();
            try {
                Properties caps = (Properties)gson.fromJson(configuration, Properties.class);
                if (!this.service.setAgentConfiguration(agentName, caps)) {
                    logger.debug("'{}''s configuration has not been updated because nothing has been changed", (Object)agentName);
                }
                return Response.ok((Object)gson.toJson((Object)caps)).type("application/json").build();
            }
            catch (JsonSyntaxException e) {
                logger.debug("Exception when deserializing capabilities: {}", (Object)e.getMessage());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        }
        Properties caps = new Properties();
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(configuration.getBytes());
            caps.loadFromXML(bais);
            if (!this.service.setAgentConfiguration(agentName, caps)) {
                logger.debug("'{}''s configuration has not been updated because nothing has been changed", (Object)agentName);
            }
            PropertiesResponse r = new PropertiesResponse(caps);
            logger.debug("{}'s configuration updated", (Object)agentName);
            response = Response.ok((Object)r).type("text/xml").build();
        }
        catch (IOException e) {
            Response response2;
            try {
                logger.debug("Unexpected I/O Exception when unmarshalling the capabilities: {}", (Object)e.getMessage());
                response2 = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bais);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)bais);
            return response2;
        }
        IOUtils.closeQuietly((InputStream)bais);
        return response;
    }

    @GET
    @Produces(value={"text/xml", "application/json"})
    @Path(value="recordings/{id}.{type:xml|json|}")
    @RestQuery(name="getRecordingState", description="Return the state of a given recording", pathParameters={@RestParameter(description="The ID of a given recording", isRequired=true, name="id", type=RestParameter.Type.STRING), @RestParameter(description="The Documenttype", isRequired=true, name="type", type=RestParameter.Type.STRING)}, restParameters={}, responses={@RestResponse(description="Returns the state of the recording with the correct id", responseCode=200), @RestResponse(description="The recording with the specified ID does not exist", responseCode=404)}, returnDescription="")
    public Response getRecordingState(@PathParam(value="id") String id, @PathParam(value="type") String type) throws NotFoundException {
        try {
            Recording rec = this.schedulerService.getRecordingState(id);
            logger.debug("Submitting state for recording {}", (Object)id);
            if ("json".equals(type)) {
                return Response.ok((Object)new RecordingStateUpdate(rec)).type("application/json").build();
            }
            return Response.ok((Object)new RecordingStateUpdate(rec)).type("text/xml").build();
        }
        catch (SchedulerException e) {
            logger.debug("Unable to get recording state of {}", (Object)id, (Object)e);
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="recordings/{id}")
    @RestQuery(name="setRecordingState", description="Set the status of a given recording, registering it if it is new", pathParameters={@RestParameter(description="The ID of a given recording", isRequired=true, name="id", type=RestParameter.Type.STRING)}, restParameters={@RestParameter(description="The state of the recording. Known states: unknown, capturing, capture_finished, capture_error, manifest, manifest_error, manifest_finished, compressing, compressing_error, uploading, upload_finished, upload_error.", isRequired=true, name="state", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="{id} set to {state}", responseCode=200), @RestResponse(description="{id} or {state} is empty or {state} is not known", responseCode=400), @RestResponse(description="Recording with {id} could not be found", responseCode=404)}, returnDescription="")
    public Response setRecordingState(@PathParam(value="id") String id, @FormParam(value="state") String state) throws NotFoundException {
        if (StringUtils.isEmpty((CharSequence)id) || StringUtils.isEmpty((CharSequence)state)) {
            return Response.serverError().status(Response.Status.BAD_REQUEST).build();
        }
        try {
            if (this.schedulerService.updateRecordingState(id, state)) {
                return Response.ok((Object)(id + " set to " + state)).build();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (SchedulerException e) {
            logger.debug("Unable to set recording state of {}", (Object)id, (Object)e);
            return Response.serverError().build();
        }
    }

    @DELETE
    @Path(value="recordings/{id}")
    @RestQuery(name="removeRecording", description="Remove record of a given recording", pathParameters={@RestParameter(description="The ID of a given recording", isRequired=true, name="id", type=RestParameter.Type.STRING)}, restParameters={}, responses={@RestResponse(description="{id} removed", responseCode=200), @RestResponse(description="{id} is empty", responseCode=400), @RestResponse(description="Recording with {id} could not be found", responseCode=404)}, returnDescription="")
    public Response removeRecording(@PathParam(value="id") String id) throws NotFoundException {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return Response.serverError().status(Response.Status.BAD_REQUEST).build();
        }
        try {
            this.schedulerService.removeRecording(id);
            return Response.ok((Object)(id + " removed")).build();
        }
        catch (SchedulerException e) {
            logger.debug("Unable to remove recording with id '{}'", (Object)id, (Object)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Produces(value={"text/xml"})
    @Path(value="recordings")
    @RestQuery(name="getAllRecordings", description="Return all registered recordings and their state", pathParameters={}, restParameters={}, responses={@RestResponse(description="Returns all known recordings.", responseCode=200)}, returnDescription="")
    public List<RecordingStateUpdate> getAllRecordings() {
        try {
            LinkedList<RecordingStateUpdate> update = new LinkedList<RecordingStateUpdate>();
            Map data = this.schedulerService.getKnownRecordings();
            for (Map.Entry e : data.entrySet()) {
                update.add(new RecordingStateUpdate((Recording)e.getValue()));
            }
            return update;
        }
        catch (SchedulerException e) {
            logger.debug("Unable to get all recordings", (Throwable)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

