/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.caption.converters;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Dictionary;
import java.util.List;
import org.apache.commons.lang3.EnumUtils;
import org.opencastproject.caption.api.Caption;
import org.opencastproject.caption.api.CaptionConverter;
import org.opencastproject.caption.api.CaptionConverterException;
import org.opencastproject.caption.util.TimeUtil;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.util.OsgiUtil;
import org.opencastproject.util.data.Option;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={CaptionConverter.class}, property={"service.description=WebVTT caption converter", "caption.format=vtt"})
public class WebVttCaptionConverter
implements CaptionConverter {
    private static final Logger logger = LoggerFactory.getLogger(WebVttCaptionConverter.class);
    private static final String EXTENSION = "vtt";
    static final String MEDIAPACKAGE_ELEMENT_TYPE_CONFIG_KEY = "mediapackage-element-type";
    static final MediaPackageElement.Type DEFAULT_MEDIAPACKAGE_ELEMENT_TYPE;
    private static MediaPackageElement.Type mediapackageElementType;

    @Activate
    public void activate(ComponentContext cc) {
        mediapackageElementType = this.getConfiguredMediapackageElementType(cc);
        logger.info("Mediapackage element type is set to '{}'.", (Object)mediapackageElementType);
    }

    public List<Caption> importCaption(InputStream in, String language) throws CaptionConverterException {
        throw new UnsupportedOperationException();
    }

    public void exportCaption(OutputStream outputStream, List<Caption> captions, String language) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(outputStream, "UTF-8");
        BufferedWriter bw = new BufferedWriter(osw);
        bw.append("WEBVTT\n\n");
        for (Caption caption : captions) {
            String captionString = String.format("%s --> %s\n%s\n\n", TimeUtil.exportToVtt(caption.getStartTime()), TimeUtil.exportToVtt(caption.getStopTime()), this.createCaptionText(caption.getCaption()));
            bw.append(captionString);
            logger.trace(captionString);
        }
        bw.flush();
        bw.close();
        osw.close();
    }

    private String createCaptionText(String[] captionLines) {
        StringBuilder builder = new StringBuilder(captionLines[0]);
        for (int i = 1; i < captionLines.length; ++i) {
            builder.append("\n");
            builder.append(captionLines[i]);
        }
        return builder.toString();
    }

    public String[] getLanguageList(InputStream input) throws CaptionConverterException {
        return new String[0];
    }

    public String getExtension() {
        return EXTENSION;
    }

    public MediaPackageElement.Type getElementType() {
        return mediapackageElementType;
    }

    private MediaPackageElement.Type getConfiguredMediapackageElementType(ComponentContext cc) {
        Option mediapackageElementTypeOption = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)MEDIAPACKAGE_ELEMENT_TYPE_CONFIG_KEY);
        if (mediapackageElementTypeOption.isNone()) {
            return DEFAULT_MEDIAPACKAGE_ELEMENT_TYPE;
        }
        return this.convertStringToEnum((String)mediapackageElementTypeOption.get());
    }

    private MediaPackageElement.Type convertStringToEnum(String mediaPackageElementType) {
        if (EnumUtils.isValidEnumIgnoreCase(MediaPackageElement.Type.class, (String)mediaPackageElementType)) {
            return (MediaPackageElement.Type)EnumUtils.getEnumIgnoreCase(MediaPackageElement.Type.class, (String)mediaPackageElementType);
        }
        String errorMessage = String.format("Couldn't convert configuration '%s'='%s' into enum.", MEDIAPACKAGE_ELEMENT_TYPE_CONFIG_KEY, mediaPackageElementType);
        throw new IllegalArgumentException(errorMessage);
    }

    static {
        mediapackageElementType = DEFAULT_MEDIAPACKAGE_ELEMENT_TYPE = MediaPackageElement.Type.Attachment;
    }
}

